/*
 * Decompiled with CFR 0.152.
 */
package com.octopusdragon.projects.mastermind;

import com.octopusdragon.projects.mastermind.CodeColor;
import com.octopusdragon.projects.mastermind.Codemaster;
import com.octopusdragon.projects.mastermind.KeyColor;
import com.octopusdragon.projects.mastermind.Player;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.stage.Stage;

public class Mastermind
extends Application {
    static final int NUM_SLOTS = 4;
    static final int NUM_COLORS = 6;
    static final int NUM_ROWS = 6;
    static final boolean REPEATING_COLORS = false;
    static final double RADIUS = 25.0;
    static final double GRIDH_SPACING = 10.0;
    static final double GRIDV_SPACING = 8.0;
    static final double H_SPACING = 8.0;
    static final double V_SPACING = 20.0;
    static final double PADDING = 30.0;
    MenuBar menuBar;
    Menu gameMenu;
    MenuItem newGameItem;
    MenuItem settingsItem;
    MenuItem exitItem;
    Menu helpMenu;
    MenuItem howToPlayItem;
    Button backButton;
    Button confirmButton;
    Label messageLabel;
    Label footerText;
    Group[] selectionRow;
    Circle[] hiddenRow;
    Circle[][] codePegs;
    Circle[][] keyPegs;
    HBox selectionBox;
    HBox hiddenBox;
    HBox buttonBox;
    GridPane decodingBoard;
    GridPane[] keyPegGroups;
    BorderPane userInterface;
    Player player;
    boolean finished;
    Codemaster codemaster;
    CodeColor[] hiddenPattern;
    int currentRow;
    int currentCol;
    int numSlots;
    int numColors;
    int numRows;
    boolean repeatingColors;

    public static void main(String[] args) {
        Mastermind.launch((String[])new String[0]);
    }

    public void start(Stage primaryStage) {
        this.numSlots = 4;
        this.numColors = 6;
        this.numRows = 6;
        this.repeatingColors = false;
        this.menuBar = new MenuBar();
        this.gameMenu = new Menu("Game");
        this.newGameItem = new MenuItem("New Game");
        this.newGameItem.setOnAction(event -> this.newGame(primaryStage));
        this.gameMenu.getItems().add((Object)this.newGameItem);
        this.settingsItem = new MenuItem("Settings");
        this.settingsItem.setOnAction(event -> this.showSettings());
        this.gameMenu.getItems().add((Object)this.settingsItem);
        this.exitItem = new MenuItem("Exit");
        this.exitItem.setOnAction(event -> primaryStage.close());
        this.gameMenu.getItems().add((Object)this.exitItem);
        this.menuBar.getMenus().add((Object)this.gameMenu);
        this.helpMenu = new Menu("Help");
        this.howToPlayItem = new MenuItem("How to Play");
        this.howToPlayItem.setOnAction(event -> this.showHowToPlay());
        this.helpMenu.getItems().add((Object)this.howToPlayItem);
        this.menuBar.getMenus().add((Object)this.helpMenu);
        this.messageLabel = new Label();
        this.backButton = new Button("Back");
        this.backButton.setOnAction((EventHandler)new BackButtonHandler());
        this.backButton.setDisable(true);
        this.confirmButton = new Button("Confirm");
        this.confirmButton.setOnAction((EventHandler)new ConfirmButtonHandler());
        this.confirmButton.setDisable(true);
        this.buttonBox = new HBox(8.0, new Node[]{this.backButton, this.confirmButton});
        this.buttonBox.setAlignment(Pos.CENTER);
        this.footerText = new Label("Repeating colors: " + (this.repeatingColors ? "Yes" : "No") + "\tSlots: " + this.numSlots + "\tColors: " + this.numColors);
        HBox footerBox = new HBox(new Node[]{this.footerText});
        footerBox.getStyleClass().add((Object)"background-white");
        this.userInterface = new BorderPane();
        this.userInterface.setTop((Node)this.menuBar);
        this.userInterface.setBottom((Node)footerBox);
        Scene scene = new Scene((Parent)this.userInterface);
        primaryStage.setScene(scene);
        this.newGame(primaryStage);
        primaryStage.setTitle("Mastermind");
        primaryStage.show();
    }

    public void showSettings() {
        Stage secondaryStage = new Stage();
        Label repeatingColorsLabel = new Label("Repeating colors");
        ComboBox repeatingColorsComboBox = new ComboBox();
        repeatingColorsComboBox.getItems().addAll((Object[])new String[]{"Yes", "No"});
        repeatingColorsComboBox.setValue((Object)(this.repeatingColors ? "Yes" : "No"));
        Label slotsLabel = new Label("Number of slots");
        Spinner slotsSpinner = new Spinner();
        SpinnerValueFactory.IntegerSpinnerValueFactory slots = new SpinnerValueFactory.IntegerSpinnerValueFactory(3, 6, this.numSlots);
        slotsSpinner.setValueFactory((SpinnerValueFactory)slots);
        slotsSpinner.setPrefWidth(60.0);
        Label colorsLabel = new Label("Number of colors");
        Spinner colorsSpinner = new Spinner();
        SpinnerValueFactory.IntegerSpinnerValueFactory colors = new SpinnerValueFactory.IntegerSpinnerValueFactory(2, 8, this.numColors);
        colorsSpinner.setValueFactory((SpinnerValueFactory)colors);
        colorsSpinner.setPrefWidth(60.0);
        Label warningLabel = new Label("*New values for settings will only take effect once you start a new game.");
        warningLabel.setWrapText(true);
        warningLabel.setPrefWidth(400.0);
        Button cancelButton = new Button("Cancel");
        cancelButton.setOnAction(event -> secondaryStage.close());
        Button saveChangesButton = new Button("Confirm");
        saveChangesButton.setOnAction(event -> {
            this.repeatingColors = ((String)repeatingColorsComboBox.getValue()).equals("Yes");
            this.numSlots = (Integer)slotsSpinner.getValue();
            this.numColors = (Integer)colorsSpinner.getValue();
            if (this.numColors < this.numSlots && !this.repeatingColors) {
                this.repeatingColors = true;
            }
            secondaryStage.close();
        });
        HBox buttonBox = new HBox(8.0, new Node[]{cancelButton, saveChangesButton});
        buttonBox.setAlignment(Pos.CENTER);
        VBox vbox = new VBox(20.0, new Node[]{repeatingColorsLabel, repeatingColorsComboBox, slotsLabel, slotsSpinner, colorsLabel, colorsSpinner, warningLabel, buttonBox});
        vbox.setAlignment(Pos.CENTER_LEFT);
        vbox.setPadding(new Insets(30.0));
        vbox.setStyle("-fx-background-color: lightgray");
        Scene scene = new Scene((Parent)vbox);
        secondaryStage.setScene(scene);
        secondaryStage.setTitle("Settings");
        secondaryStage.show();
    }

    public void showHowToPlay() {
        Stage secondaryStage = new Stage();
        Label howToPlay = new Label("\tMastermind is a code-breaking game in which, typically, two players take turns placing pegs in rows of holes on a decoding board, trying to guess a hidden pattern of pegs.\n\n\tIn this single-player digital version, a hidden pattern of colored pegs will be created at the start of the game. You have six rows to guess the pattern by clicking the colored buttons at the bottom to put a peg of the corresponding color in the next slot of the current row. After you click the Confirm button, the computer will check your guess and place a series of key pegs to the right of your code pegs. Every white peg you see to the right represents a peg that has the correct color but is in the incorrect position. A black peg represents a correct-colored peg in the correct position. If you guess the pattern correctly, or if you reach the last row without guessing the pattern correctly, the hidden pattern will be revealed, and the game will end.\n\n\tYou can start a new game by clicking the New Game button under the Game menu.\n\n\tYou can also change various settings, such as whether or not to include repeating colors in the pattern, the number of slots in the pattern, and the number of colors. If this is your first time playing, I would recommend you start out with the default settings, with no repeating colors, 4 slots, and 6 colors. If you want more of a challenge, try turning repeating colors off. If you want to up the difficulty even more, try increasing the number of colors.");
        howToPlay.setWrapText(true);
        howToPlay.setPrefWidth(600.0);
        Button okButton = new Button("OK");
        okButton.setOnAction(event -> secondaryStage.close());
        VBox vbox = new VBox(20.0, new Node[]{howToPlay, okButton});
        vbox.setAlignment(Pos.CENTER);
        vbox.setPadding(new Insets(30.0));
        vbox.setStyle("-fx-background-color: lightgray");
        Scene scene = new Scene((Parent)vbox);
        secondaryStage.setScene(scene);
        secondaryStage.setTitle("How to Play");
        secondaryStage.show();
    }

    public Group constructButton(Scene scene, CodeColor codeColor) {
        Color buttonColor;
        double BODY_RADIUS = 22.5;
        double INNER_FRAME_RADIUS = BODY_RADIUS + 5.0;
        double OUTER_FRAME_RADIUS = BODY_RADIUS + 10.0;
        switch (codeColor) {
            case RED: {
                buttonColor = Color.RED;
                break;
            }
            case BLUE: {
                buttonColor = Color.BLUE;
                break;
            }
            case GREEN: {
                buttonColor = Color.GREEN;
                break;
            }
            case YELLOW: {
                buttonColor = Color.YELLOW;
                break;
            }
            case PURPLE: {
                buttonColor = Color.PURPLE;
                break;
            }
            case ORANGE: {
                buttonColor = Color.ORANGE;
                break;
            }
            case CYAN: {
                buttonColor = Color.CYAN;
                break;
            }
            default: {
                buttonColor = Color.MAGENTA;
            }
        }
        Circle outerFrame = new Circle(OUTER_FRAME_RADIUS, (Paint)Color.GRAY);
        Circle innerFrame = new Circle(INNER_FRAME_RADIUS, (Paint)Color.GRAY);
        InnerShadow outerFrameShadow = new InnerShadow();
        outerFrameShadow.setOffsetX(OUTER_FRAME_RADIUS / 3.0);
        outerFrameShadow.setOffsetY(-OUTER_FRAME_RADIUS / 3.0);
        outerFrameShadow.setRadius(OUTER_FRAME_RADIUS);
        outerFrame.setEffect((Effect)outerFrameShadow);
        InnerShadow innerFrameShadow = new InnerShadow();
        innerFrameShadow.setOffsetX(-INNER_FRAME_RADIUS / 3.0);
        innerFrameShadow.setOffsetY(INNER_FRAME_RADIUS / 3.0);
        innerFrameShadow.setRadius(INNER_FRAME_RADIUS);
        innerFrame.setEffect((Effect)innerFrameShadow);
        Circle body = new Circle(BODY_RADIUS, (Paint)buttonColor);
        InnerShadow releasedShadow = new InnerShadow();
        releasedShadow.setOffsetX(BODY_RADIUS / 3.0);
        releasedShadow.setOffsetY(-BODY_RADIUS / 3.0);
        releasedShadow.setRadius(BODY_RADIUS);
        body.setEffect((Effect)releasedShadow);
        InnerShadow pressedShadow = new InnerShadow();
        pressedShadow.setOffsetX(-BODY_RADIUS / 3.0);
        pressedShadow.setOffsetY(BODY_RADIUS / 3.0);
        pressedShadow.setRadius(BODY_RADIUS);
        Group button = new Group(new Node[]{outerFrame, innerFrame, body});
        button.setOnMouseEntered(event -> scene.setCursor(Cursor.HAND));
        button.setOnMouseExited(event -> scene.setCursor(Cursor.DEFAULT));
        button.setOnMousePressed(event -> body.setEffect((Effect)pressedShadow));
        button.setOnMouseReleased(event -> body.setEffect((Effect)releasedShadow));
        return button;
    }

    public Circle constructPeg(CodeColor codeColor) {
        Color pegColor;
        switch (codeColor) {
            case RED: {
                pegColor = Color.RED;
                break;
            }
            case BLUE: {
                pegColor = Color.BLUE;
                break;
            }
            case GREEN: {
                pegColor = Color.GREEN;
                break;
            }
            case YELLOW: {
                pegColor = Color.YELLOW;
                break;
            }
            case PURPLE: {
                pegColor = Color.PURPLE;
                break;
            }
            case ORANGE: {
                pegColor = Color.ORANGE;
                break;
            }
            case CYAN: {
                pegColor = Color.CYAN;
                break;
            }
            default: {
                pegColor = Color.MAGENTA;
            }
        }
        Circle peg = new Circle(25.0, (Paint)pegColor);
        InnerShadow shadow = new InnerShadow();
        shadow.setOffsetX(8.333333333333334);
        shadow.setOffsetY(-8.333333333333334);
        shadow.setRadius(25.0);
        peg.setEffect((Effect)shadow);
        return peg;
    }

    public Circle constructPeg(KeyColor keyColor) {
        Color pegColor;
        switch (keyColor) {
            case BLACK: {
                pegColor = Color.BLACK;
                break;
            }
            default: {
                pegColor = Color.WHITE;
            }
        }
        Circle peg = new Circle(25.0, (Paint)pegColor);
        InnerShadow shadow = new InnerShadow();
        shadow.setOffsetX(8.333333333333334);
        shadow.setOffsetY(-8.333333333333334);
        shadow.setRadius(25.0);
        peg.setEffect((Effect)shadow);
        return peg;
    }

    public void fillWithColor(Circle[] circles, CodeColor[] pattern) {
        int i = 0;
        while (i < circles.length) {
            switch (pattern[i]) {
                case RED: {
                    circles[i].setFill((Paint)Color.RED);
                    break;
                }
                case BLUE: {
                    circles[i].setFill((Paint)Color.BLUE);
                    break;
                }
                case GREEN: {
                    circles[i].setFill((Paint)Color.GREEN);
                    break;
                }
                case YELLOW: {
                    circles[i].setFill((Paint)Color.YELLOW);
                    break;
                }
                case PURPLE: {
                    circles[i].setFill((Paint)Color.PURPLE);
                    break;
                }
                case ORANGE: {
                    circles[i].setFill((Paint)Color.ORANGE);
                    break;
                }
                case CYAN: {
                    circles[i].setFill((Paint)Color.CYAN);
                    break;
                }
                default: {
                    circles[i].setFill((Paint)Color.MAGENTA);
                }
            }
            ++i;
        }
    }

    public void fillWithColor(Circle[] circles, KeyColor[] pattern) {
        int i = 0;
        while (i < pattern.length) {
            switch (pattern[i]) {
                case BLACK: {
                    circles[i].setFill((Paint)Color.BLACK);
                    break;
                }
                default: {
                    circles[i].setFill((Paint)Color.WHITE);
                }
            }
            InnerShadow shadow = new InnerShadow();
            shadow.setOffsetX(2.7777777777777777);
            shadow.setOffsetY(-2.7777777777777777);
            shadow.setRadius(8.333333333333334);
            circles[i].setEffect((Effect)shadow);
            ++i;
        }
    }

    public CodeColor[] toCodeColor(Circle[] circles) {
        CodeColor[] guess = new CodeColor[this.numSlots];
        int i = 0;
        while (i < circles.length) {
            guess[i] = circles[i].getFill().equals(Color.RED) ? CodeColor.RED : (circles[i].getFill().equals(Color.BLUE) ? CodeColor.BLUE : (circles[i].getFill().equals(Color.GREEN) ? CodeColor.GREEN : (circles[i].getFill().equals(Color.YELLOW) ? CodeColor.YELLOW : (circles[i].getFill().equals(Color.PURPLE) ? CodeColor.PURPLE : (circles[i].getFill().equals(Color.ORANGE) ? CodeColor.ORANGE : (circles[i].getFill().equals(Color.CYAN) ? CodeColor.CYAN : CodeColor.MAGENTA))))));
            ++i;
        }
        return guess;
    }

    public void newGame(Stage stage) {
        InnerShadow shadow;
        int j;
        this.player = new Player(this.numSlots);
        this.currentCol = 0;
        this.currentRow = 0;
        this.finished = false;
        this.codemaster = new Codemaster(this.repeatingColors, this.numSlots, this.numColors);
        this.codemaster.makeHiddenPattern();
        this.hiddenPattern = this.codemaster.getHiddenPattern();
        this.messageLabel.setText("");
        this.footerText.setText("Repeating colors: " + (this.repeatingColors ? "Yes" : "No") + "\tSlots: " + this.numSlots + "\tColors: " + this.numColors);
        this.keyPegs = new Circle[this.numRows][this.numSlots];
        this.keyPegGroups = new GridPane[this.numRows];
        int i = 0;
        while (i < this.keyPegGroups.length) {
            this.keyPegGroups[i] = new GridPane();
            this.keyPegGroups[i].setAlignment(Pos.CENTER);
            this.keyPegGroups[i].setHgap(5.0);
            this.keyPegGroups[i].setVgap(4.0);
            j = 0;
            while (j < this.numSlots) {
                this.keyPegs[i][j] = new Circle(8.333333333333334, (Paint)Color.GRAY);
                shadow = new InnerShadow();
                shadow.setOffsetX(-1.6666666666666667);
                shadow.setOffsetY(1.6666666666666667);
                shadow.setRadius(2.7777777777777777);
                this.keyPegs[i][j].setEffect((Effect)shadow);
                this.keyPegGroups[i].add((Node)this.keyPegs[i][j], j, 0);
                ++j;
            }
            ++i;
        }
        this.codePegs = new Circle[this.numRows][this.numSlots];
        this.decodingBoard = new GridPane();
        this.decodingBoard.setHgap(10.0);
        this.decodingBoard.setVgap(8.0);
        i = 0;
        while (i < this.numRows) {
            j = 0;
            while (j < this.numSlots) {
                this.codePegs[i][j] = new Circle(25.0, (Paint)Color.GRAY);
                shadow = new InnerShadow();
                shadow.setOffsetX(-5.0);
                shadow.setOffsetY(5.0);
                shadow.setRadius(8.333333333333334);
                this.codePegs[i][j].setEffect((Effect)shadow);
                this.decodingBoard.add((Node)this.codePegs[i][j], j, i);
                ++j;
            }
            this.decodingBoard.add((Node)this.keyPegGroups[i], this.numSlots, i);
            ++i;
        }
        this.decodingBoard.setAlignment(Pos.CENTER);
        this.hiddenRow = new Circle[this.numSlots];
        this.hiddenBox = new HBox(8.0);
        i = 0;
        while (i < this.numSlots) {
            this.hiddenRow[i] = this.constructPeg(this.hiddenPattern[i]);
            this.hiddenBox.getChildren().add((Object)this.hiddenRow[i]);
            ++i;
        }
        this.hiddenBox.setAlignment(Pos.CENTER);
        this.hiddenBox.setStyle("-fx-border-color: black;");
        Circle[] circleArray = this.hiddenRow;
        int n = this.hiddenRow.length;
        int n2 = 0;
        while (n2 < n) {
            Circle c = circleArray[n2];
            c.setVisible(false);
            ++n2;
        }
        this.selectionRow = new Group[this.numColors];
        this.selectionBox = new HBox(8.0);
        i = 0;
        while (i < this.numColors) {
            this.selectionRow[i] = this.constructButton(stage.getScene(), CodeColor.values()[i]);
            this.selectionBox.getChildren().add((Object)this.selectionRow[i]);
            ++i;
        }
        this.selectionBox.setAlignment(Pos.CENTER);
        circleArray = this.selectionRow;
        n = this.selectionRow.length;
        n2 = 0;
        while (n2 < n) {
            Circle b = circleArray[n2];
            b.setOnMouseClicked((EventHandler)new ColorClickHandler());
            ++n2;
        }
        VBox table = new VBox(20.0);
        table.getChildren().add((Object)this.messageLabel);
        table.getChildren().add((Object)this.decodingBoard);
        table.getChildren().add((Object)this.hiddenBox);
        table.getChildren().add((Object)this.selectionBox);
        table.getChildren().add((Object)this.buttonBox);
        table.setAlignment(Pos.CENTER);
        table.setPadding(new Insets(30.0));
        table.setStyle("-fx-background-color: lightgray");
        this.userInterface.setCenter((Node)table);
        stage.sizeToScene();
    }

    public class BackButtonHandler
    implements EventHandler<ActionEvent> {
        public void handle(ActionEvent event) {
            if (Mastermind.this.currentCol != 0) {
                --Mastermind.this.currentCol;
                Mastermind.this.codePegs[Mastermind.this.currentRow][Mastermind.this.currentCol].setFill((Paint)Color.GRAY);
                InnerShadow shadow = new InnerShadow();
                shadow.setOffsetX(-5.0);
                shadow.setOffsetY(5.0);
                shadow.setRadius(8.333333333333334);
                Mastermind.this.codePegs[Mastermind.this.currentRow][Mastermind.this.currentCol].setEffect((Effect)shadow);
                Mastermind.this.confirmButton.setDisable(true);
            }
            if (Mastermind.this.currentCol == 0) {
                Mastermind.this.backButton.setDisable(true);
            }
        }
    }

    public class ColorClickHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            if (!Mastermind.this.finished && Mastermind.this.currentCol < Mastermind.this.numSlots) {
                Mastermind.this.codePegs[Mastermind.this.currentRow][Mastermind.this.currentCol].setFill(((Circle)((Group)event.getSource()).getChildren().get(2)).getFill());
                InnerShadow shadow = new InnerShadow();
                shadow.setOffsetX(8.333333333333334);
                shadow.setOffsetY(-8.333333333333334);
                shadow.setRadius(25.0);
                Mastermind.this.codePegs[Mastermind.this.currentRow][Mastermind.this.currentCol].setEffect((Effect)shadow);
                ++Mastermind.this.currentCol;
                Mastermind.this.backButton.setDisable(false);
            }
            if (Mastermind.this.currentCol == Mastermind.this.numSlots) {
                Mastermind.this.confirmButton.setDisable(false);
            }
        }
    }

    public class ConfirmButtonHandler
    implements EventHandler<ActionEvent> {
        public void handle(ActionEvent event) {
            if (Mastermind.this.currentCol == Mastermind.this.numSlots) {
                Mastermind.this.player.setGuessPattern(Mastermind.this.toCodeColor(Mastermind.this.codePegs[Mastermind.this.currentRow]));
                Mastermind.this.currentCol = 0;
                KeyColor[] feedbackPattern = Mastermind.this.codemaster.checkGuess(Mastermind.this.player);
                Mastermind.this.fillWithColor(Mastermind.this.keyPegs[Mastermind.this.currentRow], feedbackPattern);
                ++Mastermind.this.currentRow;
                Mastermind.this.currentCol = 0;
                if (feedbackPattern.length == Mastermind.this.numSlots && feedbackPattern[Mastermind.this.numSlots - 1].equals((Object)KeyColor.BLACK)) {
                    Mastermind.this.finished = true;
                    Mastermind.this.messageLabel.setText("Congratulations! You WON!");
                } else if (Mastermind.this.currentRow == Mastermind.this.numRows) {
                    Mastermind.this.finished = true;
                    Mastermind.this.messageLabel.setText("You lost. Better luck next time.");
                }
                if (Mastermind.this.finished) {
                    Circle[] circleArray = Mastermind.this.hiddenRow;
                    int n = Mastermind.this.hiddenRow.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Circle c = circleArray[n2];
                        c.setVisible(true);
                        ++n2;
                    }
                }
                Mastermind.this.confirmButton.setDisable(true);
                Mastermind.this.backButton.setDisable(true);
            }
        }
    }
}

