/*
 * Decompiled with CFR 0.152.
 */
package com.octopusdragon.projects.mastermind;

import com.octopusdragon.projects.mastermind.CodeColor;
import com.octopusdragon.projects.mastermind.KeyColor;
import com.octopusdragon.projects.mastermind.Player;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;

public class Codemaster {
    private boolean repeatingColors;
    private CodeColor[] hiddenPattern;
    private int colors;

    public Codemaster(boolean repColors, int numHoles, int numColors) {
        this.repeatingColors = repColors;
        this.colors = numColors;
        this.hiddenPattern = new CodeColor[numHoles];
    }

    public void makeHiddenPattern() {
        Random rand = new Random();
        if (this.repeatingColors) {
            int i = 0;
            while (i < this.hiddenPattern.length) {
                this.hiddenPattern[i] = CodeColor.values()[rand.nextInt(this.colors)];
                ++i;
            }
        } else {
            ArrayList<CodeColor> colorPool = new ArrayList<CodeColor>();
            int i = 0;
            while (i < CodeColor.values().length) {
                colorPool.add(CodeColor.values()[i]);
                ++i;
            }
            i = 0;
            while (i < this.hiddenPattern.length) {
                int index = rand.nextInt(this.colors);
                this.hiddenPattern[i] = (CodeColor)((Object)colorPool.get(index));
                colorPool.remove(index);
                --this.colors;
                ++i;
            }
        }
    }

    public CodeColor[] getHiddenPattern() {
        return this.hiddenPattern;
    }

    public KeyColor[] checkGuess(Player player) {
        KeyColor[] keys = new KeyColor[this.hiddenPattern.length];
        int keysLength = 0;
        ArrayList<CodeColor> guessList = new ArrayList<CodeColor>(Arrays.asList(player.getGuessPattern()));
        ArrayList<CodeColor> hiddenList = new ArrayList<CodeColor>(Arrays.asList(this.hiddenPattern));
        Iterator<CodeColor> guess = guessList.iterator();
        Iterator<CodeColor> hidden = hiddenList.iterator();
        while (guess.hasNext()) {
            if (!guess.next().equals((Object)hidden.next())) continue;
            keys[keysLength] = KeyColor.BLACK;
            guess.remove();
            hidden.remove();
            ++keysLength;
        }
        block1: for (CodeColor element : guessList) {
            hidden = hiddenList.iterator();
            while (hidden.hasNext()) {
                if (!element.equals((Object)hidden.next())) continue;
                keys[keysLength] = KeyColor.WHITE;
                hidden.remove();
                ++keysLength;
                continue block1;
            }
        }
        keys = Arrays.copyOf(keys, keysLength);
        return keys;
    }
}

