/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.intervaltimer.application.windows;

import java.io.IOException;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.image.Image;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import tech.octopusdragon.intervaltimer.Alert;
import tech.octopusdragon.intervaltimer.Interval;
import tech.octopusdragon.intervaltimer.Preset;
import tech.octopusdragon.intervaltimer.application.controls.AlertComboBox;
import tech.octopusdragon.intervaltimer.application.controls.IntervalSpinner;
import tech.octopusdragon.intervaltimer.application.util.Resource;

public class PresetDialog
extends Dialog<Interval[]> {
    @FXML
    private GridPane presetGrid;

    public PresetDialog(final Preset preset) {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("PresetDialogPane.fxml"));
        loader.setController((Object)this);
        try {
            this.setDialogPane((DialogPane)loader.load());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ((Labeled)this.getDialogPane().getHeader()).setText(preset.toString());
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Button okButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
        int i = 0;
        while (i < preset.getValues().length) {
            Preset.Value intervalType = preset.getValues()[i];
            final IntervalSpinner spinner = new IntervalSpinner(intervalType.getNumUnits());
            this.presetGrid.add((Node)new Label(intervalType.getName()), 0, i);
            this.presetGrid.add((Node)spinner, 1, i);
            this.presetGrid.add((Node)new Label(intervalType.getUnit().toString()), 2, i);
            if (intervalType.hasAlert()) {
                AlertComboBox alertComboBox = new AlertComboBox();
                alertComboBox.setValue((Object)intervalType.getAlert());
                this.presetGrid.add((Node)alertComboBox, 3, i);
                alertComboBox.valueProperty().addListener((obs, oldVal, newVal) -> intervalType.setAlert((Alert)((Object)newVal)));
            }
            spinner.valueProperty().addListener((obs, oldVal, newVal) -> intervalType.setNumUnits((int)newVal));
            okButton.addEventFilter(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (!this.validData()) {
                        event.consume();
                    }
                }

                private boolean validData() {
                    return (Integer)spinner.getValue() > 0;
                }
            });
            ++i;
        }
        this.setResultConverter((Callback)new Callback<ButtonType, Interval[]>(){

            public Interval[] call(ButtonType param) {
                if (param == ButtonType.OK) {
                    return preset.intervals();
                }
                return null;
            }
        });
        this.setTitle("Preset");
        ((Stage)this.getDialogPane().getScene().getWindow()).getIcons().add((Object)new Image(Resource.ICON.getResourceAsStream()));
    }
}

