/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.intervaltimer.application.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import tech.octopusdragon.intervaltimer.Alert;
import tech.octopusdragon.intervaltimer.Interval;

public class Userdata {
    private static final String USERDATA_FOLDERNAME = "userdata";
    private static final String FILENAME = "interval_timer_userdata.ser";
    private static Properties properties = Userdata.loadProperties();

    private static Properties loadProperties() {
        Properties object = null;
        try {
            FileInputStream fileIn = new FileInputStream("userdata/interval_timer_userdata.ser");
            ObjectInputStream objectIn = new ObjectInputStream(fileIn);
            object = (Properties)objectIn.readObject();
            objectIn.close();
        }
        catch (IOException | ClassNotFoundException e) {
            object = new Properties();
        }
        return object;
    }

    private static void saveProperties() {
        File folder = new File(USERDATA_FOLDERNAME);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            FileOutputStream fileOut = new FileOutputStream("userdata/interval_timer_userdata.ser");
            ObjectOutputStream objectOut = new ObjectOutputStream(fileOut);
            objectOut.writeObject(properties);
            objectOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String readProperty(String key) {
        return properties.getProperty(key);
    }

    public static String readProperty(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static Interval[] readIntervals() {
        int numIntervals = Integer.parseInt(Userdata.readProperty("num-intervals", Integer.toString(0)));
        if (numIntervals == 0) {
            return new Interval[]{new Interval()};
        }
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        int i = 0;
        while (i < numIntervals) {
            String intervalId = String.format("interval-%d", i);
            String intervalHours = String.format("%s-hours", intervalId);
            String intervalMinutes = String.format("%s-minutes", intervalId);
            String intervalSeconds = String.format("%s-seconds", intervalId);
            String intervalAlert = String.format("%s-alert", intervalId);
            int h = Integer.parseInt(Userdata.readProperty(intervalHours));
            int m = Integer.parseInt(Userdata.readProperty(intervalMinutes));
            int s = Integer.parseInt(Userdata.readProperty(intervalSeconds));
            try {
                Alert alert = Alert.valueOf(Userdata.readProperty(intervalAlert));
                intervals.add(new Interval(h, m, s, alert));
            }
            catch (NullPointerException e) {
                intervals.add(new Interval(h, m, s));
            }
            ++i;
        }
        return intervals.toArray(new Interval[numIntervals]);
    }

    public static void writeProperty(String key, String value) {
        properties.setProperty(key, value);
        Userdata.saveProperties();
    }

    public static void writeInterval(int index, Interval interval) {
        String intervalId = String.format("interval-%d", index);
        String intervalHours = String.format("%s-hours", intervalId);
        String intervalMinutes = String.format("%s-minutes", intervalId);
        String intervalSeconds = String.format("%s-seconds", intervalId);
        String intervalAlert = String.format("%s-alert", intervalId);
        Userdata.writeProperty(intervalHours, Integer.toString(interval.hours()));
        Userdata.writeProperty(intervalMinutes, Integer.toString(interval.minutes()));
        Userdata.writeProperty(intervalSeconds, Integer.toString(interval.seconds()));
        if (interval.hasAlert()) {
            Userdata.writeProperty(intervalAlert, interval.getAlert().name());
        }
    }
}

