/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.intervaltimer.application.scenes;

import java.util.TimerTask;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import tech.octopusdragon.intervaltimer.IntervalTimer;
import tech.octopusdragon.intervaltimer.Modality;
import tech.octopusdragon.intervaltimer.application.IntervalTimerApplication;
import tech.octopusdragon.intervaltimer.application.controls.CountdownPieChart;
import tech.octopusdragon.intervaltimer.application.util.Userdata;
import tech.octopusdragon.intervaltimer.application.util.Values;

public class TimerSceneController {
    private IntervalTimer intervalTimer;
    @FXML
    private Label intervalLabel;
    @FXML
    private ComboBox<Modality> modalityComboBox;
    @FXML
    private Label timerLabel;
    @FXML
    private CountdownPieChart timerPieChart;
    @FXML
    private Button backButton;
    @FXML
    private Button pauseResumeButton;
    @FXML
    private Button previousButton;
    @FXML
    private Button nextButton;
    @FXML
    private Button restartButton;
    @FXML
    private Button restartIntervalButton;

    public void setTimer(IntervalTimer timer) {
        this.intervalTimer = timer;
        this.intervalTimer.addTask(new TimerTask(){

            @Override
            public void run() {
                Platform.runLater(() -> TimerSceneController.this.updateDisplay());
            }
        });
        this.updateDisplay();
        Modality[] modalityArray = Modality.values();
        int n = modalityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Modality modality = modalityArray[n2];
            this.modalityComboBox.getItems().add((Object)modality);
            ++n2;
        }
        this.modalityComboBox.setValue((Object)Modality.valueOf(Userdata.readProperty("modality", Values.DEFAULT_MODALITY.name())));
        this.modalityComboBox.valueProperty().addListener((obs, oldVal, newVal) -> {
            this.setModality((Modality)((Object)((Object)this.modalityComboBox.getValue())));
            Userdata.writeProperty("modality", newVal.name());
        });
        this.timerLabel.managedProperty().bind((ObservableValue)this.timerLabel.visibleProperty());
        this.timerPieChart.managedProperty().bind((ObservableValue)this.timerPieChart.visibleProperty());
    }

    private void setModality(Modality modality) {
        switch (modality) {
            case DIGITAL: {
                this.timerLabel.setVisible(true);
                this.timerPieChart.setVisible(false);
                break;
            }
            case ANALOG: {
                this.timerLabel.setVisible(false);
                this.timerPieChart.setVisible(true);
                break;
            }
            case BOTH: {
                this.timerLabel.setVisible(true);
                this.timerPieChart.setVisible(true);
            }
        }
    }

    private void updateDisplay() {
        this.intervalLabel.setText(this.intervalTimer.intervalNumberString());
        this.timerLabel.setText(this.intervalTimer.timeLeftString());
        this.timerPieChart.displayElapsedTime(this.intervalTimer.timeLeft(), this.intervalTimer.curInterval().getDuration());
        if (!this.previousButton.isDisabled() && !this.intervalTimer.isRepeat() && this.intervalTimer.curIntervalIndex() == 0) {
            this.previousButton.setDisable(true);
        } else if (this.previousButton.isDisabled() && this.intervalTimer.isRepeat() || this.intervalTimer.curIntervalIndex() != 0) {
            this.previousButton.setDisable(false);
        }
        if (!this.nextButton.isDisabled() && !this.intervalTimer.isRepeat() && this.intervalTimer.curIntervalIndex() == this.intervalTimer.numIntervals() - 1) {
            this.nextButton.setDisable(true);
        } else if (this.nextButton.isDisabled() && this.intervalTimer.isRepeat() || this.intervalTimer.curIntervalIndex() != this.intervalTimer.numIntervals() - 1) {
            this.nextButton.setDisable(false);
        }
        if (this.intervalTimer.isCanceled()) {
            this.pauseResumeButton.setDisable(true);
            this.previousButton.setDisable(true);
            this.nextButton.setDisable(true);
            this.restartButton.setDisable(true);
            this.restartIntervalButton.setDisable(true);
        }
        if (this.intervalTimer.isRunning()) {
            this.pauseResumeButton.setText("Pause");
        } else {
            this.pauseResumeButton.setText("Resume");
        }
    }

    @FXML
    private void backToMenu(ActionEvent event) {
        if (this.intervalTimer.isRunning()) {
            this.intervalTimer.freeze();
        }
        this.updateDisplay();
        IntervalTimerApplication.switchToMenuScene();
    }

    @FXML
    private void togglePause(ActionEvent event) {
        this.intervalTimer.togglePause();
        this.updateDisplay();
    }

    @FXML
    private void previous(ActionEvent event) {
        this.intervalTimer.previous();
        this.updateDisplay();
    }

    @FXML
    private void next(ActionEvent event) {
        this.intervalTimer.next();
        this.updateDisplay();
    }

    @FXML
    private void restart(ActionEvent event) {
        this.intervalTimer.restart();
        this.updateDisplay();
    }

    @FXML
    private void restartInterval(ActionEvent event) {
        this.intervalTimer.restartInterval();
        this.updateDisplay();
    }
}

