/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.intervaltimer.application.scenes;

import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import tech.octopusdragon.intervaltimer.Alert;
import tech.octopusdragon.intervaltimer.Interval;
import tech.octopusdragon.intervaltimer.Preset;
import tech.octopusdragon.intervaltimer.application.IntervalTimerApplication;
import tech.octopusdragon.intervaltimer.application.controls.AlertComboBox;
import tech.octopusdragon.intervaltimer.application.controls.IntervalEditorBox;
import tech.octopusdragon.intervaltimer.application.util.Userdata;
import tech.octopusdragon.intervaltimer.application.util.Values;
import tech.octopusdragon.intervaltimer.application.windows.PresetDialog;

public class MenuSceneController {
    @FXML
    private Parent root;
    @FXML
    private ColorPicker colorPicker;
    @FXML
    private MenuButton presetMenuButton;
    @FXML
    private GridPane intervalTable;
    @FXML
    private Button addIntervalButton;
    @FXML
    private Button removeIntervalButton;
    @FXML
    private Button startButton;
    @FXML
    private Button continueButton;
    @FXML
    private CheckBox sharedAlertCheckBox;
    @FXML
    private AlertComboBox alertComboBox;
    @FXML
    private CheckBox repeatCheckBox;
    private ObservableList<IntervalEditorBox> intervalEditorBoxes;

    @FXML
    private void initialize() {
        Interval[] intervals;
        this.intervalEditorBoxes = FXCollections.observableArrayList();
        this.colorPicker.setValue((Object)Color.web((String)Userdata.readProperty("ui-color", "brown")));
        Preset[] presetArray = Preset.values();
        int n = presetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Preset preset = presetArray[n2];
            MenuItem presetMenuItem = new MenuItem(preset.toString());
            presetMenuItem.setOnAction(event -> {
                PresetDialog presetDialog = new PresetDialog(preset);
                presetDialog.getDialogPane().setStyle(this.root.getStyle());
                Optional value = presetDialog.showAndWait();
                if (value != null && value.isPresent()) {
                    Interval[] intervals = (Interval[])value.get();
                    this.setIntervals(intervals);
                    int i = 0;
                    while (i < intervals.length) {
                        Userdata.writeInterval(i, intervals[i]);
                        ++i;
                    }
                }
            });
            this.presetMenuButton.getItems().add((Object)presetMenuItem);
            ++n2;
        }
        this.alertComboBox.disableProperty().bind((ObservableValue)this.sharedAlertCheckBox.selectedProperty().not());
        this.alertComboBox.setValue((Object)Alert.valueOf(Userdata.readProperty("alert", Values.DEFAULT_ALERT.name())));
        this.alertComboBox.valueProperty().addListener((obs, oldVal, newVal) -> Userdata.writeProperty("alert", newVal.name()));
        this.sharedAlertCheckBox.setSelected(Boolean.parseBoolean(Userdata.readProperty("shared", Boolean.toString(true))));
        this.sharedAlertCheckBox.selectedProperty().addListener((obs, oldVal, newVal) -> Userdata.writeProperty("shared", Boolean.toString(newVal)));
        this.repeatCheckBox.setSelected(Boolean.parseBoolean(Userdata.readProperty("repeat", Boolean.toString(true))));
        this.repeatCheckBox.selectedProperty().addListener((obs, oldVal, newVal) -> Userdata.writeProperty("repeat", Boolean.toString(newVal)));
        SpinnerValueZeroListener parentListener = new SpinnerValueZeroListener();
        this.intervalEditorBoxes.addListener(parentListener);
        this.removeIntervalButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.intervalEditorBoxes.size() <= 1) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.intervalEditorBoxes}));
        this.continueButton.disableProperty().bind((ObservableValue)IntervalTimerApplication.timerProperty().isNull());
        Interval[] intervalArray = intervals = Userdata.readIntervals();
        int n3 = intervals.length;
        int n4 = 0;
        while (n4 < n3) {
            Interval inverval = intervalArray[n4];
            this.addInterval(inverval);
            ++n4;
        }
        this.evaluateButton();
    }

    private Interval[] getIntervals() {
        Interval[] intervals = new Interval[this.intervalEditorBoxes.size()];
        int i = 0;
        while (i < this.intervalEditorBoxes.size()) {
            intervals[i] = ((IntervalEditorBox)((Object)this.intervalEditorBoxes.get(i))).getInterval();
            ++i;
        }
        return intervals;
    }

    private void addInterval() {
        this.addInterval(0, 0, 0, null);
        Userdata.writeInterval(this.intervalEditorBoxes.size() - 1, ((IntervalEditorBox)((Object)this.intervalEditorBoxes.get(this.intervalEditorBoxes.size() - 1))).getInterval());
        Userdata.writeProperty("num-intervals", Integer.toString(this.intervalEditorBoxes.size()));
    }

    private void addInterval(Interval interval) {
        int h = interval.hours();
        int m = interval.minutes();
        int s = interval.seconds();
        Alert alert = interval.getAlert();
        this.addInterval(h, m, s, alert);
    }

    private void addInterval(int h, int m, int s, Alert alert) {
        Label newLabel = new Label("Interval " + (this.intervalEditorBoxes.size() + 1));
        this.intervalTable.add((Node)newLabel, 0, this.intervalEditorBoxes.size());
        IntervalEditorBox newEditorBox = new IntervalEditorBox(new Interval(h, m, s, alert));
        this.intervalTable.add((Node)newEditorBox, 1, this.intervalEditorBoxes.size());
        this.intervalEditorBoxes.add((Object)newEditorBox);
        newEditorBox.intervalProperty().addListener(new SpinnerValueZeroListener());
        newEditorBox.alertDisabledProperty().bind((ObservableValue)this.sharedAlertCheckBox.selectedProperty());
        newEditorBox.intervalProperty().addListener((obs, oldVal, newVal) -> Userdata.writeInterval(this.intervalEditorBoxes.indexOf((Object)newEditorBox), newVal));
    }

    private void removeInterval() {
        this.intervalTable.getChildren().remove(this.intervalTable.getChildren().size() - 2, this.intervalTable.getChildren().size());
        this.intervalEditorBoxes.remove(this.intervalEditorBoxes.size() - 1);
        Userdata.writeProperty("num-intervals", Integer.toString(this.intervalEditorBoxes.size()));
    }

    private void removeAllIntervals() {
        while (!this.intervalEditorBoxes.isEmpty()) {
            this.removeInterval();
        }
    }

    private void setIntervals(Interval[] intervals) {
        this.removeAllIntervals();
        Alert firstAlert = intervals[0].getAlert();
        boolean foundNullAlert = false;
        boolean foundDifferentAlert = false;
        Interval[] intervalArray = intervals;
        int n = intervals.length;
        int n2 = 0;
        while (n2 < n) {
            Interval interval = intervalArray[n2];
            this.addInterval(interval);
            Userdata.writeInterval(this.intervalEditorBoxes.size() - 1, interval);
            if (!foundNullAlert && !interval.hasAlert()) {
                foundNullAlert = true;
            }
            if (!foundDifferentAlert && interval.getAlert() != firstAlert) {
                foundDifferentAlert = true;
            }
            ++n2;
        }
        if (foundNullAlert) {
            this.sharedAlertCheckBox.setSelected(true);
        } else if (foundDifferentAlert) {
            this.sharedAlertCheckBox.setSelected(false);
            int i = 0;
            while (i < intervals.length) {
                ((IntervalEditorBox)((Object)this.intervalEditorBoxes.get(i))).setAlert(intervals[i].getAlert());
                ++i;
            }
        } else {
            this.sharedAlertCheckBox.setSelected(true);
            this.alertComboBox.setValue((Object)firstAlert);
        }
        Userdata.writeProperty("num-intervals", Integer.toString(this.intervalEditorBoxes.size()));
    }

    @FXML
    private void addInterval(ActionEvent event) {
        this.addInterval();
    }

    @FXML
    private void removeInterval(ActionEvent event) {
        this.removeInterval();
    }

    @FXML
    private void startIntervalTimer(ActionEvent event) {
        IntervalTimerApplication.switchToNewTimerScene(this.sharedAlertCheckBox.isSelected() ? (Alert)((Object)this.alertComboBox.getValue()) : null, this.repeatCheckBox.isSelected(), this.getIntervals());
    }

    @FXML
    private void continueIntervalTimer(ActionEvent event) {
        IntervalTimerApplication.switchToLastTimerScene();
    }

    @FXML
    private void changeUIColor(ActionEvent event) {
        Color color = (Color)this.colorPicker.getValue();
        String colorStr = String.format("#%02x%02x%02x", (int)Math.round(color.getRed() * 255.0), (int)Math.round(color.getGreen() * 255.0), (int)Math.round(color.getBlue() * 255.0));
        Userdata.writeProperty("ui-color", colorStr);
        this.root.setStyle("-base: " + colorStr);
    }

    private void evaluateButton() {
        if (this.intervalEditorBoxes == null) {
            return;
        }
        boolean zeroFound = false;
        int i = 0;
        while (i < this.intervalEditorBoxes.size()) {
            if (((IntervalEditorBox)((Object)this.intervalEditorBoxes.get(i))).getInterval().hours() == 0 && ((IntervalEditorBox)((Object)this.intervalEditorBoxes.get(i))).getInterval().minutes() == 0 && ((IntervalEditorBox)((Object)this.intervalEditorBoxes.get(i))).getInterval().seconds() == 0) {
                zeroFound = true;
                break;
            }
            ++i;
        }
        if (zeroFound && !this.startButton.isDisabled()) {
            this.startButton.setDisable(true);
        } else if (!zeroFound && this.startButton.isDisabled()) {
            this.startButton.setDisable(false);
        }
    }

    private class SpinnerValueZeroListener<T>
    implements ChangeListener<T>,
    ListChangeListener<T> {
        private SpinnerValueZeroListener() {
        }

        public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
            MenuSceneController.this.evaluateButton();
        }

        public void onChanged(ListChangeListener.Change<? extends T> c) {
            MenuSceneController.this.evaluateButton();
        }
    }
}

