/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.intervaltimer.application.controls;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.util.StringConverter;

public class IntervalSpinner
extends Spinner<Integer> {
    private static final int MAX_VALUE = 99;

    public IntervalSpinner() {
        this(0);
    }

    public IntervalSpinner(int initialValue) {
        super((SpinnerValueFactory)new IntervalSpinnerValueFactory(0, 99, initialValue));
        this.setEditable(true);
        this.getStyleClass().add((Object)"split-arrows-vertical");
        this.getEditor().textProperty().addListener((ChangeListener)new EditorAlphaListener(this));
        this.focusedProperty().addListener((ChangeListener)new SpinnerFocusLostListener(this));
    }

    private static class EditorAlphaListener
    implements ChangeListener<String> {
        private Spinner<Integer> spinner;

        public EditorAlphaListener(Spinner<Integer> spinner) {
            this.spinner = spinner;
        }

        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            try {
                if (!newValue.isEmpty()) {
                    Integer.parseInt(newValue);
                }
                if (newValue.length() > Integer.toString(99).length()) {
                    newValue = newValue.substring(1);
                }
                this.spinner.getEditor().setText(newValue);
            }
            catch (NumberFormatException e) {
                this.spinner.getEditor().setText(oldValue);
            }
        }
    }

    private static class IntervalSpinnerValueFactory
    extends SpinnerValueFactory.IntegerSpinnerValueFactory {
        public IntervalSpinnerValueFactory(int min, int max, int initialValue) {
            super(min, max, initialValue);
            this.setConverter((StringConverter)new StringConverter<Integer>(){

                public String toString(Integer object) {
                    return String.format("%02d", object);
                }

                public Integer fromString(String string) {
                    return Integer.parseInt(string);
                }
            });
        }
    }

    private static class SpinnerFocusLostListener
    implements ChangeListener<Boolean> {
        private IntervalSpinner spinner;

        public SpinnerFocusLostListener(IntervalSpinner spinner) {
            this.spinner = spinner;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (!newValue.booleanValue()) {
                StringConverter converter;
                if (!this.spinner.isEditable()) {
                    return;
                }
                String text = this.spinner.getEditor().getText();
                SpinnerValueFactory valueFactory = this.spinner.getValueFactory();
                if (valueFactory != null && (converter = valueFactory.getConverter()) != null) {
                    if (text.isEmpty()) {
                        text = ((IntervalSpinnerValueFactory)this.spinner.getValueFactory()).getConverter().toString((Object)0);
                        this.spinner.getEditor().setText(text);
                    }
                    Integer value = (Integer)converter.fromString(text);
                    valueFactory.setValue((Object)value);
                }
            }
        }
    }
}

