/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.intervaltimer.application.controls;

import java.io.IOException;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.layout.HBox;
import tech.octopusdragon.intervaltimer.Alert;
import tech.octopusdragon.intervaltimer.Interval;
import tech.octopusdragon.intervaltimer.application.controls.AlertComboBox;
import tech.octopusdragon.intervaltimer.application.controls.IntervalSpinner;

public class IntervalEditorBox
extends HBox {
    @FXML
    private IntervalSpinner hourSpinner;
    @FXML
    private IntervalSpinner minuteSpinner;
    @FXML
    private IntervalSpinner secondSpinner;
    @FXML
    private AlertComboBox alertComboBox;
    private ObjectProperty<Interval> intervalProperty;
    private BooleanProperty alertDisabledProperty;

    public IntervalEditorBox() {
        this(new Interval(), false);
    }

    public IntervalEditorBox(Interval interval) {
        this(interval, false);
    }

    public IntervalEditorBox(boolean alertDisabled) {
        this(new Interval(), alertDisabled);
    }

    public IntervalEditorBox(Interval interval, boolean alertDisabled) {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("IntervalEditorBox.fxml"));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.intervalProperty = new SimpleObjectProperty((Object)interval);
        this.alertDisabledProperty = new SimpleBooleanProperty(alertDisabled);
        this.build();
    }

    public void build() {
        this.hourSpinner.getValueFactory().setValue((Object)this.getInterval().hours());
        this.hourSpinner.valueProperty().addListener((ChangeListener)new ValueChangeListener());
        this.minuteSpinner.getValueFactory().setValue((Object)this.getInterval().minutes());
        this.minuteSpinner.valueProperty().addListener((ChangeListener)new ValueChangeListener());
        this.secondSpinner.getValueFactory().setValue((Object)this.getInterval().seconds());
        this.secondSpinner.valueProperty().addListener((ChangeListener)new ValueChangeListener());
        this.alertComboBox.setValue((Object)this.getInterval().getAlert());
        this.alertComboBox.valueProperty().addListener((ChangeListener)new ValueChangeListener());
        this.alertComboBox.visibleProperty().bind((ObservableValue)this.alertDisabledProperty.not());
        this.alertComboBox.visibleProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.getChildren().add((Object)this.alertComboBox);
            } else {
                this.getChildren().remove((Object)this.alertComboBox);
            }
        });
    }

    public void setHours(int h) {
        this.hourSpinner.getValueFactory().setValue((Object)h);
    }

    public int getHours() {
        return (Integer)this.hourSpinner.getValue();
    }

    public void setMinutes(int m) {
        this.minuteSpinner.getValueFactory().setValue((Object)m);
    }

    public int getMinutes() {
        return (Integer)this.minuteSpinner.getValue();
    }

    public void setSeconds(int s) {
        this.secondSpinner.getValueFactory().setValue((Object)s);
    }

    public int getSeconds() {
        return (Integer)this.secondSpinner.getValue();
    }

    public void setAlert(Alert alert) {
        this.alertComboBox.setValue((Object)alert);
    }

    public Alert getAlert() {
        return (Alert)((Object)this.alertComboBox.getValue());
    }

    public ObjectProperty<Interval> intervalProperty() {
        return this.intervalProperty;
    }

    public Interval getInterval() {
        return (Interval)this.intervalProperty.get();
    }

    public void setInterval(Interval interval) {
        this.intervalProperty.set((Object)interval);
    }

    public BooleanProperty alertDisabledProperty() {
        return this.alertDisabledProperty;
    }

    public boolean alertIsDisabled() {
        return this.alertDisabledProperty.get();
    }

    public void disableAlert(boolean disableAlert) {
        this.alertDisabledProperty.set(disableAlert);
    }

    private class ValueChangeListener
    implements ChangeListener<Object> {
        private ValueChangeListener() {
        }

        public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
            IntervalEditorBox.this.setInterval(new Interval((Integer)IntervalEditorBox.this.hourSpinner.getValue(), (Integer)IntervalEditorBox.this.minuteSpinner.getValue(), (Integer)IntervalEditorBox.this.secondSpinner.getValue(), !IntervalEditorBox.this.alertIsDisabled() ? (Alert)((Object)IntervalEditorBox.this.alertComboBox.getValue()) : null));
        }
    }
}

