/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.intervaltimer.application.controls;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Ellipse;

public class CountdownPieChart
extends Pane {
    private static final double PIE_CHART_PROPORTION = 0.9;
    private static final double OUTLINE_PROPORTION = 0.05;
    @FXML
    private Arc pieChart;
    @FXML
    private Ellipse outline;
    private StyleableProperty<Number> sizeProperty = new SimpleStyleableDoubleProperty(SIZE);
    private StyleableProperty<Paint> paintProperty = new SimpleStyleableObjectProperty(PAINT);
    private static final StyleablePropertyFactory<CountdownPieChart> FACTORY = new StyleablePropertyFactory(Pane.getClassCssMetaData());
    private static final CssMetaData<CountdownPieChart, Number> SIZE = FACTORY.createSizeCssMetaData("-size", s -> s.sizeProperty);
    private static final CssMetaData<CountdownPieChart, Paint> PAINT = FACTORY.createPaintCssMetaData("-paint", s -> s.paintProperty);

    public CountdownPieChart() {
        this.sizeProperty().addListener((obs, oldVal, newVal) -> {
            this.setPrefWidth(newVal.doubleValue());
            this.setPrefHeight(newVal.doubleValue());
        });
        this.paintProperty().addListener((obs, oldVal, newVal) -> {
            this.pieChart.setFill(newVal);
            this.outline.setStroke(newVal);
        });
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("CountdownPieChart.fxml"));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void displayElapsedTime(Duration timeLeft, Duration curDuration) {
        double lengthProportion = (double)timeLeft.toMillis() / (double)curDuration.toMillis();
        if (lengthProportion < 0.0) {
            lengthProportion = 0.0;
        }
        double length = 360.0 * lengthProportion;
        this.pieChart.setLength(length);
    }

    public double getSize() {
        return ((Number)this.sizeProperty.getValue()).doubleValue();
    }

    public void setSize(double size) {
        this.sizeProperty.setValue((Object)size);
    }

    public ObservableDoubleValue sizeProperty() {
        return (ObservableDoubleValue)this.sizeProperty;
    }

    public Paint getPaint() {
        return (Paint)this.paintProperty.getValue();
    }

    public void setPaint(Paint paint) {
        this.paintProperty.setValue((Object)paint);
    }

    public ObservableValue<Paint> paintProperty() {
        return (ObservableValue)this.paintProperty;
    }

    public void layoutChildren() {
        double height;
        double width = Math.max(this.getMinWidth(), this.getPrefWidth());
        double size = width < (height = Math.max(this.getMinHeight(), this.getPrefHeight())) ? width : height;
        this.pieChart.setRadiusX(size * 0.9 / 2.0);
        this.pieChart.setRadiusY(size * 0.9 / 2.0);
        this.pieChart.setCenterX(width / 2.0);
        this.pieChart.setCenterY(height / 2.0);
        this.outline.setRadiusX(size / 2.0);
        this.outline.setRadiusY(size / 2.0);
        this.outline.setStrokeWidth(size * 0.05 / 2.0);
        this.outline.setCenterX(width / 2.0);
        this.outline.setCenterY(height / 2.0);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FACTORY.getCssMetaData();
    }
}

