/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.intervaltimer.application.controls;

import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import tech.octopusdragon.intervaltimer.Alert;

public class AlertComboBox
extends ComboBox<Alert> {
    public AlertComboBox() {
        this(Alert.values());
    }

    public AlertComboBox(Collection<? extends Alert> items) {
        this(items.toArray(new Alert[items.size()]));
    }

    public AlertComboBox(Alert ... items) {
        super(FXCollections.observableArrayList((Object[])items));
        this.setCellFactory((Callback)new Callback<ListView<Alert>, ListCell<Alert>>(){

            public ListCell<Alert> call(ListView<Alert> list) {
                AlertCell alertCell = new AlertCell();
                return alertCell;
            }
        });
        this.setSkin((Skin)new AlertListSkin(this));
    }

    private class AlertCell
    extends ListCell<Alert> {
        private AlertCell() {
        }

        public void updateItem(Alert alert, boolean empty) {
            super.updateItem((Object)alert, empty);
            if (alert != null && !empty) {
                this.setText(alert.toString());
                Button previewButton = new Button("\ud83d\udd14");
                previewButton.getStyleClass().add((Object)"alert-button");
                previewButton.setOnAction(event -> alert.play());
                this.setGraphic((Node)previewButton);
            }
        }
    }

    private class AlertListSkin
    extends ComboBoxListViewSkin<Alert> {
        public AlertListSkin(ComboBox<Alert> comboBox) {
            super(comboBox);
            comboBox.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> comboBox.hide());
            this.getListView().setOnMouseClicked(event -> comboBox.hide());
        }

        public boolean isHideOnClickEnabled() {
            return false;
        }
    }
}

