/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.intervaltimer.application;

import java.io.IOException;
import javafx.application.Application;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import tech.octopusdragon.intervaltimer.Alert;
import tech.octopusdragon.intervaltimer.Interval;
import tech.octopusdragon.intervaltimer.IntervalTimer;
import tech.octopusdragon.intervaltimer.application.scenes.TimerSceneController;
import tech.octopusdragon.intervaltimer.application.util.Resource;
import tech.octopusdragon.intervaltimer.application.util.Userdata;

public class IntervalTimerApplication
extends Application {
    private static ObjectProperty<IntervalTimer> timerProperty;
    public static final String MENU_SCENE_FXML = "scenes/MenuScene.fxml";
    public static final String TIMER_SCENE_FXML = "scenes/TimerScene.fxml";
    private static Stage stage;
    private static Scene lastTimerScene;

    public void init() {
        timerProperty = new SimpleObjectProperty();
    }

    public void start(Stage primaryStage) {
        stage = primaryStage;
        primaryStage.setTitle("Interval Timer");
        primaryStage.getIcons().add((Object)new Image(Resource.ICON.getResourceAsStream()));
        primaryStage.setWidth(500.0);
        primaryStage.setHeight(500.0);
        IntervalTimerApplication.switchToMenuScene();
        primaryStage.show();
    }

    public static ObjectProperty<IntervalTimer> timerProperty() {
        return timerProperty;
    }

    public static IntervalTimer getTimer() {
        return (IntervalTimer)timerProperty.get();
    }

    public static void setTimer(IntervalTimer timer) {
        timerProperty.set((Object)timer);
    }

    private static FXMLLoader switchToScene(String fxmlPath) {
        FXMLLoader loader = new FXMLLoader(IntervalTimerApplication.class.getResource(fxmlPath));
        try {
            Parent root = (Parent)loader.load();
            root.setStyle("-base: " + Userdata.readProperty("ui-color", "brown"));
            if (stage.getScene() == null) {
                stage.setScene(new Scene(root));
            } else {
                stage.getScene().setRoot(root);
            }
        }
        catch (IOException e) {
            System.out.println("Error loading FXML file");
            e.printStackTrace();
        }
        return loader;
    }

    public static void switchToMenuScene() {
        IntervalTimerApplication.switchToScene(MENU_SCENE_FXML);
    }

    public static void switchToNewTimerScene(Alert alert, boolean repeat, Interval ... intervals) {
        IntervalTimerApplication.setTimer(new IntervalTimer(alert, repeat, intervals));
        FXMLLoader loader = IntervalTimerApplication.switchToScene(TIMER_SCENE_FXML);
        lastTimerScene = stage.getScene();
        TimerSceneController controller = (TimerSceneController)loader.getController();
        controller.setTimer(IntervalTimerApplication.getTimer());
    }

    public static void switchToLastTimerScene() {
        stage.setScene(lastTimerScene);
        lastTimerScene.getRoot().setStyle("-base: " + Userdata.readProperty("ui-color", "brown"));
        if (IntervalTimerApplication.getTimer().isRunning()) {
            IntervalTimerApplication.getTimer().start();
        }
    }

    public static void main(String[] args) {
        IntervalTimerApplication.launch((String[])args);
    }
}

