/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.intervaltimer;

import java.time.Duration;
import tech.octopusdragon.intervaltimer.Alert;
import tech.octopusdragon.intervaltimer.Interval;

public final class Preset
extends Enum<Preset> {
    public static final /* enum */ Preset POMODORO;
    public static final /* enum */ Preset BOX_BREATHING;
    public static final /* enum */ Preset INTERVAL_TRAINING;
    private Value[] values;
    private int[] intervalPattern;
    private static final /* synthetic */ Preset[] ENUM$VALUES;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[3] = 1;
        nArray[5] = 1;
        nArray[7] = 2;
        POMODORO = new Preset(new Value[]{new Value("Work", Unit.MINUTES, 25, Alert.DONG_DING), new Value("Short Break", Unit.MINUTES, 5, Alert.DING_DONG), new Value("Long Break", Unit.MINUTES, 15, Alert.DING_DONG)}, nArray);
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        BOX_BREATHING = new Preset(new Value[]{new Value("Inhale", Unit.SECONDS, 4, Alert.CHIMES_UP), new Value("Hold", Unit.SECONDS, 4, Alert.SILENT), new Value("Exhale", Unit.SECONDS, 4, Alert.CHIMES_DOWN), new Value("Hold", Unit.SECONDS, 4, Alert.SILENT)}, nArray2);
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        INTERVAL_TRAINING = new Preset(new Value[]{new Value("Exercise", Unit.SECONDS, 20, Alert.DONG_DING), new Value("Rest", Unit.SECONDS, 40, Alert.DING_DONG)}, nArray3);
        ENUM$VALUES = new Preset[]{POMODORO, BOX_BREATHING, INTERVAL_TRAINING};
    }

    private Preset(Value[] values, int[] intervalPattern) {
        this.values = values;
        this.intervalPattern = intervalPattern;
    }

    public Value[] getValues() {
        return this.values;
    }

    public Interval[] intervals() {
        Interval[] intervals = new Interval[this.intervalPattern.length];
        int i = 0;
        while (i < intervals.length) {
            intervals[i] = this.values[this.intervalPattern[i]].hasAlert() ? new Interval(this.values[this.intervalPattern[i]].getDuration(), this.values[this.intervalPattern[i]].getAlert()) : new Interval(this.values[this.intervalPattern[i]].getDuration());
            ++i;
        }
        return intervals;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name().toLowerCase());
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '_') {
                sb.replace(i, i + 1, " ");
            }
            ++i;
        }
        sb.replace(0, 1, sb.substring(0, 1).toUpperCase());
        i = 0;
        while (i < sb.length()) {
            if (i >= 1 && sb.charAt(i - 1) == ' ') {
                sb.replace(i, i + 1, sb.substring(i, i + 1).toUpperCase());
            }
            ++i;
        }
        return sb.toString();
    }

    public static Preset[] values() {
        Preset[] presetArray = ENUM$VALUES;
        int n = presetArray.length;
        Preset[] presetArray2 = new Preset[n];
        System.arraycopy(ENUM$VALUES, 0, presetArray2, 0, n);
        return presetArray2;
    }

    public static Preset valueOf(String string) {
        return Enum.valueOf(Preset.class, string);
    }

    public static enum Unit {
        SECONDS,
        MINUTES,
        HOURS;


        public String toString() {
            StringBuilder sb = new StringBuilder(this.name().toLowerCase());
            int i = 0;
            while (i < sb.length()) {
                if (sb.charAt(i) == '_') {
                    sb.replace(i, i + 1, " ");
                }
                ++i;
            }
            sb.replace(0, 1, sb.substring(0, 1).toUpperCase());
            i = 0;
            while (i < sb.length()) {
                if (i >= 1 && sb.charAt(i - 1) == ' ') {
                    sb.replace(i, i + 1, sb.substring(i, i + 1).toUpperCase());
                }
                ++i;
            }
            return sb.toString();
        }
    }

    public static class Value {
        private String name;
        private Unit unit;
        private int numUnits;
        private Alert alert;

        public Value(String name, Unit unit, int initialNumUnits) {
            this(name, unit, initialNumUnits, null);
        }

        public Value(String name, Unit unit, int initialNumUnits, Alert alert) {
            this.name = name;
            this.unit = unit;
            this.numUnits = initialNumUnits;
            this.alert = alert;
        }

        public String getName() {
            return this.name;
        }

        public Unit getUnit() {
            return this.unit;
        }

        public int getNumUnits() {
            return this.numUnits;
        }

        public void setNumUnits(int numUnits) {
            this.numUnits = numUnits;
        }

        public Alert getAlert() {
            return this.alert;
        }

        public void setAlert(Alert alert) {
            this.alert = alert;
        }

        public boolean hasAlert() {
            return this.alert != null;
        }

        public Duration getDuration() {
            Duration duration;
            switch (this.unit) {
                case SECONDS: {
                    duration = Duration.ofSeconds(this.numUnits);
                    break;
                }
                case MINUTES: {
                    duration = Duration.ofMinutes(this.numUnits);
                    break;
                }
                case HOURS: {
                    duration = Duration.ofHours(this.numUnits);
                    break;
                }
                default: {
                    duration = null;
                }
            }
            return duration;
        }
    }
}

