/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.intervaltimer;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import tech.octopusdragon.intervaltimer.Alert;
import tech.octopusdragon.intervaltimer.Interval;

public class IntervalTimer
extends Timer {
    public static final Duration UPDATE_RATE = Duration.ofMillis(10L);
    private Interval[] intervals;
    private int curIntervalIndex;
    private Alert alert;
    private boolean repeat;
    private IntervalTimerTask curTask;
    private List<TimerTask> tasks = new ArrayList<TimerTask>();
    private long startNanoTime;
    private Duration timePassedSinceStop;
    private boolean running = false;
    private boolean frozen;
    private boolean canceled = false;

    public IntervalTimer(boolean repeat, Interval ... intervals) {
        this(null, repeat, intervals);
    }

    public IntervalTimer(Alert alert, boolean repeat, Interval ... intervals) {
        super(true);
        this.alert = alert;
        this.repeat = repeat;
        this.intervals = new Interval[intervals.length];
        int i = 0;
        while (i < intervals.length) {
            this.intervals[i] = intervals[i];
            ++i;
        }
        this.curIntervalIndex = 0;
        this.timePassedSinceStop = Duration.ZERO;
        this.start();
    }

    public void start() {
        if (this.canceled || this.running && !this.frozen) {
            return;
        }
        this.startNanoTime = System.nanoTime();
        this.curTask = new IntervalTimerTask();
        this.schedule((TimerTask)this.curTask, UPDATE_RATE.toMillis(), UPDATE_RATE.toMillis());
        this.running = true;
        this.frozen = false;
    }

    public void stop() {
        if (this.canceled || !this.running || this.frozen) {
            return;
        }
        this.timePassedSinceStop = this.timePassed();
        this.curTask.cancel();
        this.running = false;
    }

    public void freeze() {
        this.stop();
        this.running = true;
        this.frozen = true;
    }

    @Override
    public void cancel() {
        this.stop();
        super.cancel();
        this.canceled = true;
    }

    public void togglePause() {
        if (this.running) {
            this.stop();
        } else {
            this.start();
        }
    }

    public void previous() {
        if (this.canceled) {
            return;
        }
        if (!this.repeat && this.curIntervalIndex == 0) {
            return;
        }
        this.curIntervalIndex = this.repeat && this.curIntervalIndex == 0 ? this.intervals.length - 1 : --this.curIntervalIndex;
        this.timePassedSinceStop = Duration.ZERO;
        this.startNanoTime = System.nanoTime();
    }

    public void next() {
        if (this.canceled) {
            return;
        }
        if (!this.repeat && this.curIntervalIndex == this.intervals.length - 1) {
            return;
        }
        this.curIntervalIndex = this.repeat && this.curIntervalIndex == this.intervals.length - 1 ? 0 : ++this.curIntervalIndex;
        this.timePassedSinceStop = Duration.ZERO;
        this.startNanoTime = System.nanoTime();
    }

    public void restart() {
        if (this.canceled) {
            return;
        }
        this.curIntervalIndex = 0;
        this.timePassedSinceStop = Duration.ZERO;
        this.startNanoTime = System.nanoTime();
    }

    public void restartInterval() {
        if (this.canceled) {
            return;
        }
        this.timePassedSinceStop = Duration.ZERO;
        this.startNanoTime = System.nanoTime();
    }

    private void countdown() {
        Duration timeLeft = this.timeLeft();
        if (timeLeft.isZero() || timeLeft.isNegative()) {
            Alert intervalAlert = this.curInterval().getAlert();
            if (!this.repeat && this.curIntervalIndex == this.intervals.length - 1) {
                this.cancel();
            } else {
                this.next();
            }
            new Thread(() -> {
                if (this.alert != null) {
                    this.alert.play();
                } else if (intervalAlert != null) {
                    intervalAlert.play();
                }
            }).start();
        }
    }

    public void addTask(TimerTask newTask) {
        this.tasks.add(newTask);
    }

    public Interval[] getIntervals() {
        return this.intervals;
    }

    public Interval curInterval() {
        return this.intervals[this.curIntervalIndex];
    }

    public int curIntervalIndex() {
        return this.curIntervalIndex;
    }

    public int numIntervals() {
        return this.intervals.length;
    }

    public String intervalNumberString() {
        return String.valueOf(this.curIntervalIndex + 1) + "/" + this.intervals.length;
    }

    public Alert getAlert() {
        return this.alert;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public Duration timeLeft() {
        return this.curInterval().getDuration().minus(this.timePassedSinceStop).minusNanos(this.running ? System.nanoTime() - this.startNanoTime : 0L);
    }

    public int hoursLeft() {
        return (int)Math.floor(this.timeLeft().toHours());
    }

    public int minutesLeft() {
        return (int)Math.floor(this.timeLeft().toMinutes() % 60L);
    }

    public int secondsLeft() {
        return (int)Math.floor(this.timeLeft().getSeconds() % 60L);
    }

    public String timeLeftString() {
        if (this.canceled) {
            return "Time's up!";
        }
        StringBuilder sb = new StringBuilder();
        if (this.hoursLeft() >= 1) {
            sb.append(String.format("%d:", this.hoursLeft()));
            sb.append(String.format("%02d:%02d", this.minutesLeft(), this.secondsLeft()));
        } else {
            sb.append(String.format("%01d:%02d", this.minutesLeft(), this.secondsLeft()));
        }
        return sb.toString();
    }

    public Duration timePassed() {
        return this.timePassedSinceStop.plusNanos(this.running ? System.nanoTime() - this.startNanoTime : 0L);
    }

    public int hoursPassed() {
        return (int)Math.floor(this.timePassed().toHours());
    }

    public int minutesPassed() {
        return (int)Math.floor(this.timePassed().toMinutes() % 60L);
    }

    public int secondsPassed() {
        return (int)Math.floor(this.timePassed().getSeconds() % 60L);
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isFrozen() {
        return this.running;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Alert: " + (Object)((Object)this.alert));
        sb.append("\n");
        sb.append("Repeat: " + this.repeat);
        sb.append("\n");
        sb.append("Intervals: " + this.intervals.toString());
        sb.append("\n");
        sb.append("Current interval index: " + this.curIntervalIndex);
        sb.append("\n");
        sb.append("Time left: " + this.timeLeft() + " " + UPDATE_RATE);
        sb.append("\n");
        sb.append("Start time in nanos: " + this.startNanoTime);
        sb.append("\n");
        sb.append("Is canceled: " + this.canceled);
        sb.append("\n");
        sb.append("Attached tasks: " + this.tasks);
        return sb.toString();
    }

    private class IntervalTimerTask
    extends TimerTask {
        private IntervalTimerTask() {
        }

        @Override
        public void run() {
            IntervalTimer.this.countdown();
            for (TimerTask task : IntervalTimer.this.tasks) {
                task.run();
            }
        }
    }
}

