/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.intervaltimer;

import java.io.Serializable;
import java.time.Duration;
import tech.octopusdragon.intervaltimer.Alert;

public class Interval
implements Serializable {
    private static final long serialVersionUID = -215862572180250661L;
    private Duration duration;
    private Alert alert;

    public Interval() {
        this(Duration.ZERO);
    }

    public Interval(int h, int m, int s) {
        this(Duration.ofHours(h).plusMinutes(m).plusSeconds(s));
    }

    public Interval(Duration d) {
        this.duration = d;
    }

    public Interval(int h, int m, int s, Alert alert) {
        this(Duration.ofHours(h).plusMinutes(m).plusSeconds(s), alert);
    }

    public Interval(Duration d, Alert a) {
        this.duration = d;
        this.alert = a;
    }

    public void setDuration(int h, int m, int s) {
        this.setDuration(Duration.ofHours(h).plusMinutes(m).plusSeconds(s));
    }

    public void setDuration(Duration d) {
        this.duration = d;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setAlert(Alert a) {
        this.alert = a;
    }

    public Alert getAlert() {
        return this.alert;
    }

    public boolean hasAlert() {
        return this.alert != null;
    }

    public int hours() {
        return (int)this.duration.toHours();
    }

    public int minutes() {
        return (int)(this.duration.toMinutes() % 60L);
    }

    public int seconds() {
        return (int)(this.duration.getSeconds() % 60L);
    }

    public String toString() {
        return String.valueOf(this.hours()) + " hours\n" + this.minutes() + " minutes\n" + this.seconds() + " seconds";
    }
}

