/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.intervaltimer;

import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequencer;

public enum Alert {
    TELEPHONE("telephone.mid"),
    CHIMES_UP("chimes_up.mid"),
    CHIMES_DOWN("chimes_down.mid"),
    WHISTLE("whistle.mid"),
    WOODBLOCK("woodblock.mid"),
    XYLOPHONE("xylophone.mid"),
    OCARINA("ocarina.mid"),
    GRANDFATHER_1("grandfather_clock1.mid"),
    GRANDFATHER_2("grandfather_clock2.mid"),
    DING("ding.mid"),
    DING_DONG("ding_dong.mid"),
    DONG_DING("dong_ding.mid"),
    CYMBAL("cymbal.mid"),
    APITO("apito.mid"),
    CHORDS("chords.mid"),
    OBATALA("obatala.mid"),
    BRAVE_WIND("brave_wind.mid"),
    OMOMUKI("omomuki.mid"),
    SILENT;

    private static final String ALERT_DIR = "resources/alerts/";
    private Sequencer player;
    private String filename;

    private Alert() {
    }

    private Alert(String filename) {
        this.filename = ALERT_DIR + filename;
    }

    public void play() {
        if (this.filename == null) {
            return;
        }
        try {
            if (this.player != null) {
                this.player.close();
            }
            this.player = MidiSystem.getSequencer();
            this.player.addMetaEventListener(new EndOfSequenceListener());
            this.player.open();
            this.player.setSequence(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.filename));
            this.player.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name().toLowerCase());
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '_') {
                sb.replace(i, i + 1, " ");
            }
            ++i;
        }
        sb.replace(0, 1, sb.substring(0, 1).toUpperCase());
        i = 0;
        while (i < sb.length()) {
            if (i >= 1 && sb.charAt(i - 1) == ' ') {
                sb.replace(i, i + 1, sb.substring(i, i + 1).toUpperCase());
            }
            ++i;
        }
        return sb.toString();
    }

    class EndOfSequenceListener
    implements MetaEventListener {
        EndOfSequenceListener() {
        }

        @Override
        public void meta(MetaMessage message) {
            if (message.getType() == 47) {
                Alert.this.player.close();
            }
        }
    }
}

