/*
 * Decompiled with CFR 0.152.
 */
package com.octopusdragon.projects.hello.gui;

import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Light;
import javafx.scene.effect.Lighting;
import javafx.scene.effect.Reflection;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

public class JavaFXApplication
extends Application {
    private static final double PADDING = 75.0;
    private static final double SPACING = 10.0;
    private static final String[] COLORS = new String[]{"red", "blue", "green", "yellow", "violet", "orange"};
    private static final long DURATION = 800L;
    private int startColorIndex = 0;
    private Label[] messageLabel;

    public void start(Stage primaryStage) {
        this.messageLabel = this.buildLabel("HELLO, WORLD!");
        Light.Distant light = new Light.Distant();
        light.setAzimuth(-45.0);
        light.setElevation(60.0);
        Lighting lighting = new Lighting((Light)light);
        lighting.setSurfaceScale(3.0);
        DropShadow dropShadow = new DropShadow();
        dropShadow.setInput((Effect)lighting);
        dropShadow.setRadius(5.0);
        dropShadow.setOffsetX(-5.0);
        dropShadow.setOffsetY(5.0);
        Reflection reflect = new Reflection();
        reflect.setInput((Effect)dropShadow);
        reflect.setFraction(0.475);
        Label[] labelArray = this.messageLabel;
        int n = this.messageLabel.length;
        int n2 = 0;
        while (n2 < n) {
            Label l = labelArray[n2];
            l.setStyle("-fx-text-alignment: center; -fx-font-family: sans-serif; -fx-font-weight: bold; -fx-font-size: 100px;");
            l.setEffect((Effect)reflect);
            ++n2;
        }
        this.changeText();
        HBox hbox = new HBox(5.0, (Node[])this.messageLabel);
        hbox.setAlignment(Pos.CENTER);
        hbox.setPadding(new Insets(75.0));
        hbox.setSpacing(10.0);
        Timer textTimer = new Timer(true);
        textTimer.schedule((TimerTask)new ChangeTextTask(), 800L, 800L);
        Scene scene = new Scene((Parent)hbox);
        primaryStage.setScene(scene);
        primaryStage.setTitle("Hello World Application");
        primaryStage.show();
    }

    public static void main(String[] args) {
        JavaFXApplication.launch((String[])args);
    }

    public Label[] buildLabel(String str) {
        Label[] letterLabels = new Label[str.length()];
        int i = 0;
        while (i < str.length()) {
            letterLabels[i] = new Label(String.valueOf(str.charAt(i)));
            ++i;
        }
        return letterLabels;
    }

    public void changeText() {
        int colorIndex = this.startColorIndex;
        Label[] labelArray = this.messageLabel;
        int n = this.messageLabel.length;
        int n2 = 0;
        while (n2 < n) {
            Label l = labelArray[n2];
            if (!l.getText().equals(" ")) {
                l.setStyle("-fx-text-alignment: center; -fx-font-family: sans-serif; -fx-font-weight: bold; -fx-font-size: 100px; -fx-text-fill: " + COLORS[colorIndex]);
                colorIndex = colorIndex == COLORS.length - 1 ? 0 : ++colorIndex;
            }
            ++n2;
        }
        this.startColorIndex = this.startColorIndex == 0 ? COLORS.length - 1 : --this.startColorIndex;
    }

    public class ChangeTextTask
    extends TimerTask {
        @Override
        public void run() {
            Platform.runLater(() -> JavaFXApplication.this.changeText());
        }
    }
}

