/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.dice.yacht.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Glow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import tech.octopusdragon.proj.dice.Die;
import tech.octopusdragon.proj.dice.gui.RollAnimation;
import tech.octopusdragon.proj.dice.yacht.Category;
import tech.octopusdragon.proj.dice.yacht.Player;
import tech.octopusdragon.proj.dice.yacht.Yacht;
import tech.octopusdragon.proj.dice.yacht.gui.CategoryInfoPanel;

public class YachtApplication
extends Application {
    final double INFO_SPACING = 6.0;
    final double SPACING = 22.0;
    final double DICE_PADDING = 10.0;
    final double PADDING = 20.0;
    final double CATEGORY_INFO_PANEL_WIDTH = 120.0;
    final double CATEGORY_INFO_PANEL_HEIGHT = 100.0;
    final double DIE_LENGTH = 70.0;
    final double DELAY = 100.0;
    Map<Integer, Image> dieImages = new HashMap<Integer, Image>();
    final String ONE_IMAGE = "resources\\diceOne.png";
    final String TWO_IMAGE = "resources\\diceTwo.png";
    final String THREE_IMAGE = "resources\\diceThree.png";
    final String FOUR_IMAGE = "resources\\diceFour.png";
    final String FIVE_IMAGE = "resources\\diceFive.png";
    final String SIX_IMAGE = "resources\\diceSix.png";
    final String BACKGROUND_IMAGE = "resources\\background.jpg";
    final String DICE_SOUND = "resources\\dice.wav";
    final String CHEER_SOUND = "resources\\cheer.wav";
    MediaPlayer diceSound;
    MediaPlayer cheerSound;
    List<ImageView> dieImageViews;
    Label rollsLeftLabel;
    Button rollButton;
    CategoryInfoPanel[] categoryInfoPanels;
    Label playerLabel;
    Label totalScoreLabel;
    Yacht game;
    List<Integer> heldDice;
    boolean diceDisabled;
    boolean animationRunning;

    public void init() {
        try {
            Class.forName(RollAnimation.class.getName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.dieImages.put(1, new Image("file:resources\\diceOne.png"));
        this.dieImages.put(2, new Image("file:resources\\diceTwo.png"));
        this.dieImages.put(3, new Image("file:resources\\diceThree.png"));
        this.dieImages.put(4, new Image("file:resources\\diceFour.png"));
        this.dieImages.put(5, new Image("file:resources\\diceFive.png"));
        this.dieImages.put(6, new Image("file:resources\\diceSix.png"));
        this.diceSound = new MediaPlayer(new Media(new File("resources\\dice.wav").toURI().toString()));
        this.diceSound.setOnEndOfMedia(() -> this.diceSound.stop());
        this.cheerSound = new MediaPlayer(new Media(new File("resources\\cheer.wav").toURI().toString()));
        this.cheerSound.setOnEndOfMedia(() -> this.cheerSound.stop());
    }

    public void start(Stage primaryStage) {
        GridPane root = new GridPane();
        root.setHgap(6.0);
        root.setVgap(6.0);
        root.setPadding(new Insets(20.0));
        root.setBackground(new Background(new BackgroundImage[]{new BackgroundImage(new Image("file:resources\\background.jpg"), null, null, null, null)}));
        this.rollsLeftLabel = new Label();
        this.rollsLeftLabel.setFont(new Font("Calibri Light", 20.0));
        this.rollsLeftLabel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#FFFFFF", (double)0.75), new CornerRadii(10.0), null)}));
        this.rollsLeftLabel.setPadding(new Insets(10.0));
        root.add((Node)this.rollsLeftLabel, 0, 0);
        GridPane.setColumnSpan((Node)this.rollsLeftLabel, (Integer)5);
        GridPane.setHalignment((Node)this.rollsLeftLabel, (HPos)HPos.CENTER);
        this.dieImageViews = new ArrayList<ImageView>(5);
        int i = 0;
        while (i < 5) {
            ImageView curDieImageView = new ImageView(this.dieImages.get(1));
            curDieImageView.setPreserveRatio(true);
            curDieImageView.setFitWidth(70.0);
            curDieImageView.setOnMouseEntered((EventHandler)new DieMouseEnterHandler());
            curDieImageView.setOnMouseExited((EventHandler)new DieMouseExitHandler());
            curDieImageView.setOnMouseClicked((EventHandler)new DieClickHandler());
            VBox curPane = new VBox(new Node[]{curDieImageView});
            curPane.setAlignment(Pos.CENTER);
            curPane.setPadding(new Insets(10.0));
            if (i == 4) {
                curPane.setPadding(new Insets(10.0, 22.0, 10.0, 10.0));
            }
            this.dieImageViews.add(curDieImageView);
            root.add((Node)curPane, i, 1);
            ++i;
        }
        this.categoryInfoPanels = new CategoryInfoPanel[Category.values().length];
        i = 0;
        while (i < Category.values().length) {
            this.categoryInfoPanels[i] = new CategoryInfoPanel(Category.values()[i], 120.0, 100.0);
            this.categoryInfoPanels[i].setOnMouseClicked(new CategoryClickHandler());
            int row = i % (Category.values().length / 2);
            int column = i < Category.values().length / 2 ? 5 : 6;
            root.add((Node)this.categoryInfoPanels[i], column, row);
            ++i;
        }
        this.rollButton = new Button("Roll");
        this.rollButton.setFont(new Font("Bauhaus 93", 70.0));
        this.rollButton.setTextFill((Paint)Color.LIGHTYELLOW);
        this.rollButton.backgroundProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.rollButton.pressedProperty()).then((Object)new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.INDIANRED, new CornerRadii(20.0), null)})).otherwise((ObservableObjectValue)Bindings.when((ObservableBooleanValue)this.rollButton.hoverProperty()).then((Object)new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.DARKRED, new CornerRadii(20.0), null)})).otherwise((Object)new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.MAROON, new CornerRadii(20.0), null)}))));
        this.rollButton.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, new CornerRadii(10.0), new BorderWidths(5.0))}));
        this.rollButton.setOnAction((EventHandler)new RollButtonHandler());
        root.add((Node)this.rollButton, 0, 2);
        GridPane.setRowSpan((Node)this.rollButton, (Integer)(Category.values().length / 2 - 4));
        GridPane.setColumnSpan((Node)this.rollButton, (Integer)5);
        GridPane.setValignment((Node)this.rollButton, (VPos)VPos.CENTER);
        GridPane.setHalignment((Node)this.rollButton, (HPos)HPos.CENTER);
        this.playerLabel = new Label();
        this.playerLabel.setFont(new Font("Consolas", 24.0));
        this.playerLabel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#FFFFFF", (double)0.75), new CornerRadii(10.0), null)}));
        this.playerLabel.setPadding(new Insets(10.0));
        root.add((Node)this.playerLabel, 0, Category.values().length / 2 - 2);
        GridPane.setColumnSpan((Node)this.playerLabel, (Integer)5);
        GridPane.setHalignment((Node)this.playerLabel, (HPos)HPos.CENTER);
        this.totalScoreLabel = new Label();
        this.totalScoreLabel.setFont(new Font("Consolas", 24.0));
        this.totalScoreLabel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#FFFFFF", (double)0.75), new CornerRadii(10.0), null)}));
        this.totalScoreLabel.setPadding(new Insets(10.0));
        root.add((Node)this.totalScoreLabel, 0, Category.values().length / 2 - 1);
        GridPane.setColumnSpan((Node)this.totalScoreLabel, (Integer)5);
        GridPane.setHalignment((Node)this.totalScoreLabel, (HPos)HPos.CENTER);
        Scene scene = new Scene((Parent)root);
        primaryStage.setScene(scene);
        primaryStage.setTitle("Yacht");
        primaryStage.setResizable(false);
        this.numberOfPlayersDialog();
        primaryStage.show();
    }

    public static void main(String[] args) {
        YachtApplication.launch((String[])args);
    }

    public void newGame() {
        this.rollsLeftLabel.setText("Rolls left: " + this.game.rollsLeft());
        int i = 0;
        while (i < Category.values().length) {
            this.categoryInfoPanels[i].setPanelDisabled(false);
            Category category = this.categoryInfoPanels[i].getCategory();
            this.categoryInfoPanels[i].setScore(this.game.curPlayer().getPoints(category), this.game.curPlayer().hasUsedCategory(category));
            if (this.game.curPlayer().hasUsedCategory(category)) {
                this.categoryInfoPanels[i].disable();
            } else {
                this.categoryInfoPanels[i].deselect();
            }
            this.categoryInfoPanels[i].setPanelDisabled(true);
            ++i;
        }
        this.rollButton.setText("Roll");
        this.rollButton.setOnAction((EventHandler)new RollButtonHandler());
        this.playerLabel.setText(this.game.curPlayer().getName());
        this.totalScoreLabel.setText("Total score: " + this.game.curPlayer().getTotalScore());
        this.heldDice = new ArrayList<Integer>();
        this.diceDisabled = true;
        this.animationRunning = false;
    }

    public void nextPlayer() {
        this.game.nextPlayer();
        this.heldDice.clear();
        for (ImageView die : this.dieImageViews) {
            this.setDieEffect(die, false, false);
        }
        int i = 0;
        while (i < this.categoryInfoPanels.length) {
            this.categoryInfoPanels[i].setPanelDisabled(false);
            Category category = this.categoryInfoPanels[i].getCategory();
            this.categoryInfoPanels[i].setScore(this.game.curPlayer().getPoints(category), this.game.curPlayer().hasUsedCategory(category));
            if (this.game.curPlayer().hasUsedCategory(category)) {
                this.categoryInfoPanels[i].disable();
            } else {
                this.categoryInfoPanels[i].deselect();
            }
            this.categoryInfoPanels[i].setPanelDisabled(true);
            ++i;
        }
        this.rollsLeftLabel.setText("Rolls left: " + this.game.rollsLeft());
        this.rollButton.setText("Roll");
        this.rollButton.setOnAction((EventHandler)new RollButtonHandler());
        this.playerLabel.setText(this.game.curPlayer().getName());
        this.totalScoreLabel.setText("Total score: " + this.game.curPlayer().getTotalScore());
    }

    public void setDieEffect(ImageView die, boolean highlight, boolean glow) {
        Glow highlightEffect = null;
        if (highlight) {
            highlightEffect = new Glow(0.5);
        }
        DropShadow glowEffect = null;
        if (glow) {
            glowEffect = new DropShadow();
            glowEffect.setColor(Color.YELLOW);
            glowEffect.setRadius(12.0);
            glowEffect.setSpread(0.8);
        }
        if (highlight && glow) {
            glowEffect.setInput((Effect)highlightEffect);
            die.setEffect((Effect)glowEffect);
        } else if (highlight) {
            die.setEffect((Effect)highlightEffect);
        } else if (glow) {
            die.setEffect((Effect)glowEffect);
        } else {
            die.setEffect(null);
        }
    }

    public void playAgainDialog() {
        ButtonType playButtonType = new ButtonType("Yes", ButtonBar.ButtonData.OK_DONE);
        ButtonType exitButtonType = new ButtonType("No", ButtonBar.ButtonData.CANCEL_CLOSE);
        GridPane results = new GridPane();
        Label resultLabel = new Label("Here are the results:");
        results.add((Node)resultLabel, 0, 0);
        GridPane.setColumnSpan((Node)resultLabel, (Integer)this.game.numPlayers());
        Player winner = this.game.getPlayer(0);
        boolean tied = false;
        int i = 0;
        while (i < this.game.numPlayers()) {
            results.add((Node)new Label(this.game.getPlayer(i).getName()), i, 1);
            results.add((Node)new Label(String.valueOf(this.game.getPlayer(i).getTotalScore())), i, 2);
            if (this.game.getPlayer(i).getTotalScore() > winner.getTotalScore()) {
                winner = this.game.getPlayer(i);
                tied = false;
            } else if (this.game.getPlayer(i).getTotalScore() == winner.getTotalScore()) {
                tied = true;
            }
            ++i;
        }
        Label messageLabel = new Label();
        if (this.game.numPlayers() == 1) {
            messageLabel.setText("Game over!");
        } else if (!tied) {
            messageLabel.setText(String.format("%s won with %d points. Congratulations!", winner.getName(), winner.getTotalScore()));
        } else {
            messageLabel.setText("There was a tie");
        }
        results.add((Node)messageLabel, 0, 3);
        GridPane.setColumnSpan((Node)messageLabel, (Integer)this.game.numPlayers());
        Alert dialog = new Alert(Alert.AlertType.CONFIRMATION, null, new ButtonType[]{playButtonType, exitButtonType});
        dialog.setTitle("Yacht - New Game");
        dialog.setHeaderText("Play again?");
        dialog.getDialogPane().setContent((Node)results);
        this.cheerSound.play();
        dialog.showAndWait().ifPresent(response -> {
            if (response == playButtonType) {
                this.numberOfPlayersDialog();
            } else {
                Platform.exit();
            }
        });
    }

    public void numberOfPlayersDialog() {
        ButtonType nextButtonType = new ButtonType("Next", ButtonBar.ButtonData.OK_DONE);
        ButtonType exitButtonType = new ButtonType("Exit", ButtonBar.ButtonData.CANCEL_CLOSE);
        Spinner playerCountSpinner = new Spinner(1, 8, 1);
        Alert dialog = new Alert(Alert.AlertType.CONFIRMATION, null, new ButtonType[]{nextButtonType, exitButtonType});
        dialog.setTitle("Yacht - New Game");
        dialog.setHeaderText("How many players?");
        dialog.getDialogPane().setContent((Node)playerCountSpinner);
        dialog.showAndWait().ifPresent(response -> {
            if (response == nextButtonType) {
                this.game = new Yacht((Integer)playerCountSpinner.getValue());
                this.playerNamesDialog();
            } else {
                Platform.exit();
            }
        });
    }

    public void playerNamesDialog() {
        ButtonType playButtonType = new ButtonType("Play", ButtonBar.ButtonData.OK_DONE);
        ButtonType backButtonType = new ButtonType("Back", ButtonBar.ButtonData.BACK_PREVIOUS);
        ButtonType exitButtonType = new ButtonType("Exit", ButtonBar.ButtonData.CANCEL_CLOSE);
        TextField[] names = new TextField[this.game.numPlayers()];
        VBox namesBox = new VBox();
        int i = 0;
        while (i < this.game.numPlayers()) {
            names[i] = new TextField();
            namesBox.getChildren().add((Object)names[i]);
            ++i;
        }
        Alert dialog = new Alert(Alert.AlertType.CONFIRMATION, null, new ButtonType[]{playButtonType, backButtonType, exitButtonType});
        dialog.setTitle("Yacht - New Game");
        dialog.setHeaderText("What are the players' names? (Optional)");
        dialog.getDialogPane().setContent((Node)namesBox);
        dialog.showAndWait().ifPresent(response -> {
            if (response == playButtonType) {
                int i = 0;
                while (i < this.game.numPlayers()) {
                    if (!names[i].getText().isEmpty()) {
                        this.game.getPlayer(i).setName(names[i].getText());
                    }
                    ++i;
                }
                this.newGame();
            } else if (response == backButtonType) {
                this.numberOfPlayersDialog();
            } else {
                Platform.exit();
            }
        });
    }

    public class CategoryClickHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            CategoryInfoPanel panel = (CategoryInfoPanel)((Object)event.getSource());
            Category category = panel.getCategory();
            if (YachtApplication.this.animationRunning) {
                return;
            }
            if (YachtApplication.this.game.curPlayerHasGone() || YachtApplication.this.game.rollsLeft() == 3 || YachtApplication.this.game.curPlayer().hasUsedCategory(category)) {
                return;
            }
            YachtApplication.this.game.submit(category);
            panel.setScore(YachtApplication.this.game.curPlayer().getPoints(category), YachtApplication.this.game.curPlayer().hasUsedCategory(category));
            YachtApplication.this.totalScoreLabel.setText("Total score: " + YachtApplication.this.game.curPlayer().getTotalScore());
            panel.disable();
            int i = 0;
            while (i < YachtApplication.this.categoryInfoPanels.length) {
                YachtApplication.this.categoryInfoPanels[i].setPanelDisabled(true);
                ++i;
            }
            YachtApplication.this.rollButton.setText("Next");
            YachtApplication.this.rollButton.setOnAction(e -> YachtApplication.this.nextPlayer());
            YachtApplication.this.rollButton.setDisable(false);
            if (YachtApplication.this.game.isOver()) {
                YachtApplication.this.playAgainDialog();
            }
        }
    }

    public class DieClickHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            if (YachtApplication.this.diceDisabled) {
                return;
            }
            ImageView die = (ImageView)event.getSource();
            int dieIndex = YachtApplication.this.dieImageViews.indexOf((ImageView)event.getSource());
            if (YachtApplication.this.heldDice.indexOf(dieIndex) == -1) {
                YachtApplication.this.setDieEffect(die, true, true);
                YachtApplication.this.heldDice.add(dieIndex);
            } else {
                YachtApplication.this.setDieEffect(die, true, false);
                YachtApplication.this.heldDice.remove((Object)dieIndex);
            }
            YachtApplication.this.heldDice.sort(null);
            if (YachtApplication.this.heldDice.size() == 5) {
                YachtApplication.this.rollButton.setDisable(true);
            } else {
                YachtApplication.this.rollButton.setDisable(false);
            }
        }
    }

    public class DieMouseEnterHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            if (YachtApplication.this.diceDisabled) {
                return;
            }
            ImageView die = (ImageView)event.getSource();
            int dieIndex = YachtApplication.this.dieImageViews.indexOf((ImageView)event.getSource());
            YachtApplication.this.setDieEffect(die, true, YachtApplication.this.heldDice.indexOf(dieIndex) != -1);
            Scene scene = ((ImageView)event.getSource()).getScene();
            scene.setCursor(Cursor.HAND);
        }
    }

    public class DieMouseExitHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            if (YachtApplication.this.diceDisabled) {
                return;
            }
            ImageView die = (ImageView)event.getSource();
            int dieIndex = YachtApplication.this.dieImageViews.indexOf((ImageView)event.getSource());
            YachtApplication.this.setDieEffect(die, false, YachtApplication.this.heldDice.indexOf(dieIndex) != -1);
            Scene scene = ((ImageView)event.getSource()).getScene();
            scene.setCursor(Cursor.DEFAULT);
        }
    }

    public class RollButtonHandler
    implements EventHandler<ActionEvent> {
        public void handle(ActionEvent event) {
            if (YachtApplication.this.animationRunning) {
                return;
            }
            ArrayList<Integer> diceToRollList = new ArrayList<Integer>();
            int i = 0;
            while (i < 5) {
                if (YachtApplication.this.heldDice.indexOf(i) == -1) {
                    diceToRollList.add(i);
                }
                ++i;
            }
            int[] diceToRoll = new int[diceToRollList.size()];
            int i2 = 0;
            while (i2 < diceToRoll.length) {
                diceToRoll[i2] = (Integer)diceToRollList.get(i2);
                ++i2;
            }
            YachtApplication.this.game.roll(diceToRoll);
            RollAnimation[] animations = new RollAnimation[diceToRoll.length];
            int i3 = 0;
            while (i3 < diceToRoll.length) {
                Die curDie = YachtApplication.this.game.getDice()[diceToRoll[i3]];
                ImageView dieImageView = YachtApplication.this.dieImageViews.get(diceToRoll[i3]);
                Image startImage = dieImageView.getImage();
                Image endImage = YachtApplication.this.dieImages.get(curDie.getValue());
                animations[i3] = new RollAnimation(dieImageView, startImage, endImage, (double)i3 * 100.0);
                ++i3;
            }
            YachtApplication.this.animationRunning = true;
            animations[0].getAnimation().setOnFinished(e -> YachtApplication.this.diceSound.play());
            animations[diceToRoll.length - 1].getAnimation().setOnFinished(e -> {
                if (diceToRoll.length == 1) {
                    YachtApplication.this.diceSound.play();
                }
                if (YachtApplication.this.game.rollsLeft() != 0) {
                    YachtApplication.this.diceDisabled = false;
                }
                YachtApplication.this.animationRunning = false;
            });
            i3 = 0;
            while (i3 < diceToRoll.length) {
                animations[i3].play();
                ++i3;
            }
            YachtApplication.this.rollsLeftLabel.setText("Rolls left: " + YachtApplication.this.game.rollsLeft());
            i3 = 0;
            while (i3 < YachtApplication.this.categoryInfoPanels.length) {
                Category category = YachtApplication.this.categoryInfoPanels[i3].getCategory();
                YachtApplication.this.categoryInfoPanels[i3].setPanelDisabled(YachtApplication.this.game.curPlayer().hasUsedCategory(category));
                ++i3;
            }
            if (YachtApplication.this.game.rollsLeft() == 0) {
                YachtApplication.this.rollButton.setDisable(true);
                for (ImageView die : YachtApplication.this.dieImageViews) {
                    YachtApplication.this.setDieEffect(die, false, false);
                }
            }
            YachtApplication.this.diceDisabled = true;
        }
    }
}

