/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.dice.yacht;

import tech.octopusdragon.proj.dice.Die;
import tech.octopusdragon.proj.dice.yacht.Category;
import tech.octopusdragon.proj.dice.yacht.Player;

public class Yacht {
    public static final int NUM_DICE = 5;
    public static final int NUM_ROLLS = 3;
    private Die[] dice = new Die[5];
    private Player[] players;
    private int curPlayerIndex;
    private boolean curPlayerHasGone;
    private int rollsLeft;

    public Yacht(int numPlayers) {
        int i = 0;
        while (i < 5) {
            this.dice[i] = new Die();
            ++i;
        }
        this.players = new Player[numPlayers];
        i = 0;
        while (i < numPlayers) {
            this.players[i] = new Player("Player " + (i + 1));
            ++i;
        }
        this.curPlayerIndex = 0;
        this.curPlayerHasGone = false;
        this.rollsLeft = 3;
    }

    public Die[] getDice() {
        return this.dice;
    }

    public int numPlayers() {
        return this.players.length;
    }

    public Player getPlayer(int i) {
        return this.players[i];
    }

    public Player curPlayer() {
        return this.players[this.curPlayerIndex];
    }

    public void nextPlayer() {
        ++this.curPlayerIndex;
        if (this.curPlayerIndex >= this.players.length) {
            this.curPlayerIndex = 0;
        }
        this.curPlayerHasGone = false;
        this.rollsLeft = 3;
    }

    public void roll() {
        int[] dieIndexes = new int[5];
        int i = 0;
        while (i < 5) {
            dieIndexes[i] = i;
            ++i;
        }
        this.roll(dieIndexes);
    }

    public void roll(int ... dieIndexes) {
        if (this.rollsLeft == 0) {
            return;
        }
        int i = 0;
        while (i < dieIndexes.length) {
            this.dice[dieIndexes[i]].roll();
            ++i;
        }
        --this.rollsLeft;
    }

    public boolean curPlayerHasGone() {
        return this.curPlayerHasGone;
    }

    public boolean isOver() {
        int i = 0;
        while (i < this.players.length) {
            Category[] categoryArray = Category.values();
            int n = categoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Category category = categoryArray[n2];
                if (!this.players[i].hasUsedCategory(category)) {
                    return false;
                }
                ++n2;
            }
            ++i;
        }
        return true;
    }

    public int rollsLeft() {
        return this.rollsLeft;
    }

    public void submit(Category category) {
        switch (category) {
            case ONES: {
                this.curPlayer().submit(this.numDiceWithValue(1) * 1, category);
                break;
            }
            case TWOS: {
                this.curPlayer().submit(this.numDiceWithValue(2) * 2, category);
                break;
            }
            case THREES: {
                this.curPlayer().submit(this.numDiceWithValue(3) * 3, category);
                break;
            }
            case FOURS: {
                this.curPlayer().submit(this.numDiceWithValue(4) * 4, category);
                break;
            }
            case FIVES: {
                this.curPlayer().submit(this.numDiceWithValue(5) * 5, category);
                break;
            }
            case SIXES: {
                this.curPlayer().submit(this.numDiceWithValue(6) * 6, category);
                break;
            }
            case FULL_HOUSE: {
                boolean fullHouse = false;
                int i = 1;
                while (i <= 6) {
                    int j = 1;
                    while (j <= 6) {
                        if (i != j && this.numDiceWithValue(i) == 2 && this.numDiceWithValue(j) == 3) {
                            fullHouse = true;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (fullHouse) {
                    this.curPlayer().submit(25, category);
                    break;
                }
                this.curPlayer().submit(0, category);
                break;
            }
            case FOUR_OF_A_KIND: {
                if (this.numDiceWithValue(1) >= 4) {
                    this.curPlayer().submit(4, category);
                    break;
                }
                if (this.numDiceWithValue(2) >= 4) {
                    this.curPlayer().submit(8, category);
                    break;
                }
                if (this.numDiceWithValue(3) >= 4) {
                    this.curPlayer().submit(12, category);
                    break;
                }
                if (this.numDiceWithValue(4) >= 4) {
                    this.curPlayer().submit(16, category);
                    break;
                }
                if (this.numDiceWithValue(5) >= 4) {
                    this.curPlayer().submit(20, category);
                    break;
                }
                if (this.numDiceWithValue(6) >= 4) {
                    this.curPlayer().submit(24, category);
                    break;
                }
                this.curPlayer().submit(0, category);
                break;
            }
            case LITTLE_STRAIGHT: {
                if (this.numDiceWithValue(1) >= 1 && this.numDiceWithValue(2) >= 1 && this.numDiceWithValue(3) >= 1 && this.numDiceWithValue(4) >= 1 && this.numDiceWithValue(5) >= 1) {
                    this.curPlayer().submit(30, category);
                    break;
                }
                this.curPlayer().submit(0, category);
                break;
            }
            case BIG_STRAIGHT: {
                if (this.numDiceWithValue(2) >= 1 && this.numDiceWithValue(3) >= 1 && this.numDiceWithValue(4) >= 1 && this.numDiceWithValue(5) >= 1 && this.numDiceWithValue(6) >= 1) {
                    this.curPlayer().submit(30, category);
                    break;
                }
                this.curPlayer().submit(0, category);
                break;
            }
            case CHOICE: {
                int score = 0;
                Die[] dieArray = this.dice;
                int n = this.dice.length;
                int n2 = 0;
                while (n2 < n) {
                    Die die = dieArray[n2];
                    score += die.getValue();
                    ++n2;
                }
                this.curPlayer().submit(score, category);
                break;
            }
            case YACHT: {
                if (this.numDiceWithValue(1) == 5 || this.numDiceWithValue(2) == 5 || this.numDiceWithValue(3) == 5 || this.numDiceWithValue(4) == 5 || this.numDiceWithValue(5) == 5 || this.numDiceWithValue(6) == 5) {
                    this.curPlayer().submit(50, category);
                    break;
                }
                this.curPlayer().submit(0, category);
            }
        }
        this.curPlayerHasGone = true;
    }

    private int numDiceWithValue(int value) {
        int numDice = 0;
        Die[] dieArray = this.dice;
        int n = this.dice.length;
        int n2 = 0;
        while (n2 < n) {
            Die die = dieArray[n2];
            if (die.getValue() == value) {
                ++numDice;
            }
            ++n2;
        }
        return numDice;
    }
}

