/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.dice.gui;

import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import javafx.geometry.Insets;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.stage.Modality;
import javafx.stage.Stage;
import tech.octopusdragon.proj.dice.DiceGame;
import tech.octopusdragon.proj.dice.gui.RollAnimation;

public class VariantInfoDialog {
    private static final double WIDTH = 500.0;
    private static final double HEIGHT = 300.0;
    private static final double PADDING = 20.0;
    private static DiceGame variantInstance;

    public static void show(Class<?> variant) {
        try {
            variantInstance = (DiceGame)variant.getDeclaredConstructor(Integer.TYPE).newInstance(1);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.out.println("Error instantiating dice game class...");
            e.printStackTrace();
            System.exit(1);
        }
        Stage stage = new Stage();
        stage.initModality(Modality.APPLICATION_MODAL);
        VariantInfoDialog.buildUI(stage);
        stage.show();
    }

    private static void buildUI(Stage stage) {
        Label descriptionLabel = new Label(variantInstance.description());
        descriptionLabel.setWrapText(true);
        descriptionLabel.setPadding(new Insets(20.0));
        Scene scene = new Scene((Parent)descriptionLabel, 500.0, 300.0);
        stage.setScene(scene);
        stage.setTitle(String.valueOf(variantInstance.name()) + " Info");
        stage.getIcons().add((Object)RollAnimation.images[new Random().nextInt(RollAnimation.images.length)]);
    }
}

