/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.dice.gui;

import java.util.Random;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.RotateTransition;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.Duration;

public class RollAnimation {
    private final double DURATION = 1000.0;
    private final int REVOLUTIONS = 0;
    private final int IMAGE_CHANGES = 12;
    private ImageView imageView;
    private Image startImage;
    private Image endImage;
    private RotateTransition spinAnimation;
    private Timeline changeImageAnimation;
    private ParallelTransition combinedAnimation;
    private static final String IMAGE_DIRECTORY = "animation";
    public static final Image[] images = new Image[32];

    static {
        int i = 0;
        while (i < images.length) {
            RollAnimation.images[i] = new Image(RollAnimation.class.getClassLoader().getResourceAsStream(String.format("%s/%02d.png", IMAGE_DIRECTORY, i + 1)));
            ++i;
        }
    }

    public RollAnimation(ImageView view, Image start, Image end) {
        this(view, start, end, 0.0);
    }

    public RollAnimation(ImageView view, Image start, Image end, double delay) {
        this.imageView = view;
        this.startImage = start;
        this.endImage = end;
        this.spinAnimation = new RotateTransition();
        this.spinAnimation.setNode((Node)this.imageView);
        this.spinAnimation.setDelay(new Duration(delay));
        this.spinAnimation.setDuration(new Duration(1000.0));
        this.spinAnimation.setFromAngle(0.0);
        this.spinAnimation.setToAngle(0.0);
        this.changeImageAnimation = new Timeline();
        this.changeImageAnimation.setDelay(new Duration(delay));
        this.combinedAnimation = new ParallelTransition(new Animation[]{this.spinAnimation, this.changeImageAnimation});
    }

    public Animation getAnimation() {
        return this.combinedAnimation;
    }

    public void play() {
        this.generateKeyFrames();
        this.combinedAnimation.play();
    }

    private void generateKeyFrames() {
        Random rand = new Random();
        this.changeImageAnimation.getKeyFrames().clear();
        this.changeImageAnimation.getKeyFrames().add((Object)new KeyFrame(new Duration(0.0), new KeyValue[]{new KeyValue((WritableValue)this.imageView.imageProperty(), (Object)this.startImage)}));
        int i = 1;
        while (i < 10) {
            this.changeImageAnimation.getKeyFrames().add((Object)new KeyFrame(new Duration(83.33333333333333 * (double)i), new KeyValue[]{new KeyValue((WritableValue)this.imageView.imageProperty(), (Object)images[rand.nextInt(images.length)])}));
            ++i;
        }
        this.changeImageAnimation.getKeyFrames().add((Object)new KeyFrame(new Duration(916.6666666666666), new KeyValue[]{new KeyValue((WritableValue)this.imageView.imageProperty(), (Object)this.endImage)}));
    }
}

