/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.dice.gui;

import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import tech.octopusdragon.proj.dice.DiceGame;
import tech.octopusdragon.proj.dice.gui.RollAnimation;
import tech.octopusdragon.proj.dice.gui.VariantInfoDialog;

public class NewGameDialog {
    private static final double H_PADDING = 100.0;
    private static final double V_PADDING = 20.0;
    private static final double H_SPACING = 4.0;
    private static final double V_SPACING = 12.0;
    private static Class<?>[] variants;
    private static Class<?> selectedVariant;

    public static Class<?> showAndWait(Class<?>[] variants) {
        if (NewGameDialog.variants == null) {
            NewGameDialog.variants = variants;
        }
        Stage stage = new Stage();
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setOnCloseRequest(e -> {
            Platform.exit();
            System.exit(0);
        });
        NewGameDialog.buildUI(stage);
        stage.showAndWait();
        return selectedVariant;
    }

    private static void buildUI(Stage stage) {
        GridPane variantGridPane = new GridPane();
        variantGridPane.setAlignment(Pos.CENTER);
        variantGridPane.setPadding(new Insets(20.0, 100.0, 20.0, 100.0));
        variantGridPane.setHgap(4.0);
        variantGridPane.setVgap(12.0);
        int i = 0;
        while (i < variants.length) {
            Class<?> variant = variants[i];
            DiceGame variantInstance = null;
            try {
                variantInstance = (DiceGame)variants[i].getDeclaredConstructor(Integer.TYPE).newInstance(1);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
                System.out.println("Error instantiating dice game class...");
                e2.printStackTrace();
                System.exit(1);
            }
            Button playButton = new Button(variantInstance.name());
            playButton.setOnAction(e -> {
                selectedVariant = variant;
                stage.close();
            });
            AnchorPane playButtonAnchorPane = new AnchorPane(new Node[]{playButton});
            AnchorPane.setLeftAnchor((Node)playButton, (Double)0.0);
            AnchorPane.setRightAnchor((Node)playButton, (Double)0.0);
            variantGridPane.add((Node)playButtonAnchorPane, 0, i);
            Button infoButton = new Button("?");
            infoButton.setOnAction(e -> VariantInfoDialog.show(variant));
            AnchorPane infoButtonAnchorPane = new AnchorPane(new Node[]{infoButton});
            AnchorPane.setLeftAnchor((Node)infoButton, (Double)0.0);
            AnchorPane.setRightAnchor((Node)infoButton, (Double)0.0);
            variantGridPane.add((Node)infoButtonAnchorPane, 1, i);
            ++i;
        }
        Scene scene = new Scene((Parent)variantGridPane);
        stage.setScene(scene);
        stage.setTitle("Variant Selection");
        stage.getIcons().add((Object)RollAnimation.images[new Random().nextInt(RollAnimation.images.length)]);
    }
}

