/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.dice.gui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Glow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import tech.octopusdragon.proj.dice.Category;
import tech.octopusdragon.proj.dice.DiceGame;
import tech.octopusdragon.proj.dice.Die;
import tech.octopusdragon.proj.dice.Player;
import tech.octopusdragon.proj.dice.gui.CategoryInfoPanel;
import tech.octopusdragon.proj.dice.gui.NewGameDialog;
import tech.octopusdragon.proj.dice.gui.RollAnimation;
import tech.octopusdragon.proj.dice.variants.Crag;
import tech.octopusdragon.proj.dice.variants.Yacht;

public class DiceApplication
extends Application {
    public static final double INFO_SPACING = 6.0;
    public static final double SPACING = 22.0;
    public static final double DICE_PADDING = 10.0;
    public static final double PADDING = 20.0;
    public static final double CATEGORY_INFO_PANEL_WIDTH = 120.0;
    public static final double CATEGORY_INFO_PANEL_HEIGHT = 100.0;
    public static final double DIE_LENGTH = 70.0;
    public static final double DELAY = 100.0;
    public static final Map<Integer, Image> dieImages = new HashMap<Integer, Image>();
    public static final String ONE_IMAGE = "diceOne.png";
    public static final String TWO_IMAGE = "diceTwo.png";
    public static final String THREE_IMAGE = "diceThree.png";
    public static final String FOUR_IMAGE = "diceFour.png";
    public static final String FIVE_IMAGE = "diceFive.png";
    public static final String SIX_IMAGE = "diceSix.png";
    public static final String BACKGROUND_IMAGE = "background.jpg";
    public static final String DICE_SOUND = "dice.wav";
    public static final String CHEER_SOUND = "cheer.wav";
    MediaPlayer diceSound;
    MediaPlayer cheerSound;
    GridPane root;
    List<ImageView> dieImageViews;
    Label rollsLeftLabel;
    Button rollButton;
    CategoryInfoPanel[] categoryInfoPanels;
    Label playerLabel;
    Label totalScoreLabel;
    DiceGame game;
    Class<?>[] variants;
    List<Integer> heldDice;
    boolean diceDisabled;
    boolean animationRunning;

    public void init() {
        try {
            Class.forName(RollAnimation.class.getName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        dieImages.put(1, new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(ONE_IMAGE)));
        dieImages.put(2, new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(TWO_IMAGE)));
        dieImages.put(3, new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(THREE_IMAGE)));
        dieImages.put(4, new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(FOUR_IMAGE)));
        dieImages.put(5, new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(FIVE_IMAGE)));
        dieImages.put(6, new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(SIX_IMAGE)));
        this.diceSound = new MediaPlayer(new Media(((Object)((Object)this)).getClass().getClassLoader().getResource(DICE_SOUND).toExternalForm()));
        this.diceSound.setOnEndOfMedia(() -> this.diceSound.stop());
        this.cheerSound = new MediaPlayer(new Media(((Object)((Object)this)).getClass().getClassLoader().getResource(CHEER_SOUND).toExternalForm()));
        this.cheerSound.setOnEndOfMedia(() -> this.cheerSound.stop());
        this.variants = new Class[]{Yacht.class, Crag.class};
    }

    public void start(Stage primaryStage) {
        this.root = new GridPane();
        this.root.setHgap(6.0);
        this.root.setVgap(6.0);
        this.root.setPadding(new Insets(20.0));
        this.root.setBackground(new Background(new BackgroundImage[]{new BackgroundImage(new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(BACKGROUND_IMAGE)), null, null, null, null)}));
        primaryStage.setOnCloseRequest(e -> {
            e.consume();
            primaryStage.hide();
            this.newGameDialog();
            primaryStage.show();
        });
        Scene scene = new Scene((Parent)this.root);
        primaryStage.setScene(scene);
        primaryStage.setTitle("Unspecified dice game");
        primaryStage.setResizable(false);
        this.newGameDialog();
        primaryStage.show();
    }

    public static void main(String[] args) {
        DiceApplication.launch((String[])args);
    }

    public void newGame(Class<?> variant, int numPlayers) {
        try {
            this.game = (DiceGame)variant.getDeclaredConstructor(Integer.TYPE).newInstance(numPlayers);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.out.println("Error instantiating checkers class...");
            e.printStackTrace();
            System.exit(1);
        }
        this.root.getChildren().clear();
        this.rollsLeftLabel = new Label("Rolls left: " + this.game.rollsLeft());
        this.rollsLeftLabel.setFont(new Font("Calibri Light", 20.0));
        this.rollsLeftLabel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#FFFFFF", (double)0.75), new CornerRadii(10.0), null)}));
        this.rollsLeftLabel.setPadding(new Insets(10.0));
        this.root.add((Node)this.rollsLeftLabel, 0, 0);
        GridPane.setColumnSpan((Node)this.rollsLeftLabel, (Integer)this.game.numDice());
        GridPane.setHalignment((Node)this.rollsLeftLabel, (HPos)HPos.CENTER);
        this.dieImageViews = new ArrayList<ImageView>(this.game.numDice());
        int i = 0;
        while (i < this.game.numDice()) {
            ImageView curDieImageView = new ImageView(dieImages.get(1));
            curDieImageView.setPreserveRatio(true);
            curDieImageView.setFitWidth(70.0);
            curDieImageView.setOnMouseEntered((EventHandler)new DieMouseEnterHandler());
            curDieImageView.setOnMouseExited((EventHandler)new DieMouseExitHandler());
            curDieImageView.setOnMouseClicked((EventHandler)new DieClickHandler());
            VBox curPane = new VBox(new Node[]{curDieImageView});
            curPane.setAlignment(Pos.CENTER);
            curPane.setPadding(new Insets(10.0));
            if (i == this.game.numDice() - 1) {
                curPane.setPadding(new Insets(10.0, 22.0, 10.0, 10.0));
            }
            this.dieImageViews.add(curDieImageView);
            this.root.add((Node)curPane, i, 1);
            ++i;
        }
        this.categoryInfoPanels = new CategoryInfoPanel[this.game.categories().length];
        i = 0;
        while (i < this.game.categories().length) {
            this.categoryInfoPanels[i] = new CategoryInfoPanel(this.game.categories()[i], 120.0, 100.0);
            this.categoryInfoPanels[i].setOnMouseClicked(new CategoryClickHandler());
            int row = i % (this.game.categories().length / 2 + this.game.categories().length % 2);
            int column = i < this.game.categories().length / 2 + this.game.categories().length % 2 ? this.game.numDice() : this.game.numDice() + 1;
            this.root.add((Node)this.categoryInfoPanels[i], column, row);
            ++i;
        }
        this.rollButton = new Button("Roll");
        if (this.game.getClass() == Yacht.class) {
            this.rollButton.setFont(new Font("Bauhaus 93", 70.0));
            this.rollButton.setTextFill((Paint)Color.LIGHTYELLOW);
            this.rollButton.backgroundProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.rollButton.pressedProperty()).then((Object)new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.INDIANRED, new CornerRadii(20.0), null)})).otherwise((ObservableObjectValue)Bindings.when((ObservableBooleanValue)this.rollButton.hoverProperty()).then((Object)new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.DARKRED, new CornerRadii(20.0), null)})).otherwise((Object)new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.MAROON, new CornerRadii(20.0), null)}))));
            this.rollButton.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, new CornerRadii(10.0), new BorderWidths(5.0))}));
        } else if (this.game.getClass() == Crag.class) {
            this.rollButton.setFont(new Font("Freestyle Script", 70.0));
            this.rollButton.setTextFill((Paint)Color.AZURE);
            this.rollButton.backgroundProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.rollButton.pressedProperty()).then((Object)new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.SEAGREEN, null, null)})).otherwise((ObservableObjectValue)Bindings.when((ObservableBooleanValue)this.rollButton.hoverProperty()).then((Object)new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.DARKSEAGREEN, null, null)})).otherwise((Object)new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.MEDIUMSEAGREEN, null, null)}))));
            this.rollButton.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.DARKGOLDENROD, BorderStrokeStyle.SOLID, null, new BorderWidths(3.0))}));
        }
        this.rollButton.setOnAction((EventHandler)new RollButtonHandler());
        this.root.add((Node)this.rollButton, 0, 2);
        GridPane.setRowSpan((Node)this.rollButton, (Integer)(this.game.categories().length / 2 + this.game.categories().length % 2 - 4));
        GridPane.setColumnSpan((Node)this.rollButton, (Integer)this.game.numDice());
        GridPane.setValignment((Node)this.rollButton, (VPos)VPos.CENTER);
        GridPane.setHalignment((Node)this.rollButton, (HPos)HPos.CENTER);
        this.playerLabel = new Label();
        this.playerLabel.setFont(new Font("Consolas", 24.0));
        this.playerLabel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#FFFFFF", (double)0.75), new CornerRadii(10.0), null)}));
        this.playerLabel.setPadding(new Insets(10.0));
        this.root.add((Node)this.playerLabel, 0, this.game.categories().length / 2 + this.game.categories().length % 2 - 2);
        GridPane.setColumnSpan((Node)this.playerLabel, (Integer)this.game.numDice());
        GridPane.setHalignment((Node)this.playerLabel, (HPos)HPos.CENTER);
        this.totalScoreLabel = new Label();
        this.totalScoreLabel.setFont(new Font("Consolas", 24.0));
        this.totalScoreLabel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#FFFFFF", (double)0.75), new CornerRadii(10.0), null)}));
        this.totalScoreLabel.setPadding(new Insets(10.0));
        this.root.add((Node)this.totalScoreLabel, 0, this.game.categories().length / 2 + this.game.categories().length % 2 - 1);
        GridPane.setColumnSpan((Node)this.totalScoreLabel, (Integer)this.game.numDice());
        GridPane.setHalignment((Node)this.totalScoreLabel, (HPos)HPos.CENTER);
        this.rollsLeftLabel.setText("Rolls left: " + this.game.rollsLeft());
        i = 0;
        while (i < this.game.categories().length) {
            this.categoryInfoPanels[i].setPanelDisabled(false);
            Category category = this.categoryInfoPanels[i].getCategory();
            this.categoryInfoPanels[i].setScore(this.game.curPlayer().getPoints(category), this.game.curPlayer().hasUsedCategory(category));
            if (this.game.curPlayer().hasUsedCategory(category)) {
                this.categoryInfoPanels[i].disable();
            } else {
                this.categoryInfoPanels[i].deselect();
            }
            this.categoryInfoPanels[i].setPanelDisabled(true);
            ++i;
        }
        this.rollButton.setText("Roll");
        this.rollButton.setOnAction((EventHandler)new RollButtonHandler());
        this.playerLabel.setText(this.game.curPlayer().getName());
        this.totalScoreLabel.setText("Total score: " + this.game.curPlayer().getTotalScore());
        this.heldDice = new ArrayList<Integer>();
        this.diceDisabled = true;
        this.animationRunning = false;
        ((Stage)this.root.getScene().getWindow()).setTitle(this.game.name());
    }

    public void nextPlayer() {
        this.game.nextPlayer();
        this.heldDice.clear();
        for (ImageView die : this.dieImageViews) {
            this.setDieEffect(die, false, false);
        }
        int i = 0;
        while (i < this.categoryInfoPanels.length) {
            this.categoryInfoPanels[i].setPanelDisabled(false);
            Category category = this.categoryInfoPanels[i].getCategory();
            this.categoryInfoPanels[i].setScore(this.game.curPlayer().getPoints(category), this.game.curPlayer().hasUsedCategory(category));
            if (this.game.curPlayer().hasUsedCategory(category)) {
                this.categoryInfoPanels[i].disable();
            } else {
                this.categoryInfoPanels[i].deselect();
            }
            this.categoryInfoPanels[i].setPanelDisabled(true);
            ++i;
        }
        this.rollsLeftLabel.setText("Rolls left: " + this.game.rollsLeft());
        this.rollButton.setText("Roll");
        this.rollButton.setOnAction((EventHandler)new RollButtonHandler());
        this.playerLabel.setText(this.game.curPlayer().getName());
        this.totalScoreLabel.setText("Total score: " + this.game.curPlayer().getTotalScore());
    }

    public void setDieEffect(ImageView die, boolean highlight, boolean glow) {
        Glow highlightEffect = null;
        if (highlight) {
            highlightEffect = new Glow(0.5);
        }
        DropShadow glowEffect = null;
        if (glow) {
            glowEffect = new DropShadow();
            glowEffect.setColor(Color.YELLOW);
            glowEffect.setRadius(12.0);
            glowEffect.setSpread(0.8);
        }
        if (highlight && glow) {
            glowEffect.setInput((Effect)highlightEffect);
            die.setEffect((Effect)glowEffect);
        } else if (highlight) {
            die.setEffect((Effect)highlightEffect);
        } else if (glow) {
            die.setEffect((Effect)glowEffect);
        } else {
            die.setEffect(null);
        }
    }

    public void playAgainDialog() {
        ButtonType playButtonType = new ButtonType("Yes", ButtonBar.ButtonData.OK_DONE);
        ButtonType exitButtonType = new ButtonType("No", ButtonBar.ButtonData.CANCEL_CLOSE);
        GridPane results = new GridPane();
        Label resultLabel = new Label("Here are the results:");
        results.add((Node)resultLabel, 0, 0);
        GridPane.setColumnSpan((Node)resultLabel, (Integer)this.game.numPlayers());
        Player winner = this.game.getPlayer(0);
        boolean tied = false;
        int i = 0;
        while (i < this.game.numPlayers()) {
            results.add((Node)new Label(this.game.getPlayer(i).getName()), i, 1);
            results.add((Node)new Label(String.valueOf(this.game.getPlayer(i).getTotalScore())), i, 2);
            if (this.game.getPlayer(i).getTotalScore() > winner.getTotalScore()) {
                winner = this.game.getPlayer(i);
                tied = false;
            } else if (this.game.getPlayer(i).getTotalScore() == winner.getTotalScore()) {
                tied = true;
            }
            ++i;
        }
        Label messageLabel = new Label();
        if (this.game.numPlayers() == 1) {
            messageLabel.setText("Game over!");
        } else if (!tied) {
            messageLabel.setText(String.format("%s won with %d points. Congratulations!", winner.getName(), winner.getTotalScore()));
        } else {
            messageLabel.setText("There was a tie");
        }
        results.add((Node)messageLabel, 0, 3);
        GridPane.setColumnSpan((Node)messageLabel, (Integer)this.game.numPlayers());
        Alert dialog = new Alert(Alert.AlertType.CONFIRMATION, null, new ButtonType[]{playButtonType, exitButtonType});
        dialog.setTitle(String.valueOf(this.game.name()) + " - New Game");
        dialog.setHeaderText("Play again?");
        dialog.getDialogPane().setContent((Node)results);
        this.cheerSound.play();
        dialog.showAndWait().ifPresent(response -> {
            if (response == playButtonType) {
                this.newGameDialog();
            } else {
                Platform.exit();
            }
        });
    }

    public void newGameDialog() {
        Class<?> variant = NewGameDialog.showAndWait(this.variants);
        this.numberOfPlayersDialog(variant);
    }

    public void numberOfPlayersDialog(Class<?> variant) {
        ButtonType nextButtonType = new ButtonType("Next", ButtonBar.ButtonData.OK_DONE);
        ButtonType exitButtonType = new ButtonType("Exit", ButtonBar.ButtonData.CANCEL_CLOSE);
        Spinner playerCountSpinner = new Spinner(1, 8, 1);
        DiceGame variantInstance = null;
        try {
            variantInstance = (DiceGame)variant.getDeclaredConstructor(Integer.TYPE).newInstance(1);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.out.println("Error instantiating dice game class...");
            e.printStackTrace();
            System.exit(1);
        }
        Alert dialog = new Alert(Alert.AlertType.CONFIRMATION, null, new ButtonType[]{nextButtonType, exitButtonType});
        dialog.setTitle(String.valueOf(variantInstance.name()) + " - New Game");
        dialog.setHeaderText("How many players?");
        dialog.getDialogPane().setContent((Node)playerCountSpinner);
        dialog.showAndWait().ifPresent(response -> {
            if (response == nextButtonType) {
                this.playerNamesDialog(variant, (Integer)playerCountSpinner.getValue());
            } else {
                Platform.exit();
            }
        });
    }

    public void playerNamesDialog(Class<?> variant, int numPlayers) {
        ButtonType playButtonType = new ButtonType("Play", ButtonBar.ButtonData.OK_DONE);
        ButtonType backButtonType = new ButtonType("Back", ButtonBar.ButtonData.BACK_PREVIOUS);
        ButtonType exitButtonType = new ButtonType("Exit", ButtonBar.ButtonData.CANCEL_CLOSE);
        TextField[] names = new TextField[numPlayers];
        VBox namesBox = new VBox();
        int i = 0;
        while (i < numPlayers) {
            names[i] = new TextField();
            namesBox.getChildren().add((Object)names[i]);
            ++i;
        }
        DiceGame variantInstance = null;
        try {
            variantInstance = (DiceGame)variant.getDeclaredConstructor(Integer.TYPE).newInstance(1);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.out.println("Error instantiating dice game class...");
            e.printStackTrace();
            System.exit(1);
        }
        Alert dialog = new Alert(Alert.AlertType.CONFIRMATION, null, new ButtonType[]{playButtonType, backButtonType, exitButtonType});
        dialog.setTitle(String.valueOf(variantInstance.name()) + " - New Game");
        dialog.setHeaderText("What are the players' names? (Optional)");
        dialog.getDialogPane().setContent((Node)namesBox);
        dialog.showAndWait().ifPresent(response -> {
            if (response == playButtonType) {
                this.newGame(variant, numPlayers);
                int i = 0;
                while (i < numPlayers) {
                    if (!names[i].getText().isEmpty()) {
                        this.game.getPlayer(i).setName(names[i].getText());
                    }
                    ++i;
                }
            } else if (response == backButtonType) {
                this.numberOfPlayersDialog(variant);
            } else {
                Platform.exit();
            }
        });
    }

    public class CategoryClickHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            CategoryInfoPanel panel = (CategoryInfoPanel)((Object)event.getSource());
            Category category = panel.getCategory();
            if (DiceApplication.this.animationRunning) {
                return;
            }
            if (DiceApplication.this.game.curPlayerHasGone() || DiceApplication.this.game.rollsLeft() == DiceApplication.this.game.numRolls() || DiceApplication.this.game.curPlayer().hasUsedCategory(category)) {
                return;
            }
            DiceApplication.this.game.submit(category);
            panel.setScore(DiceApplication.this.game.curPlayer().getPoints(category), DiceApplication.this.game.curPlayer().hasUsedCategory(category));
            DiceApplication.this.totalScoreLabel.setText("Total score: " + DiceApplication.this.game.curPlayer().getTotalScore());
            panel.disable();
            int i = 0;
            while (i < DiceApplication.this.categoryInfoPanels.length) {
                DiceApplication.this.categoryInfoPanels[i].setPanelDisabled(true);
                ++i;
            }
            DiceApplication.this.rollButton.setText("Next");
            DiceApplication.this.rollButton.setOnAction(e -> DiceApplication.this.nextPlayer());
            DiceApplication.this.rollButton.setDisable(false);
            if (DiceApplication.this.game.isOver()) {
                DiceApplication.this.playAgainDialog();
            }
        }
    }

    public class DieClickHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            if (DiceApplication.this.diceDisabled) {
                return;
            }
            ImageView die = (ImageView)event.getSource();
            int dieIndex = DiceApplication.this.dieImageViews.indexOf((ImageView)event.getSource());
            if (DiceApplication.this.heldDice.indexOf(dieIndex) == -1) {
                DiceApplication.this.setDieEffect(die, true, true);
                DiceApplication.this.heldDice.add(dieIndex);
            } else {
                DiceApplication.this.setDieEffect(die, true, false);
                DiceApplication.this.heldDice.remove((Object)dieIndex);
            }
            DiceApplication.this.heldDice.sort(null);
            if (DiceApplication.this.heldDice.size() == DiceApplication.this.game.numDice()) {
                DiceApplication.this.rollButton.setDisable(true);
            } else {
                DiceApplication.this.rollButton.setDisable(false);
            }
        }
    }

    public class DieMouseEnterHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            if (DiceApplication.this.diceDisabled) {
                return;
            }
            ImageView die = (ImageView)event.getSource();
            int dieIndex = DiceApplication.this.dieImageViews.indexOf((ImageView)event.getSource());
            DiceApplication.this.setDieEffect(die, true, DiceApplication.this.heldDice.indexOf(dieIndex) != -1);
            Scene scene = ((ImageView)event.getSource()).getScene();
            scene.setCursor(Cursor.HAND);
        }
    }

    public class DieMouseExitHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            if (DiceApplication.this.diceDisabled) {
                return;
            }
            ImageView die = (ImageView)event.getSource();
            int dieIndex = DiceApplication.this.dieImageViews.indexOf((ImageView)event.getSource());
            DiceApplication.this.setDieEffect(die, false, DiceApplication.this.heldDice.indexOf(dieIndex) != -1);
            Scene scene = ((ImageView)event.getSource()).getScene();
            scene.setCursor(Cursor.DEFAULT);
        }
    }

    public class RollButtonHandler
    implements EventHandler<ActionEvent> {
        public void handle(ActionEvent event) {
            if (DiceApplication.this.animationRunning) {
                return;
            }
            ArrayList<Integer> diceToRollList = new ArrayList<Integer>();
            int i = 0;
            while (i < DiceApplication.this.game.numDice()) {
                if (DiceApplication.this.heldDice.indexOf(i) == -1) {
                    diceToRollList.add(i);
                }
                ++i;
            }
            int[] diceToRoll = new int[diceToRollList.size()];
            int i2 = 0;
            while (i2 < diceToRoll.length) {
                diceToRoll[i2] = (Integer)diceToRollList.get(i2);
                ++i2;
            }
            DiceApplication.this.game.roll(diceToRoll);
            RollAnimation[] animations = new RollAnimation[diceToRoll.length];
            int i3 = 0;
            while (i3 < diceToRoll.length) {
                Die curDie = DiceApplication.this.game.getDice()[diceToRoll[i3]];
                ImageView dieImageView = DiceApplication.this.dieImageViews.get(diceToRoll[i3]);
                Image startImage = dieImageView.getImage();
                Image endImage = dieImages.get(curDie.getValue());
                animations[i3] = new RollAnimation(dieImageView, startImage, endImage, (double)i3 * 100.0);
                ++i3;
            }
            DiceApplication.this.animationRunning = true;
            animations[0].getAnimation().setOnFinished(e -> DiceApplication.this.diceSound.play());
            animations[diceToRoll.length - 1].getAnimation().setOnFinished(e -> {
                if (diceToRoll.length == 1) {
                    DiceApplication.this.diceSound.play();
                }
                if (DiceApplication.this.game.rollsLeft() != 0) {
                    DiceApplication.this.diceDisabled = false;
                }
                DiceApplication.this.animationRunning = false;
            });
            i3 = 0;
            while (i3 < diceToRoll.length) {
                animations[i3].play();
                ++i3;
            }
            DiceApplication.this.rollsLeftLabel.setText("Rolls left: " + DiceApplication.this.game.rollsLeft());
            i3 = 0;
            while (i3 < DiceApplication.this.categoryInfoPanels.length) {
                Category category = DiceApplication.this.categoryInfoPanels[i3].getCategory();
                DiceApplication.this.categoryInfoPanels[i3].setPanelDisabled(DiceApplication.this.game.curPlayer().hasUsedCategory(category));
                ++i3;
            }
            if (DiceApplication.this.game.rollsLeft() == 0) {
                DiceApplication.this.rollButton.setDisable(true);
                for (ImageView die : DiceApplication.this.dieImageViews) {
                    DiceApplication.this.setDieEffect(die, false, false);
                }
            }
            DiceApplication.this.diceDisabled = true;
        }
    }
}

