/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.dice.crag.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Glow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import tech.octopusdragon.proj.dice.Die;
import tech.octopusdragon.proj.dice.crag.Category;
import tech.octopusdragon.proj.dice.crag.Crag;
import tech.octopusdragon.proj.dice.crag.Player;
import tech.octopusdragon.proj.dice.crag.gui.CategoryInfoPanel;
import tech.octopusdragon.proj.dice.gui.RollAnimation;

public class CragApplication
extends Application {
    final double INFO_SPACING = 6.0;
    final double SPACING = 22.0;
    final double DICE_PADDING = 10.0;
    final double PADDING = 20.0;
    final double CATEGORY_INFO_PANEL_WIDTH = 120.0;
    final double CATEGORY_INFO_PANEL_HEIGHT = 100.0;
    final double DIE_LENGTH = 70.0;
    final double DELAY = 100.0;
    Map<Integer, Image> dieImages = new HashMap<Integer, Image>();
    final String ONE_IMAGE = "resources\\diceOne.png";
    final String TWO_IMAGE = "resources\\diceTwo.png";
    final String THREE_IMAGE = "resources\\diceThree.png";
    final String FOUR_IMAGE = "resources\\diceFour.png";
    final String FIVE_IMAGE = "resources\\diceFive.png";
    final String SIX_IMAGE = "resources\\diceSix.png";
    final String BACKGROUND_IMAGE = "resources\\background.jpg";
    final String DICE_SOUND = "resources\\dice.wav";
    final String CHEER_SOUND = "resources\\cheer.wav";
    MediaPlayer diceSound;
    MediaPlayer cheerSound;
    List<ImageView> dieImageViews;
    Label rollsLeftLabel;
    Button rollButton;
    CategoryInfoPanel[] categoryInfoPanels;
    Label playerLabel;
    Label totalScoreLabel;
    Crag game;
    List<Integer> heldDice;
    boolean diceDisabled;
    boolean animationRunning;

    public void init() {
        try {
            Class.forName(RollAnimation.class.getName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.dieImages.put(1, new Image("file:resources\\diceOne.png"));
        this.dieImages.put(2, new Image("file:resources\\diceTwo.png"));
        this.dieImages.put(3, new Image("file:resources\\diceThree.png"));
        this.dieImages.put(4, new Image("file:resources\\diceFour.png"));
        this.dieImages.put(5, new Image("file:resources\\diceFive.png"));
        this.dieImages.put(6, new Image("file:resources\\diceSix.png"));
        this.diceSound = new MediaPlayer(new Media(new File("resources\\dice.wav").toURI().toString()));
        this.diceSound.setOnEndOfMedia(() -> this.diceSound.stop());
        this.cheerSound = new MediaPlayer(new Media(new File("resources\\cheer.wav").toURI().toString()));
        this.cheerSound.setOnEndOfMedia(() -> this.cheerSound.stop());
    }

    public void start(Stage primaryStage) {
        GridPane root = new GridPane();
        root.setHgap(6.0);
        root.setVgap(6.0);
        root.setPadding(new Insets(20.0));
        root.setBackground(new Background(new BackgroundImage[]{new BackgroundImage(new Image("file:resources\\background.jpg"), null, null, BackgroundPosition.CENTER, null)}));
        this.rollsLeftLabel = new Label();
        this.rollsLeftLabel.setFont(new Font("Calibri Light", 20.0));
        this.rollsLeftLabel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#FFFFFF", (double)0.75), new CornerRadii(10.0), null)}));
        this.rollsLeftLabel.setPadding(new Insets(10.0));
        root.add((Node)this.rollsLeftLabel, 0, 0);
        GridPane.setColumnSpan((Node)this.rollsLeftLabel, (Integer)3);
        GridPane.setHalignment((Node)this.rollsLeftLabel, (HPos)HPos.CENTER);
        this.dieImageViews = new ArrayList<ImageView>(3);
        int i = 0;
        while (i < 3) {
            ImageView curDieImageView = new ImageView(this.dieImages.get(1));
            curDieImageView.setPreserveRatio(true);
            curDieImageView.setFitWidth(70.0);
            curDieImageView.setOnMouseEntered((EventHandler)new DieMouseEnterHandler());
            curDieImageView.setOnMouseExited((EventHandler)new DieMouseExitHandler());
            curDieImageView.setOnMouseClicked((EventHandler)new DieClickHandler());
            VBox curPane = new VBox(new Node[]{curDieImageView});
            curPane.setAlignment(Pos.CENTER);
            curPane.setPadding(new Insets(10.0));
            if (i == 2) {
                curPane.setPadding(new Insets(10.0, 22.0, 10.0, 10.0));
            }
            this.dieImageViews.add(curDieImageView);
            root.add((Node)curPane, i, 1);
            ++i;
        }
        this.categoryInfoPanels = new CategoryInfoPanel[Category.values().length];
        i = 0;
        while (i < Category.values().length) {
            this.categoryInfoPanels[i] = new CategoryInfoPanel(Category.values()[i], 120.0, 100.0);
            this.categoryInfoPanels[i].setOnMouseClicked(new CategoryClickHandler());
            int row = i % (Category.values().length / 2 + Category.values().length % 2);
            int column = i < Category.values().length / 2 + Category.values().length % 2 ? 3 : 4;
            root.add((Node)this.categoryInfoPanels[i], column, row);
            ++i;
        }
        this.rollButton = new Button("Roll");
        this.rollButton.setFont(new Font("Freestyle Script", 70.0));
        this.rollButton.setTextFill((Paint)Color.AZURE);
        this.rollButton.backgroundProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.rollButton.pressedProperty()).then((Object)new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.SEAGREEN, new CornerRadii(20.0), null)})).otherwise((ObservableObjectValue)Bindings.when((ObservableBooleanValue)this.rollButton.hoverProperty()).then((Object)new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.DARKSEAGREEN, new CornerRadii(20.0), null)})).otherwise((Object)new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.MEDIUMSEAGREEN, new CornerRadii(20.0), null)}))));
        this.rollButton.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, new CornerRadii(10.0), new BorderWidths(5.0))}));
        this.rollButton.setOnAction((EventHandler)new RollButtonHandler());
        root.add((Node)this.rollButton, 0, 2);
        GridPane.setRowSpan((Node)this.rollButton, (Integer)(Category.values().length / 2 + Category.values().length % 2 - 4));
        GridPane.setColumnSpan((Node)this.rollButton, (Integer)3);
        GridPane.setValignment((Node)this.rollButton, (VPos)VPos.CENTER);
        GridPane.setHalignment((Node)this.rollButton, (HPos)HPos.CENTER);
        this.playerLabel = new Label();
        this.playerLabel.setFont(new Font("Consolas", 24.0));
        this.playerLabel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#FFFFFF", (double)0.75), new CornerRadii(10.0), null)}));
        this.playerLabel.setPadding(new Insets(10.0));
        root.add((Node)this.playerLabel, 0, Category.values().length / 2 + Category.values().length % 2 - 2);
        GridPane.setColumnSpan((Node)this.playerLabel, (Integer)3);
        GridPane.setHalignment((Node)this.playerLabel, (HPos)HPos.CENTER);
        this.totalScoreLabel = new Label();
        this.totalScoreLabel.setFont(new Font("Consolas", 24.0));
        this.totalScoreLabel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#FFFFFF", (double)0.75), new CornerRadii(10.0), null)}));
        this.totalScoreLabel.setPadding(new Insets(10.0));
        root.add((Node)this.totalScoreLabel, 0, Category.values().length / 2 + Category.values().length % 2 - 1);
        GridPane.setColumnSpan((Node)this.totalScoreLabel, (Integer)3);
        GridPane.setHalignment((Node)this.totalScoreLabel, (HPos)HPos.CENTER);
        Scene scene = new Scene((Parent)root);
        primaryStage.setScene(scene);
        primaryStage.setTitle("Crag");
        primaryStage.setResizable(false);
        this.numberOfPlayersDialog();
        primaryStage.show();
    }

    public static void main(String[] args) {
        CragApplication.launch((String[])args);
    }

    public void newGame() {
        this.rollsLeftLabel.setText("Rolls left: " + this.game.rollsLeft());
        int i = 0;
        while (i < Category.values().length) {
            this.categoryInfoPanels[i].setPanelDisabled(false);
            Category category = this.categoryInfoPanels[i].getCategory();
            this.categoryInfoPanels[i].setScore(this.game.curPlayer().getPoints(category), this.game.curPlayer().hasUsedCategory(category));
            if (this.game.curPlayer().hasUsedCategory(category)) {
                this.categoryInfoPanels[i].disable();
            } else {
                this.categoryInfoPanels[i].deselect();
            }
            this.categoryInfoPanels[i].setPanelDisabled(true);
            ++i;
        }
        this.rollButton.setText("Roll");
        this.rollButton.setOnAction((EventHandler)new RollButtonHandler());
        this.playerLabel.setText(this.game.curPlayer().getName());
        this.totalScoreLabel.setText("Total score: " + this.game.curPlayer().getTotalScore());
        this.heldDice = new ArrayList<Integer>();
        this.diceDisabled = true;
        this.animationRunning = false;
    }

    public void nextPlayer() {
        this.game.nextPlayer();
        this.heldDice.clear();
        for (ImageView die : this.dieImageViews) {
            this.setDieEffect(die, false, false);
        }
        int i = 0;
        while (i < this.categoryInfoPanels.length) {
            this.categoryInfoPanels[i].setPanelDisabled(false);
            Category category = this.categoryInfoPanels[i].getCategory();
            this.categoryInfoPanels[i].setScore(this.game.curPlayer().getPoints(category), this.game.curPlayer().hasUsedCategory(category));
            if (this.game.curPlayer().hasUsedCategory(category)) {
                this.categoryInfoPanels[i].disable();
            } else {
                this.categoryInfoPanels[i].deselect();
            }
            this.categoryInfoPanels[i].setPanelDisabled(true);
            ++i;
        }
        this.rollsLeftLabel.setText("Rolls left: " + this.game.rollsLeft());
        this.rollButton.setText("Roll");
        this.rollButton.setOnAction((EventHandler)new RollButtonHandler());
        this.playerLabel.setText(this.game.curPlayer().getName());
        this.totalScoreLabel.setText("Total score: " + this.game.curPlayer().getTotalScore());
    }

    public void setDieEffect(ImageView die, boolean highlight, boolean glow) {
        Glow highlightEffect = null;
        if (highlight) {
            highlightEffect = new Glow(0.5);
        }
        DropShadow glowEffect = null;
        if (glow) {
            glowEffect = new DropShadow();
            glowEffect.setColor(Color.YELLOW);
            glowEffect.setRadius(12.0);
            glowEffect.setSpread(0.8);
        }
        if (highlight && glow) {
            glowEffect.setInput((Effect)highlightEffect);
            die.setEffect((Effect)glowEffect);
        } else if (highlight) {
            die.setEffect((Effect)highlightEffect);
        } else if (glow) {
            die.setEffect((Effect)glowEffect);
        } else {
            die.setEffect(null);
        }
    }

    public void playAgainDialog() {
        ButtonType playButtonType = new ButtonType("Yes", ButtonBar.ButtonData.OK_DONE);
        ButtonType exitButtonType = new ButtonType("No", ButtonBar.ButtonData.CANCEL_CLOSE);
        GridPane results = new GridPane();
        Label resultLabel = new Label("Here are the results:");
        results.add((Node)resultLabel, 0, 0);
        GridPane.setColumnSpan((Node)resultLabel, (Integer)this.game.numPlayers());
        Player winner = this.game.getPlayer(0);
        boolean tied = false;
        int i = 0;
        while (i < this.game.numPlayers()) {
            results.add((Node)new Label(this.game.getPlayer(i).getName()), i, 1);
            results.add((Node)new Label(String.valueOf(this.game.getPlayer(i).getTotalScore())), i, 2);
            if (this.game.getPlayer(i).getTotalScore() > winner.getTotalScore()) {
                winner = this.game.getPlayer(i);
                tied = false;
            } else if (this.game.getPlayer(i).getTotalScore() == winner.getTotalScore()) {
                tied = true;
            }
            ++i;
        }
        Label messageLabel = new Label();
        if (this.game.numPlayers() == 1) {
            messageLabel.setText("Game over!");
        } else if (!tied) {
            messageLabel.setText(String.format("%s won with %d points. Congratulations!", winner.getName(), winner.getTotalScore()));
        } else {
            messageLabel.setText("There was a tie");
        }
        results.add((Node)messageLabel, 0, 3);
        GridPane.setColumnSpan((Node)messageLabel, (Integer)this.game.numPlayers());
        Alert dialog = new Alert(Alert.AlertType.CONFIRMATION, null, new ButtonType[]{playButtonType, exitButtonType});
        dialog.setTitle("Crag - New Game");
        dialog.setHeaderText("Play again?");
        dialog.getDialogPane().setContent((Node)results);
        this.cheerSound.play();
        dialog.showAndWait().ifPresent(response -> {
            if (response == playButtonType) {
                this.numberOfPlayersDialog();
            } else {
                Platform.exit();
            }
        });
    }

    public void numberOfPlayersDialog() {
        ButtonType nextButtonType = new ButtonType("Next", ButtonBar.ButtonData.OK_DONE);
        ButtonType exitButtonType = new ButtonType("Exit", ButtonBar.ButtonData.CANCEL_CLOSE);
        Spinner playerCountSpinner = new Spinner(1, 8, 1);
        Alert dialog = new Alert(Alert.AlertType.CONFIRMATION, null, new ButtonType[]{nextButtonType, exitButtonType});
        dialog.setTitle("Crag - New Game");
        dialog.setHeaderText("How many players?");
        dialog.getDialogPane().setContent((Node)playerCountSpinner);
        dialog.showAndWait().ifPresent(response -> {
            if (response == nextButtonType) {
                this.game = new Crag((Integer)playerCountSpinner.getValue());
                this.playerNamesDialog();
            } else {
                Platform.exit();
            }
        });
    }

    public void playerNamesDialog() {
        ButtonType playButtonType = new ButtonType("Play", ButtonBar.ButtonData.OK_DONE);
        ButtonType backButtonType = new ButtonType("Back", ButtonBar.ButtonData.BACK_PREVIOUS);
        ButtonType exitButtonType = new ButtonType("Exit", ButtonBar.ButtonData.CANCEL_CLOSE);
        TextField[] names = new TextField[this.game.numPlayers()];
        VBox namesBox = new VBox();
        int i = 0;
        while (i < this.game.numPlayers()) {
            names[i] = new TextField();
            namesBox.getChildren().add((Object)names[i]);
            ++i;
        }
        Alert dialog = new Alert(Alert.AlertType.CONFIRMATION, null, new ButtonType[]{playButtonType, backButtonType, exitButtonType});
        dialog.setTitle("Crag - New Game");
        dialog.setHeaderText("What are the players' names? (Optional)");
        dialog.getDialogPane().setContent((Node)namesBox);
        dialog.showAndWait().ifPresent(response -> {
            if (response == playButtonType) {
                int i = 0;
                while (i < this.game.numPlayers()) {
                    if (!names[i].getText().isEmpty()) {
                        this.game.getPlayer(i).setName(names[i].getText());
                    }
                    ++i;
                }
                this.newGame();
            } else if (response == backButtonType) {
                this.numberOfPlayersDialog();
            } else {
                Platform.exit();
            }
        });
    }

    public class CategoryClickHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            CategoryInfoPanel panel = (CategoryInfoPanel)((Object)event.getSource());
            Category category = panel.getCategory();
            if (CragApplication.this.animationRunning) {
                return;
            }
            if (CragApplication.this.game.curPlayerHasGone() || CragApplication.this.game.rollsLeft() == 3 || CragApplication.this.game.curPlayer().hasUsedCategory(category)) {
                return;
            }
            CragApplication.this.game.submit(category);
            panel.setScore(CragApplication.this.game.curPlayer().getPoints(category), CragApplication.this.game.curPlayer().hasUsedCategory(category));
            CragApplication.this.totalScoreLabel.setText("Total score: " + CragApplication.this.game.curPlayer().getTotalScore());
            panel.disable();
            int i = 0;
            while (i < CragApplication.this.categoryInfoPanels.length) {
                CragApplication.this.categoryInfoPanels[i].setPanelDisabled(true);
                ++i;
            }
            CragApplication.this.rollButton.setText("Next");
            CragApplication.this.rollButton.setOnAction(e -> CragApplication.this.nextPlayer());
            CragApplication.this.rollButton.setDisable(false);
            if (CragApplication.this.game.isOver()) {
                CragApplication.this.playAgainDialog();
            }
        }
    }

    public class DieClickHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            if (CragApplication.this.diceDisabled) {
                return;
            }
            ImageView die = (ImageView)event.getSource();
            int dieIndex = CragApplication.this.dieImageViews.indexOf((ImageView)event.getSource());
            if (CragApplication.this.heldDice.indexOf(dieIndex) == -1) {
                CragApplication.this.setDieEffect(die, true, true);
                CragApplication.this.heldDice.add(dieIndex);
            } else {
                CragApplication.this.setDieEffect(die, true, false);
                CragApplication.this.heldDice.remove((Object)dieIndex);
            }
            CragApplication.this.heldDice.sort(null);
            if (CragApplication.this.heldDice.size() == 3) {
                CragApplication.this.rollButton.setDisable(true);
            } else {
                CragApplication.this.rollButton.setDisable(false);
            }
        }
    }

    public class DieMouseEnterHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            if (CragApplication.this.diceDisabled) {
                return;
            }
            ImageView die = (ImageView)event.getSource();
            int dieIndex = CragApplication.this.dieImageViews.indexOf((ImageView)event.getSource());
            CragApplication.this.setDieEffect(die, true, CragApplication.this.heldDice.indexOf(dieIndex) != -1);
            Scene scene = ((ImageView)event.getSource()).getScene();
            scene.setCursor(Cursor.HAND);
        }
    }

    public class DieMouseExitHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            if (CragApplication.this.diceDisabled) {
                return;
            }
            ImageView die = (ImageView)event.getSource();
            int dieIndex = CragApplication.this.dieImageViews.indexOf((ImageView)event.getSource());
            CragApplication.this.setDieEffect(die, false, CragApplication.this.heldDice.indexOf(dieIndex) != -1);
            Scene scene = ((ImageView)event.getSource()).getScene();
            scene.setCursor(Cursor.DEFAULT);
        }
    }

    public class RollButtonHandler
    implements EventHandler<ActionEvent> {
        public void handle(ActionEvent event) {
            if (CragApplication.this.animationRunning) {
                return;
            }
            ArrayList<Integer> diceToRollList = new ArrayList<Integer>();
            int i = 0;
            while (i < 3) {
                if (CragApplication.this.heldDice.indexOf(i) == -1) {
                    diceToRollList.add(i);
                }
                ++i;
            }
            int[] diceToRoll = new int[diceToRollList.size()];
            int i2 = 0;
            while (i2 < diceToRoll.length) {
                diceToRoll[i2] = (Integer)diceToRollList.get(i2);
                ++i2;
            }
            CragApplication.this.game.roll(diceToRoll);
            RollAnimation[] animations = new RollAnimation[diceToRoll.length];
            int i3 = 0;
            while (i3 < diceToRoll.length) {
                Die curDie = CragApplication.this.game.getDice()[diceToRoll[i3]];
                ImageView dieImageView = CragApplication.this.dieImageViews.get(diceToRoll[i3]);
                Image startImage = dieImageView.getImage();
                Image endImage = CragApplication.this.dieImages.get(curDie.getValue());
                animations[i3] = new RollAnimation(dieImageView, startImage, endImage, (double)i3 * 100.0);
                ++i3;
            }
            CragApplication.this.animationRunning = true;
            animations[0].getAnimation().setOnFinished(e -> CragApplication.this.diceSound.play());
            animations[diceToRoll.length - 1].getAnimation().setOnFinished(e -> {
                if (diceToRoll.length == 1) {
                    CragApplication.this.diceSound.play();
                }
                if (CragApplication.this.game.rollsLeft() != 0) {
                    CragApplication.this.diceDisabled = false;
                }
                CragApplication.this.animationRunning = false;
            });
            i3 = 0;
            while (i3 < diceToRoll.length) {
                animations[i3].play();
                ++i3;
            }
            CragApplication.this.rollsLeftLabel.setText("Rolls left: " + CragApplication.this.game.rollsLeft());
            i3 = 0;
            while (i3 < CragApplication.this.categoryInfoPanels.length) {
                Category category = CragApplication.this.categoryInfoPanels[i3].getCategory();
                CragApplication.this.categoryInfoPanels[i3].setPanelDisabled(CragApplication.this.game.curPlayer().hasUsedCategory(category));
                ++i3;
            }
            if (CragApplication.this.game.rollsLeft() == 0) {
                CragApplication.this.rollButton.setDisable(true);
                for (ImageView die : CragApplication.this.dieImageViews) {
                    CragApplication.this.setDieEffect(die, false, false);
                }
            }
            CragApplication.this.diceDisabled = true;
        }
    }
}

