/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.dice.crag.gui;

import java.util.HashMap;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import tech.octopusdragon.proj.dice.crag.Category;

public class CategoryInfoPanel
extends GridPane {
    private final Map<Category, String> names = new HashMap<Category, String>();
    private final Map<Category, String> descriptions = new HashMap<Category, String>();
    private final Map<Category, String> scores = new HashMap<Category, String>();
    private final double PADDING = 5.0;
    private final double SCORE_LABEL_WIDTH = 50.0;
    private final Background DEFAULT_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, new CornerRadii(5.0), null)});
    private final Background SELECTED_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.YELLOW, new CornerRadii(5.0), null)});
    private final Background DISABLED_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.LIGHTGRAY, new CornerRadii(5.0), null)});
    private Label nameLabel;
    private Label descriptionLabel;
    private Label scoreLabel;
    private Category category;
    private boolean disabled;

    private void initializeNames() {
        this.names.put(Category.CRAG, "Crag");
        this.names.put(Category.THIRTEEN, "Thirteen");
        this.names.put(Category.THREE_OF_A_KIND, "Three-Of-A-Kind");
        this.names.put(Category.LOW_STRAIGHT, "Low Straight");
        this.names.put(Category.HIGH_STRAIGHT, "High Straight");
        this.names.put(Category.ODD_STRAIGHT, "Odd Straight");
        this.names.put(Category.EVEN_STRAIGHT, "Even Straight");
        this.names.put(Category.SIXES, "Sixes");
        this.names.put(Category.FIVES, "Fives");
        this.names.put(Category.FOURS, "Fours");
        this.names.put(Category.THREES, "Threes");
        this.names.put(Category.TWOS, "Twos");
        this.names.put(Category.ONES, "Ones");
    }

    private void initializeDescriptions() {
        this.descriptions.put(Category.CRAG, "Any combination containing a pair and totalling 13");
        this.descriptions.put(Category.THIRTEEN, "Any combination totalling 13");
        this.descriptions.put(Category.THREE_OF_A_KIND, "Three dice showing the same face");
        this.descriptions.put(Category.LOW_STRAIGHT, "1-2-3");
        this.descriptions.put(Category.HIGH_STRAIGHT, "4-5-6");
        this.descriptions.put(Category.ODD_STRAIGHT, "1-3-5");
        this.descriptions.put(Category.EVEN_STRAIGHT, "2-4-6");
        this.descriptions.put(Category.SIXES, "Any combination");
        this.descriptions.put(Category.FIVES, "Any combination");
        this.descriptions.put(Category.FOURS, "Any combination");
        this.descriptions.put(Category.THREES, "Any combination");
        this.descriptions.put(Category.TWOS, "Any combination");
        this.descriptions.put(Category.ONES, "Any combination");
    }

    private void initializeScores() {
        this.scores.put(Category.CRAG, "50");
        this.scores.put(Category.THIRTEEN, "26");
        this.scores.put(Category.THREE_OF_A_KIND, "25");
        this.scores.put(Category.LOW_STRAIGHT, "20");
        this.scores.put(Category.HIGH_STRAIGHT, "20");
        this.scores.put(Category.ODD_STRAIGHT, "20");
        this.scores.put(Category.EVEN_STRAIGHT, "20");
        this.scores.put(Category.SIXES, "The sum of the dice with the number 6");
        this.scores.put(Category.FIVES, "The sum of the dice with the number 5");
        this.scores.put(Category.FOURS, "The sum of the dice with the number 4");
        this.scores.put(Category.THREES, "The sum of the dice with the number 3");
        this.scores.put(Category.TWOS, "The sum of the dice with the number 2");
        this.scores.put(Category.ONES, "The sum of the dice with the number 1");
    }

    public CategoryInfoPanel(Category cat, double width, double height) {
        this.category = cat;
        this.initializeNames();
        this.initializeDescriptions();
        this.initializeScores();
        this.nameLabel = new Label(this.names.get((Object)this.category));
        this.nameLabel.setFont(new Font("Candara Bold", 13.0));
        this.descriptionLabel = new Label(String.valueOf(this.descriptions.get((Object)this.category)) + " - " + this.scores.get((Object)this.category));
        this.descriptionLabel.setFont(new Font("Georgia", 11.0));
        this.descriptionLabel.setTextFill((Paint)Color.GRAY);
        this.descriptionLabel.setWrapText(true);
        this.descriptionLabel.setTextAlignment(TextAlignment.CENTER);
        this.scoreLabel = new Label();
        this.scoreLabel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, new CornerRadii(2.0), null)}));
        this.scoreLabel.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, new CornerRadii(2.0), new BorderWidths(1.0))}));
        this.scoreLabel.setFont(new Font("Calibri", 13.0));
        this.scoreLabel.setAlignment(Pos.CENTER);
        this.scoreLabel.setMinWidth(50.0);
        this.scoreLabel.setPrefWidth(50.0);
        this.scoreLabel.setMaxWidth(50.0);
        this.add((Node)this.nameLabel, 0, 0);
        GridPane.setHalignment((Node)this.nameLabel, (HPos)HPos.CENTER);
        GridPane.setVgrow((Node)this.nameLabel, (Priority)Priority.ALWAYS);
        this.add((Node)this.descriptionLabel, 0, 1);
        GridPane.setHalignment((Node)this.descriptionLabel, (HPos)HPos.CENTER);
        GridPane.setVgrow((Node)this.descriptionLabel, (Priority)Priority.ALWAYS);
        this.add((Node)this.scoreLabel, 0, 2);
        GridPane.setHalignment((Node)this.scoreLabel, (HPos)HPos.CENTER);
        GridPane.setVgrow((Node)this.scoreLabel, (Priority)Priority.ALWAYS);
        this.setBackground(this.DEFAULT_BACKGROUND);
        this.setOnMouseEntered(new MouseEnterHandler());
        this.setOnMouseExited(new MouseExitHandler());
        this.setAlignment(Pos.CENTER);
        this.setPadding(new Insets(5.0));
        this.setMinSize(width, height);
        this.setPrefSize(width, height);
        this.setMaxSize(width, height);
    }

    public Category getCategory() {
        return this.category;
    }

    public void setScore(int score, boolean show) {
        if (show) {
            this.scoreLabel.setText(Integer.toString(score));
        } else {
            this.scoreLabel.setText("");
        }
    }

    public void setPanelDisabled(boolean d) {
        this.disabled = d;
    }

    public void select() {
        if (this.disabled) {
            return;
        }
        this.setBackground(this.SELECTED_BACKGROUND);
        Scene scene = this.getScene();
        scene.setCursor(Cursor.HAND);
    }

    public void deselect() {
        if (this.disabled) {
            return;
        }
        this.setBackground(this.DEFAULT_BACKGROUND);
        Scene scene = this.getScene();
        scene.setCursor(Cursor.DEFAULT);
    }

    public void disable() {
        this.setBackground(this.DISABLED_BACKGROUND);
        Scene scene = this.getScene();
        scene.setCursor(Cursor.DEFAULT);
    }

    private class MouseEnterHandler
    implements EventHandler<MouseEvent> {
        private MouseEnterHandler() {
        }

        public void handle(MouseEvent event) {
            CategoryInfoPanel.this.select();
        }
    }

    private class MouseExitHandler
    implements EventHandler<MouseEvent> {
        private MouseExitHandler() {
        }

        public void handle(MouseEvent event) {
            CategoryInfoPanel.this.deselect();
        }
    }
}

