/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.dice.crag;

import tech.octopusdragon.proj.dice.Die;
import tech.octopusdragon.proj.dice.crag.Category;
import tech.octopusdragon.proj.dice.crag.Player;

public class Crag {
    public static final int NUM_DICE = 3;
    public static final int NUM_ROLLS = 3;
    private Die[] dice = new Die[3];
    private Player[] players;
    private int curPlayerIndex;
    private boolean curPlayerHasGone;
    private int rollsLeft;

    public Crag(int numPlayers) {
        int i = 0;
        while (i < 3) {
            this.dice[i] = new Die();
            ++i;
        }
        this.players = new Player[numPlayers];
        i = 0;
        while (i < numPlayers) {
            this.players[i] = new Player("Player " + (i + 1));
            ++i;
        }
        this.curPlayerIndex = 0;
        this.curPlayerHasGone = false;
        this.rollsLeft = 3;
    }

    public Die[] getDice() {
        return this.dice;
    }

    public int numPlayers() {
        return this.players.length;
    }

    public Player getPlayer(int i) {
        return this.players[i];
    }

    public Player curPlayer() {
        return this.players[this.curPlayerIndex];
    }

    public void nextPlayer() {
        ++this.curPlayerIndex;
        if (this.curPlayerIndex >= this.players.length) {
            this.curPlayerIndex = 0;
        }
        this.curPlayerHasGone = false;
        this.rollsLeft = 3;
    }

    public void roll() {
        int[] dieIndexes = new int[3];
        int i = 0;
        while (i < 3) {
            dieIndexes[i] = i;
            ++i;
        }
        this.roll(dieIndexes);
    }

    public void roll(int ... dieIndexes) {
        if (this.rollsLeft == 0) {
            return;
        }
        int i = 0;
        while (i < dieIndexes.length) {
            this.dice[dieIndexes[i]].roll();
            ++i;
        }
        --this.rollsLeft;
    }

    public boolean curPlayerHasGone() {
        return this.curPlayerHasGone;
    }

    public boolean isOver() {
        int i = 0;
        while (i < this.players.length) {
            Category[] categoryArray = Category.values();
            int n = categoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Category category = categoryArray[n2];
                if (!this.players[i].hasUsedCategory(category)) {
                    return false;
                }
                ++n2;
            }
            ++i;
        }
        return true;
    }

    public int rollsLeft() {
        return this.rollsLeft;
    }

    public void submit(Category category) {
        switch (category) {
            case CRAG: {
                if ((this.numDiceWithValue(1) >= 2 || this.numDiceWithValue(2) >= 2 || this.numDiceWithValue(3) >= 2 || this.numDiceWithValue(4) >= 2 || this.numDiceWithValue(5) >= 2 || this.numDiceWithValue(6) >= 2) && this.diceTotal() == 13) {
                    this.curPlayer().submit(50, category);
                    break;
                }
                this.curPlayer().submit(0, category);
                break;
            }
            case THIRTEEN: {
                if (this.diceTotal() == 13) {
                    this.curPlayer().submit(26, category);
                    break;
                }
                this.curPlayer().submit(0, category);
                break;
            }
            case THREE_OF_A_KIND: {
                if (this.numDiceWithValue(1) == 3 || this.numDiceWithValue(2) == 3 || this.numDiceWithValue(3) == 3 || this.numDiceWithValue(4) == 3 || this.numDiceWithValue(5) == 3 || this.numDiceWithValue(6) == 3) {
                    this.curPlayer().submit(25, category);
                    break;
                }
                this.curPlayer().submit(0, category);
                break;
            }
            case LOW_STRAIGHT: {
                if (this.numDiceWithValue(1) >= 1 && this.numDiceWithValue(2) >= 1 && this.numDiceWithValue(3) >= 1) {
                    this.curPlayer().submit(20, category);
                    break;
                }
                this.curPlayer().submit(0, category);
                break;
            }
            case HIGH_STRAIGHT: {
                if (this.numDiceWithValue(4) >= 1 && this.numDiceWithValue(5) >= 1 && this.numDiceWithValue(6) >= 1) {
                    this.curPlayer().submit(20, category);
                    break;
                }
                this.curPlayer().submit(0, category);
                break;
            }
            case ODD_STRAIGHT: {
                if (this.numDiceWithValue(1) >= 1 && this.numDiceWithValue(3) >= 1 && this.numDiceWithValue(5) >= 1) {
                    this.curPlayer().submit(20, category);
                    break;
                }
                this.curPlayer().submit(0, category);
                break;
            }
            case EVEN_STRAIGHT: {
                if (this.numDiceWithValue(2) >= 1 && this.numDiceWithValue(4) >= 1 && this.numDiceWithValue(6) >= 1) {
                    this.curPlayer().submit(20, category);
                    break;
                }
                this.curPlayer().submit(0, category);
                break;
            }
            case SIXES: {
                this.curPlayer().submit(this.numDiceWithValue(6) * 6, category);
                break;
            }
            case FIVES: {
                this.curPlayer().submit(this.numDiceWithValue(5) * 5, category);
                break;
            }
            case FOURS: {
                this.curPlayer().submit(this.numDiceWithValue(4) * 4, category);
                break;
            }
            case THREES: {
                this.curPlayer().submit(this.numDiceWithValue(3) * 3, category);
                break;
            }
            case TWOS: {
                this.curPlayer().submit(this.numDiceWithValue(2) * 2, category);
                break;
            }
            case ONES: {
                this.curPlayer().submit(this.numDiceWithValue(1) * 1, category);
            }
        }
        this.curPlayerHasGone = true;
    }

    private int numDiceWithValue(int value) {
        int numDice = 0;
        Die[] dieArray = this.dice;
        int n = this.dice.length;
        int n2 = 0;
        while (n2 < n) {
            Die die = dieArray[n2];
            if (die.getValue() == value) {
                ++numDice;
            }
            ++n2;
        }
        return numDice;
    }

    private int diceTotal() {
        int total = 0;
        Die[] dieArray = this.dice;
        int n = this.dice.length;
        int n2 = 0;
        while (n2 < n) {
            Die die = dieArray[n2];
            total += die.getValue();
            ++n2;
        }
        return total;
    }
}

