/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.dice;

import java.util.HashMap;
import java.util.Map;
import tech.octopusdragon.proj.dice.Category;

public class Player {
    private String name;
    private Map<Category, Integer> categoryPoints;
    private Map<Category, Boolean> usedCategories;

    public Player(String name, Category[] categories) {
        this.name = name;
        this.categoryPoints = new HashMap<Category, Integer>();
        this.usedCategories = new HashMap<Category, Boolean>();
        Category[] categoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            Category category = categoryArray[n2];
            this.categoryPoints.put(category, 0);
            this.usedCategories.put(category, false);
            ++n2;
        }
    }

    public Player(Category[] categories) {
        this("Player", categories);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void submit(Category category, int points) {
        this.categoryPoints.put(category, points);
        this.usedCategories.put(category, true);
    }

    public boolean hasUsedCategory(Category category) {
        return this.usedCategories.get((Object)category);
    }

    public int getPoints(Category category) {
        return this.categoryPoints.get((Object)category);
    }

    public int getTotalScore() {
        int score = 0;
        for (Category category : this.usedCategories.keySet()) {
            score += this.categoryPoints.get((Object)category).intValue();
        }
        return score;
    }
}

