/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.dice;

import tech.octopusdragon.proj.dice.Category;
import tech.octopusdragon.proj.dice.Die;
import tech.octopusdragon.proj.dice.Player;

public abstract class DiceGame {
    private Die[] dice = new Die[this.numDice()];
    private Player[] players;
    private int curPlayerIndex;
    private boolean curPlayerHasGone;
    private int rollsLeft;

    public abstract String name();

    public abstract String description();

    public abstract int numDice();

    public abstract int numRolls();

    public abstract Category[] categories();

    public DiceGame(int numPlayers) {
        int i = 0;
        while (i < this.numDice()) {
            this.dice[i] = new Die();
            ++i;
        }
        this.players = new Player[numPlayers];
        i = 0;
        while (i < numPlayers) {
            this.players[i] = new Player("Player " + (i + 1), this.categories());
            ++i;
        }
        this.curPlayerIndex = -1;
        this.nextPlayer();
    }

    public Die[] getDice() {
        return this.dice;
    }

    public int numPlayers() {
        return this.players.length;
    }

    public Player getPlayer(int i) {
        return this.players[i];
    }

    public Player curPlayer() {
        return this.players[this.curPlayerIndex];
    }

    public void nextPlayer() {
        ++this.curPlayerIndex;
        if (this.curPlayerIndex >= this.players.length) {
            this.curPlayerIndex = 0;
        }
        this.curPlayerHasGone = false;
        this.rollsLeft = this.numRolls();
    }

    public void roll() {
        int[] dieIndexes = new int[this.numDice()];
        int i = 0;
        while (i < this.numDice()) {
            dieIndexes[i] = i;
            ++i;
        }
        this.roll(dieIndexes);
    }

    public void roll(int ... dieIndexes) {
        if (this.rollsLeft == 0) {
            return;
        }
        int i = 0;
        while (i < dieIndexes.length) {
            this.dice[dieIndexes[i]].roll();
            ++i;
        }
        --this.rollsLeft;
    }

    public boolean curPlayerHasGone() {
        return this.curPlayerHasGone;
    }

    public boolean isOver() {
        int i = 0;
        while (i < this.players.length) {
            Category[] categoryArray = this.categories();
            int n = categoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Category category = categoryArray[n2];
                if (!this.players[i].hasUsedCategory(category)) {
                    return false;
                }
                ++n2;
            }
            ++i;
        }
        return true;
    }

    public int rollsLeft() {
        return this.rollsLeft;
    }

    public void submit(Category category) {
        this.curPlayer().submit(category, category.score(this.dice));
        this.curPlayerHasGone = true;
    }
}

