/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.dice;

import tech.octopusdragon.proj.dice.Die;

public enum Category {
    ONES("Ones", "Any combination", "The sum of dice with the 1 face"),
    TWOS("Twos", "Any combination", "The sum of dice with the 2 face"),
    THREES("Threes", "Any combination", "The sum of dice with the 3 face"),
    FOURS("Fours", "Any combination", "The sum of dice with the 4 face"),
    FIVES("Fives", "Any combination", "The sum of dice with the 5 face"),
    SIXES("Sixes", "Any combination", "The sum of dice with the 6 face"),
    FULL_HOUSE("Full House", "Three of one same face and two of another", "25"),
    FOUR_OF_A_KIND("Four-Of-A-Kind", "At least four dice showing the same face", "Sum of those four dice"),
    LITTLE_STRAIGHT("Little Straight", "1-2-3-4-5", "30"),
    BIG_STRAIGHT("Big Straight", "2-3-4-5-6", "30"),
    CHOICE("Choice", "Any combination", "Sum of all dice"),
    YACHT("Yacht", "All five dice showing the same face", "50"),
    CRAG("Crag", "Any combination containing a pair and totalling 13", "50"),
    THIRTEEN("Thirteen", "Any combination totalling 13", "26"),
    THREE_OF_A_KIND("Three-Of-A-Kind", "Three dice showing the same face", "25"),
    LOW_STRAIGHT("Low Straight", "1-2-3", "20"),
    HIGH_STRAIGHT("High Straight", "4-5-6", "20"),
    ODD_STRAIGHT("Odd Straight", "1-3-5", "20"),
    EVEN_STRAIGHT("Even Straight", "2-4-6", "20");

    private final String name;
    private final String description;
    private final String scoring;

    private Category(String name, String description, String score) {
        this.name = name;
        this.description = description;
        this.scoring = score;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getScoring() {
        return this.scoring;
    }

    public int score(Die[] dice) {
        int score = 0;
        switch (this) {
            case ONES: {
                score = this.numDiceWithValue(dice, 1) * 1;
                break;
            }
            case TWOS: {
                score = this.numDiceWithValue(dice, 2) * 2;
                break;
            }
            case THREES: {
                score = this.numDiceWithValue(dice, 3) * 3;
                break;
            }
            case FOURS: {
                score = this.numDiceWithValue(dice, 4) * 4;
                break;
            }
            case FIVES: {
                score = this.numDiceWithValue(dice, 5) * 5;
                break;
            }
            case SIXES: {
                score = this.numDiceWithValue(dice, 6) * 6;
                break;
            }
            case FULL_HOUSE: {
                boolean fullHouse = false;
                int i = 1;
                while (i <= 6) {
                    int j = 1;
                    while (j <= 6) {
                        if (i != j && this.numDiceWithValue(dice, i) == 2 && this.numDiceWithValue(dice, j) == 3) {
                            fullHouse = true;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (!fullHouse) break;
                score = 25;
                break;
            }
            case FOUR_OF_A_KIND: {
                if (this.numDiceWithValue(dice, 1) >= 4) {
                    score = 4;
                    break;
                }
                if (this.numDiceWithValue(dice, 2) >= 4) {
                    score = 8;
                    break;
                }
                if (this.numDiceWithValue(dice, 3) >= 4) {
                    score = 12;
                    break;
                }
                if (this.numDiceWithValue(dice, 4) >= 4) {
                    score = 16;
                    break;
                }
                if (this.numDiceWithValue(dice, 5) >= 4) {
                    score = 20;
                    break;
                }
                if (this.numDiceWithValue(dice, 6) < 4) break;
                score = 24;
                break;
            }
            case LITTLE_STRAIGHT: {
                if (this.numDiceWithValue(dice, 1) < 1 || this.numDiceWithValue(dice, 2) < 1 || this.numDiceWithValue(dice, 3) < 1 || this.numDiceWithValue(dice, 4) < 1 || this.numDiceWithValue(dice, 5) < 1) break;
                score = 30;
                break;
            }
            case BIG_STRAIGHT: {
                if (this.numDiceWithValue(dice, 2) < 1 || this.numDiceWithValue(dice, 3) < 1 || this.numDiceWithValue(dice, 4) < 1 || this.numDiceWithValue(dice, 5) < 1 || this.numDiceWithValue(dice, 6) < 1) break;
                score = 30;
                break;
            }
            case CHOICE: {
                Die[] dieArray = dice;
                int n = dice.length;
                int n2 = 0;
                while (n2 < n) {
                    Die die = dieArray[n2];
                    score += die.getValue();
                    ++n2;
                }
                break;
            }
            case YACHT: {
                if (this.numDiceWithValue(dice, 1) != 5 && this.numDiceWithValue(dice, 2) != 5 && this.numDiceWithValue(dice, 3) != 5 && this.numDiceWithValue(dice, 4) != 5 && this.numDiceWithValue(dice, 5) != 5 && this.numDiceWithValue(dice, 6) != 5) break;
                score = 50;
                break;
            }
            case CRAG: {
                if (this.numDiceWithValue(dice, 1) < 2 && this.numDiceWithValue(dice, 2) < 2 && this.numDiceWithValue(dice, 3) < 2 && this.numDiceWithValue(dice, 4) < 2 && this.numDiceWithValue(dice, 5) < 2 && this.numDiceWithValue(dice, 6) < 2 || this.diceTotal(dice) != 13) break;
                score = 50;
                break;
            }
            case THIRTEEN: {
                if (this.diceTotal(dice) != 13) break;
                score = 26;
                break;
            }
            case THREE_OF_A_KIND: {
                if (this.numDiceWithValue(dice, 1) != 3 && this.numDiceWithValue(dice, 2) != 3 && this.numDiceWithValue(dice, 3) != 3 && this.numDiceWithValue(dice, 4) != 3 && this.numDiceWithValue(dice, 5) != 3 && this.numDiceWithValue(dice, 6) != 3) break;
                score = 25;
                break;
            }
            case LOW_STRAIGHT: {
                if (this.numDiceWithValue(dice, 1) < 1 || this.numDiceWithValue(dice, 2) < 1 || this.numDiceWithValue(dice, 3) < 1) break;
                score = 20;
                break;
            }
            case HIGH_STRAIGHT: {
                if (this.numDiceWithValue(dice, 4) < 1 || this.numDiceWithValue(dice, 5) < 1 || this.numDiceWithValue(dice, 6) < 1) break;
                score = 20;
                break;
            }
            case ODD_STRAIGHT: {
                if (this.numDiceWithValue(dice, 1) < 1 || this.numDiceWithValue(dice, 3) < 1 || this.numDiceWithValue(dice, 5) < 1) break;
                score = 20;
                break;
            }
            case EVEN_STRAIGHT: {
                if (this.numDiceWithValue(dice, 2) < 1 || this.numDiceWithValue(dice, 4) < 1 || this.numDiceWithValue(dice, 6) < 1) break;
                score = 20;
            }
        }
        return score;
    }

    private int numDiceWithValue(Die[] dice, int value) {
        int numDice = 0;
        Die[] dieArray = dice;
        int n = dice.length;
        int n2 = 0;
        while (n2 < n) {
            Die die = dieArray[n2];
            if (die.getValue() == value) {
                ++numDice;
            }
            ++n2;
        }
        return numDice;
    }

    private int diceTotal(Die[] dice) {
        int total = 0;
        Die[] dieArray = dice;
        int n = dice.length;
        int n2 = 0;
        while (n2 < n) {
            Die die = dieArray[n2];
            total += die.getValue();
            ++n2;
        }
        return total;
    }
}

