/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.cursordodge.game;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Ellipse;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import tech.octopusdragon.cursordodge.application.CursorDodgeApplication;
import tech.octopusdragon.cursordodge.game.classes.CollisionPoint;
import tech.octopusdragon.cursordodge.game.classes.Corner;
import tech.octopusdragon.cursordodge.game.classes.Edge;
import tech.octopusdragon.cursordodge.game.classes.GameOverReason;
import tech.octopusdragon.cursordodge.game.classes.Position;

public class Game
extends Pane {
    private static final double CIRCLE_SIZE = 0.001;
    private static final double MOUSE_BOX_SIZE = 0.5;
    private static final double NEW_ANGLE_RANGE = 22.5;
    private static final int COUNTDOWN_FROM = 3;
    private static final double COUNTDOWN_DURATION = 0.5;
    private static final Paint OBSTACLE_CIRCLE_PAINT = Color.RED;
    private static final double OBSTACLE_CIRCLE_INITIAL_SPEED = 100.0;
    private static final double OBSTACLE_CIRCLE_ACCELERATION = 2.0;
    private static final double OBSTACLE_CIRCLE_INITIAL_INTERVAL = 7.5;
    private static final double OBSTACLE_CIRCLE_INTERVAL_ADDER = 5.0;
    private static final Paint CATCH_CIRCLE_PAINT = Color.BLUE;
    private static final double CATCH_CIRCLE_DELAY = 22.5;
    private static final double CATCH_CIRCLE_INTERVAL = 15.0;
    private static final double CATCH_CIRCLE_INITIAL_DURATION = 5.0;
    private static final double CATCH_CIRCLE_DURATION_MULTIPLIER = 0.95;
    private static final Paint CORNER_CIRCLE_PAINT = Color.GREEN;
    private static final double CORNER_CIRCLE_INTERVAL = 2.0;
    private static final double CORNER_CIRCLE_ANIMATION_DURATION = 0.15;
    private static final double CORNER_CIRCLE_DURATION = 0.15;
    private static final double CORNER_CIRCLE_SAME_CIRCLE_CHANCE = 0.5;
    private double screenWidth;
    private double screenHeight;
    private double sceneWidth;
    private double sceneHeight;
    private double circleRadius;
    private Label messageLabel;
    private Ellipse firstObstacleCircle;
    private ObjectProperty<Position> cursorPosProperty;
    private BooleanProperty mouseExitedProperty;
    private ChangeListener<? super Boolean> mouseExitedListener;
    private BooleanProperty windowOutOfBoundsProperty;
    private ChangeListener<? super Boolean> windowOutOfBoundsListener;
    private BooleanProperty maximizedProperty;
    private BooleanProperty gameOverProperty;
    private double obstacleCircleSpeed;
    private DoubleProperty obstacleCircleIntervalProperty;
    private double catchCircleFadeDuration;
    private double startTime;
    private double endTime;
    private boolean cornerCirclesActive;

    public Game(Label messageLabel) {
        this.messageLabel = messageLabel;
        this.cursorPosProperty = new SimpleObjectProperty((Object)new Position());
        this.mouseExitedProperty = new SimpleBooleanProperty();
        this.windowOutOfBoundsProperty = new SimpleBooleanProperty();
        this.maximizedProperty = new SimpleBooleanProperty();
        this.gameOverProperty = new SimpleBooleanProperty(false);
        this.obstacleCircleSpeed = 100.0;
        this.obstacleCircleIntervalProperty = new SimpleDoubleProperty(7.5);
        this.catchCircleFadeDuration = 5.0;
        Platform.runLater(() -> {
            Scene scene = this.getScene();
            Stage stage = (Stage)scene.getWindow();
            scene.setOnMouseExited(event -> this.mouseExitedProperty.set(true));
            scene.setOnMouseEntered(event -> this.mouseExitedProperty.set(false));
            this.windowOutOfBoundsProperty.bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                if (!this.gameOverProperty.get()) {
                    return this.windowOutOfBounds();
                }
                return false;
            }, (Observable[])new Observable[]{stage.xProperty(), stage.yProperty(), stage.widthProperty(), stage.heightProperty()}));
            this.maximizedProperty.bind((ObservableValue)stage.maximizedProperty());
            if (this.maximizedProperty.get()) {
                messageLabel.setText("Please unmaximize the window.");
                this.maximizedProperty.addListener((obs, oldVal, newVal) -> {
                    if (!newVal.booleanValue()) {
                        messageLabel.setText("Please move your cursor inside the window.");
                        Platform.runLater(() -> {
                            this.buildPane();
                            this.displayMoveCursor();
                        });
                    }
                });
            } else {
                this.buildPane();
                this.displayMoveCursor();
            }
        });
    }

    private void buildPane() {
        Scene scene = this.getScene();
        Rectangle2D bounds = Screen.getPrimary().getBounds();
        this.screenWidth = bounds.getWidth();
        this.screenHeight = bounds.getHeight();
        this.sceneWidth = scene.getWidth();
        this.sceneHeight = scene.getHeight();
        double screenArea = this.screenWidth * this.screenHeight;
        this.circleRadius = Math.sqrt(screenArea * 0.001) / 2.0;
        this.firstObstacleCircle = this.newObstacleCircle();
        this.getScene().setOnMouseMoved((EventHandler)new MouseMoveHandler());
        ChangeListener<Number> resizeListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Game.this.gameOver(GameOverReason.RESIZE);
            }
        };
        Window window = this.getScene().getWindow();
        window.widthProperty().addListener((ChangeListener)resizeListener);
        window.heightProperty().addListener((ChangeListener)resizeListener);
        this.gameOverProperty.addListener((arg_0, arg_1, arg_2) -> Game.lambda$6(window, (ChangeListener)resizeListener, arg_0, arg_1, arg_2));
    }

    private Ellipse newObstacleCircle() {
        Ellipse circle = new Ellipse(this.circleRadius, this.circleRadius);
        circle.setFill(OBSTACLE_CIRCLE_PAINT);
        Position startPosition = this.randomPositionExcludeCursorVicinity();
        circle.setTranslateX(startPosition.getX());
        circle.setTranslateY(startPosition.getY());
        circle.addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                Game.this.gameOver(GameOverReason.OBSTACLE);
            }
        });
        this.getChildren().add(0, (Object)circle);
        return circle;
    }

    private Ellipse newCatchCircle() {
        final Ellipse circle = new Ellipse(this.circleRadius, this.circleRadius);
        circle.setFill(CATCH_CIRCLE_PAINT);
        Position position = this.randomPosition();
        circle.setTranslateX(position.getX());
        circle.setTranslateY(position.getY());
        circle.addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                ((Pane)circle.getParent()).getChildren().remove((Object)circle);
            }
        });
        this.getChildren().add((Object)circle);
        return circle;
    }

    private Ellipse newCornerCircle() {
        Ellipse circle = new Ellipse(this.circleRadius, this.circleRadius);
        circle.setFill(CORNER_CIRCLE_PAINT);
        circle.addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                Game.this.gameOver(GameOverReason.OBSTACLE);
            }
        });
        this.getChildren().add((Object)circle);
        return circle;
    }

    private Animation newObstacleCircleAnimation(Ellipse circle) {
        return this.newCircleAnimation(circle, this.randomAngle());
    }

    private Animation newCircleAnimation(Ellipse circle, double angle) {
        TranslateTransition tt = new TranslateTransition();
        tt.setNode((Node)circle);
        tt.setInterpolator(Interpolator.LINEAR);
        CollisionPoint collisionPoint = this.collisionPoint(circle, angle);
        tt.setDuration(Duration.seconds((double)this.time(new Position(circle.getTranslateX(), circle.getTranslateY()), new Position(collisionPoint.getX(), collisionPoint.getY()))));
        tt.setToX(collisionPoint.getX());
        tt.setToY(collisionPoint.getY());
        tt.setOnFinished(e -> {
            double newAngle = this.newAngle(collisionPoint, angle);
            this.newCircleAnimation(circle, newAngle).play();
        });
        this.gameOverProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                tt.stop();
            }
        });
        return tt;
    }

    private Animation newCatchCircleAnimation(Ellipse circle) {
        final FadeTransition ft = new FadeTransition(Duration.seconds((double)this.catchCircleFadeDuration), (Node)circle);
        ft.setInterpolator(Interpolator.LINEAR);
        ft.setToValue(0.0);
        ft.setOnFinished(e -> this.gameOver(GameOverReason.DID_NOT_CATCH));
        circle.addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                ft.stop();
            }
        });
        this.gameOverProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                ft.stop();
            }
        });
        return ft;
    }

    private Animation newCornerCircleAnimation(Ellipse circle, Corner cursorCorner) {
        Corner corner;
        HashMap<Corner, Position> onscreenPositions = new HashMap<Corner, Position>();
        onscreenPositions.put(Corner.TOP_LEFT, new Position(0.0, 0.0));
        onscreenPositions.put(Corner.TOP_RIGHT, new Position(this.sceneWidth, 0.0));
        onscreenPositions.put(Corner.BOTTOM_LEFT, new Position(0.0, this.sceneHeight));
        onscreenPositions.put(Corner.BOTTOM_RIGHT, new Position(this.sceneWidth, this.sceneHeight));
        HashMap<Corner, Position> offscreenPositions = new HashMap<Corner, Position>();
        offscreenPositions.put(Corner.TOP_LEFT, new Position(-this.circleRadius, -this.circleRadius));
        offscreenPositions.put(Corner.TOP_RIGHT, new Position(this.sceneWidth + this.circleRadius, -this.circleRadius));
        offscreenPositions.put(Corner.BOTTOM_LEFT, new Position(-this.circleRadius, this.sceneHeight + this.circleRadius));
        offscreenPositions.put(Corner.BOTTOM_RIGHT, new Position(this.sceneWidth + this.circleRadius, this.sceneHeight + this.circleRadius));
        Random rand = new Random();
        if (rand.nextDouble() < 0.5) {
            corner = cursorCorner;
        } else {
            ArrayList<Corner> cornersLeft = new ArrayList<Corner>(Arrays.asList(Corner.values()));
            cornersLeft.remove((Object)cursorCorner);
            corner = (Corner)((Object)cornersLeft.get(rand.nextInt(cornersLeft.size())));
        }
        Position onscreenPosition = (Position)onscreenPositions.get((Object)corner);
        Position offscreenPosition = (Position)offscreenPositions.get((Object)corner);
        TranslateTransition enter = new TranslateTransition(Duration.seconds((double)0.15));
        enter.setInterpolator(Interpolator.LINEAR);
        enter.setFromX(offscreenPosition.getX());
        enter.setFromY(offscreenPosition.getY());
        enter.setToX(onscreenPosition.getX());
        enter.setToY(onscreenPosition.getY());
        TranslateTransition exit = new TranslateTransition(Duration.seconds((double)0.15));
        exit.setInterpolator(Interpolator.LINEAR);
        exit.setFromX(onscreenPosition.getX());
        exit.setFromY(onscreenPosition.getY());
        exit.setToX(offscreenPosition.getX());
        exit.setToY(offscreenPosition.getY());
        SequentialTransition animation = new SequentialTransition((Node)circle, new Animation[]{enter, new PauseTransition(Duration.seconds((double)0.15)), exit});
        animation.setOnFinished(e -> ((Pane)circle.getParent()).getChildren().remove((Object)circle));
        this.gameOverProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                animation.stop();
            }
        });
        return animation;
    }

    private CollisionPoint collisionPoint(Ellipse circle, double angle) throws IllegalArgumentException {
        double fromX = circle.getTranslateX();
        double fromY = circle.getTranslateY();
        ArrayList<CollisionPoint> possibleIntersections = new ArrayList<CollisionPoint>();
        double dirAngleRadians = Math.toRadians(angle);
        double slope = Math.tan(dirAngleRadians);
        if (slope != 0.0) {
            double xIntersection = fromX + fromY / slope;
            if ((xIntersection -= circle.getRadiusY() / slope) - circle.getRadiusY() >= 0.0 && xIntersection + circle.getRadiusY() <= this.sceneWidth) {
                possibleIntersections.add(new CollisionPoint(Edge.TOP, xIntersection, 0.0 + circle.getRadiusY()));
            }
            xIntersection = fromX - (this.sceneHeight - fromY) / slope;
            if ((xIntersection += circle.getRadiusY() / slope) - circle.getRadiusY() >= 0.0 && xIntersection + circle.getRadiusY() <= this.sceneWidth) {
                possibleIntersections.add(new CollisionPoint(Edge.BOTTOM, xIntersection, this.sceneHeight - circle.getRadiusY()));
            }
        }
        if (slope != Double.POSITIVE_INFINITY) {
            double yIntersection = fromY + slope * fromX;
            if ((yIntersection -= circle.getRadiusX() * slope) - circle.getRadiusX() >= 0.0 && yIntersection + circle.getRadiusX() <= this.sceneHeight) {
                possibleIntersections.add(new CollisionPoint(Edge.LEFT, 0.0 + circle.getRadiusX(), yIntersection));
            }
            yIntersection = fromY - slope * (this.sceneWidth - fromX);
            if ((yIntersection += circle.getRadiusX() * slope) - circle.getRadiusX() >= 0.0 && yIntersection + circle.getRadiusX() <= this.sceneHeight) {
                possibleIntersections.add(new CollisionPoint(Edge.RIGHT, this.sceneWidth - circle.getRadiusX(), yIntersection));
            }
        }
        if (possibleIntersections.size() == 1) {
            return (CollisionPoint)possibleIntersections.get(0);
        }
        if (possibleIntersections.size() > 1) {
            double smallestAngle = Double.MAX_VALUE;
            CollisionPoint smallestIntersection = null;
            for (CollisionPoint curIntersection : possibleIntersections) {
                double curAngle = Double.MAX_VALUE;
                switch (curIntersection.getEdge()) {
                    case TOP: {
                        curAngle = Math.abs(dirAngleRadians - 1.5707963267948966);
                        break;
                    }
                    case RIGHT: {
                        curAngle = Math.min(Math.abs(dirAngleRadians), Math.abs(dirAngleRadians - Math.PI * 2));
                        break;
                    }
                    case BOTTOM: {
                        curAngle = Math.abs(dirAngleRadians - 4.71238898038469);
                        break;
                    }
                    case LEFT: {
                        curAngle = Math.abs(dirAngleRadians - Math.PI);
                    }
                }
                if (!(curAngle < smallestAngle)) continue;
                smallestAngle = curAngle;
                smallestIntersection = curIntersection;
            }
            return smallestIntersection;
        }
        throw new IllegalArgumentException(String.format("fromX: %f\nfromY: %f\nangle: %f\nOne of these numbers did not allow for a correct collision point equation.", fromX, fromY, angle));
    }

    private double newAngle(CollisionPoint collisionPoint, double angle) {
        double reflectionAxis = 0.0;
        switch (collisionPoint.getEdge()) {
            case TOP: {
                reflectionAxis = 90.0;
                break;
            }
            case RIGHT: {
                reflectionAxis = 360.0;
                break;
            }
            case BOTTOM: {
                reflectionAxis = 270.0;
                break;
            }
            case LEFT: {
                reflectionAxis = 180.0;
            }
        }
        double reflectedAngle = (180.0 + reflectionAxis - (angle - reflectionAxis)) % 360.0;
        double rangeMin = reflectedAngle - 11.25;
        double rangeMax = reflectedAngle + 11.25;
        switch (collisionPoint.getEdge()) {
            case TOP: {
                rangeMin = Math.max(rangeMin, 180.0);
                rangeMax = Math.min(rangeMax, 360.0);
                break;
            }
            case RIGHT: {
                rangeMin = Math.max(rangeMin, 90.0);
                rangeMax = Math.min(rangeMax, 270.0);
                break;
            }
            case BOTTOM: {
                rangeMin = Math.max(rangeMin, 0.0);
                rangeMax = Math.min(rangeMax, 180.0);
                break;
            }
            case LEFT: {
                if (reflectedAngle > 0.0 && reflectedAngle < 90.0) {
                    rangeMin = Math.max(rangeMin, -90.0);
                    rangeMax = Math.min(rangeMax, 90.0);
                    break;
                }
                if (!(reflectedAngle > 270.0) || !(reflectedAngle < 360.0)) break;
                rangeMin = Math.max(rangeMin, 270.0);
                rangeMax = Math.min(rangeMax, 450.0);
            }
        }
        Random rand = new Random();
        double newAngle = rangeMin + (rangeMax - rangeMin) * rand.nextDouble();
        newAngle = (newAngle % 360.0 + 360.0) % 360.0;
        return newAngle;
    }

    private double time(Position initialPos, Position finalPos) {
        double distanceX = Math.abs(initialPos.getX() - finalPos.getX());
        double distanceY = Math.abs(initialPos.getY() - finalPos.getY());
        double distance = Math.sqrt(Math.pow(distanceX, 2.0) + Math.pow(distanceY, 2.0));
        double time = distance / this.obstacleCircleSpeed;
        return time;
    }

    private double randomAngle() {
        Random rand = new Random();
        return rand.nextDouble() * 360.0;
    }

    private Position randomPosition() {
        Random rand = new Random();
        double x = this.circleRadius + (this.sceneWidth - 2.0 * this.circleRadius) * rand.nextDouble();
        double y = this.circleRadius + (this.sceneHeight - 2.0 * this.circleRadius) * rand.nextDouble();
        return new Position(x, y);
    }

    private Position randomPositionExcludeCursorVicinity() {
        Random rand = new Random();
        Position cursorPos = (Position)this.cursorPosProperty.get();
        if (cursorPos.isEmpty()) {
            return this.randomPosition();
        }
        ArrayList<Position> validPositions = new ArrayList<Position>();
        int x = (int)this.circleRadius;
        while ((double)x < this.sceneWidth - this.circleRadius) {
            int y = (int)this.circleRadius;
            while ((double)y < this.sceneHeight - this.circleRadius) {
                if (!((double)x >= cursorPos.getX() - this.sceneWidth * 0.5 / 2.0 && (double)x <= cursorPos.getY() + this.sceneWidth * 0.5 / 2.0 && (double)y >= cursorPos.getY() - this.sceneHeight * 0.5 / 2.0 && (double)y <= cursorPos.getY() + this.sceneHeight * 0.5 / 2.0)) {
                    validPositions.add(new Position(x, y));
                }
                ++y;
            }
            ++x;
        }
        return (Position)validPositions.get(rand.nextInt(validPositions.size()));
    }

    private void displayMoveCursor() {
        if (this.windowOutOfBounds()) {
            this.messageLabel.setText("Please move the window fully inside the screen.");
            this.windowOutOfBoundsProperty.addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> obs, Boolean oldVal, Boolean newVal) {
                    Game.this.windowOutOfBoundsProperty.removeListener((ChangeListener)this);
                    Game.this.displayCountdownAndStartGame();
                }
            });
        } else {
            this.cursorPosProperty.addListener((ChangeListener)new ChangeListener<Position>(){

                public void changed(ObservableValue<? extends Position> obs, Position oldVal, Position newVal) {
                    Game.this.cursorPosProperty.removeListener((ChangeListener)this);
                    Game.this.displayCountdownAndStartGame();
                }
            });
        }
    }

    private void displayCorrectionNeeded() {
        if (this.windowOutOfBounds()) {
            this.messageLabel.setText("Please move the window back inside the screen.");
            this.windowOutOfBoundsProperty.addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> obs, Boolean oldVal, Boolean newVal) {
                    if (!newVal.booleanValue()) {
                        Game.this.windowOutOfBoundsProperty.removeListener((ChangeListener)this);
                        Game.this.displayCountdownAndStartGame();
                    }
                }
            });
        } else if (this.mouseExitedProperty.get()) {
            this.messageLabel.setText("Please move the cursor back inside the window.");
            final ChangeListener alsoOutOfBoundsListener = (obs, oldVal, newVal) -> {
                if (newVal.booleanValue()) {
                    this.messageLabel.setText("Please move the window back inside the screen.");
                } else {
                    this.messageLabel.setText("Please move the cursor back inside the window.");
                }
            };
            this.windowOutOfBoundsProperty.addListener(alsoOutOfBoundsListener);
            this.mouseExitedProperty.addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> obs, Boolean oldVal, Boolean newVal) {
                    if (!newVal.booleanValue() && !Game.this.windowOutOfBounds()) {
                        Game.this.windowOutOfBoundsProperty.removeListener(alsoOutOfBoundsListener);
                        Game.this.mouseExitedProperty.removeListener((ChangeListener)this);
                        Game.this.displayCountdownAndStartGame();
                    }
                }
            });
        }
        this.windowOutOfBoundsProperty.removeListener(this.windowOutOfBoundsListener);
        this.mouseExitedProperty.removeListener(this.mouseExitedListener);
    }

    private void displayCountdownAndStartGame() {
        class Countdown {
            private int count = 3;
            private Timeline countdownTimeline;

            public Countdown() {
                Game.this.messageLabel.setText(String.valueOf(this.count));
                this.countdownTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.5), (EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent e) {
                        Countdown countdown = this;
                        countdown.count = countdown.count - 1;
                        if (count == 0) {
                            Game.this.messageLabel.setText("Go!");
                            Game.this.startGame();
                        } else if (count > 0) {
                            Game.this.messageLabel.setText(String.valueOf(count));
                        }
                    }
                }, new KeyValue[0])});
                this.countdownTimeline.setCycleCount(4);
                this.countdownTimeline.setOnFinished(e -> Game.this.messageLabel.setVisible(false));
                this.countdownTimeline.play();
            }

            public Timeline getCountdownTimeline() {
                return this.countdownTimeline;
            }
        }
        Countdown countdown = new Countdown();
        this.mouseExitedListener = (obs, oldVal, newVal) -> {
            countdown.getCountdownTimeline().stop();
            this.displayCorrectionNeeded();
        };
        this.mouseExitedProperty.addListener(this.mouseExitedListener);
        this.windowOutOfBoundsListener = (obs, oldVal, newVal) -> {
            countdown.getCountdownTimeline().stop();
            this.displayCorrectionNeeded();
        };
        this.windowOutOfBoundsProperty.addListener(this.windowOutOfBoundsListener);
        if (this.maximizedProperty.get() || this.mouseExitedProperty.get() || this.windowOutOfBoundsProperty.get()) {
            countdown.getCountdownTimeline().stop();
            this.displayCorrectionNeeded();
        }
        countdown.getCountdownTimeline().setOnFinished(event -> {
            this.messageLabel.setVisible(false);
            this.mouseExitedProperty.removeListener(this.mouseExitedListener);
            this.windowOutOfBoundsProperty.removeListener(this.windowOutOfBoundsListener);
        });
    }

    private void startGame() {
        this.mouseExitedProperty.addListener((obs, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.gameOver(GameOverReason.OUT_OF_BOUNDS);
            }
        });
        this.newObstacleCircleAnimation(this.firstObstacleCircle).play();
        Timeline firstNewObstacleCircleTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)this.obstacleCircleIntervalProperty.get()), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Ellipse circle = Game.this.newObstacleCircle();
                Game.this.newObstacleCircleAnimation(circle).play();
                Game.this.obstacleCircleIntervalProperty.set(Game.this.obstacleCircleIntervalProperty.get() + 5.0);
            }
        }, new KeyValue[0])});
        this.obstacleCircleIntervalProperty.addListener((observable, oldValue, newValue) -> {
            Timeline newObstacleCircleTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)this.obstacleCircleIntervalProperty.get()), (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    Ellipse circle = Game.this.newObstacleCircle();
                    Game.this.newObstacleCircleAnimation(circle).play();
                    Game.this.obstacleCircleIntervalProperty.set(Game.this.obstacleCircleIntervalProperty.get() + 5.0);
                }
            }, new KeyValue[0])});
            newObstacleCircleTimeline.play();
            this.gameOverProperty.addListener((obs, oldVal, newVal) -> {
                if (newVal.booleanValue()) {
                    newObstacleCircleTimeline.stop();
                }
            });
        });
        Timeline initialCatchCircleTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)22.5), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Ellipse circle = Game.this.newCatchCircle();
                Game.this.newCatchCircleAnimation(circle).play();
            }
        }, new KeyValue[0])});
        Timeline newCatchCircleTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)15.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Ellipse circle = Game.this.newCatchCircle();
                Game.this.newCatchCircleAnimation(circle).play();
                Game game = Game.this;
                game.catchCircleFadeDuration = game.catchCircleFadeDuration * 0.95;
            }
        }, new KeyValue[0])});
        newCatchCircleTimeline.setCycleCount(-1);
        initialCatchCircleTimeline.setOnFinished(e -> newCatchCircleTimeline.play());
        this.cursorPosProperty.addListener((obs, oldVal, newVal) -> {
            if (this.cursorInCorner() && !this.cornerCirclesActive) {
                new CornerCircleTimeline().play();
            }
        });
        Timeline updateTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Game game = Game.this;
                game.obstacleCircleSpeed = game.obstacleCircleSpeed + 2.0;
            }
        }, new KeyValue[0])});
        updateTimeline.setCycleCount(-1);
        this.gameOverProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                firstNewObstacleCircleTimeline.stop();
                initialCatchCircleTimeline.stop();
                newCatchCircleTimeline.stop();
                updateTimeline.stop();
            }
        });
        firstNewObstacleCircleTimeline.play();
        initialCatchCircleTimeline.play();
        updateTimeline.play();
        this.startTime = System.nanoTime();
    }

    private void gameOver(GameOverReason reason) {
        if (this.gameOverProperty.get()) {
            return;
        }
        this.endTime = System.nanoTime();
        this.gameOverProperty.set(true);
        double time = (this.endTime - this.startTime) / 1.0E9;
        if (this.startTime == 0.0) {
            CursorDodgeApplication.switchToGameOverScene(reason);
        } else {
            CursorDodgeApplication.switchToGameOverScene(reason, time, this.sceneWidth, this.sceneHeight, this.screenWidth, this.screenHeight);
        }
    }

    private boolean windowOutOfBounds() {
        Stage stage = (Stage)this.getScene().getWindow();
        Rectangle2D screenBounds = Screen.getPrimary().getBounds();
        double x = stage.getX();
        double y = stage.getY();
        double w = stage.getWidth();
        double h = stage.getHeight();
        boolean outOfBounds = false;
        if (x <= screenBounds.getMinX()) {
            outOfBounds = true;
        } else if (x + w >= screenBounds.getMaxX()) {
            outOfBounds = true;
        } else if (y <= screenBounds.getMinY()) {
            outOfBounds = true;
        } else if (y + h >= screenBounds.getMaxY()) {
            outOfBounds = true;
        }
        return outOfBounds;
    }

    private boolean cursorInCorner() {
        Position cursorPos = (Position)this.cursorPosProperty.get();
        return (cursorPos.getX() <= this.circleRadius || cursorPos.getX() >= this.sceneWidth - this.circleRadius) && (cursorPos.getY() <= this.circleRadius || cursorPos.getY() >= this.sceneHeight - this.circleRadius);
    }

    private Corner cursorCorner() {
        Position cursorPos = (Position)this.cursorPosProperty.get();
        Corner corner = cursorPos.getX() <= this.circleRadius && cursorPos.getY() <= this.circleRadius ? Corner.TOP_LEFT : (cursorPos.getX() >= this.sceneWidth - this.circleRadius && cursorPos.getY() <= this.circleRadius ? Corner.TOP_RIGHT : (cursorPos.getX() <= this.circleRadius && cursorPos.getY() >= this.sceneHeight - this.circleRadius ? Corner.BOTTOM_LEFT : (cursorPos.getX() >= this.sceneWidth - this.circleRadius && cursorPos.getY() >= this.sceneHeight - this.circleRadius ? Corner.BOTTOM_RIGHT : null)));
        return corner;
    }

    private static /* synthetic */ void lambda$6(Window window, ChangeListener changeListener, ObservableValue observable, Boolean oldValue, Boolean newValue) {
        if (newValue.booleanValue()) {
            window.widthProperty().removeListener(changeListener);
            window.heightProperty().removeListener(changeListener);
        }
    }

    private class CornerCircleTimeline {
        private Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Ellipse circle = Game.this.newCornerCircle();
                Animation animation = Game.this.newCornerCircleAnimation(circle, Game.this.cursorCorner());
                CornerCircleTimeline.this.gameOverListener = new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> obs, Boolean oldVal, Boolean newVal) {
                        if (newVal.booleanValue()) {
                            CornerCircleTimeline.this.timeline.stop();
                            CornerCircleTimeline.this.removeListeners();
                            Game.this.cornerCirclesActive = false;
                        }
                    }
                };
                CornerCircleTimeline.this.cursorMoveListener = new ChangeListener<Position>(){

                    public void changed(ObservableValue<? extends Position> obs, Position oldVal, Position newVal) {
                        if (!Game.this.cursorInCorner()) {
                            CornerCircleTimeline.this.timeline.stop();
                            CornerCircleTimeline.this.removeListeners();
                            Game.this.cornerCirclesActive = false;
                        }
                    }
                };
                CornerCircleTimeline.this.addListeners();
                animation.play();
            }
        }, new KeyValue[0]), new KeyFrame(Duration.seconds((double)2.0), new KeyValue[0])});
        ChangeListener<Boolean> gameOverListener;
        ChangeListener<Position> cursorMoveListener;

        public CornerCircleTimeline() {
            this.timeline.setCycleCount(-1);
        }

        private void addListeners() {
            Game.this.gameOverProperty.addListener(this.gameOverListener);
            Game.this.cursorPosProperty.addListener(this.cursorMoveListener);
        }

        private void removeListeners() {
            Game.this.gameOverProperty.removeListener(this.gameOverListener);
            Game.this.cursorPosProperty.removeListener(this.cursorMoveListener);
        }

        public void play() {
            this.timeline.play();
            Game.this.cornerCirclesActive = true;
        }
    }

    private class MouseMoveHandler
    implements EventHandler<MouseEvent> {
        private MouseMoveHandler() {
        }

        public void handle(MouseEvent e) {
            Game.this.cursorPosProperty.set((Object)new Position(e.getSceneX(), e.getSceneY()));
        }
    }
}

