/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.cursordodge.application;

import java.io.IOException;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Screen;
import javafx.stage.Stage;
import tech.octopusdragon.cursordodge.application.scenes.GameOverSceneController;
import tech.octopusdragon.cursordodge.game.classes.GameOverReason;

public class CursorDodgeApplication
extends Application {
    public static final double DEFAULT_WINDOW_SIZE_PROPORTION = 0.5;
    public static final String GAME_SCENE_FXML = "scenes/GameScene.fxml";
    public static final String TITLE_SCENE_FXML = "scenes/TitleScene.fxml";
    public static final String GAME_OVER_SCENE_FXML = "scenes/GameOverScene.fxml";
    public static final String HOW_TO_PLAY_SCENE_FXML = "scenes/HowToPlayScene.fxml";
    private static final String ICON_PATH = "resources/icon.png";
    private static Stage stage;

    public void start(Stage primaryStage) {
        stage = primaryStage;
        primaryStage.setTitle("Cursor Dodge");
        primaryStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(ICON_PATH)));
        Rectangle2D screenBounds = Screen.getPrimary().getBounds();
        double screenW = screenBounds.getWidth();
        double screenH = screenBounds.getHeight();
        double windowSize = (screenH < screenW ? screenH : screenW) * 0.5;
        primaryStage.setWidth(windowSize);
        primaryStage.setHeight(windowSize);
        CursorDodgeApplication.switchToTitleScene();
        primaryStage.show();
    }

    public static void main(String[] args) {
        CursorDodgeApplication.launch((String[])args);
    }

    private static FXMLLoader switchToScene(String fxmlPath) {
        FXMLLoader loader = new FXMLLoader(CursorDodgeApplication.class.getResource(fxmlPath));
        try {
            if (stage.getScene() == null) {
                stage.setScene(new Scene((Parent)loader.load()));
            } else {
                stage.getScene().setRoot((Parent)loader.load());
            }
        }
        catch (IOException e) {
            System.out.println("Error loading FXML file");
            e.printStackTrace();
        }
        return loader;
    }

    public static void switchToGameScene() {
        CursorDodgeApplication.switchToScene(GAME_SCENE_FXML);
    }

    public static void switchToTitleScene() {
        CursorDodgeApplication.switchToScene(TITLE_SCENE_FXML);
    }

    public static void switchToHowToPlayScene() {
        CursorDodgeApplication.switchToScene(HOW_TO_PLAY_SCENE_FXML);
    }

    public static void switchToGameOverScene(GameOverReason reason) {
        FXMLLoader loader = CursorDodgeApplication.switchToScene(GAME_OVER_SCENE_FXML);
        GameOverSceneController controller = (GameOverSceneController)loader.getController();
        controller.gameOverMessage(reason);
    }

    public static void switchToGameOverScene(GameOverReason reason, double time, double sceneWidth, double sceneHeight, double screenWidth, double screenHeight) {
        FXMLLoader loader = CursorDodgeApplication.switchToScene(GAME_OVER_SCENE_FXML);
        GameOverSceneController controller = (GameOverSceneController)loader.getController();
        controller.gameOverMessage(reason, time, sceneWidth, sceneHeight, screenWidth, screenHeight);
    }
}

