/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj;

import java.util.Scanner;
import tech.octopusdragon.proj.ConnectFour;
import tech.octopusdragon.proj.Difficulty;
import tech.octopusdragon.proj.Token;

public class ConnectFourDemo {
    private static final char P1_TOKEN = 'x';
    private static final char P2_TOKEN = 'o';
    private static final char EMPTY = ' ';
    private static final boolean SINGLE_PLAYER = true;
    private static final Difficulty DIFFICULTY = Difficulty.HARD;
    private static ConnectFour game;
    private static Scanner keyboard;

    public static void main(String[] args) {
        keyboard = new Scanner(System.in);
        boolean keepGoing = true;
        do {
            ConnectFourDemo.playGame();
            boolean validInput = false;
            while (!validInput) {
                System.out.print("Would you like to keep playing ('y'/'n')? ");
                String input = keyboard.nextLine();
                try {
                    if (input.charAt(0) == 'y' || input.charAt(0) == 'Y') {
                        keepGoing = true;
                        validInput = true;
                        continue;
                    }
                    if (input.charAt(0) == 'n' || input.charAt(0) == 'N') {
                        keepGoing = false;
                        validInput = true;
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
                catch (Exception e) {
                    System.out.print("Invalid input. ");
                }
            }
        } while (keepGoing);
        System.out.println("Thanks for playing!");
        keyboard.close();
    }

    private static void playGame() {
        game = new ConnectFour();
        game.setDifficulty(DIFFICULTY);
        ConnectFourDemo.displayGrid();
        while (!game.isOver()) {
            if (game.curPlayer() == Token.P2) {
                game.computerTurn();
            } else {
                int column = -1;
                boolean validInput = false;
                while (!validInput) {
                    System.out.printf("%s (%c)'s turn. Enter the column to drop (or 'q' to quit): ", game.curPlayer() == Token.P1 ? "Player 1" : "Player 2", Character.valueOf(ConnectFourDemo.getToken(game.curPlayer())));
                    String input = keyboard.nextLine();
                    try {
                        if (input.charAt(0) == 'q' || input.charAt(0) == 'Q') {
                            System.out.println("Goodbye!");
                            System.exit(0);
                        }
                        if (!game.validColumn(column = Integer.parseInt(input) - 1)) {
                            throw new IllegalArgumentException();
                        }
                        validInput = true;
                    }
                    catch (Exception e) {
                        System.out.print("Invalid input. ");
                    }
                }
                game.drop(column);
            }
            ConnectFourDemo.displayGrid();
        }
        Token winner = game.getWinner();
        if (winner == Token.P1) {
            System.out.println("Player 1 won!");
        } else if (winner == Token.P2) {
            System.out.println("Player 2 won!");
        } else {
            System.out.println("There was a tie.");
        }
    }

    private static void displayGrid() {
        Token[][] grid = game.getGrid();
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 7) {
                System.out.print("+---");
                ++j;
            }
            System.out.println("+");
            j = 0;
            while (j < 7) {
                System.out.print("| " + ConnectFourDemo.getToken(grid[i][j]) + " ");
                ++j;
            }
            System.out.println("|");
            ++i;
        }
        int j = 0;
        while (j < 7) {
            System.out.print("+---");
            ++j;
        }
        System.out.println("+");
        System.out.print("|   ");
        i = 0;
        while (i < 6) {
            System.out.print("    ");
            ++i;
        }
        System.out.println("|");
        System.out.print("\u22a5   ");
        i = 0;
        while (i < 6) {
            System.out.print("    ");
            ++i;
        }
        System.out.println("\u22a5");
    }

    public static char getToken(Token player) {
        if (player == Token.P1) {
            return 'x';
        }
        if (player == Token.P2) {
            return 'o';
        }
        return ' ';
    }
}

