/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj;

import java.util.Random;
import javafx.animation.TranslateTransition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.util.Duration;
import tech.octopusdragon.proj.ConnectFour;
import tech.octopusdragon.proj.Difficulty;
import tech.octopusdragon.proj.Token;

public class ConnectFourApplication
extends Application {
    private final double DEF_LEN = 8.0;
    private final double DIALOG_WIDTH = 500.0;
    private final double DIALOG_HEIGHT = 200.0;
    private final int WAIT_TIME = 500;
    private ConnectFour game;
    private boolean playing;
    private boolean singlePlayer;
    private Token playerToken;
    private int selectedDifficulty = 1;
    private int selectedPlayerColor = 0;
    private int selectedFirstPlayer = 2;
    private Stage primaryStage;
    private Scene scene;
    private StackPane root;
    private Pane canvas;
    private StackPane stackPane;
    private GridPane boardGridPane;
    private Pane[][] frontPanes;
    private ImageView[][] backImages;
    private GridPane rackVBox;
    private ImageView curPlayerImageView;
    private final Image P1_IMAGE = new Image(ConnectFourApplication.class.getClassLoader().getResourceAsStream("p1_token.png"));
    private final String P1_COLOR = "Red";
    private final Image P2_IMAGE = new Image(ConnectFourApplication.class.getClassLoader().getResourceAsStream("p2_token.png"));
    private final String P2_COLOR = "Yellow";
    private final Image BACKGROUND_IMAGE = new Image(ConnectFourApplication.class.getClassLoader().getResourceAsStream("background.jpg"));
    private Image holeImage = new Image(ConnectFourApplication.class.getClassLoader().getResourceAsStream("hole.png"));
    private MediaPlayer clinkSound = new MediaPlayer(new Media(ConnectFourApplication.class.getClassLoader().getResource("clink.wav").toExternalForm()));
    private MediaPlayer cheerSound = new MediaPlayer(new Media(ConnectFourApplication.class.getClassLoader().getResource("cheer.wav").toExternalForm()));
    private MediaPlayer lossSound = new MediaPlayer(new Media(ConnectFourApplication.class.getClassLoader().getResource("loss.wav").toExternalForm()));

    public void init() {
        this.game = new ConnectFour();
        this.clinkSound.setOnEndOfMedia(() -> this.clinkSound.stop());
        this.cheerSound.setOnEndOfMedia(() -> this.cheerSound.stop());
        this.lossSound.setOnEndOfMedia(() -> this.lossSound.stop());
        this.playing = false;
    }

    public void start(Stage primaryStage) throws Exception {
        int j;
        this.boardGridPane = new GridPane();
        Image topLeftCornerImage = new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("top_left_corner.png"));
        ImageView topLeftCorner = new ImageView(topLeftCornerImage);
        this.boardGridPane.add((Node)topLeftCorner, 0, 0);
        Image topRightCornerImage = new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("top_right_corner.png"));
        ImageView topRightCorner = new ImageView(topRightCornerImage);
        this.boardGridPane.add((Node)topRightCorner, 16, 0);
        Image bottomLeftCornerImage = new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("bottom_left_corner.png"));
        ImageView bottomLeftCorner = new ImageView(bottomLeftCornerImage);
        this.boardGridPane.add((Node)bottomLeftCorner, 0, 14);
        Image bottomRightCornerImage = new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("bottom_right_corner.png"));
        ImageView bottomRightCorner = new ImageView(bottomRightCornerImage);
        this.boardGridPane.add((Node)bottomRightCorner, 16, 14);
        int i = 1;
        while (i < 14) {
            int j2 = 1;
            while (j2 < 16) {
                if (i % 2 == 1 || j2 % 2 == 1) {
                    Pane pane = new Pane();
                    pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"00137F"), null, null)}));
                    this.boardGridPane.add((Node)pane, j2, i);
                }
                ++j2;
            }
            ++i;
        }
        ImageView[][] holes = new ImageView[6][7];
        int i2 = 0;
        while (i2 < 6) {
            int j3 = 0;
            while (j3 < 7) {
                holes[i2][j3] = new ImageView(this.holeImage);
                this.boardGridPane.add((Node)holes[i2][j3], j3 * 2 + 2, i2 * 2 + 2);
                ++j3;
            }
            ++i2;
        }
        RowConstraints[] rows = new RowConstraints[GridPane.getRowIndex((Node)bottomLeftCorner) + 1];
        ColumnConstraints[] columns = new ColumnConstraints[GridPane.getColumnIndex((Node)topRightCorner) + 1];
        int i3 = 0;
        while (i3 <= 14) {
            rows[i3] = i3 == 0 || i3 == 14 ? new RowConstraints(topLeftCornerImage.getWidth()) : (i3 % 2 == 0 ? new RowConstraints(this.holeImage.getWidth()) : new RowConstraints(8.0));
            this.boardGridPane.getRowConstraints().add((Object)rows[i3]);
            ++i3;
        }
        int j4 = 0;
        while (j4 <= 16) {
            columns[j4] = j4 == 0 || j4 == 16 ? new ColumnConstraints(topLeftCornerImage.getHeight()) : (j4 % 2 == 0 ? new ColumnConstraints(this.holeImage.getHeight()) : new ColumnConstraints(8.0));
            this.boardGridPane.getColumnConstraints().add((Object)columns[j4]);
            ++j4;
        }
        double fitWidth = 0.0;
        int i4 = 0;
        while (i4 < 7) {
            fitWidth += this.holeImage.getWidth();
            ++i4;
        }
        i4 = 1;
        while (i4 <= 15) {
            fitWidth += 8.0;
            i4 += 2;
        }
        double fitHeight = 0.0;
        int i5 = 0;
        while (i5 < 6) {
            fitHeight += this.holeImage.getHeight();
            ++i5;
        }
        i5 = 1;
        while (i5 <= 13) {
            fitHeight += 8.0;
            i5 += 2;
        }
        Image topEdgeImage = new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("top_edge.png"));
        ImageView topEdge = new ImageView(topEdgeImage);
        Pane topEdgePane = new Pane(new Node[]{topEdge});
        this.boardGridPane.add((Node)topEdgePane, 1, 0);
        GridPane.setColumnSpan((Node)topEdgePane, (Integer)15);
        topEdge.setFitWidth(fitWidth);
        Image leftEdgeImage = new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("left_edge.png"));
        ImageView leftEdge = new ImageView(leftEdgeImage);
        Pane leftEdgePane = new Pane(new Node[]{leftEdge});
        this.boardGridPane.add((Node)leftEdgePane, 0, 1);
        GridPane.setRowSpan((Node)leftEdgePane, (Integer)13);
        leftEdge.setFitHeight(fitHeight);
        Image bottomEdgeImage = new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("bottom_edge.png"));
        ImageView bottomEdge = new ImageView(bottomEdgeImage);
        Pane bottomEdgePane = new Pane(new Node[]{bottomEdge});
        this.boardGridPane.add((Node)bottomEdgePane, 1, 14);
        GridPane.setColumnSpan((Node)bottomEdgePane, (Integer)15);
        bottomEdge.setFitWidth(fitWidth);
        Image rightEdgeImage = new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("right_edge.png"));
        ImageView rightEdge = new ImageView(rightEdgeImage);
        Pane rightEdgePane = new Pane(new Node[]{rightEdge});
        this.boardGridPane.add((Node)rightEdgePane, 16, 1);
        GridPane.setRowSpan((Node)rightEdgePane, (Integer)13);
        rightEdge.setFitHeight(fitHeight);
        this.backImages = new ImageView[6][7];
        GridPane back = new GridPane();
        int i6 = 0;
        while (i6 <= 14) {
            back.getRowConstraints().add((Object)rows[i6]);
            ++i6;
        }
        int j5 = 0;
        while (j5 <= 16) {
            back.getColumnConstraints().add((Object)columns[j5]);
            ++j5;
        }
        i6 = 0;
        while (i6 <= 14) {
            j = 0;
            while (j <= 16) {
                ImageView curImageView = new ImageView();
                if (i6 > 0 && i6 < 14 && i6 % 2 == 0 && j > 0 && j < 16 && j % 2 == 0) {
                    this.backImages[i6 / 2 - 1][j / 2 - 1] = curImageView;
                }
                back.add((Node)curImageView, j, i6);
                ++j;
            }
            ++i6;
        }
        this.frontPanes = new Pane[rows.length][columns.length];
        GridPane front = new GridPane();
        int i7 = 0;
        while (i7 <= 14) {
            front.getRowConstraints().add((Object)rows[i7]);
            ++i7;
        }
        j = 0;
        while (j <= 16) {
            front.getColumnConstraints().add((Object)columns[j]);
            ++j;
        }
        i7 = 0;
        while (i7 <= 14) {
            int j6 = 0;
            while (j6 <= 16) {
                this.frontPanes[i7][j6] = new Pane();
                if (j6 > 0 && j6 < 16 && j6 % 2 == 0) {
                    this.frontPanes[i7][j6].setOnMouseClicked((EventHandler)new ClickHandler());
                    this.frontPanes[i7][j6].setOnMouseEntered((EventHandler)new MouseEnterHandler());
                    this.frontPanes[i7][j6].setOnMouseExited((EventHandler)new MouseExitHandler());
                }
                front.add((Node)this.frontPanes[i7][j6], j6, i7);
                ++j6;
            }
            ++i7;
        }
        this.stackPane = new StackPane(new Node[]{back, this.boardGridPane, front});
        Image leftStand = new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("left_stand.png"));
        ImageView standLeft = new ImageView(leftStand);
        Image rightStand = new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("right_stand.png"));
        ImageView standRight = new ImageView(rightStand);
        this.rackVBox = new GridPane();
        this.rackVBox.add((Node)this.stackPane, 0, 0);
        GridPane.setColumnSpan((Node)this.stackPane, (Integer)2);
        this.rackVBox.add((Node)standLeft, 0, 1);
        GridPane.setHalignment((Node)standLeft, (HPos)HPos.LEFT);
        this.rackVBox.add((Node)standRight, 1, 1);
        GridPane.setHalignment((Node)standRight, (HPos)HPos.RIGHT);
        ImageView background = new ImageView(this.BACKGROUND_IMAGE);
        this.canvas = new Pane(new Node[]{background, this.rackVBox});
        this.canvas.setMinSize(this.BACKGROUND_IMAGE.getWidth(), this.BACKGROUND_IMAGE.getHeight());
        this.canvas.setPrefSize(this.BACKGROUND_IMAGE.getWidth(), this.BACKGROUND_IMAGE.getHeight());
        this.canvas.setMaxSize(this.BACKGROUND_IMAGE.getWidth(), this.BACKGROUND_IMAGE.getHeight());
        primaryStage.setOnShown(event -> this.rackVBox.setLayoutX(this.BACKGROUND_IMAGE.getWidth() / 2.0 - this.rackVBox.getWidth() / 2.0));
        this.rackVBox.setLayoutY(80.0);
        VBox curPlayerBox = new VBox();
        curPlayerBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"white", (double)0.75), new CornerRadii(10.0), null)}));
        curPlayerBox.setMinSize(200.0, 150.0);
        curPlayerBox.setPrefSize(200.0, 150.0);
        curPlayerBox.setMaxSize(200.0, 150.0);
        curPlayerBox.setAlignment(Pos.CENTER);
        curPlayerBox.setSpacing(17.0);
        StackPane.setAlignment((Node)curPlayerBox, (Pos)Pos.BOTTOM_RIGHT);
        StackPane.setMargin((Node)curPlayerBox, (Insets)new Insets(20.0));
        Label curPlayerLabel = new Label("CURRENT PLAYER");
        curPlayerLabel.setFont(new Font("Century Gothic Bold", 19.0));
        curPlayerBox.getChildren().add((Object)curPlayerLabel);
        this.curPlayerImageView = new ImageView(this.game.curPlayer() == Token.P1 ? this.P1_IMAGE : this.P2_IMAGE);
        curPlayerBox.getChildren().add((Object)this.curPlayerImageView);
        this.root = new StackPane();
        this.root.getChildren().addAll((Object[])new Node[]{this.canvas, curPlayerBox});
        this.root.setAlignment(Pos.CENTER);
        this.root.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.DARKGREEN, null, null)}));
        this.scene = new Scene((Parent)this.root, this.BACKGROUND_IMAGE.getWidth(), this.BACKGROUND_IMAGE.getHeight());
        this.primaryStage = primaryStage;
        primaryStage.setScene(this.scene);
        primaryStage.setTitle("Connect 4");
        primaryStage.setResizable(false);
        this.newGameDialog();
    }

    public static void main(String[] args) {
        ConnectFourApplication.launch((String[])args);
    }

    public void dropToken(int column) {
        if (this.game.isOver() || !this.game.validColumn(column) || this.playing) {
            return;
        }
        Token curToken = this.game.curPlayer();
        int row = this.game.lowestAvailableSpace(column);
        this.game.drop(column);
        ImageView imageView = new ImageView(curToken == Token.P1 ? this.P1_IMAGE : this.P2_IMAGE);
        double x = this.rackVBox.getLayoutX() + this.backImages[row][column].getLayoutX();
        double startY = 0.0;
        double endY = this.rackVBox.getLayoutY() + this.backImages[row][column].getLayoutY() - this.holeImage.getWidth() / 2.0;
        TranslateTransition ttrans = new TranslateTransition(Duration.millis((double)(1.5 * endY)), (Node)imageView);
        ttrans.setFromX(x);
        ttrans.setFromY(startY);
        ttrans.setToX(x);
        ttrans.setToY(endY);
        ttrans.setOnFinished(e -> {
            if (!this.game.isOver()) {
                this.clinkSound.play();
            } else {
                this.cheerSound.play();
            }
            this.backImages[row][column].setImage(curToken == Token.P1 ? this.P1_IMAGE : this.P2_IMAGE);
            this.canvas.getChildren().remove((Object)imageView);
            this.playing = false;
            if (!this.game.isOver()) {
                this.curPlayerImageView.setImage(curToken == Token.P1 ? this.P2_IMAGE : this.P1_IMAGE);
                if (this.singlePlayer) {
                    new Thread((Runnable)new Task<Void>(){

                        public Void call() throws InterruptedException {
                            Thread.sleep(500L);
                            ConnectFourApplication.this.computerDropToken();
                            return null;
                        }
                    }).start();
                }
            } else {
                Platform.runLater(() -> this.newGameDialog());
            }
        });
        this.canvas.getChildren().add(1, (Object)imageView);
        ttrans.play();
        this.playing = true;
    }

    public void computerDropToken() {
        Token curToken = this.game.curPlayer();
        int column = this.game.computerTurn();
        int row = this.game.lowestAvailableSpace(column) + 1;
        Platform.runLater(() -> {
            ImageView imageView = new ImageView(curToken == Token.P1 ? this.P1_IMAGE : this.P2_IMAGE);
            double x = this.rackVBox.getLayoutX() + this.backImages[row][column].getLayoutX();
            double startY = 0.0;
            double endY = this.rackVBox.getLayoutY() + this.backImages[row][column].getLayoutY() - this.holeImage.getWidth() / 2.0;
            TranslateTransition ttrans = new TranslateTransition(Duration.millis((double)(1.5 * endY)), (Node)imageView);
            ttrans.setFromX(x);
            ttrans.setFromY(startY);
            ttrans.setToX(x);
            ttrans.setToY(endY);
            ttrans.setOnFinished(e -> {
                if (!this.game.isOver()) {
                    this.clinkSound.play();
                } else if (this.game.getWinner() != this.playerToken) {
                    this.lossSound.play();
                } else {
                    this.cheerSound.play();
                }
                this.backImages[row][column].setImage(curToken == Token.P1 ? this.P1_IMAGE : this.P2_IMAGE);
                this.canvas.getChildren().remove((Object)imageView);
                this.playing = false;
                if (!this.game.isOver()) {
                    this.curPlayerImageView.setImage(curToken == Token.P1 ? this.P2_IMAGE : this.P1_IMAGE);
                } else {
                    Platform.runLater(() -> this.newGameDialog());
                }
            });
            this.canvas.getChildren().add(1, (Object)imageView);
            ttrans.play();
            this.playing = true;
        });
    }

    public void newGameDialog() {
        String prompt;
        ImageView graphic;
        String message;
        String title;
        if (!this.primaryStage.isShowing()) {
            this.singlePlayer = false;
            this.primaryStage.show();
            this.newGame();
            return;
        }
        if (this.singlePlayer && this.game.getWinner() == this.playerToken) {
            title = "Game Over";
            message = "You won!";
            graphic = new ImageView(new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("winner.png")));
            prompt = "Would you like to play again?";
        } else if (this.singlePlayer && this.game.getWinner() == (this.playerToken == Token.P1 ? Token.P2 : Token.P1)) {
            title = "Game Over";
            message = "You lost... Better luck next time.";
            graphic = new ImageView(new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("loser.png")));
            prompt = "Would you like to play again?";
        } else if (this.game.getWinner() == Token.P1) {
            title = "Game Over";
            message = "Red won!";
            graphic = new ImageView(new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("winner.png")));
            prompt = "Would you like to play again?";
        } else if (this.game.getWinner() == Token.P2) {
            title = "Game Over";
            message = "Yellow won!";
            graphic = new ImageView(new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("winner.png")));
            prompt = "Would you like to play again?";
        } else {
            title = "Game Over";
            message = "It was a draw!";
            graphic = new ImageView(new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("tie.png")));
            prompt = "Would you like to play again?";
        }
        ButtonType twoPlayerButtonType = new ButtonType("Play", ButtonBar.ButtonData.OK_DONE);
        ButtonType cancelButtonType = new ButtonType("Exit", ButtonBar.ButtonData.CANCEL_CLOSE);
        Alert dialog = new Alert(Alert.AlertType.CONFIRMATION, prompt, new ButtonType[]{twoPlayerButtonType, cancelButtonType});
        dialog.setTitle(title);
        dialog.setHeaderText(message);
        dialog.setGraphic((Node)graphic);
        dialog.getDialogPane().setPrefSize(500.0, 200.0);
        dialog.showAndWait().ifPresent(response -> {
            if (response == twoPlayerButtonType) {
                if (!this.primaryStage.isShowing()) {
                    this.primaryStage.show();
                }
                this.singlePlayer = false;
                this.newGame();
            } else {
                Platform.exit();
            }
        });
    }

    public void singlePlayerGameDialog() {
        ButtonType playButtonType = new ButtonType("Play", ButtonBar.ButtonData.OK_DONE);
        ButtonType backButtonType = new ButtonType("Back", ButtonBar.ButtonData.CANCEL_CLOSE);
        Label difficultyLabel = new Label("Computer Difficulty");
        ToggleGroup difficultyToggleGroup = new ToggleGroup();
        RadioButton easyRadioButton = new RadioButton("Easy");
        easyRadioButton.setToggleGroup(difficultyToggleGroup);
        RadioButton mediumRadioButton = new RadioButton("Medium");
        mediumRadioButton.setToggleGroup(difficultyToggleGroup);
        RadioButton hardRadioButton = new RadioButton("Hard");
        hardRadioButton.setToggleGroup(difficultyToggleGroup);
        difficultyToggleGroup.selectToggle((Toggle)difficultyToggleGroup.getToggles().get(this.selectedDifficulty));
        Label playerColorLabel = new Label("Your Color");
        ToggleGroup playerColorToggleGroup = new ToggleGroup();
        RadioButton redRadioButton = new RadioButton("Red");
        redRadioButton.setToggleGroup(playerColorToggleGroup);
        RadioButton yellowRadioButton = new RadioButton("Yellow");
        yellowRadioButton.setToggleGroup(playerColorToggleGroup);
        RadioButton randomColorRadioButton = new RadioButton("Random");
        randomColorRadioButton.setToggleGroup(playerColorToggleGroup);
        playerColorToggleGroup.selectToggle((Toggle)playerColorToggleGroup.getToggles().get(this.selectedPlayerColor));
        Label firstPlayerLabel = new Label("First Move");
        ToggleGroup firstPlayerToggleGroup = new ToggleGroup();
        RadioButton youRadioButton = new RadioButton("You");
        youRadioButton.setToggleGroup(firstPlayerToggleGroup);
        RadioButton computerRadioButton = new RadioButton("Computer");
        computerRadioButton.setToggleGroup(firstPlayerToggleGroup);
        RadioButton randomFirstPlayerRadioButton = new RadioButton("Random");
        randomFirstPlayerRadioButton.setToggleGroup(firstPlayerToggleGroup);
        firstPlayerToggleGroup.selectToggle((Toggle)firstPlayerToggleGroup.getToggles().get(this.selectedFirstPlayer));
        GridPane radioBox = new GridPane();
        radioBox.add((Node)difficultyLabel, 0, 0);
        radioBox.add((Node)easyRadioButton, 0, 1);
        radioBox.add((Node)mediumRadioButton, 1, 1);
        radioBox.add((Node)hardRadioButton, 2, 1);
        radioBox.add((Node)playerColorLabel, 0, 3);
        radioBox.add((Node)redRadioButton, 0, 4);
        radioBox.add((Node)yellowRadioButton, 1, 4);
        radioBox.add((Node)randomColorRadioButton, 2, 4);
        radioBox.add((Node)firstPlayerLabel, 0, 6);
        radioBox.add((Node)youRadioButton, 0, 7);
        radioBox.add((Node)computerRadioButton, 1, 7);
        radioBox.add((Node)randomFirstPlayerRadioButton, 2, 7);
        radioBox.setHgap(10.0);
        radioBox.setVgap(10.0);
        Alert dialog = new Alert(Alert.AlertType.CONFIRMATION, null, new ButtonType[]{playButtonType, backButtonType});
        dialog.setTitle("Single-Player Game");
        dialog.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("computer.png"))));
        dialog.setHeaderText("Set the settings to your liking and press Play when ready.");
        dialog.getDialogPane().setContent((Node)radioBox);
        dialog.getDialogPane().setPrefSize(500.0, 200.0);
        dialog.showAndWait().ifPresent(response -> {
            if (response == playButtonType) {
                this.singlePlayer = true;
                if (redRadioButton.isSelected()) {
                    this.playerToken = Token.P1;
                    this.selectedPlayerColor = 0;
                } else if (yellowRadioButton.isSelected()) {
                    this.playerToken = Token.P2;
                    this.selectedPlayerColor = 1;
                } else {
                    Random rand = new Random();
                    this.playerToken = rand.nextBoolean() ? Token.P1 : Token.P2;
                    this.selectedPlayerColor = 2;
                }
                if (youRadioButton.isSelected()) {
                    this.newGame(this.playerToken);
                    this.selectedFirstPlayer = 0;
                } else if (computerRadioButton.isSelected()) {
                    this.newGame(this.playerToken == Token.P1 ? Token.P2 : Token.P1);
                    this.selectedFirstPlayer = 1;
                } else {
                    this.newGame();
                    this.selectedFirstPlayer = 2;
                }
                if (easyRadioButton.isSelected()) {
                    this.game.setDifficulty(Difficulty.EASY);
                    this.selectedDifficulty = 0;
                } else if (mediumRadioButton.isSelected()) {
                    this.game.setDifficulty(Difficulty.MEDIUM);
                    this.selectedDifficulty = 1;
                } else {
                    this.game.setDifficulty(Difficulty.HARD);
                    this.selectedDifficulty = 2;
                }
                if (!this.primaryStage.isShowing()) {
                    this.primaryStage.show();
                }
                if (this.game.curPlayer() != this.playerToken) {
                    this.computerDropToken();
                }
            } else {
                this.newGameDialog();
            }
        });
    }

    public void newGame() {
        this.game = new ConnectFour();
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 7) {
                this.backImages[i][j].setImage(null);
                ++j;
            }
            ++i;
        }
        this.curPlayerImageView.setImage(this.game.curPlayer() == Token.P1 ? this.P1_IMAGE : this.P2_IMAGE);
    }

    public void newGame(Token firstPlayer) {
        this.game = new ConnectFour(firstPlayer);
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 7) {
                this.backImages[i][j].setImage(null);
                ++j;
            }
            ++i;
        }
        this.curPlayerImageView.setImage(this.game.curPlayer() == Token.P1 ? this.P1_IMAGE : this.P2_IMAGE);
    }

    public class ClickHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            if (ConnectFourApplication.this.singlePlayer && ConnectFourApplication.this.game.curPlayer() != ConnectFourApplication.this.playerToken) {
                return;
            }
            int column = GridPane.getColumnIndex((Node)((Node)event.getSource()));
            column = column / 2 - 1;
            ConnectFourApplication.this.dropToken(column);
        }
    }

    public class MouseEnterHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            int column = GridPane.getColumnIndex((Node)((Node)event.getSource()));
            int i = 0;
            while (i < ConnectFourApplication.this.frontPanes.length) {
                ConnectFourApplication.this.frontPanes[i][column - 1].setStyle("-fx-background-color: rgba(255, 255, 0, 0.25);");
                ConnectFourApplication.this.frontPanes[i][column].setStyle("-fx-background-color: rgba(255, 255, 0, 0.25);");
                ConnectFourApplication.this.frontPanes[i][column + 1].setStyle("-fx-background-color: rgba(255, 255, 0, 0.25);");
                ++i;
            }
            ConnectFourApplication.this.scene.setCursor(Cursor.HAND);
        }
    }

    public class MouseExitHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            int column = GridPane.getColumnIndex((Node)((Node)event.getSource()));
            int i = 0;
            while (i < ConnectFourApplication.this.frontPanes.length) {
                ConnectFourApplication.this.frontPanes[i][column - 1].setStyle("");
                ConnectFourApplication.this.frontPanes[i][column].setStyle("");
                ConnectFourApplication.this.frontPanes[i][column + 1].setStyle("");
                ++i;
            }
            ConnectFourApplication.this.scene.setCursor(Cursor.DEFAULT);
        }
    }
}

