/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj;

import java.util.ArrayList;
import java.util.Random;
import tech.octopusdragon.proj.Difficulty;
import tech.octopusdragon.proj.Token;

public class ConnectFour {
    public static final int ROWS = 6;
    public static final int COLUMNS = 7;
    public static final int LINE_LENGTH = 4;
    public static final int MAX_DEPTH = 5;
    private Token[][] grid = new Token[6][7];
    private Token curPlayer;
    private Difficulty difficulty;

    public ConnectFour() {
        this(new Random().nextInt(2) == 0 ? Token.P1 : Token.P2);
    }

    public ConnectFour(Token startingPlayer) {
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 7) {
                this.grid[i][j] = Token.EMPTY;
                ++j;
            }
            ++i;
        }
        this.curPlayer = startingPlayer;
    }

    public ConnectFour(ConnectFour object) {
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 7) {
                this.grid[i][j] = object.grid[i][j];
                ++j;
            }
            ++i;
        }
        this.curPlayer = object.curPlayer;
        this.difficulty = object.difficulty;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public void drop(int column) {
        if (!this.isOver() && this.validColumn(column)) {
            this.grid[this.lowestAvailableSpace((int)column)][column] = this.curPlayer;
        }
        if (!this.isOver()) {
            this.nextPlayer();
        }
    }

    public int computerTurn() {
        Random rand;
        int columnToDrop = this.difficulty == Difficulty.EASY ? this.randomComputerMove() : (this.difficulty == Difficulty.MEDIUM ? ((rand = new Random()).nextBoolean() ? this.randomComputerMove() : this.aiComputerMove()) : this.aiComputerMove());
        this.drop(columnToDrop);
        return columnToDrop;
    }

    private int randomComputerMove() {
        Random rand = new Random();
        ArrayList<Integer> validColumns = new ArrayList<Integer>();
        int i = 0;
        while (i < 7) {
            if (this.validColumn(i)) {
                validColumns.add(i);
            }
            ++i;
        }
        return (Integer)validColumns.get(rand.nextInt(validColumns.size()));
    }

    private int aiComputerMove() {
        ArrayList<Integer> bestMoveCols = new ArrayList<Integer>();
        bestMoveCols.add(0);
        int a = Integer.MIN_VALUE;
        int b = Integer.MAX_VALUE;
        int maxEval = Integer.MIN_VALUE;
        int i = 0;
        while (i < 7) {
            if (this.validColumn(i)) {
                ConnectFour newTempGame = new ConnectFour(this);
                newTempGame.drop(i);
                int eval = this.minimax(newTempGame, 0, a, b, false);
                System.out.printf("%12d", eval);
                if (eval > maxEval) {
                    maxEval = eval;
                    bestMoveCols.clear();
                    bestMoveCols.add(i);
                } else if (eval == maxEval) {
                    bestMoveCols.add(i);
                }
                a = Math.max(a, maxEval);
                if (maxEval >= b) break;
            }
            ++i;
        }
        System.out.println();
        Random rand = new Random();
        return (Integer)bestMoveCols.get(rand.nextInt(bestMoveCols.size()));
    }

    private int minimax(ConnectFour tempGame, int depth, int a, int b, boolean maximizingPlayer) {
        Token result;
        Token token = result = tempGame.isOver() ? tempGame.getWinner() : null;
        if (result != null) {
            int eval = result.equals((Object)this.curPlayer) ? Integer.MAX_VALUE - depth : (result.equals((Object)(this.curPlayer == Token.P1 ? Token.P2 : Token.P1)) ? Integer.MIN_VALUE + depth : 0);
            return eval;
        }
        if (depth >= 5) {
            int score = tempGame.scoreBoard(4, 0);
            return score;
        }
        if (maximizingPlayer) {
            int maxEval = Integer.MIN_VALUE;
            int i = 0;
            while (i < 7) {
                if (tempGame.validColumn(i)) {
                    ConnectFour newTempGame = new ConnectFour(tempGame);
                    newTempGame.drop(i);
                    int eval = this.minimax(newTempGame, depth + 1, a, b, false);
                    maxEval = Math.max(maxEval, eval);
                    a = Math.max(a, maxEval);
                    if (maxEval >= b) break;
                }
                ++i;
            }
            return maxEval;
        }
        int maxEval = Integer.MAX_VALUE;
        int i = 0;
        while (i < 7) {
            if (tempGame.validColumn(i)) {
                ConnectFour newTempGame = new ConnectFour(tempGame);
                newTempGame.drop(i);
                int eval = this.minimax(newTempGame, depth + 1, a, b, true);
                maxEval = Math.min(maxEval, eval);
                b = Math.min(b, maxEval);
                if (maxEval <= a) break;
            }
            ++i;
        }
        return maxEval;
    }

    private int scoreBoard(int inARow, int points) {
        int column;
        int row;
        int inARowCount;
        Token lastPlayer;
        int pointValue = 1000;
        int i = inARow;
        while (i < 4) {
            pointValue /= 10;
            ++i;
        }
        int row2 = 0;
        while (row2 < 6) {
            lastPlayer = Token.EMPTY;
            inARowCount = 0;
            int column2 = 0;
            while (column2 < 7) {
                if (this.grid[row2][column2] != lastPlayer) {
                    inARowCount = 0;
                    lastPlayer = this.grid[row2][column2];
                }
                if (this.grid[row2][column2] != Token.EMPTY) {
                    ++inARowCount;
                }
                if (inARowCount == inARow) {
                    points += pointValue;
                }
                ++column2;
            }
            ++row2;
        }
        int column3 = 0;
        while (column3 < 7) {
            lastPlayer = Token.EMPTY;
            inARowCount = 0;
            row = 0;
            while (row < 6) {
                if (this.grid[row][column3] != lastPlayer) {
                    inARowCount = 0;
                    lastPlayer = this.grid[row][column3];
                }
                if (this.grid[row][column3] != Token.EMPTY) {
                    ++inARowCount;
                }
                if (inARowCount == inARow) {
                    points += pointValue;
                }
                ++row;
            }
            ++column3;
        }
        i = 2;
        while (i > 0) {
            row = i;
            column = 0;
            lastPlayer = Token.EMPTY;
            inARowCount = 0;
            while (row < 6 && column < 7) {
                if (this.grid[row][column] != lastPlayer) {
                    inARowCount = 0;
                    lastPlayer = this.grid[row][column];
                }
                if (this.grid[row][column] != Token.EMPTY) {
                    ++inARowCount;
                }
                if (inARowCount == inARow) {
                    points += pointValue;
                }
                ++row;
                ++column;
            }
            --i;
        }
        i = 0;
        while (i <= 3) {
            row = 0;
            column = i;
            lastPlayer = Token.EMPTY;
            inARowCount = 0;
            while (row < 6 && column < 7) {
                if (this.grid[row][column] != lastPlayer) {
                    inARowCount = 0;
                    lastPlayer = this.grid[row][column];
                }
                if (this.grid[row][column] != Token.EMPTY) {
                    ++inARowCount;
                }
                if (inARowCount == inARow) {
                    points += pointValue;
                }
                ++row;
                ++column;
            }
            ++i;
        }
        i = 2;
        while (i > 0) {
            row = i;
            column = 6;
            lastPlayer = Token.EMPTY;
            inARowCount = 0;
            while (row < 6 && column >= 0) {
                if (this.grid[row][column] != lastPlayer) {
                    inARowCount = 0;
                    lastPlayer = this.grid[row][column];
                }
                if (this.grid[row][column] != Token.EMPTY) {
                    ++inARowCount;
                }
                if (inARowCount == inARow) {
                    points += pointValue;
                }
                ++row;
                --column;
            }
            --i;
        }
        i = 6;
        while (i >= 4) {
            row = 0;
            column = i;
            lastPlayer = Token.EMPTY;
            inARowCount = 0;
            while (row < 6 && column >= 0) {
                if (this.grid[row][column] != lastPlayer) {
                    inARowCount = 0;
                    lastPlayer = this.grid[row][column];
                }
                if (this.grid[row][column] != Token.EMPTY) {
                    ++inARowCount;
                }
                if (inARowCount == inARow) {
                    points += pointValue;
                }
                ++row;
                --column;
            }
            --i;
        }
        if (inARow == 1) {
            return points;
        }
        return this.scoreBoard(inARow - 1, points);
    }

    public boolean validColumn(int column) {
        boolean validColumn = true;
        if (column < 0) {
            validColumn = false;
        } else if (column >= 7) {
            validColumn = false;
        } else if (this.lowestAvailableSpace(column) < 0) {
            validColumn = false;
        }
        return validColumn;
    }

    public Token[][] getGrid() {
        return this.grid;
    }

    public Token curPlayer() {
        return this.curPlayer;
    }

    public Token getWinner() {
        int column;
        int row;
        int inARowCount;
        Token lastPlayer;
        int row2 = 0;
        while (row2 < 6) {
            lastPlayer = Token.EMPTY;
            inARowCount = 0;
            int column2 = 0;
            while (column2 < 7) {
                if (this.grid[row2][column2] != lastPlayer) {
                    inARowCount = 0;
                    lastPlayer = this.grid[row2][column2];
                }
                if (this.grid[row2][column2] != Token.EMPTY) {
                    ++inARowCount;
                }
                if (inARowCount == 4) {
                    return lastPlayer;
                }
                ++column2;
            }
            ++row2;
        }
        int column3 = 0;
        while (column3 < 7) {
            lastPlayer = Token.EMPTY;
            inARowCount = 0;
            row = 0;
            while (row < 6) {
                if (this.grid[row][column3] != lastPlayer) {
                    inARowCount = 0;
                    lastPlayer = this.grid[row][column3];
                }
                if (this.grid[row][column3] != Token.EMPTY) {
                    ++inARowCount;
                }
                if (inARowCount == 4) {
                    return lastPlayer;
                }
                ++row;
            }
            ++column3;
        }
        int i = 2;
        while (i > 0) {
            row = i;
            column = 0;
            lastPlayer = Token.EMPTY;
            inARowCount = 0;
            while (row < 6 && column < 7) {
                if (this.grid[row][column] != lastPlayer) {
                    inARowCount = 0;
                    lastPlayer = this.grid[row][column];
                }
                if (this.grid[row][column] != Token.EMPTY) {
                    ++inARowCount;
                }
                if (inARowCount == 4) {
                    return lastPlayer;
                }
                ++row;
                ++column;
            }
            --i;
        }
        i = 0;
        while (i <= 3) {
            row = 0;
            column = i;
            lastPlayer = Token.EMPTY;
            inARowCount = 0;
            while (row < 6 && column < 7) {
                if (this.grid[row][column] != lastPlayer) {
                    inARowCount = 0;
                    lastPlayer = this.grid[row][column];
                }
                if (this.grid[row][column] != Token.EMPTY) {
                    ++inARowCount;
                }
                if (inARowCount == 4) {
                    return lastPlayer;
                }
                ++row;
                ++column;
            }
            ++i;
        }
        i = 2;
        while (i > 0) {
            row = i;
            column = 6;
            lastPlayer = Token.EMPTY;
            inARowCount = 0;
            while (row < 6 && column >= 0) {
                if (this.grid[row][column] != lastPlayer) {
                    inARowCount = 0;
                    lastPlayer = this.grid[row][column];
                }
                if (this.grid[row][column] != Token.EMPTY) {
                    ++inARowCount;
                }
                if (inARowCount == 4) {
                    return lastPlayer;
                }
                ++row;
                --column;
            }
            --i;
        }
        i = 6;
        while (i >= 4) {
            row = 0;
            column = i;
            lastPlayer = Token.EMPTY;
            inARowCount = 0;
            while (row < 6 && column >= 0) {
                if (this.grid[row][column] != lastPlayer) {
                    inARowCount = 0;
                    lastPlayer = this.grid[row][column];
                }
                if (this.grid[row][column] != Token.EMPTY) {
                    ++inARowCount;
                }
                if (inARowCount == 4) {
                    return lastPlayer;
                }
                ++row;
                --column;
            }
            --i;
        }
        return Token.EMPTY;
    }

    public boolean isOver() {
        boolean isOver = false;
        if (this.getWinner() != Token.EMPTY) {
            isOver = true;
        } else {
            isOver = true;
            int i = 0;
            block0: while (i < 6) {
                int j = 0;
                while (j < 7) {
                    if (this.grid[i][j] == Token.EMPTY) {
                        isOver = false;
                        break block0;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return isOver;
    }

    public int lowestAvailableSpace(int column) {
        int space = 5;
        while (space >= 0 && this.grid[space][column] != Token.EMPTY) {
            --space;
        }
        return space;
    }

    private void nextPlayer() {
        this.curPlayer = this.curPlayer == Token.P1 ? Token.P2 : Token.P1;
    }
}

