/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.checkers.window;

import java.io.IOException;
import java.util.Arrays;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import tech.octopusdragon.checkers.model.RelativeDirection;
import tech.octopusdragon.checkers.model.Variant;

public class VariantInfoWindow
extends Stage {
    @FXML
    private Label nameLabel;
    @FXML
    private Label descriptionLabel;
    @FXML
    private Label rowsLabel;
    @FXML
    private Label colsLabel;
    @FXML
    private Label piecesLabel;
    @FXML
    private Label boardPatternLabel;
    @FXML
    private Label startingPositionsLabel;
    @FXML
    private Label startingPlayerLabel;
    @FXML
    private Label movementLabel;
    @FXML
    private Label backwardsCaptureLabel;
    @FXML
    private Label flyingKingsLabel;
    @FXML
    private Label kingsRowCapturePromotionLabel;
    @FXML
    private Label removePiecesImmediatelyLabel;
    @FXML
    private Label manCanCaptureKingLabel;
    @FXML
    private Label quantityRuleLabel;
    @FXML
    private Label qualityRuleLabel;
    @FXML
    private Label priorityRuleLabel;

    public VariantInfoWindow(Variant variant) {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/view/VariantInfo.fxml"));
        loader.setController((Object)this);
        try {
            Scene scene = new Scene((Parent)loader.load());
            Platform.runLater(() -> ((Stage)scene.getWindow()).getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/icon.png"))));
            this.setScene(scene);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.updateValues(variant);
        this.setTitle(String.valueOf(variant.getName()) + " Info");
        this.initModality(Modality.APPLICATION_MODAL);
    }

    private void updateValues(Variant variant) {
        this.nameLabel.setText(variant.getName());
        this.descriptionLabel.setText(variant.getDescription());
        this.rowsLabel.setText(Integer.toString(variant.getRows()));
        this.colsLabel.setText(Integer.toString(variant.getCols()));
        this.piecesLabel.setText(Integer.toString(variant.getNumPieces()));
        this.boardPatternLabel.setText(variant.getBoardPattern().toString());
        this.startingPositionsLabel.setText(variant.getStartingPositions().toString());
        this.startingPlayerLabel.setText(variant.getStartingPlayer().toString());
        StringBuilder sb = new StringBuilder();
        switch (variant.getFamily()) {
            case TURKISH: {
                sb.append("Orthogonal");
                break;
            }
            case INTERNATIONAL: 
            case SPANISH: 
            case MISCELLANEOUS: {
                sb.append("Diagonal");
                break;
            }
            case GOTHIC: {
                sb.append("Orthogonal + Diagonal");
                break;
            }
            case FRISIAN: {
                sb.append("Diagonal + Orthogonal");
                break;
            }
            case SPECIAL: {
                sb.append("Special");
            }
        }
        this.movementLabel.setText(sb.toString());
        this.backwardsCaptureLabel.setText(Arrays.asList(variant.getManCaptureDirections()).contains((Object)RelativeDirection.ORTHOGONAL_BACKWARD) || Arrays.asList(variant.getManCaptureDirections()).contains((Object)RelativeDirection.DIAGONAL_BACKWARD) ? "\u25ef" : "\u2715");
        sb = new StringBuilder();
        switch (variant.getKingType()) {
            case SHORT: {
                sb.append("\u2715");
                break;
            }
            case FLYING: {
                sb.append("\u25ef");
                break;
            }
            case SHORT_FLYING: {
                sb.append("\u25ef (King Halt)");
            }
        }
        this.flyingKingsLabel.setText(sb.toString());
        this.kingsRowCapturePromotionLabel.setText(variant.getKingsRowCapture().toString());
        this.removePiecesImmediatelyLabel.setText(variant.isRemovePiecesImmediately() ? "\u25ef" : "\u2715");
        this.manCanCaptureKingLabel.setText(variant.isManCanCaptureKing() ? "\u25ef" : "\u2715");
        this.quantityRuleLabel.setText(variant.hasQuantityRule() ? "\u25ef" : "\u2715");
        this.qualityRuleLabel.setText(variant.hasQualityRule() ? "\u25ef" : "\u2715");
        this.priorityRuleLabel.setText(variant.hasPriorityRule() ? "\u25ef" : "\u2715");
    }

    @FXML
    private void close(ActionEvent event) {
        this.close();
    }
}

