/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.checkers.window;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import tech.octopusdragon.checkers.model.Board;
import tech.octopusdragon.checkers.model.Checkers;
import tech.octopusdragon.checkers.model.Config;
import tech.octopusdragon.checkers.model.Family;
import tech.octopusdragon.checkers.model.PlayerType;
import tech.octopusdragon.checkers.model.Variant;
import tech.octopusdragon.checkers.model.rules.StartingPlayer;
import tech.octopusdragon.checkers.window.CustomGameDialog;
import tech.octopusdragon.checkers.window.StartingPlayerDialog;
import tech.octopusdragon.checkers.window.VariantInfoWindow;

public class NewGameDialog
extends Dialog<Checkers> {
    @FXML
    private ButtonType closeButtonType;
    @FXML
    private ButtonType playButtonType;
    @FXML
    private ButtonType infoButtonType;
    @FXML
    private ButtonType customGameButtonType;
    @FXML
    private TreeView<Object> variantList;
    @FXML
    private CheckBox highlightMovesCheckBox;
    @FXML
    private RadioButton topPlayerBlackRadioButton;
    @FXML
    private RadioButton bottomPlayerBlackRadioButton;
    @FXML
    private RadioButton topPlayerWhiteRadioButton;
    @FXML
    private RadioButton bottomPlayerWhiteRadioButton;
    @FXML
    private CheckBox blackComputerPlayerCheckBox;
    @FXML
    private CheckBox whiteComputerPlayerCheckBox;
    @FXML
    private Slider blackDifficultySlider;
    @FXML
    private Slider whiteDifficultySlider;
    private Checkers game;

    public NewGameDialog() {
        this.buildUI();
        this.setResultConverter(dialogButton -> {
            ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE || data == ButtonBar.ButtonData.OTHER ? this.game : null;
        });
    }

    private void buildUI() {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/view/NewGame.fxml"));
        loader.setController((Object)this);
        DialogPane dialogPane = null;
        try {
            dialogPane = (DialogPane)loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setDialogPane(dialogPane);
        ((Stage)dialogPane.getScene().getWindow()).getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/icon.png")));
        LinkedHashMap families = new LinkedHashMap();
        Variant[] variantArray = Variant.values();
        int n = variantArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variant variant = variantArray[n2];
            if (variant != Variant.CUSTOM) {
                if (!families.containsKey((Object)variant.getFamily())) {
                    families.put(variant.getFamily(), new ArrayList());
                }
                ((List)families.get((Object)variant.getFamily())).add(variant);
            }
            ++n2;
        }
        TreeItem rootItem = new TreeItem((Object)"Variants");
        rootItem.setExpanded(true);
        for (Family family : families.keySet()) {
            TreeItem familyItem = new TreeItem((Object)((Object)((Object)family) + " Variants"));
            familyItem.setExpanded(true);
            for (Variant variant : (List)families.get((Object)family)) {
                TreeItem variantItem = new TreeItem((Object)variant);
                familyItem.getChildren().add((Object)variantItem);
            }
            rootItem.getChildren().add((Object)familyItem);
        }
        this.variantList.setRoot(rootItem);
        this.topPlayerBlackRadioButton.selectedProperty().bindBidirectional((Property)this.bottomPlayerWhiteRadioButton.selectedProperty());
        this.bottomPlayerBlackRadioButton.selectedProperty().bindBidirectional((Property)this.topPlayerWhiteRadioButton.selectedProperty());
        this.blackDifficultySlider.setValue(Config.getBlackDifficulty());
        this.whiteDifficultySlider.setValue(Config.getWhiteDifficulty());
        this.blackDifficultySlider.disableProperty().bind((ObservableValue)this.blackComputerPlayerCheckBox.selectedProperty().not());
        this.whiteDifficultySlider.disableProperty().bind((ObservableValue)this.whiteComputerPlayerCheckBox.selectedProperty().not());
        this.blackDifficultySlider.valueProperty().addListener((obs, oldVal, newVal) -> Config.setBlackDifficulty(newVal.doubleValue()));
        this.whiteDifficultySlider.valueProperty().addListener((obs, oldVal, newVal) -> Config.setWhiteDifficulty(newVal.doubleValue()));
        this.highlightMovesCheckBox.setSelected(Config.isHighlightMoves());
        RadioButton topPlayerRadioButton = null;
        RadioButton bottomPlayerRadioButton = null;
        switch (Config.getTopPlayer()) {
            case BLACK: {
                topPlayerRadioButton = this.topPlayerBlackRadioButton;
                bottomPlayerRadioButton = this.bottomPlayerWhiteRadioButton;
                break;
            }
            case WHITE: {
                topPlayerRadioButton = this.topPlayerWhiteRadioButton;
                bottomPlayerRadioButton = this.bottomPlayerBlackRadioButton;
            }
        }
        topPlayerRadioButton.setSelected(true);
        bottomPlayerRadioButton.setSelected(true);
        this.blackComputerPlayerCheckBox.setSelected(Config.isBlackComputerPlayer());
        this.whiteComputerPlayerCheckBox.setSelected(Config.isWhiteComputerPlayer());
        BooleanBinding disableButtonBinding = Bindings.createBooleanBinding(() -> {
            if (this.variantList.getSelectionModel().getSelectedItem() == null || !((TreeItem)this.variantList.getSelectionModel().getSelectedItem()).isLeaf()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.variantList.getSelectionModel().selectedItemProperty()});
        dialogPane.lookupButton(this.playButtonType).disableProperty().bind((ObservableValue)disableButtonBinding);
        dialogPane.lookupButton(this.infoButtonType).disableProperty().bind((ObservableValue)disableButtonBinding);
        dialogPane.lookupButton(this.playButtonType).addEventFilter(ActionEvent.ACTION, event -> {
            Variant variant = (Variant)((Object)((Object)((TreeItem)this.variantList.getSelectionModel().getSelectedItem()).getValue()));
            this.game = new Checkers(variant);
            if (variant.getStartingPlayer() == StartingPlayer.EITHER) {
                Optional startingPlayerResult = new StartingPlayerDialog().showAndWait();
                if (startingPlayerResult.isPresent()) {
                    PlayerType startingPlayer = (PlayerType)((Object)((Object)startingPlayerResult.get()));
                    this.game.setStartingPlayer(startingPlayer);
                } else {
                    event.consume();
                }
            }
        });
        dialogPane.lookupButton(this.infoButtonType).addEventFilter(ActionEvent.ACTION, event -> {
            new VariantInfoWindow((Variant)((Object)((Object)((TreeItem)this.variantList.getSelectionModel().getSelectedItem()).getValue()))).show();
            event.consume();
        });
        dialogPane.lookupButton(this.customGameButtonType).addEventFilter(ActionEvent.ACTION, event -> {
            Optional result = new CustomGameDialog().showAndWait();
            if (!result.isPresent()) {
                event.consume();
                return;
            }
            this.game = new Checkers((Variant)((Object)((Object)result.get())));
            if (((Variant)((Object)((Object)result.get()))).getStartingPlayer() == StartingPlayer.EITHER) {
                Optional startingPlayerResult = new StartingPlayerDialog().showAndWait();
                if (startingPlayerResult.isPresent()) {
                    PlayerType startingPlayer = (PlayerType)((Object)((Object)startingPlayerResult.get()));
                    this.game.setStartingPlayer(startingPlayer);
                } else {
                    event.consume();
                }
            }
        });
        this.setTitle("New Game");
        Stage stage = (Stage)dialogPane.getScene().getWindow();
        Platform.runLater(() -> {
            stage.setMinWidth(stage.getWidth());
            stage.setMinHeight(stage.getHeight());
        });
        this.setResizable(true);
    }

    @FXML
    private void setTopPlayerTypeToBlack() {
        Board.setTopPlayerType(PlayerType.BLACK);
        Config.setTopPlayer(PlayerType.BLACK);
    }

    @FXML
    private void setTopPlayerTypeToWhite() {
        Board.setTopPlayerType(PlayerType.WHITE);
        Config.setTopPlayer(PlayerType.WHITE);
    }

    @FXML
    private void toggleBlackPlayerComputer() {
        Config.setBlackComputerPlayer(!Config.isBlackComputerPlayer());
    }

    @FXML
    private void toggleWhitePlayerComputer() {
        Config.setWhiteComputerPlayer(!Config.isWhiteComputerPlayer());
    }

    @FXML
    private void toggleHighlightMoves() {
        Config.setHighlightMoves(!Config.isHighlightMoves());
    }
}

