/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.checkers.window;

import java.io.IOException;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Spinner;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import tech.octopusdragon.checkers.model.RelativeDirection;
import tech.octopusdragon.checkers.model.Variant;
import tech.octopusdragon.checkers.model.rules.BoardPattern;
import tech.octopusdragon.checkers.model.rules.KingType;
import tech.octopusdragon.checkers.model.rules.KingsRowCapture;
import tech.octopusdragon.checkers.model.rules.StartingPlayer;
import tech.octopusdragon.checkers.model.rules.StartingPositions;

public class CustomGameDialog
extends Dialog<Variant> {
    @FXML
    private Spinner<Integer> rowsSpinner;
    @FXML
    private Spinner<Integer> columnsSpinner;
    @FXML
    private Spinner<Integer> piecesSpinner;
    @FXML
    private ChoiceBox<StartingPositions> startingPositionsChoiceBox;
    @FXML
    private ChoiceBox<BoardPattern> boardPatternChoiceBox;
    @FXML
    private ChoiceBox<StartingPlayer> startingPlayerChoiceBox;
    @FXML
    private ChoiceBox<KingType> kingTypeChoiceBox;
    @FXML
    private ChoiceBox<KingsRowCapture> kingsRowCapturePromotionChoiceBox;
    @FXML
    private CheckBox removePiecesImmediatelyCheckBox;
    @FXML
    private CheckBox manCanCaptureKingCheckBox;
    @FXML
    private CheckBox quantityRuleCheckBox;
    @FXML
    private CheckBox qualityRuleCheckBox;
    @FXML
    private CheckBox priorityRuleCheckBox;
    @FXML
    private CheckBox manMoveDiagonalForwardCheckBox;
    @FXML
    private CheckBox manMoveDiagonalBackwardCheckBox;
    @FXML
    private CheckBox manMoveOrthogonalForwardCheckBox;
    @FXML
    private CheckBox manMoveOrthogonalSidewaysCheckBox;
    @FXML
    private CheckBox manMoveOrthogonalBackwardCheckBox;
    @FXML
    private CheckBox kingMoveDiagonalForwardCheckBox;
    @FXML
    private CheckBox kingMoveDiagonalBackwardCheckBox;
    @FXML
    private CheckBox kingMoveOrthogonalForwardCheckBox;
    @FXML
    private CheckBox kingMoveOrthogonalSidewaysCheckBox;
    @FXML
    private CheckBox kingMoveOrthogonalBackwardCheckBox;
    @FXML
    private CheckBox manCaptureDiagonalForwardCheckBox;
    @FXML
    private CheckBox manCaptureDiagonalBackwardCheckBox;
    @FXML
    private CheckBox manCaptureOrthogonalForwardCheckBox;
    @FXML
    private CheckBox manCaptureOrthogonalSidewaysCheckBox;
    @FXML
    private CheckBox manCaptureOrthogonalBackwardCheckBox;
    @FXML
    private CheckBox kingCaptureDiagonalForwardCheckBox;
    @FXML
    private CheckBox kingCaptureDiagonalBackwardCheckBox;
    @FXML
    private CheckBox kingCaptureOrthogonalForwardCheckBox;
    @FXML
    private CheckBox kingCaptureOrthogonalSidewaysCheckBox;
    @FXML
    private CheckBox kingCaptureOrthogonalBackwardCheckBox;
    @FXML
    private ButtonType playButtonType;

    public CustomGameDialog() {
        this.buildUI();
        this.setResultConverter(dialogButton -> {
            Variant.setCustomRows((Integer)this.rowsSpinner.getValue());
            Variant.setCustomCols((Integer)this.columnsSpinner.getValue());
            Variant.setCustomNumPieces((Integer)this.piecesSpinner.getValue());
            Variant.setCustomStartingPositions((StartingPositions)((Object)((Object)this.startingPositionsChoiceBox.getValue())));
            Variant.setCustomBoardPattern((BoardPattern)((Object)((Object)this.boardPatternChoiceBox.getValue())));
            Variant.setCustomStartingPlayer((StartingPlayer)((Object)((Object)this.startingPlayerChoiceBox.getValue())));
            Variant.setCustomKingType((KingType)((Object)((Object)this.kingTypeChoiceBox.getValue())));
            Variant.setCustomKingsRowCapture((KingsRowCapture)((Object)((Object)this.kingsRowCapturePromotionChoiceBox.getValue())));
            Variant.setCustomRemovePiecesImmediately(this.removePiecesImmediatelyCheckBox.isSelected());
            Variant.setCustomManCanCaptureKing(this.manCanCaptureKingCheckBox.isSelected());
            Variant.setCustomQuantityRule(this.quantityRuleCheckBox.isSelected());
            Variant.setCustomQualityRule(this.qualityRuleCheckBox.isSelected());
            Variant.setCustomPriorityRule(this.priorityRuleCheckBox.isSelected());
            ArrayList<RelativeDirection> manMoveDirections = new ArrayList<RelativeDirection>();
            if (this.manMoveDiagonalForwardCheckBox.isSelected()) {
                manMoveDirections.add(RelativeDirection.DIAGONAL_FORWARD);
            }
            if (this.manMoveDiagonalBackwardCheckBox.isSelected()) {
                manMoveDirections.add(RelativeDirection.DIAGONAL_BACKWARD);
            }
            if (this.manMoveOrthogonalForwardCheckBox.isSelected()) {
                manMoveDirections.add(RelativeDirection.ORTHOGONAL_FORWARD);
            }
            if (this.manMoveOrthogonalBackwardCheckBox.isSelected()) {
                manMoveDirections.add(RelativeDirection.ORTHOGONAL_BACKWARD);
            }
            if (this.manMoveOrthogonalSidewaysCheckBox.isSelected()) {
                manMoveDirections.add(RelativeDirection.ORTHOGONAL_SIDEWAYS);
            }
            Variant.setCustomManMovementDirections(manMoveDirections.toArray(new RelativeDirection[0]));
            ArrayList<RelativeDirection> kingMoveDirections = new ArrayList<RelativeDirection>();
            if (this.kingMoveDiagonalForwardCheckBox.isSelected()) {
                kingMoveDirections.add(RelativeDirection.DIAGONAL_FORWARD);
            }
            if (this.kingMoveDiagonalBackwardCheckBox.isSelected()) {
                kingMoveDirections.add(RelativeDirection.DIAGONAL_BACKWARD);
            }
            if (this.kingMoveOrthogonalForwardCheckBox.isSelected()) {
                kingMoveDirections.add(RelativeDirection.ORTHOGONAL_FORWARD);
            }
            if (this.kingMoveOrthogonalBackwardCheckBox.isSelected()) {
                kingMoveDirections.add(RelativeDirection.ORTHOGONAL_BACKWARD);
            }
            if (this.kingMoveOrthogonalSidewaysCheckBox.isSelected()) {
                kingMoveDirections.add(RelativeDirection.ORTHOGONAL_SIDEWAYS);
            }
            Variant.setCustomKingMovementDirections(kingMoveDirections.toArray(new RelativeDirection[0]));
            ArrayList<RelativeDirection> manCaptureDirections = new ArrayList<RelativeDirection>();
            if (this.manCaptureDiagonalForwardCheckBox.isSelected()) {
                manCaptureDirections.add(RelativeDirection.DIAGONAL_FORWARD);
            }
            if (this.manCaptureDiagonalBackwardCheckBox.isSelected()) {
                manCaptureDirections.add(RelativeDirection.DIAGONAL_BACKWARD);
            }
            if (this.manCaptureOrthogonalForwardCheckBox.isSelected()) {
                manCaptureDirections.add(RelativeDirection.ORTHOGONAL_FORWARD);
            }
            if (this.manCaptureOrthogonalBackwardCheckBox.isSelected()) {
                manCaptureDirections.add(RelativeDirection.ORTHOGONAL_BACKWARD);
            }
            if (this.manCaptureOrthogonalSidewaysCheckBox.isSelected()) {
                manCaptureDirections.add(RelativeDirection.ORTHOGONAL_SIDEWAYS);
            }
            Variant.setCustomManCaptureDirections(manCaptureDirections.toArray(new RelativeDirection[0]));
            ArrayList<RelativeDirection> kingCaptureDirections = new ArrayList<RelativeDirection>();
            if (this.kingCaptureDiagonalForwardCheckBox.isSelected()) {
                kingCaptureDirections.add(RelativeDirection.DIAGONAL_FORWARD);
            }
            if (this.kingCaptureDiagonalBackwardCheckBox.isSelected()) {
                kingCaptureDirections.add(RelativeDirection.DIAGONAL_BACKWARD);
            }
            if (this.kingCaptureOrthogonalForwardCheckBox.isSelected()) {
                kingCaptureDirections.add(RelativeDirection.ORTHOGONAL_FORWARD);
            }
            if (this.kingCaptureOrthogonalBackwardCheckBox.isSelected()) {
                kingCaptureDirections.add(RelativeDirection.ORTHOGONAL_BACKWARD);
            }
            if (this.kingCaptureOrthogonalSidewaysCheckBox.isSelected()) {
                kingCaptureDirections.add(RelativeDirection.ORTHOGONAL_SIDEWAYS);
            }
            Variant.setCustomKingCaptureDirections(kingCaptureDirections.toArray(new RelativeDirection[0]));
            ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? Variant.CUSTOM : null;
        });
    }

    private void buildUI() {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/view/CustomGame.fxml"));
        loader.setController((Object)this);
        DialogPane dialogPane = null;
        try {
            dialogPane = (DialogPane)loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setDialogPane(dialogPane);
        this.startingPositionsChoiceBox.setItems(FXCollections.observableArrayList((Object[])StartingPositions.values()));
        this.boardPatternChoiceBox.setItems(FXCollections.observableArrayList((Object[])BoardPattern.values()));
        this.startingPlayerChoiceBox.setItems(FXCollections.observableArrayList((Object[])StartingPlayer.values()));
        this.kingTypeChoiceBox.setItems(FXCollections.observableArrayList((Object[])KingType.values()));
        this.kingsRowCapturePromotionChoiceBox.setItems(FXCollections.observableArrayList((Object[])KingsRowCapture.values()));
        dialogPane.lookupButton(this.playButtonType).disableProperty().bind((ObservableValue)this.rowsSpinner.valueProperty().isNull().or((ObservableBooleanValue)this.columnsSpinner.valueProperty().isNull().or((ObservableBooleanValue)this.piecesSpinner.valueProperty().isNull().or((ObservableBooleanValue)this.startingPositionsChoiceBox.valueProperty().isNull().or((ObservableBooleanValue)this.boardPatternChoiceBox.valueProperty().isNull().or((ObservableBooleanValue)this.startingPlayerChoiceBox.valueProperty().isNull().or((ObservableBooleanValue)this.kingTypeChoiceBox.valueProperty().isNull().or((ObservableBooleanValue)this.kingsRowCapturePromotionChoiceBox.valueProperty().isNull()))))))));
        ((Stage)dialogPane.getScene().getWindow()).getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/icon.png")));
        this.setTitle("Custom Game");
        Stage stage = (Stage)dialogPane.getScene().getWindow();
        Platform.runLater(() -> {
            stage.setMinWidth(stage.getWidth());
            stage.setMinHeight(stage.getHeight());
        });
        this.setResizable(true);
    }
}

