/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.checkers.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import tech.octopusdragon.checkers.model.Family;
import tech.octopusdragon.checkers.model.RelativeDirection;
import tech.octopusdragon.checkers.model.rules.BoardPattern;
import tech.octopusdragon.checkers.model.rules.KingType;
import tech.octopusdragon.checkers.model.rules.KingVKingAutomaticDrawRule;
import tech.octopusdragon.checkers.model.rules.KingVKingDrawRule;
import tech.octopusdragon.checkers.model.rules.KingsRowCapture;
import tech.octopusdragon.checkers.model.rules.StartingPlayer;
import tech.octopusdragon.checkers.model.rules.StartingPositions;

public enum Variant {
    TURKISH,
    GREEK,
    ADIGHA,
    OSSETIAN_KENY,
    INTERNATIONAL,
    IVORIAN,
    CANADIAN,
    SRI_LANKAN,
    SOUTH_AFRICAN,
    BRAZILIAN,
    FILIPINO,
    MOZAMBICAN,
    SWAZI,
    RUSSIAN,
    SPANTSIRETTI,
    POOL,
    NORTH_GERMAN,
    JAMAICAN,
    LAOTIAN,
    GHANAIAN,
    NIGERIAN,
    ARMENIAN,
    GOTHIC,
    TURKTHIC,
    CRODA,
    UNIVERSAL,
    FRISIAN,
    EURASIAN,
    SIBERIAN,
    GERMAN_ENGLISCH,
    DANISH,
    SWEDISH,
    SPANISH,
    PORTUGUESE,
    ARGENTINIAN,
    BURMESE,
    INDONESIAN,
    MALAYSIAN,
    CZECH,
    SLOVAK,
    THAI,
    AFRICAN_AMERICAN,
    TANZANIAN,
    GERMAN,
    CENTRAL_SOUTH_GERMAN,
    SINGAPOREAN,
    AMERICAN,
    ITALIAN,
    DAMA_TRIESTINA,
    DAMEO,
    CUSTOM;

    private String name;
    private String description;
    private Family family;
    private int rows;
    private int cols;
    private int numPieces;
    private BoardPattern boardPattern;
    private StartingPositions startingPositions;
    private StartingPlayer startingPlayer;
    private RelativeDirection[] manMovementDirections;
    private RelativeDirection[] manCaptureDirections;
    private RelativeDirection[] kingMovementDirections;
    private RelativeDirection[] kingCaptureDirections;
    private KingType kingType;
    private KingsRowCapture kingsRowCapture;
    private boolean removePiecesImmediately;
    private boolean manCanCaptureKing;
    private boolean kingCanReverseDirection;
    private boolean quantityRule;
    private boolean qualityRule;
    private boolean priorityRule;
    private int numBoardRepeatsToDraw;
    private KingVKingDrawRule kingVKingDrawRule;
    private KingVKingAutomaticDrawRule kingVKingAutomaticDrawRule;
    private boolean prioritizeKingCaptureInKingsRow;
    private boolean captureFirstKing;
    private int quantityRuleManValue;
    private int quantityRuleKingValue;
    private int kingMaxConsecutiveMoves;
    private boolean onlyMoveOnSameColor;
    private int minPieces;
    private boolean huffing;
    private boolean linearMovement;

    static {
        TURKISH.setName("Turkish Dama");
        TURKISH.setFamily(Family.TURKISH);
        TURKISH.setRows(8);
        TURKISH.setCols(8);
        TURKISH.setNumPieces(16);
        TURKISH.setBoardPattern(BoardPattern.ALL_WHITE);
        TURKISH.setStartingPositions(StartingPositions.ALL_FROM_SECOND_ROW);
        TURKISH.setStartingPlayer(StartingPlayer.WHITE);
        TURKISH.setManMovementDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS});
        TURKISH.setManCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS});
        TURKISH.setKingMovementDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD});
        TURKISH.setKingCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD});
        TURKISH.setKingType(KingType.FLYING);
        TURKISH.setKingsRowCapture(KingsRowCapture.SKIP);
        TURKISH.setRemovePiecesImmediately(true);
        TURKISH.setManCanCaptureKing(true);
        TURKISH.setKingCanReverseDirection(false);
        TURKISH.setQuantityRule(true);
        TURKISH.setQualityRule(false);
        TURKISH.setPriorityRule(false);
        TURKISH.setPrioritizeKingCaptureInKingsRow(true);
        GREEK.copyVariant(TURKISH);
        GREEK.setName("Greek Ntama");
        GREEK.setKingType(KingType.SHORT_FLYING);
        ADIGHA.copyVariant(TURKISH);
        ADIGHA.setName("Adigha Ph\u00e8kl\u00e8n");
        ADIGHA.setRemovePiecesImmediately(false);
        OSSETIAN_KENY.copyVariant(TURKISH);
        OSSETIAN_KENY.setName("Ossetian Keny");
        OSSETIAN_KENY.setKingCanReverseDirection(true);
        OSSETIAN_KENY.setKingsRowCapture(KingsRowCapture.ADAPT);
        INTERNATIONAL.setName("International Draughts/Polish Warcaby");
        INTERNATIONAL.setFamily(Family.INTERNATIONAL);
        INTERNATIONAL.setRows(10);
        INTERNATIONAL.setCols(10);
        INTERNATIONAL.setNumPieces(20);
        INTERNATIONAL.setBoardPattern(BoardPattern.BOTTOM_LEFT_SQUARE_BLACK);
        INTERNATIONAL.setStartingPositions(StartingPositions.ALTERNATING_FROM_BOTTOM_LEFT);
        INTERNATIONAL.setStartingPlayer(StartingPlayer.WHITE);
        INTERNATIONAL.setManMovementDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD});
        INTERNATIONAL.setManCaptureDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        INTERNATIONAL.setKingMovementDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        INTERNATIONAL.setKingCaptureDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        INTERNATIONAL.setKingType(KingType.FLYING);
        INTERNATIONAL.setKingsRowCapture(KingsRowCapture.SKIP);
        INTERNATIONAL.setRemovePiecesImmediately(false);
        INTERNATIONAL.setManCanCaptureKing(true);
        INTERNATIONAL.setKingCanReverseDirection(false);
        INTERNATIONAL.setQuantityRule(true);
        INTERNATIONAL.setQualityRule(false);
        INTERNATIONAL.setPriorityRule(false);
        INTERNATIONAL.setNumBoardRepeatsToDraw(3);
        IVORIAN.copyVariant(INTERNATIONAL);
        IVORIAN.setName("Ivorian Dames/Paraguayan Dames");
        IVORIAN.setBoardPattern(BoardPattern.BOTTOM_LEFT_SQUARE_WHITE);
        IVORIAN.setStartingPositions(StartingPositions.ALTERNATING_FROM_BOTTOM_RIGHT);
        CANADIAN.copyVariant(INTERNATIONAL);
        CANADIAN.setName("Canadian Dames");
        CANADIAN.setRows(12);
        CANADIAN.setCols(12);
        CANADIAN.setNumPieces(30);
        SRI_LANKAN.copyVariant(CANADIAN);
        SRI_LANKAN.setName("Sri Lankan Dam");
        SRI_LANKAN.setBoardPattern(BoardPattern.BOTTOM_LEFT_SQUARE_WHITE);
        SRI_LANKAN.setStartingPositions(StartingPositions.ALTERNATING_FROM_BOTTOM_RIGHT);
        SOUTH_AFRICAN.copyVariant(INTERNATIONAL);
        SOUTH_AFRICAN.setName("South African Dumm");
        SOUTH_AFRICAN.setRows(14);
        SOUTH_AFRICAN.setCols(14);
        SOUTH_AFRICAN.setNumPieces(42);
        BRAZILIAN.copyVariant(INTERNATIONAL);
        BRAZILIAN.setName("Brazilian Damas");
        BRAZILIAN.setRows(8);
        BRAZILIAN.setCols(8);
        BRAZILIAN.setNumPieces(12);
        FILIPINO.copyVariant(BRAZILIAN);
        FILIPINO.setName("Filipino Dama");
        FILIPINO.setBoardPattern(BoardPattern.FILIPINO);
        FILIPINO.setStartingPositions(StartingPositions.ALTERNATING_FROM_BOTTOM_RIGHT);
        MOZAMBICAN.copyVariant(INTERNATIONAL);
        MOZAMBICAN.setName("Mozambican Damas");
        MOZAMBICAN.setStartingPlayer(StartingPlayer.EITHER);
        MOZAMBICAN.setQuantityRuleKingValue(2);
        SWAZI.copyVariant(INTERNATIONAL);
        SWAZI.setName("Swazi Mswati");
        SWAZI.setStartingPlayer(StartingPlayer.EITHER);
        SWAZI.setKingsRowCapture(KingsRowCapture.ADAPT);
        SWAZI.setRemovePiecesImmediately(false);
        SWAZI.setHuffing(true);
        RUSSIAN.copyVariant(INTERNATIONAL);
        RUSSIAN.setName("Russian Shashki");
        RUSSIAN.setRows(8);
        RUSSIAN.setCols(8);
        RUSSIAN.setNumPieces(12);
        RUSSIAN.setKingsRowCapture(KingsRowCapture.ADAPT);
        RUSSIAN.setQuantityRule(false);
        RUSSIAN.setKingVKingDrawRule(new KingVKingDrawRule(3, 1, 15));
        SPANTSIRETTI.copyVariant(RUSSIAN);
        SPANTSIRETTI.setName("Spantsiretti/Russian 80 Cells");
        SPANTSIRETTI.setCols(10);
        SPANTSIRETTI.setNumPieces(15);
        POOL.copyVariant(RUSSIAN);
        POOL.setName("Pool Checkers");
        POOL.setStartingPlayer(StartingPlayer.BLACK);
        POOL.setKingsRowCapture(KingsRowCapture.SKIP);
        POOL.setKingVKingDrawRule(new KingVKingDrawRule(3, 1, 13));
        NORTH_GERMAN.copyVariant(POOL);
        NORTH_GERMAN.setName("North German Dame");
        NORTH_GERMAN.setStartingPlayer(StartingPlayer.WHITE);
        NORTH_GERMAN.setKingVKingDrawRule(new KingVKingDrawRule());
        JAMAICAN.copyVariant(POOL);
        JAMAICAN.setName("Jamaican Draughts");
        JAMAICAN.setBoardPattern(BoardPattern.BOTTOM_LEFT_SQUARE_WHITE);
        JAMAICAN.setStartingPositions(StartingPositions.ALTERNATING_FROM_BOTTOM_RIGHT);
        LAOTIAN.copyVariant(JAMAICAN);
        LAOTIAN.setName("Laotian Draughts");
        LAOTIAN.setRows(10);
        LAOTIAN.setCols(10);
        LAOTIAN.setNumPieces(20);
        LAOTIAN.setStartingPlayer(StartingPlayer.WHITE);
        LAOTIAN.setBoardPattern(BoardPattern.BOTTOM_LEFT_SQUARE_BLACK);
        LAOTIAN.setStartingPositions(StartingPositions.ALTERNATING_FROM_BOTTOM_LEFT);
        GHANAIAN.copyVariant(LAOTIAN);
        GHANAIAN.setName("Ghanaian Damii");
        GHANAIAN.setBoardPattern(BoardPattern.BOTTOM_LEFT_SQUARE_WHITE);
        GHANAIAN.setStartingPositions(StartingPositions.ALTERNATING_FROM_BOTTOM_RIGHT);
        GHANAIAN.setMinPieces(1);
        GHANAIAN.setHuffing(true);
        NIGERIAN.copyVariant(LAOTIAN);
        NIGERIAN.setName("Nigerian Drafts");
        NIGERIAN.setStartingPlayer(StartingPlayer.EITHER);
        NIGERIAN.setBoardPattern(BoardPattern.BOTTOM_LEFT_SQUARE_WHITE);
        NIGERIAN.setStartingPositions(StartingPositions.ALTERNATING_FROM_BOTTOM_RIGHT);
        NIGERIAN.setHuffing(true);
        ARMENIAN.copyVariant(TURKISH);
        ARMENIAN.setFamily(Family.GOTHIC);
        ARMENIAN.setName("Armenian Tama");
        ARMENIAN.setManMovementDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.DIAGONAL_FORWARD});
        ARMENIAN.setKingMovementDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD, RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        GOTHIC.copyVariant(ARMENIAN);
        GOTHIC.setName("Gothic Dame/Old German Dame");
        GOTHIC.setBoardPattern(BoardPattern.BOTTOM_LEFT_SQUARE_BLACK);
        GOTHIC.setStartingPositions(StartingPositions.ALL_FROM_FIRST_ROW);
        GOTHIC.setManMovementDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD});
        GOTHIC.setManCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.DIAGONAL_FORWARD});
        GOTHIC.setKingMovementDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD, RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        GOTHIC.setKingCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD, RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        GOTHIC.setKingType(KingType.SHORT);
        GOTHIC.setKingsRowCapture(KingsRowCapture.STOP);
        TURKTHIC.copyVariant(ARMENIAN);
        TURKTHIC.setName("Turkthic Dama/Turkish Gothic Dama");
        TURKTHIC.setManMovementDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.DIAGONAL_FORWARD});
        TURKTHIC.setManCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.DIAGONAL_FORWARD});
        TURKTHIC.setKingMovementDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD, RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        TURKTHIC.setKingCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD, RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        TURKTHIC.setKingType(KingType.SHORT_FLYING);
        TURKTHIC.setKingsRowCapture(KingsRowCapture.ADAPT);
        CRODA.copyVariant(ARMENIAN);
        CRODA.setName("Croda Croation");
        CRODA.setNumPieces(24);
        CRODA.setBoardPattern(BoardPattern.BOTTOM_LEFT_SQUARE_BLACK);
        CRODA.setStartingPositions(StartingPositions.ALL_FROM_FIRST_ROW);
        CRODA.setManMovementDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.DIAGONAL_FORWARD});
        CRODA.setManCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD});
        CRODA.setKingMovementDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD});
        CRODA.setKingCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD});
        CRODA.setRemovePiecesImmediately(false);
        UNIVERSAL.copyVariant(CRODA);
        UNIVERSAL.setName("Universal Checkers");
        UNIVERSAL.setManMovementDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.DIAGONAL_FORWARD});
        UNIVERSAL.setManCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD, RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        UNIVERSAL.setKingMovementDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD, RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        UNIVERSAL.setKingCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD, RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        FRISIAN.copyVariant(INTERNATIONAL);
        FRISIAN.setName("Frisian Dammen");
        FRISIAN.setFamily(Family.FRISIAN);
        FRISIAN.setManCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD, RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        FRISIAN.setKingCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD, RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        FRISIAN.setQualityRule(true);
        FRISIAN.setPriorityRule(true);
        FRISIAN.setKingVKingDrawRule(new KingVKingDrawRule(2, 1, 7));
        FRISIAN.setQuantityRuleManValue(2);
        FRISIAN.setQuantityRuleKingValue(3);
        FRISIAN.setKingMaxConsecutiveMoves(3);
        FRISIAN.setOnlyMoveOnSameColor(true);
        EURASIAN.copyVariant(INTERNATIONAL);
        EURASIAN.setFamily(FRISIAN.getFamily());
        EURASIAN.setName("Eurasian Dama/Turkish-Russian Dama");
        EURASIAN.setRows(8);
        EURASIAN.setCols(8);
        EURASIAN.setNumPieces(12);
        EURASIAN.setManCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD});
        EURASIAN.setKingCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD});
        EURASIAN.setQuantityRule(false);
        EURASIAN.setKingVKingDrawRule(new KingVKingDrawRule(3, 1, 15));
        EURASIAN.setOnlyMoveOnSameColor(true);
        SIBERIAN.copyVariant(EURASIAN);
        SIBERIAN.setName("Siberian Turkutaga");
        SIBERIAN.setNumPieces(8);
        SIBERIAN.setManCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS});
        SIBERIAN.setKingsRowCapture(KingsRowCapture.STOP);
        SIBERIAN.setKingVKingDrawRule(new KingVKingDrawRule());
        GERMAN_ENGLISCH.copyVariant(EURASIAN);
        GERMAN_ENGLISCH.setName("German Englisch/Swedish Engelska");
        GERMAN_ENGLISCH.setManCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD, RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        GERMAN_ENGLISCH.setKingMovementDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD, RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        GERMAN_ENGLISCH.setKingCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD, RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        GERMAN_ENGLISCH.setKingVKingDrawRule(new KingVKingDrawRule());
        DANISH.copyVariant(GERMAN_ENGLISCH);
        DANISH.setName("Danish Makvar");
        DANISH.setManCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.DIAGONAL_FORWARD});
        SWEDISH.copyVariant(GERMAN_ENGLISCH);
        SWEDISH.setName("Swedish Marquere");
        SWEDISH.setKingsRowCapture(KingsRowCapture.STOP);
        SPANISH.setName("Spanish Damas");
        SPANISH.setFamily(Family.SPANISH);
        SPANISH.setRows(8);
        SPANISH.setCols(8);
        SPANISH.setNumPieces(12);
        SPANISH.setBoardPattern(BoardPattern.BOTTOM_LEFT_SQUARE_BLACK);
        SPANISH.setStartingPositions(StartingPositions.ALTERNATING_FROM_BOTTOM_RIGHT);
        SPANISH.setStartingPlayer(StartingPlayer.WHITE);
        SPANISH.setManMovementDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD});
        SPANISH.setManCaptureDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD});
        SPANISH.setKingMovementDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        SPANISH.setKingCaptureDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        SPANISH.setKingType(KingType.FLYING);
        SPANISH.setKingsRowCapture(KingsRowCapture.STOP);
        SPANISH.setRemovePiecesImmediately(false);
        SPANISH.setManCanCaptureKing(true);
        SPANISH.setKingCanReverseDirection(false);
        SPANISH.setQuantityRule(true);
        SPANISH.setQualityRule(true);
        SPANISH.setPriorityRule(false);
        PORTUGUESE.copyVariant(SPANISH);
        PORTUGUESE.setName("Portuguese Damas");
        PORTUGUESE.setBoardPattern(BoardPattern.BOTTOM_LEFT_SQUARE_WHITE);
        PORTUGUESE.setKingVKingDrawRule(new KingVKingDrawRule(3, 1, 12));
        ARGENTINIAN.copyVariant(SPANISH);
        ARGENTINIAN.setName("Argentinian Damas");
        ARGENTINIAN.setBoardPattern(BoardPattern.BOTTOM_LEFT_SQUARE_WHITE);
        ARGENTINIAN.setKingType(KingType.SHORT_FLYING);
        BURMESE.copyVariant(SPANISH);
        BURMESE.setName("Burmese Kyar/Moroccan Dama/Algerian Dama/Tunisian Dama");
        BURMESE.setBoardPattern(BoardPattern.BOTTOM_LEFT_SQUARE_WHITE);
        BURMESE.setQuantityRule(false);
        INDONESIAN.copyVariant(SPANISH);
        INDONESIAN.setName("Indonesian Dam Blas");
        INDONESIAN.setRows(10);
        INDONESIAN.setCols(10);
        INDONESIAN.setNumPieces(20);
        INDONESIAN.setStartingPositions(StartingPositions.ALTERNATING_FROM_BOTTOM_LEFT);
        INDONESIAN.setHuffing(true);
        MALAYSIAN.copyVariant(SPANISH);
        MALAYSIAN.setName("Malaysian Dam Haji");
        MALAYSIAN.setRows(12);
        MALAYSIAN.setCols(12);
        MALAYSIAN.setNumPieces(30);
        MALAYSIAN.setStartingPositions(StartingPositions.ALTERNATING_FROM_BOTTOM_LEFT);
        MALAYSIAN.setHuffing(true);
        CZECH.copyVariant(SPANISH);
        CZECH.setName("Czech Dama");
        CZECH.setStartingPositions(StartingPositions.ALTERNATING_FROM_BOTTOM_LEFT);
        CZECH.setQuantityRule(false);
        CZECH.setQualityRule(false);
        CZECH.setPriorityRule(true);
        SLOVAK.copyVariant(CZECH);
        SLOVAK.setName("Slovak Dama");
        SLOVAK.setNumPieces(8);
        THAI.copyVariant(CZECH);
        THAI.setName("Thai Makhos");
        THAI.setNumPieces(8);
        THAI.setStartingPlayer(StartingPlayer.BLACK);
        THAI.setKingType(KingType.SHORT_FLYING);
        THAI.setRemovePiecesImmediately(true);
        THAI.setKingCanReverseDirection(true);
        THAI.setPriorityRule(false);
        AFRICAN_AMERICAN.copyVariant(SPANISH);
        AFRICAN_AMERICAN.setName("African-American Straight");
        AFRICAN_AMERICAN.setStartingPositions(StartingPositions.ALTERNATING_FROM_BOTTOM_LEFT);
        AFRICAN_AMERICAN.setStartingPlayer(StartingPlayer.BLACK);
        AFRICAN_AMERICAN.setPriorityRule(false);
        TANZANIAN.copyVariant(AFRICAN_AMERICAN);
        TANZANIAN.setName("Tanzanian Draughts");
        TANZANIAN.setStartingPlayer(StartingPlayer.EITHER);
        TANZANIAN.setKingVKingDrawRule(new KingVKingDrawRule(3, 1, 12));
        TANZANIAN.setKingVKingAutomaticDrawRule(new KingVKingAutomaticDrawRule(2, 2));
        GERMAN.copyVariant(CZECH);
        GERMAN.setName("German Dame/Swedish Dampsel");
        GERMAN.setPriorityRule(false);
        CENTRAL_SOUTH_GERMAN.copyVariant(GERMAN);
        CENTRAL_SOUTH_GERMAN.setName("Central-South German Dame/Danish Damspil/Finnish Tammi");
        CENTRAL_SOUTH_GERMAN.setKingType(KingType.SHORT_FLYING);
        SINGAPOREAN.copyVariant(CZECH);
        SINGAPOREAN.setName("Singaporean Dam Haji");
        SINGAPOREAN.setRows(12);
        SINGAPOREAN.setCols(12);
        SINGAPOREAN.setNumPieces(30);
        SINGAPOREAN.setPriorityRule(true);
        SINGAPOREAN.setHuffing(true);
        AMERICAN.setName("American Checkers/English Draughts/Straight Checkers");
        AMERICAN.setFamily(Family.MISCELLANEOUS);
        AMERICAN.setRows(8);
        AMERICAN.setCols(8);
        AMERICAN.setNumPieces(12);
        AMERICAN.setBoardPattern(BoardPattern.BOTTOM_LEFT_SQUARE_BLACK);
        AMERICAN.setStartingPositions(StartingPositions.ALTERNATING_FROM_BOTTOM_LEFT);
        AMERICAN.setStartingPlayer(StartingPlayer.BLACK);
        AMERICAN.setManMovementDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD});
        AMERICAN.setManCaptureDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD});
        AMERICAN.setKingMovementDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        AMERICAN.setKingCaptureDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        AMERICAN.setKingType(KingType.SHORT);
        AMERICAN.setKingsRowCapture(KingsRowCapture.STOP);
        AMERICAN.setRemovePiecesImmediately(true);
        AMERICAN.setManCanCaptureKing(true);
        AMERICAN.setKingCanReverseDirection(false);
        AMERICAN.setQuantityRule(false);
        AMERICAN.setQualityRule(false);
        AMERICAN.setPriorityRule(false);
        ITALIAN.setName("Italian Dama");
        ITALIAN.setFamily(AMERICAN.getFamily());
        ITALIAN.setRows(8);
        ITALIAN.setCols(8);
        ITALIAN.setNumPieces(12);
        ITALIAN.setBoardPattern(BoardPattern.BOTTOM_LEFT_SQUARE_WHITE);
        ITALIAN.setStartingPositions(StartingPositions.ALTERNATING_FROM_BOTTOM_RIGHT);
        ITALIAN.setStartingPlayer(StartingPlayer.WHITE);
        ITALIAN.setManMovementDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD});
        ITALIAN.setManCaptureDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD});
        ITALIAN.setKingMovementDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        ITALIAN.setKingCaptureDirections(new RelativeDirection[]{RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        ITALIAN.setKingType(KingType.SHORT);
        ITALIAN.setKingsRowCapture(KingsRowCapture.STOP);
        ITALIAN.setRemovePiecesImmediately(false);
        ITALIAN.setManCanCaptureKing(false);
        ITALIAN.setKingCanReverseDirection(false);
        ITALIAN.setQuantityRule(true);
        ITALIAN.setQualityRule(true);
        ITALIAN.setPriorityRule(true);
        ITALIAN.setCaptureFirstKing(true);
        DAMA_TRIESTINA.copyVariant(ITALIAN);
        DAMA_TRIESTINA.setName("Dama Triestina");
        DAMA_TRIESTINA.setRows(10);
        DAMA_TRIESTINA.setCols(10);
        DAMA_TRIESTINA.setNumPieces(20);
        DAMEO.setName("Dameo");
        DAMEO.setFamily(Family.SPECIAL);
        DAMEO.setRows(8);
        DAMEO.setCols(8);
        DAMEO.setNumPieces(18);
        DAMEO.setBoardPattern(BoardPattern.BOTTOM_LEFT_SQUARE_BLACK);
        DAMEO.setStartingPositions(StartingPositions.DAMEO);
        DAMEO.setStartingPlayer(StartingPlayer.WHITE);
        DAMEO.setManMovementDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.DIAGONAL_FORWARD});
        DAMEO.setManCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD});
        DAMEO.setKingMovementDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD, RelativeDirection.DIAGONAL_FORWARD, RelativeDirection.DIAGONAL_BACKWARD});
        DAMEO.setKingCaptureDirections(new RelativeDirection[]{RelativeDirection.ORTHOGONAL_FORWARD, RelativeDirection.ORTHOGONAL_SIDEWAYS, RelativeDirection.ORTHOGONAL_BACKWARD});
        DAMEO.setKingType(KingType.FLYING);
        DAMEO.setKingsRowCapture(KingsRowCapture.SKIP);
        DAMEO.setRemovePiecesImmediately(false);
        DAMEO.setManCanCaptureKing(true);
        DAMEO.setKingCanReverseDirection(false);
        DAMEO.setQuantityRule(true);
        DAMEO.setQualityRule(false);
        DAMEO.setPriorityRule(false);
        DAMEO.setLinearMovement(true);
        CUSTOM.setName("Custom");
    }

    private Variant() {
        block17: {
            this.setNumBoardRepeatsToDraw(-1);
            this.setKingVKingDrawRule(new KingVKingDrawRule());
            this.setKingVKingAutomaticDrawRule(new KingVKingAutomaticDrawRule());
            this.setQuantityRuleManValue(1);
            this.setQuantityRuleKingValue(1);
            this.setKingMaxConsecutiveMoves(Integer.MAX_VALUE);
            InputStream inputStream = null;
            try {
                try {
                    String line;
                    inputStream = Variant.class.getClassLoader().getResourceAsStream("variant_descriptions/" + this.name().toLowerCase() + ".txt");
                    BufferedReader inputFile = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    StringBuilder descriptionSB = new StringBuilder();
                    while ((line = inputFile.readLine()) != null) {
                        descriptionSB.append(line);
                    }
                    this.setDescription(descriptionSB.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (inputStream == null) break block17;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    if (inputStream == null) break block17;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    public Family getFamily() {
        return this.family;
    }

    private void setFamily(Family family) {
        this.family = family;
    }

    public int getRows() {
        return this.rows;
    }

    private void setRows(int rows) {
        this.rows = rows;
    }

    public int getCols() {
        return this.cols;
    }

    private void setCols(int cols) {
        this.cols = cols;
    }

    public int getNumPieces() {
        return this.numPieces;
    }

    private void setNumPieces(int numPieces) {
        this.numPieces = numPieces;
    }

    public BoardPattern getBoardPattern() {
        return this.boardPattern;
    }

    private void setBoardPattern(BoardPattern boardPattern) {
        this.boardPattern = boardPattern;
    }

    public StartingPositions getStartingPositions() {
        return this.startingPositions;
    }

    private void setStartingPositions(StartingPositions startingPositions) {
        this.startingPositions = startingPositions;
    }

    public StartingPlayer getStartingPlayer() {
        return this.startingPlayer;
    }

    private void setStartingPlayer(StartingPlayer startingPlayer) {
        this.startingPlayer = startingPlayer;
    }

    public RelativeDirection[] getManMovementDirections() {
        return this.manMovementDirections;
    }

    private void setManMovementDirections(RelativeDirection[] manMovementDirections) {
        this.manMovementDirections = manMovementDirections;
    }

    public RelativeDirection[] getManCaptureDirections() {
        return this.manCaptureDirections;
    }

    private void setManCaptureDirections(RelativeDirection[] manCaptureDirections) {
        this.manCaptureDirections = manCaptureDirections;
    }

    public RelativeDirection[] getKingMovementDirections() {
        return this.kingMovementDirections;
    }

    private void setKingMovementDirections(RelativeDirection[] kingMovementDirections) {
        this.kingMovementDirections = kingMovementDirections;
    }

    public RelativeDirection[] getKingCaptureDirections() {
        return this.kingCaptureDirections;
    }

    private void setKingCaptureDirections(RelativeDirection[] kingCaptureDirections) {
        this.kingCaptureDirections = kingCaptureDirections;
    }

    public KingType getKingType() {
        return this.kingType;
    }

    private void setKingType(KingType kingType) {
        this.kingType = kingType;
    }

    public KingsRowCapture getKingsRowCapture() {
        return this.kingsRowCapture;
    }

    private void setKingsRowCapture(KingsRowCapture kingsRowCapture) {
        this.kingsRowCapture = kingsRowCapture;
    }

    public boolean isRemovePiecesImmediately() {
        return this.removePiecesImmediately;
    }

    private void setRemovePiecesImmediately(boolean removePiecesImmediately) {
        this.removePiecesImmediately = removePiecesImmediately;
    }

    public boolean isManCanCaptureKing() {
        return this.manCanCaptureKing;
    }

    private void setManCanCaptureKing(boolean manCanCaptureKing) {
        this.manCanCaptureKing = manCanCaptureKing;
    }

    public boolean isKingCanReverseDirection() {
        return this.kingCanReverseDirection;
    }

    private void setKingCanReverseDirection(boolean kingCanReverseDirection) {
        this.kingCanReverseDirection = kingCanReverseDirection;
    }

    public boolean hasQuantityRule() {
        return this.quantityRule;
    }

    private void setQuantityRule(boolean quantityRule) {
        this.quantityRule = quantityRule;
    }

    public boolean hasQualityRule() {
        return this.qualityRule;
    }

    private void setQualityRule(boolean qualityRule) {
        this.qualityRule = qualityRule;
    }

    public boolean hasPriorityRule() {
        return this.priorityRule;
    }

    private void setPriorityRule(boolean priorityRule) {
        this.priorityRule = priorityRule;
    }

    public int getNumBoardRepeatsToDraw() {
        return this.numBoardRepeatsToDraw;
    }

    private void setNumBoardRepeatsToDraw(int numBoardRepeatsToDraw) {
        this.numBoardRepeatsToDraw = numBoardRepeatsToDraw;
    }

    public boolean hasNumBoardRepeatsToDraw() {
        return this.numBoardRepeatsToDraw != -1;
    }

    public KingVKingDrawRule getKingVKingDrawRule() {
        return this.kingVKingDrawRule;
    }

    private void setKingVKingDrawRule(KingVKingDrawRule kingVKingDrawRule) {
        this.kingVKingDrawRule = kingVKingDrawRule;
    }

    public boolean hasKingVKingDrawRule() {
        return !this.kingVKingDrawRule.isEmpty();
    }

    public KingVKingAutomaticDrawRule getKingVKingAutomaticDrawRule() {
        return this.kingVKingAutomaticDrawRule;
    }

    private void setKingVKingAutomaticDrawRule(KingVKingAutomaticDrawRule kingVKingAutomaticDrawRule) {
        this.kingVKingAutomaticDrawRule = kingVKingAutomaticDrawRule;
    }

    public boolean hasKingVKingAutomaticDrawRule() {
        return !this.kingVKingAutomaticDrawRule.isEmpty();
    }

    public boolean isPrioritizeKingCaptureInKingsRow() {
        return this.prioritizeKingCaptureInKingsRow;
    }

    private void setPrioritizeKingCaptureInKingsRow(boolean prioritizeKingCaptureInKingsRow) {
        this.prioritizeKingCaptureInKingsRow = prioritizeKingCaptureInKingsRow;
    }

    public boolean isCaptureFirstKing() {
        return this.captureFirstKing;
    }

    private void setCaptureFirstKing(boolean captureFirstKing) {
        this.captureFirstKing = captureFirstKing;
    }

    public int getQuantityRuleManValue() {
        return this.quantityRuleManValue;
    }

    private void setQuantityRuleManValue(int quantityRuleManValue) {
        this.quantityRuleManValue = quantityRuleManValue;
    }

    public int getQuantityRuleKingValue() {
        return this.quantityRuleKingValue;
    }

    private void setQuantityRuleKingValue(int quantityRuleKingValue) {
        this.quantityRuleKingValue = quantityRuleKingValue;
    }

    public int getKingMaxConsecutiveMoves() {
        return this.kingMaxConsecutiveMoves;
    }

    private void setKingMaxConsecutiveMoves(int kingMaxConsecutiveMoves) {
        this.kingMaxConsecutiveMoves = kingMaxConsecutiveMoves;
    }

    public boolean canOnlyMoveOnSameColor() {
        return this.onlyMoveOnSameColor;
    }

    private void setOnlyMoveOnSameColor(boolean onlyMoveOnSameColor) {
        this.onlyMoveOnSameColor = onlyMoveOnSameColor;
    }

    public int getMinPieces() {
        return this.minPieces;
    }

    private void setMinPieces(int minPieces) {
        this.minPieces = minPieces;
    }

    public boolean isHuffing() {
        return this.huffing;
    }

    private void setHuffing(boolean huffing) {
        this.huffing = huffing;
    }

    public boolean hasLinearMovement() {
        return this.linearMovement;
    }

    private void setLinearMovement(boolean linearMovement) {
        this.linearMovement = linearMovement;
    }

    public static void setCustomRows(int rows) {
        Variant.CUSTOM.rows = rows;
    }

    public static void setCustomCols(int cols) {
        Variant.CUSTOM.cols = cols;
    }

    public static void setCustomNumPieces(int numPieces) {
        Variant.CUSTOM.numPieces = numPieces;
    }

    public static void setCustomBoardPattern(BoardPattern boardPattern) {
        Variant.CUSTOM.boardPattern = boardPattern;
    }

    public static void setCustomStartingPositions(StartingPositions startingPositions) {
        Variant.CUSTOM.startingPositions = startingPositions;
    }

    public static void setCustomStartingPlayer(StartingPlayer startingPlayer) {
        Variant.CUSTOM.startingPlayer = startingPlayer;
    }

    public static void setCustomManMovementDirections(RelativeDirection[] manMovementDirections) {
        Variant.CUSTOM.manMovementDirections = manMovementDirections;
    }

    public static void setCustomManCaptureDirections(RelativeDirection[] manCaptureDirections) {
        Variant.CUSTOM.manCaptureDirections = manCaptureDirections;
    }

    public static void setCustomKingMovementDirections(RelativeDirection[] kingMovementDirections) {
        Variant.CUSTOM.kingMovementDirections = kingMovementDirections;
    }

    public static void setCustomKingCaptureDirections(RelativeDirection[] kingCaptureDirections) {
        Variant.CUSTOM.kingCaptureDirections = kingCaptureDirections;
    }

    public static void setCustomKingType(KingType kingType) {
        Variant.CUSTOM.kingType = kingType;
    }

    public static void setCustomKingsRowCapture(KingsRowCapture kingsRowCapture) {
        Variant.CUSTOM.kingsRowCapture = kingsRowCapture;
    }

    public static void setCustomRemovePiecesImmediately(boolean removePiecesImmediately) {
        Variant.CUSTOM.removePiecesImmediately = removePiecesImmediately;
    }

    public static void setCustomManCanCaptureKing(boolean manCanCaptureKing) {
        Variant.CUSTOM.manCanCaptureKing = manCanCaptureKing;
    }

    public static void setCustomKingCanReverseDirection(boolean kingCanReverseDirection) {
        Variant.CUSTOM.kingCanReverseDirection = kingCanReverseDirection;
    }

    public static void setCustomQuantityRule(boolean quantityRule) {
        Variant.CUSTOM.quantityRule = quantityRule;
    }

    public static void setCustomQualityRule(boolean qualityRule) {
        Variant.CUSTOM.qualityRule = qualityRule;
    }

    public static void setCustomPriorityRule(boolean priorityRule) {
        Variant.CUSTOM.priorityRule = priorityRule;
    }

    private void copyVariant(Variant parentVariant) {
        this.family = parentVariant.family;
        this.rows = parentVariant.rows;
        this.cols = parentVariant.cols;
        this.numPieces = parentVariant.numPieces;
        this.numPieces = parentVariant.numPieces;
        this.boardPattern = parentVariant.boardPattern;
        this.startingPositions = parentVariant.startingPositions;
        this.startingPlayer = parentVariant.startingPlayer;
        this.manMovementDirections = parentVariant.manMovementDirections;
        this.manCaptureDirections = parentVariant.manCaptureDirections;
        this.kingMovementDirections = parentVariant.kingMovementDirections;
        this.kingCaptureDirections = parentVariant.kingCaptureDirections;
        this.kingType = parentVariant.kingType;
        this.kingsRowCapture = parentVariant.kingsRowCapture;
        this.removePiecesImmediately = parentVariant.removePiecesImmediately;
        this.manCanCaptureKing = parentVariant.manCanCaptureKing;
        this.kingCanReverseDirection = parentVariant.kingCanReverseDirection;
        this.quantityRule = parentVariant.quantityRule;
        this.qualityRule = parentVariant.qualityRule;
        this.priorityRule = parentVariant.priorityRule;
        this.numBoardRepeatsToDraw = parentVariant.numBoardRepeatsToDraw;
        this.kingVKingDrawRule = parentVariant.kingVKingDrawRule;
        this.kingVKingAutomaticDrawRule = parentVariant.kingVKingAutomaticDrawRule;
        this.prioritizeKingCaptureInKingsRow = parentVariant.prioritizeKingCaptureInKingsRow;
        this.captureFirstKing = parentVariant.captureFirstKing;
        this.quantityRuleManValue = parentVariant.quantityRuleManValue;
        this.quantityRuleKingValue = parentVariant.quantityRuleKingValue;
        this.kingMaxConsecutiveMoves = parentVariant.kingMaxConsecutiveMoves;
        this.onlyMoveOnSameColor = parentVariant.onlyMoveOnSameColor;
        this.minPieces = parentVariant.minPieces;
        this.huffing = parentVariant.huffing;
        this.linearMovement = parentVariant.linearMovement;
    }

    public String toString() {
        return this.name;
    }
}

