/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.checkers.model;

import java.io.Serializable;
import tech.octopusdragon.checkers.model.PlayerType;

public class Piece
implements Serializable {
    private static final long serialVersionUID = -3719252967902203014L;
    private PieceType type;
    private boolean hasMoved;
    private int consecutiveMoves;

    public Piece(PieceType type) {
        this.type = type;
    }

    public void crown() {
        switch (this.type) {
            case BLACK_MAN: {
                this.type = PieceType.BLACK_KING;
                break;
            }
            case WHITE_MAN: {
                this.type = PieceType.WHITE_KING;
            }
        }
    }

    public PieceType getType() {
        return this.type;
    }

    public boolean hasMoved() {
        return this.hasMoved;
    }

    public int getConsecutiveMoves() {
        return this.consecutiveMoves;
    }

    public void resetConsecutiveMoves() {
        this.consecutiveMoves = 0;
    }

    public void markMoved(boolean moved) {
        if (moved && !this.hasMoved) {
            this.hasMoved = true;
        }
        if (moved) {
            ++this.consecutiveMoves;
        } else if (this.consecutiveMoves > 0) {
            this.consecutiveMoves = 0;
        }
    }

    public PlayerType getPlayerType() {
        PlayerType playerType = null;
        switch (this.type) {
            case BLACK_MAN: 
            case BLACK_KING: {
                playerType = PlayerType.BLACK;
                break;
            }
            case WHITE_MAN: 
            case WHITE_KING: {
                playerType = PlayerType.WHITE;
            }
        }
        return playerType;
    }

    public boolean isBlack() {
        return this.type == PieceType.BLACK_MAN || this.type == PieceType.BLACK_KING;
    }

    public boolean isWhite() {
        return this.type == PieceType.WHITE_MAN || this.type == PieceType.WHITE_KING;
    }

    public boolean isMan() {
        return this.type == PieceType.BLACK_MAN || this.type == PieceType.WHITE_MAN;
    }

    public boolean isKing() {
        return this.type == PieceType.BLACK_KING || this.type == PieceType.WHITE_KING;
    }

    public Piece clone() {
        Piece copy = new Piece(this.getType());
        return copy;
    }

    public static enum PieceType {
        BLACK_MAN,
        WHITE_MAN,
        BLACK_KING,
        WHITE_KING;


        public String toString() {
            StringBuilder sb = new StringBuilder(this.name().toLowerCase());
            int i = 0;
            while (i < sb.length()) {
                if (sb.charAt(i) == '_') {
                    sb.replace(i, i + 1, " ");
                }
                ++i;
            }
            sb.replace(0, 1, sb.substring(0, 1).toUpperCase());
            i = 0;
            while (i < sb.length()) {
                if (i >= 1 && sb.charAt(i - 1) == ' ') {
                    sb.replace(i, i + 1, sb.substring(i, i + 1).toUpperCase());
                }
                ++i;
            }
            return sb.toString();
        }
    }
}

