/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.checkers.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import tech.octopusdragon.checkers.model.PlayerType;

public class Config {
    private static final String USERDATA_DIRECTORY = "userdata/";
    private static final String USERDATA_FILENAME = "checkers_config.json";
    private static Config config;
    private static Gson gson;
    private PlayerType topPlayer = PlayerType.BLACK;
    private boolean highlightMoves = true;
    private boolean isBlackComputerPlayer = false;
    private boolean isWhiteComputerPlayer = false;
    private double blackDifficulty = 0.5;
    private double whiteDifficulty = 0.5;

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            config = (Config)gson.fromJson(new JsonReader(new InputStreamReader(new FileInputStream("userdata/checkers_config.json"))), (Type)((Object)Config.class));
        }
        catch (JsonParseException | IOException e) {
            config = new Config();
            Config.save();
        }
    }

    public static void save() {
        File folder = new File(USERDATA_DIRECTORY);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream("userdata/checkers_config.json"));
            gson.toJson((Object)config, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (JsonIOException | IOException e) {
            e.printStackTrace();
        }
    }

    public static PlayerType getTopPlayer() {
        return Config.config.topPlayer;
    }

    public static void setTopPlayer(PlayerType topPlayer) {
        Config.config.topPlayer = topPlayer;
        Config.save();
    }

    public static boolean isHighlightMoves() {
        return Config.config.highlightMoves;
    }

    public static void setHighlightMoves(boolean highlightMoves) {
        Config.config.highlightMoves = highlightMoves;
        Config.save();
    }

    public static boolean isBlackComputerPlayer() {
        return Config.config.isBlackComputerPlayer;
    }

    public static void setBlackComputerPlayer(boolean isBlackComputerPlayer) {
        Config.config.isBlackComputerPlayer = isBlackComputerPlayer;
        Config.save();
    }

    public static boolean isWhiteComputerPlayer() {
        return Config.config.isWhiteComputerPlayer;
    }

    public static void setWhiteComputerPlayer(boolean isWhiteComputerPlayer) {
        Config.config.isWhiteComputerPlayer = isWhiteComputerPlayer;
        Config.save();
    }

    public static double getBlackDifficulty() {
        return Config.config.blackDifficulty;
    }

    public static void setBlackDifficulty(double blackDifficulty) {
        Config.config.blackDifficulty = blackDifficulty;
        Config.save();
    }

    public static double getWhiteDifficulty() {
        return Config.config.whiteDifficulty;
    }

    public static void setWhiteDifficulty(double whiteDifficulty) {
        Config.config.whiteDifficulty = whiteDifficulty;
        Config.save();
    }

    private Config() {
    }
}

