/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.checkers.model;

import java.util.ArrayList;
import java.util.Random;
import tech.octopusdragon.checkers.model.Checkers;
import tech.octopusdragon.checkers.model.Move;
import tech.octopusdragon.checkers.model.Player;
import tech.octopusdragon.checkers.model.rules.KingType;

public class ComputerPlayer {
    private static int MIN_DEPTH = 2;
    private static int MAX_DEPTH = 10;

    public static Move getMove(Checkers game, double difficulty) throws InterruptedException {
        Random rand = new Random();
        if (rand.nextDouble() < -Math.log10(0.9 * difficulty + 0.1)) {
            return ComputerPlayer.randomMove(game);
        }
        return ComputerPlayer.minimaxMove(game, (int)Math.ceil(difficulty * (double)MAX_DEPTH));
    }

    private static Move randomMove(Checkers game) {
        Random rand = new Random();
        Move move = game.validMoves(game.getCurPlayer()).get(rand.nextInt(game.validMoves(game.getCurPlayer()).size()));
        return move;
    }

    private static Move minimaxMove(Checkers game, int startingDepth) throws InterruptedException {
        int bestValue = Integer.MIN_VALUE;
        int value = Integer.MIN_VALUE;
        boolean maximizingPlayer = true;
        int alpha = Integer.MIN_VALUE;
        int beta = Integer.MAX_VALUE;
        if (game.getVariant().hasQuantityRule()) {
            --startingDepth;
        }
        startingDepth -= game.getVariant().getNumPieces() / 10;
        startingDepth -= (game.getVariant().getManMovementDirections().length + game.getVariant().getKingMovementDirections().length + game.getVariant().getManCaptureDirections().length + game.getVariant().getKingCaptureDirections().length) / 4;
        if (game.getVariant().getKingType() != KingType.SHORT) {
            startingDepth /= 2;
        }
        startingDepth = Math.max(startingDepth, MIN_DEPTH);
        Checkers gameCopy = game.clone();
        Player movedPlayer = gameCopy.getCurPlayer();
        ArrayList<Move> bestMoves = new ArrayList<Move>();
        for (Move move : gameCopy.validMoves(movedPlayer)) {
            gameCopy.move(move);
            value = ComputerPlayer.minimax(gameCopy, startingDepth - 1, alpha, beta, gameCopy.getCurPlayer() == movedPlayer ? maximizingPlayer : !maximizingPlayer);
            gameCopy.undoMove();
            if (bestMoves.isEmpty()) {
                bestValue = value;
                bestMoves.add(move);
            } else if (value > bestValue) {
                bestValue = value;
                bestMoves.clear();
                bestMoves.add(move);
            } else if (value == bestValue) {
                bestMoves.add(move);
            }
            alpha = Math.max(alpha, value);
            if (value >= beta) break;
        }
        return (Move)bestMoves.get(new Random().nextInt(bestMoves.size()));
    }

    private static int minimax(Checkers game, int depth, int alpha, int beta, boolean maximizingPlayer) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (game.isOver()) {
            if (game.winner() != null) {
                return maximizingPlayer ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            }
            return 0;
        }
        if (depth == 0) {
            return ComputerPlayer.staticEvaluation(game, maximizingPlayer);
        }
        if (maximizingPlayer) {
            int value = Integer.MIN_VALUE;
            for (Move move : game.validMoves(game.getCurPlayer())) {
                Player movedPlayer = game.getCurPlayer();
                game.move(move);
                value = Math.max(value, ComputerPlayer.minimax(game, depth - 1, alpha, beta, game.getCurPlayer() == movedPlayer ? maximizingPlayer : !maximizingPlayer));
                game.undoMove();
                alpha = Math.max(alpha, value);
                if (value >= beta) break;
            }
            return value;
        }
        int value = Integer.MAX_VALUE;
        for (Move move : game.validMoves(game.getCurPlayer())) {
            Player movedPlayer = game.getCurPlayer();
            game.move(move);
            value = Math.min(value, ComputerPlayer.minimax(game, depth - 1, alpha, beta, game.getCurPlayer() == movedPlayer ? maximizingPlayer : !maximizingPlayer));
            game.undoMove();
            beta = Math.min(beta, value);
            if (value <= alpha) break;
        }
        return value;
    }

    private static int staticEvaluation(Checkers game, boolean maximizingPlayer) {
        Player minimizer;
        Player maximizer;
        if (game.getCurPlayer() == game.getTopPlayer() && maximizingPlayer) {
            maximizer = game.getTopPlayer();
            minimizer = game.getBottomPlayer();
        } else if (game.getCurPlayer() == game.getBottomPlayer() && !maximizingPlayer) {
            maximizer = game.getTopPlayer();
            minimizer = game.getBottomPlayer();
        } else if (maximizingPlayer) {
            maximizer = game.getBottomPlayer();
            minimizer = game.getTopPlayer();
        } else {
            maximizer = game.getBottomPlayer();
            minimizer = game.getTopPlayer();
        }
        return game.numPieces(maximizer) - game.numPieces(minimizer);
    }
}

