/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.checkers.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import tech.octopusdragon.checkers.model.AbsoluteDirection;
import tech.octopusdragon.checkers.model.Board;
import tech.octopusdragon.checkers.model.BoardHistory;
import tech.octopusdragon.checkers.model.BoardState;
import tech.octopusdragon.checkers.model.Capture;
import tech.octopusdragon.checkers.model.CapturePosition;
import tech.octopusdragon.checkers.model.MaximumCapturePosition;
import tech.octopusdragon.checkers.model.Move;
import tech.octopusdragon.checkers.model.Piece;
import tech.octopusdragon.checkers.model.Player;
import tech.octopusdragon.checkers.model.PlayerType;
import tech.octopusdragon.checkers.model.Position;
import tech.octopusdragon.checkers.model.RelativeDirection;
import tech.octopusdragon.checkers.model.Variant;
import tech.octopusdragon.checkers.model.rules.KingType;

public class Checkers
implements Serializable {
    private static final long serialVersionUID = -3394984352759443037L;
    private Variant variant;
    private Board board;
    private Player blackPlayer;
    private Player whitePlayer;
    private Player curPlayer;
    private Piece capturingPiece;
    private List<Position> capturedPosList;
    private AbsoluteDirection lastDir;
    private BoardHistory history;
    private int kingVKingTurnsLeft;
    private boolean kingVKingStarted;
    private Player higherKingPlayer;
    private boolean missedCapture;
    private Piece missedCapturePiece;
    private boolean moved;
    private boolean captured;

    public Checkers(Variant variant) {
        this.variant = variant;
        this.blackPlayer = new Player(PlayerType.BLACK);
        this.whitePlayer = new Player(PlayerType.WHITE);
        this.board = new Board(variant.getRows(), variant.getCols(), variant.getBoardPattern(), variant.getNumPieces(), variant.getStartingPositions());
        this.capturingPiece = null;
        this.capturedPosList = new ArrayList<Position>();
        this.lastDir = null;
        switch (variant.getStartingPlayer()) {
            case BLACK: {
                this.curPlayer = this.blackPlayer;
                break;
            }
            case WHITE: {
                this.curPlayer = this.whitePlayer;
                break;
            }
            case EITHER: {
                this.curPlayer = null;
            }
        }
        if (this.curPlayer != null) {
            this.history = new BoardHistory();
            this.history.push(this.board, this.curPlayer, new Position[0], null);
        }
        if (variant.hasKingVKingDrawRule()) {
            this.kingVKingTurnsLeft = variant.getKingVKingDrawRule().getNumTurns();
            this.kingVKingStarted = false;
        }
    }

    public void serialize() {
        File folder = new File("userdata/");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            FileOutputStream outStream = new FileOutputStream("userdata/checkers.ser");
            ObjectOutputStream objectOutputFile = new ObjectOutputStream(outStream);
            objectOutputFile.writeObject(this);
            objectOutputFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Checkers deserialize(String filename) throws IOException, ClassNotFoundException {
        Checkers object = null;
        FileInputStream inStream = new FileInputStream("userdata/checkers.ser");
        ObjectInputStream objectInputFile = new ObjectInputStream(inStream);
        object = (Checkers)objectInputFile.readObject();
        objectInputFile.close();
        return object;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public Board getBoard() {
        return this.board;
    }

    public List<Piece> getPieces() {
        ArrayList<Piece> pieces = new ArrayList<Piece>();
        int i = 0;
        while (i < this.variant.getRows()) {
            int j = 0;
            while (j < this.variant.getCols()) {
                Piece curPiece = this.board.getPiece(i, j);
                if (curPiece != null) {
                    pieces.add(curPiece);
                }
                ++j;
            }
            ++i;
        }
        return pieces;
    }

    public List<Piece> getCapturedPieces() {
        ArrayList<Piece> capturedPieces = new ArrayList<Piece>();
        for (Position pos : this.capturedPosList) {
            capturedPieces.add(this.board.getPiece(pos));
        }
        return capturedPieces;
    }

    public void setStartingPlayer(PlayerType startingPlayerType) {
        switch (startingPlayerType) {
            case BLACK: {
                this.curPlayer = this.blackPlayer;
                break;
            }
            case WHITE: {
                this.curPlayer = this.whitePlayer;
            }
        }
        this.history = new BoardHistory();
        this.history.push(this.board, this.curPlayer, new Position[0], null);
    }

    public Player getCurPlayer() {
        return this.curPlayer;
    }

    public Player getTopPlayer() {
        return this.topPlayer();
    }

    public Player getBottomPlayer() {
        return this.bottomPlayer();
    }

    public boolean missedCapture() {
        return this.missedCapture;
    }

    public Piece missedCapturePiece() {
        return this.missedCapturePiece;
    }

    public Piece capturingPiece() {
        return this.capturingPiece;
    }

    public boolean hasMoved() {
        return this.moved;
    }

    public boolean hasCaptured() {
        return this.captured;
    }

    public Player topPlayer() {
        return Board.getTopPlayerType() == PlayerType.BLACK ? this.blackPlayer : this.whitePlayer;
    }

    public Player bottomPlayer() {
        return Board.getBottomPlayerType() == PlayerType.BLACK ? this.blackPlayer : this.whitePlayer;
    }

    private void nextPlayer() {
        this.curPlayer = this.curPlayer == this.topPlayer() ? this.bottomPlayer() : this.topPlayer();
        this.moved = false;
        this.captured = false;
    }

    public void endTurn() {
        if (!this.variant.isHuffing()) {
            return;
        }
        if (this.missedCapture) {
            this.board.remove(this.missedCapturePiece);
        }
        this.missedCapture = false;
        this.missedCapturePiece = null;
        this.terminateSequence();
        this.nextPlayer();
    }

    public boolean isOver() {
        return this.piecesOf(this.topPlayer()).isEmpty() || this.piecesOf(this.bottomPlayer()).isEmpty() || this.numPieces(this.topPlayer()) <= this.variant.getMinPieces() || this.numPieces(this.bottomPlayer()) <= this.variant.getMinPieces() || !this.canMove(this.curPlayer) && !this.moved || this.drawFromBoardRepeats() || this.drawFromKingVKing() || this.drawFromKingVKingAutomatic();
    }

    public Player winner() {
        Player winner = null;
        if (this.piecesOf(this.bottomPlayer()).isEmpty() || !this.canMove(this.bottomPlayer()) || this.numPieces(this.bottomPlayer()) <= this.variant.getMinPieces()) {
            winner = this.topPlayer();
        } else if (this.piecesOf(this.topPlayer()).isEmpty() || !this.canMove(this.topPlayer()) || this.numPieces(this.topPlayer()) <= this.variant.getMinPieces()) {
            winner = this.bottomPlayer();
        }
        return winner;
    }

    private Player player(PlayerType playerType) {
        Player player = null;
        switch (playerType) {
            case BLACK: {
                player = this.blackPlayer;
                break;
            }
            case WHITE: {
                player = this.whitePlayer;
            }
        }
        return player;
    }

    private Player playerOf(Piece piece) {
        Player piecePlayer = null;
        switch (piece.getPlayerType()) {
            case BLACK: {
                piecePlayer = this.blackPlayer;
                break;
            }
            case WHITE: {
                piecePlayer = this.whitePlayer;
            }
        }
        return piecePlayer;
    }

    private List<Piece> piecesOf(Player player) {
        ArrayList<Piece> playerPieces = new ArrayList<Piece>();
        int i = 0;
        while (i < this.variant.getRows()) {
            int j = 0;
            while (j < this.variant.getCols()) {
                Piece curPiece = this.board.getPiece(i, j);
                if (curPiece != null && (player.getType() == PlayerType.BLACK && curPiece.isBlack() || player.getType() == PlayerType.WHITE && curPiece.isWhite())) {
                    playerPieces.add(curPiece);
                }
                ++j;
            }
            ++i;
        }
        return playerPieces;
    }

    public int numPieces(Player player) {
        return this.piecesOf(player).size();
    }

    public List<Piece> menOf(Player player) {
        ArrayList<Piece> playerMen = new ArrayList<Piece>();
        for (Piece piece : this.piecesOf(player)) {
            if (!piece.isMan()) continue;
            playerMen.add(piece);
        }
        return playerMen;
    }

    public int numMen(Player player) {
        return this.menOf(player).size();
    }

    public boolean hasMen(Player player) {
        return !this.menOf(player).isEmpty();
    }

    public List<Piece> kingsOf(Player player) {
        ArrayList<Piece> playerKings = new ArrayList<Piece>();
        for (Piece piece : this.piecesOf(player)) {
            if (!piece.isKing()) continue;
            playerKings.add(piece);
        }
        return playerKings;
    }

    public int numKings(Player player) {
        return this.kingsOf(player).size();
    }

    public boolean hasKings(Player player) {
        return !this.kingsOf(player).isEmpty();
    }

    public void move(Move move) {
        this.move(move.getFromPos().getRow(), move.getFromPos().getCol(), move.getToPos().getRow(), move.getToPos().getCol());
    }

    public void move(Piece piece, int toRow, int toCol) {
        Position pos = this.board.getPosition(piece);
        int fromRow = pos.getRow();
        int fromCol = pos.getCol();
        this.move(fromRow, fromCol, toRow, toCol);
    }

    public void move(int fromRow, int fromCol, int toRow, int toCol) {
        boolean terminateSequence = false;
        boolean capture = false;
        Piece piece = this.board.getPiece(fromRow, fromCol);
        if (!this.isValidMove(piece, toRow, toCol)) {
            return;
        }
        if (this.canCapture(this.playerOf(piece)) && !this.isValidCapture(piece, toRow, toCol)) {
            this.missedCapture = true;
            this.missedCapturePiece = piece;
        }
        if (this.isValidCapture(piece, toRow, toCol)) {
            Piece capturedPiece = this.capturedPiece(piece, toRow, toCol);
            if (!this.variant.isRemovePiecesImmediately()) {
                this.capturedPosList.add(this.board.getPosition(capturedPiece));
            } else {
                this.board.remove(capturedPiece);
            }
            capture = true;
            this.captured = true;
            this.capturingPiece = piece;
            piece.resetConsecutiveMoves();
        } else {
            terminateSequence = true;
        }
        this.lastDir = this.board.absoluteDirection(piece, new Position(toRow, toCol));
        this.board.move(piece, toRow, toCol);
        this.moved = true;
        if (capture && !this.canCapture(piece)) {
            terminateSequence = true;
        }
        if (capture && this.canCapture(piece) && piece.isMan() && this.board.isInKingsRow(piece)) {
            switch (this.variant.getKingsRowCapture()) {
                case STOP: {
                    terminateSequence = true;
                    piece.crown();
                    break;
                }
                case SKIP: {
                    break;
                }
                case ADAPT: {
                    piece.crown();
                }
            }
        } else if (piece.isMan() && this.board.isInKingsRow(piece)) {
            piece.crown();
        }
        if (terminateSequence && !this.variant.isHuffing()) {
            this.terminateSequence();
            if (!this.isOver()) {
                this.nextPlayer();
            }
        }
        this.history.push(this.board, this.curPlayer, this.capturedPosList.toArray(new Position[0]), this.board.getPosition(this.capturingPiece));
    }

    private void terminateSequence() {
        for (Position capturedPos : this.capturedPosList) {
            this.board.remove(this.board.getPiece(capturedPos));
        }
        this.capturingPiece = null;
        this.capturedPosList.clear();
        this.lastDir = null;
        if (this.variant.hasKingVKingDrawRule()) {
            if (!this.kingVKingStarted && this.hasKingVKingCondition()) {
                this.kingVKingStarted = true;
                this.higherKingPlayer = this.curPlayer;
            } else if (this.kingVKingStarted && this.curPlayer == this.higherKingPlayer) {
                --this.kingVKingTurnsLeft;
            }
        }
    }

    private void setState(BoardState state, Position[] capturedPosArr, Position capturingPiecePosition) {
        if (state == null) {
            return;
        }
        this.curPlayer = this.player(state.playerType());
        this.board = new Board(state, this.variant.getBoardPattern());
        this.capturedPosList.clear();
        this.capturedPosList.addAll(Arrays.asList(capturedPosArr));
        if (capturingPiecePosition != null) {
            this.capturingPiece = this.board.getPiece(capturingPiecePosition);
        }
    }

    public BoardHistory getHistory() {
        return this.history;
    }

    public void undoMove() {
        this.setState(this.history.previous(), this.history.getCurrentCapturedPosArr(), this.history.getCurrentCapturingPiecePos());
    }

    public void undoTurn() {
        Player lastMovedPlayer = this.getCurPlayer();
        while (this.getCurPlayer() == lastMovedPlayer) {
            this.setState(this.history.previous(), this.history.getCurrentCapturedPosArr(), this.history.getCurrentCapturingPiecePos());
        }
    }

    public void undoAllTurns() {
        this.setState(this.history.first(), this.history.getCurrentCapturedPosArr(), this.history.getCurrentCapturingPiecePos());
    }

    public void redoTurn() {
        Player lastMovedPlayer = this.getCurPlayer();
        while (this.getCurPlayer() == lastMovedPlayer) {
            this.setState(this.history.next(), this.history.getCurrentCapturedPosArr(), this.history.getCurrentCapturingPiecePos());
        }
    }

    public void redoAllTurns() {
        this.setState(this.history.last(), this.history.getCurrentCapturedPosArr(), this.history.getCurrentCapturingPiecePos());
    }

    private void maximumCaptureMove(int fromRow, int fromCol, int toRow, int toCol) {
        boolean terminateSequence = false;
        Piece piece = this.board.getPiece(fromRow, fromCol);
        Piece thisCapturedPiece = this.capturedPiece(piece, toRow, toCol);
        if (!this.variant.isRemovePiecesImmediately()) {
            this.capturedPosList.add(this.board.getPosition(thisCapturedPiece));
        } else {
            this.board.remove(thisCapturedPiece);
        }
        this.board.move(piece, toRow, toCol);
        if (piece.isMan() && this.board.isInKingsRow(piece)) {
            switch (this.variant.getKingsRowCapture()) {
                case STOP: {
                    terminateSequence = true;
                    piece.crown();
                    break;
                }
                case SKIP: {
                    break;
                }
                case ADAPT: {
                    piece.crown();
                }
            }
        } else if (piece.isMan() && this.board.isInKingsRow(piece)) {
            piece.crown();
        }
        if (terminateSequence) {
            for (Position capturedPos : this.capturedPosList) {
                this.board.remove(this.board.getPiece(capturedPos));
            }
            this.capturingPiece = null;
            this.capturedPosList.clear();
            this.lastDir = null;
            this.nextPlayer();
        } else {
            this.capturingPiece = piece;
            this.lastDir = this.board.absoluteDirection(piece, new Position(toRow, toCol));
        }
    }

    private boolean isMaximumCapturePiece(Piece piece) {
        List<Piece> maxCapturePieces = this.maximumCapturePieces(this.playerOf(piece));
        return maxCapturePieces.contains(piece);
    }

    private List<Piece> maximumCapturePieces(Player player) {
        ArrayList<Piece> pieces = new ArrayList<Piece>();
        ArrayList<Integer> maxCaptureValues = new ArrayList<Integer>();
        int maxMaxCaptureValue = 0;
        for (Piece piece : this.piecesOf(player)) {
            pieces.add(piece);
            maxCaptureValues.add(this.maximumCaptureValue(piece));
            maxMaxCaptureValue = Math.max((Integer)maxCaptureValues.get(maxCaptureValues.size() - 1), maxMaxCaptureValue);
        }
        ArrayList<Piece> piecesToReturn = new ArrayList<Piece>();
        int i = 0;
        while (i < maxCaptureValues.size()) {
            if ((Integer)maxCaptureValues.get(i) == maxMaxCaptureValue) {
                piecesToReturn.add((Piece)pieces.get(i));
            }
            ++i;
        }
        return piecesToReturn;
    }

    private boolean isMaximumCapture(Piece piece, Position position) {
        List<MaximumCapturePosition> maxCapturePositions = this.maximumCaptures(piece);
        boolean found = false;
        for (Position position2 : maxCapturePositions) {
            if (position2.getRow() != position.getRow() || position2.getCol() != position.getCol()) continue;
            found = true;
            break;
        }
        return found;
    }

    private int maximumCaptureValue(Piece piece) {
        List<MaximumCapturePosition> maxCapPositions = this.maximumCaptures(piece);
        if (maxCapPositions.isEmpty()) {
            return 0;
        }
        return this.maximumCaptures(piece).get(0).getMaxCaptureValue();
    }

    private List<MaximumCapturePosition> maximumCaptures(Piece piece) {
        int captureValue;
        ArrayList<MaximumCapturePosition> maxCapturePositions = new ArrayList<MaximumCapturePosition>();
        int maxCaptureValue = 0;
        for (CapturePosition pos : this.capturePositions(piece)) {
            captureValue = this.maximumCaptureRecursive(piece, pos, this);
            maxCapturePositions.add(new MaximumCapturePosition(pos.getRow(), pos.getCol(), pos.getCapturedPiece(), captureValue));
            maxCaptureValue = Math.max(captureValue, maxCaptureValue);
        }
        Iterator i = maxCapturePositions.iterator();
        while (i.hasNext()) {
            MaximumCapturePosition capturePosition = (MaximumCapturePosition)i.next();
            captureValue = capturePosition.getMaxCaptureValue();
            if (captureValue >= maxCaptureValue) continue;
            i.remove();
        }
        if (this.variant.hasQualityRule()) {
            int maxNumKings = 0;
            for (MaximumCapturePosition pos : maxCapturePositions) {
                int numKings = this.maximumCaptureKingsRecursive(piece, pos, this);
                maxNumKings = Math.max(numKings, maxNumKings);
            }
            i = maxCapturePositions.iterator();
            while (i.hasNext()) {
                MaximumCapturePosition capturePosition = (MaximumCapturePosition)i.next();
                int numKings = this.maximumCaptureKingsRecursive(piece, capturePosition, this);
                if (numKings >= maxNumKings) continue;
                i.remove();
            }
        }
        return maxCapturePositions;
    }

    private int maximumCaptureRecursive(Piece piece, CapturePosition position, Checkers game) {
        if (game.getCurPlayer() != game.playerOf(piece)) {
            return 0;
        }
        int fromRow = game.getBoard().getPosition(piece).getRow();
        int fromCol = game.getBoard().getPosition(piece).getCol();
        int toRow = position.getRow();
        int toCol = position.getCol();
        Checkers gameCopy = game.clone();
        Piece pieceCopy = gameCopy.getBoard().getPiece(fromRow, fromCol);
        gameCopy.maximumCaptureMove(fromRow, fromCol, toRow, toCol);
        int maxCaptureValue = 0;
        for (CapturePosition pos : gameCopy.capturePositions(pieceCopy)) {
            int captureValue = this.maximumCaptureRecursive(pieceCopy, pos, gameCopy);
            maxCaptureValue = Math.max(captureValue, maxCaptureValue);
        }
        return maxCaptureValue + (position.getCapturedPiece().isKing() ? this.variant.getQuantityRuleKingValue() : this.variant.getQuantityRuleManValue());
    }

    private int maximumCaptureKingsRecursive(Piece piece, CapturePosition position, Checkers game) {
        int fromRow = game.getBoard().getPosition(piece).getRow();
        int fromCol = game.getBoard().getPosition(piece).getCol();
        int toRow = position.getRow();
        int toCol = position.getCol();
        Checkers gameCopy = game.clone();
        Piece pieceCopy = gameCopy.getBoard().getPiece(fromRow, fromCol);
        gameCopy.maximumCaptureMove(fromRow, fromCol, toRow, toCol);
        gameCopy.curPlayer = gameCopy.playerOf(pieceCopy);
        int numKings = position.getCapturedPiece().isKing() ? 1 : 0;
        int maxNumKings = 0;
        for (CapturePosition pos : gameCopy.capturePositions(pieceCopy)) {
            int curNumKings = this.maximumCaptureKingsRecursive(pieceCopy, pos, gameCopy);
            maxNumKings = Math.max(curNumKings, maxNumKings);
        }
        return numKings + maxNumKings;
    }

    private Piece capturedPiece(Piece piece, int toRow, int toCol) {
        Piece capturablePiece = null;
        for (CapturePosition capturePos : this.capturePositions(piece)) {
            if (capturePos.getRow() != toRow || capturePos.getCol() != toCol) continue;
            capturablePiece = capturePos.getCapturedPiece();
            break;
        }
        return capturablePiece;
    }

    public List<Piece> movablePieces() {
        ArrayList<Piece> movablePieces = new ArrayList<Piece>();
        for (Piece piece : this.getPieces()) {
            if (!this.canMove(piece)) continue;
            movablePieces.add(piece);
        }
        return movablePieces;
    }

    private List<Piece> capturingPiecesNoRules(Player player) {
        ArrayList<Piece> capturablePieces = new ArrayList<Piece>();
        for (Piece piece : this.piecesOf(player)) {
            if (this.capturePositions(piece).isEmpty()) continue;
            capturablePieces.add(piece);
        }
        return capturablePieces;
    }

    public boolean canMove(Player player) {
        return !this.validMoves(player).isEmpty();
    }

    public boolean canMove(Piece piece) {
        return !this.validMoves(piece).isEmpty();
    }

    public boolean canMultiCapture(Piece piece) {
        for (Capture capture : this.validCaptures(piece)) {
            int fromRow = capture.getFromPos().getRow();
            int fromCol = capture.getFromPos().getCol();
            int toRow = capture.getToPos().getRow();
            int toCol = capture.getToPos().getCol();
            Checkers gameCopy = this.clone();
            gameCopy.move(fromRow, fromCol, toRow, toCol);
            if (!gameCopy.canCapture(gameCopy.getBoard().getPiece(toRow, toCol))) continue;
            return true;
        }
        return false;
    }

    public boolean canCapture(Player player) {
        return !this.validCaptures(player).isEmpty();
    }

    public boolean canCapture(Piece piece) {
        return !this.validCaptures(piece).isEmpty();
    }

    public boolean isValidMove(Piece piece, int toRow, int toCol) {
        for (Move move : this.validMoves(piece)) {
            if (move.getToPos().getRow() != toRow || move.getToPos().getCol() != toCol) continue;
            return true;
        }
        return false;
    }

    public boolean isValidCapture(Piece piece, int toRow, int toCol) {
        for (Move move : this.validCaptures(piece)) {
            if (move.getToPos().getRow() != toRow || move.getToPos().getCol() != toCol) continue;
            return true;
        }
        return false;
    }

    public List<Move> validMoves(Player player) {
        ArrayList<Move> moves = new ArrayList<Move>();
        for (Piece piece : this.piecesOf(player)) {
            moves.addAll(this.validMoves(piece));
        }
        return moves;
    }

    public List<Move> validMoves(Piece piece) {
        ArrayList<Move> moves;
        block9: {
            block7: {
                block8: {
                    moves = new ArrayList<Move>();
                    if (!this.variant.isHuffing()) break block7;
                    if (!this.moved) break block8;
                    if (this.capturingPiece == null || piece != this.capturingPiece) break block9;
                    for (CapturePosition capturePos : this.validCapturePositions(piece)) {
                        moves.add(new Capture(this.board.getPosition(piece), capturePos, this.board.getPosition(capturePos.getCapturedPiece())));
                    }
                    break block9;
                }
                for (CapturePosition capturePos : this.validCapturePositions(piece)) {
                    moves.add(new Capture(this.board.getPosition(piece), capturePos, this.board.getPosition(capturePos.getCapturedPiece())));
                }
                for (Position pos : this.validMovementPositions(piece)) {
                    moves.add(new Move(this.board.getPosition(piece), pos));
                }
                break block9;
            }
            if (this.canCapture(this.playerOf(piece))) {
                for (CapturePosition capturePos : this.validCapturePositions(piece)) {
                    moves.add(new Capture(this.board.getPosition(piece), capturePos, this.board.getPosition(capturePos.getCapturedPiece())));
                }
            } else {
                for (Position pos : this.validMovementPositions(piece)) {
                    moves.add(new Move(this.board.getPosition(piece), pos));
                }
            }
        }
        return moves;
    }

    private List<Capture> validCaptures(Player player) {
        ArrayList<Capture> captures = new ArrayList<Capture>();
        for (Piece piece : this.piecesOf(player)) {
            captures.addAll(this.validCaptures(piece));
        }
        return captures;
    }

    public List<Capture> validCaptures(Piece piece) {
        ArrayList<Capture> captures = new ArrayList<Capture>();
        for (CapturePosition capturePos : this.validCapturePositions(piece)) {
            captures.add(new Capture(this.board.getPosition(piece), capturePos, this.board.getPosition(capturePos.getCapturedPiece())));
        }
        return captures;
    }

    private List<Position> validMovementPositions(Piece piece) {
        ArrayList<Position> positions = new ArrayList<Position>();
        if (this.playerOf(piece) != this.curPlayer) {
            return positions;
        }
        if (piece.isKing() && this.hasMen(this.playerOf(piece)) && piece.getConsecutiveMoves() >= this.variant.getKingMaxConsecutiveMoves()) {
            return positions;
        }
        positions.addAll(this.movementPositions(piece));
        return positions;
    }

    private List<Position> movementPositions(Piece piece) {
        ArrayList<Position> positions = new ArrayList<Position>();
        block10: for (AbsoluteDirection direction : this.absoluteMovementDirections(piece)) {
            boolean afterMovableSpace = false;
            int curRow = this.board.getPosition(piece).getRow();
            int curCol = this.board.getPosition(piece).getCol();
            do {
                Position position = new Position(curRow, curCol);
                switch (direction) {
                    case N: {
                        position.setRow(--curRow);
                        break;
                    }
                    case S: {
                        position.setRow(++curRow);
                        break;
                    }
                    case E: {
                        position.setCol(++curCol);
                        break;
                    }
                    case W: {
                        position.setCol(--curCol);
                        break;
                    }
                    case NW: {
                        position.setRow(--curRow);
                        position.setCol(--curCol);
                        break;
                    }
                    case NE: {
                        position.setRow(--curRow);
                        position.setCol(++curCol);
                        break;
                    }
                    case SW: {
                        position.setRow(++curRow);
                        position.setCol(--curCol);
                        break;
                    }
                    case SE: {
                        position.setRow(++curRow);
                        position.setCol(++curCol);
                    }
                }
                if (!this.board.isValidSpace(position)) continue block10;
                if (this.variant.hasLinearMovement() && piece.isMan() && this.board.getPiece(position) != null && this.board.getPiece(position).isMan() && this.board.getPiece(position).getPlayerType() == piece.getPlayerType()) continue;
                if (!this.board.isMovableSpace(position)) continue block10;
                if (this.variant.canOnlyMoveOnSameColor() && this.board.getSquare(position) != this.board.getSquare(this.board.getPosition(piece))) continue;
                positions.add(position);
                afterMovableSpace = true;
            } while (piece.isKing() && this.variant.getKingType().isFlying() || this.variant.hasLinearMovement() && !afterMovableSpace);
        }
        return positions;
    }

    private List<AbsoluteDirection> absoluteMovementDirections(Piece piece) {
        Player player = this.playerOf(piece);
        ArrayList<AbsoluteDirection> absDirections = new ArrayList<AbsoluteDirection>();
        RelativeDirection[] relativeDirectionArray = piece.isMan() ? this.variant.getManMovementDirections() : this.variant.getKingMovementDirections();
        int n = relativeDirectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            RelativeDirection relDirection = relativeDirectionArray[n2];
            switch (relDirection) {
                case DIAGONAL_FORWARD: {
                    if (player == this.bottomPlayer()) {
                        Collections.addAll(absDirections, AbsoluteDirection.NW, AbsoluteDirection.NE);
                        break;
                    }
                    if (player != this.topPlayer()) break;
                    Collections.addAll(absDirections, AbsoluteDirection.SW, AbsoluteDirection.SE);
                    break;
                }
                case DIAGONAL_BACKWARD: {
                    if (player == this.bottomPlayer()) {
                        Collections.addAll(absDirections, AbsoluteDirection.SW, AbsoluteDirection.SE);
                        break;
                    }
                    if (player != this.topPlayer()) break;
                    Collections.addAll(absDirections, AbsoluteDirection.NW, AbsoluteDirection.NE);
                    break;
                }
                case ORTHOGONAL_FORWARD: {
                    if (player == this.bottomPlayer()) {
                        Collections.addAll(absDirections, AbsoluteDirection.N);
                        break;
                    }
                    if (player != this.topPlayer()) break;
                    Collections.addAll(absDirections, AbsoluteDirection.S);
                    break;
                }
                case ORTHOGONAL_BACKWARD: {
                    if (player == this.bottomPlayer()) {
                        Collections.addAll(absDirections, AbsoluteDirection.S);
                        break;
                    }
                    if (player != this.topPlayer()) break;
                    Collections.addAll(absDirections, AbsoluteDirection.N);
                    break;
                }
                case ORTHOGONAL_SIDEWAYS: {
                    Collections.addAll(absDirections, AbsoluteDirection.W, AbsoluteDirection.E);
                }
            }
            ++n2;
        }
        return absDirections;
    }

    private List<CapturePosition> validCapturePositions(Piece piece) {
        ArrayList<CapturePosition> positions = new ArrayList<CapturePosition>();
        if (this.playerOf(piece) != this.curPlayer) {
            return positions;
        }
        positions.addAll(this.capturePositions(piece));
        Iterator i = positions.iterator();
        while (i.hasNext()) {
            CapturePosition position = (CapturePosition)i.next();
            if (this.capturingPiece != null && piece != this.capturingPiece) {
                i.remove();
                continue;
            }
            if (piece.isMan() && position.getCapturedPiece().isKing() && !this.variant.isManCanCaptureKing()) {
                i.remove();
                continue;
            }
            if (!(!this.variant.hasQuantityRule() || this.isMaximumCapture(piece, position) && this.isMaximumCapturePiece(piece))) {
                i.remove();
                continue;
            }
            if (this.variant.hasPriorityRule() && piece.isMan() && this.kingCanMaximumCapture(this.playerOf(piece))) {
                i.remove();
                continue;
            }
            if (this.variant.isCaptureFirstKing() && !this.isFirstKingCapture(piece, position)) {
                i.remove();
                continue;
            }
            if (!this.variant.isKingCanReverseDirection() && piece.isKing() && this.lastDir != null && this.board.absoluteDirection(piece, position) == this.lastDir.opposite()) {
                i.remove();
                continue;
            }
            if (!this.variant.isPrioritizeKingCaptureInKingsRow() || !piece.isMan() || !this.board.isInKingsRow(piece) || !this.canCaptureKing(piece) || position.getCapturedPiece().isKing()) continue;
            i.remove();
        }
        return positions;
    }

    private List<CapturePosition> capturePositions(Piece piece) {
        ArrayList<CapturePosition> positions = new ArrayList<CapturePosition>();
        block10: for (AbsoluteDirection direction : this.absoluteCaptureDirections(piece)) {
            boolean foundCapturablePiece = false;
            boolean afterCapturablePiece = false;
            int curRow = this.board.getPosition(piece).getRow();
            int curCol = this.board.getPosition(piece).getCol();
            CapturePosition position = new CapturePosition(curRow, curCol);
            while (true) {
                switch (direction) {
                    case N: {
                        position.setRow(--curRow);
                        break;
                    }
                    case S: {
                        position.setRow(++curRow);
                        break;
                    }
                    case E: {
                        position.setCol(++curCol);
                        break;
                    }
                    case W: {
                        position.setCol(--curCol);
                        break;
                    }
                    case NW: {
                        position.setRow(--curRow);
                        position.setCol(--curCol);
                        break;
                    }
                    case NE: {
                        position.setRow(--curRow);
                        position.setCol(++curCol);
                        break;
                    }
                    case SW: {
                        position.setRow(++curRow);
                        position.setCol(--curCol);
                        break;
                    }
                    case SE: {
                        position.setRow(++curRow);
                        position.setCol(++curCol);
                    }
                }
                if (!this.board.isValidSpace(position)) continue block10;
                if (this.variant.canOnlyMoveOnSameColor() && this.board.getSquare(position) != this.board.getSquare(this.board.getPosition(piece))) continue;
                if (this.board.getPiece(position) != null && (this.capturedPosList.contains(position) || this.board.getPiece(position).getPlayerType() == piece.getPlayerType())) continue block10;
                if (!foundCapturablePiece && this.board.getPiece(position) != null && this.playerOf(this.board.getPiece(position)) != this.curPlayer) {
                    foundCapturablePiece = true;
                    position.setCapturedPiece(this.board.getPiece(position));
                } else {
                    if (this.board.getPiece(position) != null) continue block10;
                    if (foundCapturablePiece && !afterCapturablePiece) {
                        afterCapturablePiece = true;
                    }
                }
                if (!foundCapturablePiece && (piece.isMan() || this.variant.getKingType() == KingType.SHORT)) continue block10;
                if (afterCapturablePiece) {
                    positions.add(position);
                    position = new CapturePosition(position);
                }
                if (afterCapturablePiece && (piece.isMan() || this.variant.getKingType().isShort())) break;
            }
        }
        return positions;
    }

    private List<AbsoluteDirection> absoluteCaptureDirections(Piece piece) {
        Player player = this.playerOf(piece);
        ArrayList<AbsoluteDirection> absDirections = new ArrayList<AbsoluteDirection>();
        RelativeDirection[] relativeDirectionArray = piece.isMan() ? this.variant.getManCaptureDirections() : this.variant.getKingCaptureDirections();
        int n = relativeDirectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            RelativeDirection relDirection = relativeDirectionArray[n2];
            switch (relDirection) {
                case DIAGONAL_FORWARD: {
                    if (player == this.bottomPlayer()) {
                        Collections.addAll(absDirections, AbsoluteDirection.NW, AbsoluteDirection.NE);
                        break;
                    }
                    if (player != this.topPlayer()) break;
                    Collections.addAll(absDirections, AbsoluteDirection.SW, AbsoluteDirection.SE);
                    break;
                }
                case DIAGONAL_BACKWARD: {
                    if (player == this.bottomPlayer()) {
                        Collections.addAll(absDirections, AbsoluteDirection.SW, AbsoluteDirection.SE);
                        break;
                    }
                    if (player != this.topPlayer()) break;
                    Collections.addAll(absDirections, AbsoluteDirection.NW, AbsoluteDirection.NE);
                    break;
                }
                case ORTHOGONAL_FORWARD: {
                    if (player == this.bottomPlayer()) {
                        Collections.addAll(absDirections, AbsoluteDirection.N);
                        break;
                    }
                    if (player != this.topPlayer()) break;
                    Collections.addAll(absDirections, AbsoluteDirection.S);
                    break;
                }
                case ORTHOGONAL_BACKWARD: {
                    if (player == this.bottomPlayer()) {
                        Collections.addAll(absDirections, AbsoluteDirection.S);
                        break;
                    }
                    if (player != this.topPlayer()) break;
                    Collections.addAll(absDirections, AbsoluteDirection.N);
                    break;
                }
                case ORTHOGONAL_SIDEWAYS: {
                    Collections.addAll(absDirections, AbsoluteDirection.W, AbsoluteDirection.E);
                }
            }
            ++n2;
        }
        return absDirections;
    }

    private boolean kingCanMaximumCapture(Player player) {
        boolean kingCanMaximumCapture = false;
        for (Piece piece : this.capturingPiecesNoRules(player)) {
            if (!piece.isKing() || !this.isMaximumCapturePiece(piece)) continue;
            kingCanMaximumCapture = true;
            break;
        }
        return kingCanMaximumCapture;
    }

    private boolean canCaptureKing(Piece piece) {
        boolean canCaptureKing = false;
        for (CapturePosition capturePosition : this.capturePositions(piece)) {
            if (!capturePosition.getCapturedPiece().isKing()) continue;
            canCaptureKing = true;
            break;
        }
        return canCaptureKing;
    }

    private boolean drawFromBoardRepeats() {
        return this.variant.hasNumBoardRepeatsToDraw() && this.history.highestCount() >= this.variant.getNumBoardRepeatsToDraw();
    }

    private boolean hasKingVKingCondition() {
        int topPlayerNumKings = this.numKings(this.topPlayer());
        int bottomPlayerNumKings = this.numKings(this.bottomPlayer());
        int higherNumKings = this.variant.getKingVKingDrawRule().getHigherNumKings();
        int lowerNumKings = this.variant.getKingVKingDrawRule().getLowerNumKings();
        return (topPlayerNumKings >= higherNumKings && bottomPlayerNumKings <= lowerNumKings && !this.hasMen(this.bottomPlayer()) || bottomPlayerNumKings >= higherNumKings && topPlayerNumKings <= lowerNumKings && !this.hasMen(this.topPlayer())) && (this.curPlayer == this.topPlayer() && topPlayerNumKings >= bottomPlayerNumKings || this.curPlayer == this.bottomPlayer() && bottomPlayerNumKings >= topPlayerNumKings);
    }

    private boolean hasKingVKingAutomaticCondition() {
        int topPlayerNumKings = this.numKings(this.topPlayer());
        int bottomPlayerNumKings = this.numKings(this.bottomPlayer());
        int p1NumKings = this.variant.getKingVKingAutomaticDrawRule().getP1NumKings();
        int p2NumKings = this.variant.getKingVKingAutomaticDrawRule().getP2NumKings();
        return !this.hasMen(this.topPlayer()) && !this.hasMen(this.bottomPlayer()) && (topPlayerNumKings <= p1NumKings && bottomPlayerNumKings <= p2NumKings || bottomPlayerNumKings <= p1NumKings && topPlayerNumKings <= p2NumKings);
    }

    private boolean drawFromKingVKing() {
        if (!this.variant.hasKingVKingDrawRule()) {
            return false;
        }
        return this.kingVKingTurnsLeft == 0;
    }

    private boolean drawFromKingVKingAutomatic() {
        if (!this.variant.hasKingVKingDrawRule()) {
            return false;
        }
        return this.hasKingVKingAutomaticCondition();
    }

    private boolean isFirstKingCapture(Piece piece, CapturePosition position) {
        MaximumCapturePosition[] maximumCapturePositions = this.maximumCaptures(piece).toArray(new MaximumCapturePosition[0]);
        Integer[] soonestKings = new Integer[maximumCapturePositions.length];
        int thisSoonestKing = Integer.MAX_VALUE;
        int i = 0;
        while (i < maximumCapturePositions.length) {
            soonestKings[i] = this.firstKingCaptureRecursive(piece, position, this, 1);
            if (maximumCapturePositions[i].equals(position)) {
                thisSoonestKing = soonestKings[i];
            }
            ++i;
        }
        int firstKingTurn = Collections.min(Arrays.asList(soonestKings));
        return thisSoonestKing <= firstKingTurn;
    }

    private int firstKingCaptureRecursive(Piece piece, CapturePosition position, Checkers game, int turn) {
        int fromRow = game.getBoard().getPosition(piece).getRow();
        int fromCol = game.getBoard().getPosition(piece).getCol();
        int toRow = position.getRow();
        int toCol = position.getCol();
        Checkers gameCopy = game.clone();
        Piece pieceCopy = gameCopy.getBoard().getPiece(fromRow, fromCol);
        gameCopy.maximumCaptureMove(fromRow, fromCol, toRow, toCol);
        if (game.getCurPlayer() != game.playerOf(piece)) {
            return Integer.MAX_VALUE;
        }
        if (position.getCapturedPiece().isKing()) {
            return turn;
        }
        int earliestKingTurn = Integer.MAX_VALUE;
        for (CapturePosition pos : gameCopy.capturePositions(pieceCopy)) {
            int kingTurn = this.firstKingCaptureRecursive(pieceCopy, pos, gameCopy, turn + 1);
            earliestKingTurn = Math.min(kingTurn, earliestKingTurn);
        }
        return earliestKingTurn;
    }

    public Checkers clone() {
        Checkers copy = new Checkers(this.variant);
        copy.board = this.board.clone();
        copy.blackPlayer = this.blackPlayer.clone();
        copy.whitePlayer = this.whitePlayer.clone();
        copy.curPlayer = this.curPlayer == this.blackPlayer ? copy.blackPlayer : copy.whitePlayer;
        copy.higherKingPlayer = this.higherKingPlayer == this.blackPlayer ? copy.blackPlayer : copy.whitePlayer;
        copy.capturedPosList = new ArrayList<Position>();
        int i = 0;
        while (i < this.variant.getRows()) {
            int j = 0;
            while (j < this.variant.getCols()) {
                Piece curPiece = this.board.getPiece(i, j);
                Piece copyPiece = copy.board.getPiece(i, j);
                if (this.capturedPosList.contains(this.board.getPosition(curPiece))) {
                    copy.capturedPosList.add(copy.board.getPosition(copyPiece));
                }
                if (curPiece == this.capturingPiece) {
                    copy.capturingPiece = copyPiece;
                }
                if (curPiece == this.missedCapturePiece) {
                    copy.missedCapturePiece = copyPiece;
                }
                ++j;
            }
            ++i;
        }
        copy.lastDir = this.lastDir;
        copy.history = this.history.clone();
        copy.kingVKingTurnsLeft = this.kingVKingTurnsLeft;
        copy.kingVKingStarted = this.kingVKingStarted;
        copy.missedCapture = this.missedCapture;
        copy.moved = this.moved;
        copy.captured = this.captured;
        return copy;
    }
}

