/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.checkers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import tech.octopusdragon.checkers.model.Board;
import tech.octopusdragon.checkers.model.Piece;
import tech.octopusdragon.checkers.model.Player;
import tech.octopusdragon.checkers.model.PlayerType;

public class BoardState
implements Serializable {
    private static final long serialVersionUID = 4313286164206736232L;
    private Piece.PieceType[][] pieceTypes;
    private PlayerType playerType;

    public BoardState(Board board, Player player) {
        int rows = board.getRows();
        int cols = board.getCols();
        this.pieceTypes = new Piece.PieceType[rows][cols];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                this.pieceTypes[i][j] = board.getPiece(i, j) == null ? null : board.getPiece(i, j).getType();
                ++j;
            }
            ++i;
        }
        this.playerType = player.getType();
    }

    public int rows() {
        return this.pieceTypes.length;
    }

    public int cols() {
        return this.pieceTypes[0].length;
    }

    public Piece.PieceType[][] pieceTypes() {
        return (Piece.PieceType[][])this.pieceTypes.clone();
    }

    public PlayerType playerType() {
        return this.playerType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BoardState)) {
            return false;
        }
        BoardState other = (BoardState)obj;
        return this.playerType == other.playerType && Arrays.deepEquals((Object[])this.pieceTypes, (Object[])other.pieceTypes);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode((Object[])this.pieceTypes);
        result = 31 * result + Objects.hash(new Object[]{this.playerType});
        return result;
    }

    public String toString() {
        String str = "";
        int i = 0;
        while (i < this.pieceTypes.length) {
            int j = 0;
            while (j < this.pieceTypes[i].length) {
                Piece.PieceType pieceType = this.pieceTypes[i][j];
                str = pieceType == null ? String.valueOf(str) + " " : (pieceType == Piece.PieceType.BLACK_KING || pieceType == Piece.PieceType.BLACK_MAN ? String.valueOf(str) + "B" : String.valueOf(str) + "W");
                ++j;
            }
            str = String.valueOf(str) + "\n";
            ++i;
        }
        return str;
    }
}

