/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.checkers.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tech.octopusdragon.checkers.model.Board;
import tech.octopusdragon.checkers.model.BoardState;
import tech.octopusdragon.checkers.model.Player;
import tech.octopusdragon.checkers.model.Position;

public class BoardHistory
implements Serializable {
    private static final long serialVersionUID = 1789959895674278458L;
    private List<BoardState> boardHistory = new ArrayList<BoardState>();
    private int index;
    private Map<BoardState, Integer> boardCounts = new HashMap<BoardState, Integer>();
    private List<Position[]> capturedPosListHistory = new ArrayList<Position[]>();
    private List<Position> capturingPiecePosHistory = new ArrayList<Position>();

    public void push(Board board, Player player, Position[] capturedPosArr, Position capturingPiecePos) {
        while (this.boardHistory.size() > this.index + 1) {
            Integer count = this.boardCounts.get(this.boardHistory.get(this.index + 1));
            this.boardCounts.put(this.boardHistory.get(this.index + 1), count - 1);
            this.boardHistory.remove(this.index + 1);
            this.capturedPosListHistory.remove(this.index + 1);
            this.capturingPiecePosHistory.remove(this.index + 1);
        }
        BoardState boardState = new BoardState(board, player);
        this.boardHistory.add(new BoardState(board, player));
        this.capturedPosListHistory.add(capturedPosArr);
        this.capturingPiecePosHistory.add(capturingPiecePos);
        Integer count = this.boardCounts.get(boardState);
        if (count == null) {
            this.boardCounts.put(boardState, 1);
        } else {
            this.boardCounts.put(boardState, count + 1);
        }
        this.index = this.boardHistory.size() - 1;
    }

    public BoardState getCurrent() {
        return this.boardHistory.get(this.index);
    }

    public Position[] getCurrentCapturedPosArr() {
        return this.capturedPosListHistory.get(this.index);
    }

    public Position getCurrentCapturingPiecePos() {
        return this.capturingPiecePosHistory.get(this.index);
    }

    public int getIndex() {
        return this.index;
    }

    public BoardState previous() {
        if (this.index <= 0) {
            return null;
        }
        return this.boardHistory.get(--this.index);
    }

    public BoardState next() {
        if (this.index >= this.boardHistory.size() - 1) {
            return null;
        }
        return this.boardHistory.get(++this.index);
    }

    public BoardState first() {
        if (this.boardHistory.isEmpty()) {
            return null;
        }
        this.index = 0;
        return this.boardHistory.get(0);
    }

    public BoardState last() {
        if (this.boardHistory.isEmpty()) {
            return null;
        }
        this.index = this.boardHistory.size() - 1;
        return this.boardHistory.get(this.index);
    }

    public int highestCount() {
        return Collections.max(this.boardCounts.values());
    }

    public BoardHistory clone() {
        BoardHistory copy = new BoardHistory();
        copy.boardHistory = new ArrayList<BoardState>(this.boardHistory);
        copy.index = this.index;
        copy.boardCounts = new HashMap<BoardState, Integer>(this.boardCounts);
        copy.capturedPosListHistory = new ArrayList<Position[]>(this.capturedPosListHistory);
        copy.capturingPiecePosHistory = new ArrayList<Position>(this.capturingPiecePosHistory);
        return copy;
    }
}

