/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.checkers.model;

import java.io.Serializable;
import tech.octopusdragon.checkers.model.AbsoluteDirection;
import tech.octopusdragon.checkers.model.BoardState;
import tech.octopusdragon.checkers.model.Config;
import tech.octopusdragon.checkers.model.Piece;
import tech.octopusdragon.checkers.model.PlayerType;
import tech.octopusdragon.checkers.model.Position;
import tech.octopusdragon.checkers.model.Square;
import tech.octopusdragon.checkers.model.rules.BoardPattern;
import tech.octopusdragon.checkers.model.rules.StartingPositions;

public class Board
implements Serializable {
    private static final long serialVersionUID = -1895927710282652311L;
    private static PlayerType topPlayerType = Config.getTopPlayer();
    private static PlayerType bottomPlayerType = topPlayerType == PlayerType.BLACK ? PlayerType.WHITE : PlayerType.BLACK;
    private int rows;
    private int cols;
    private BoardPattern pattern;
    private Square[][] squares;
    private Piece[][] pieces;

    public Board(int rows, int cols, BoardPattern pattern) {
        int j;
        this.rows = rows;
        this.cols = cols;
        this.pattern = pattern;
        this.squares = new Square[rows][cols];
        int i = 0;
        while (i < rows) {
            j = 0;
            while (j < cols) {
                switch (pattern) {
                    case ALL_BLACK: {
                        this.squares[i][j] = Square.BLACK;
                        break;
                    }
                    case ALL_WHITE: {
                        this.squares[i][j] = Square.WHITE;
                        break;
                    }
                    case BOTTOM_LEFT_SQUARE_BLACK: {
                        this.squares[i][j] = (i + j) % 2 == 1 ? Square.BLACK : Square.WHITE;
                        break;
                    }
                    case BOTTOM_LEFT_SQUARE_WHITE: {
                        this.squares[i][j] = (i + j) % 2 == 0 ? Square.BLACK : Square.WHITE;
                        break;
                    }
                    case FILIPINO: {
                        this.squares[i][j] = Square.FILIPINO;
                    }
                }
                ++j;
            }
            ++i;
        }
        this.pieces = new Piece[rows][cols];
        i = 0;
        while (i < rows) {
            j = 0;
            while (j < cols) {
                this.pieces[i][j] = null;
                ++j;
            }
            ++i;
        }
    }

    public Board(int rows, int cols, BoardPattern pattern, int numPieces, StartingPositions positions) {
        this(rows, cols, pattern);
        int topPiecesLeft = numPieces;
        int i = 0;
        block14: while (i < rows) {
            int j = 0;
            while (j < cols) {
                switch (positions) {
                    case ALL_FROM_FIRST_ROW: {
                        this.pieces[i][j] = new Piece(topPlayerType.manPiece());
                        --topPiecesLeft;
                        break;
                    }
                    case ALL_FROM_SECOND_ROW: {
                        if (i < 1) break;
                        this.pieces[i][j] = new Piece(topPlayerType.manPiece());
                        --topPiecesLeft;
                        break;
                    }
                    case ALTERNATING_FROM_BOTTOM_LEFT: {
                        if ((i + j) % 2 != 1) break;
                        this.pieces[i][j] = new Piece(topPlayerType.manPiece());
                        --topPiecesLeft;
                        break;
                    }
                    case ALTERNATING_FROM_BOTTOM_RIGHT: {
                        if ((i + j) % 2 != 0) break;
                        this.pieces[i][j] = new Piece(topPlayerType.manPiece());
                        --topPiecesLeft;
                        break;
                    }
                    case DAMEO: {
                        if (j < i || j >= rows - i) break;
                        this.pieces[i][j] = new Piece(topPlayerType.manPiece());
                        --topPiecesLeft;
                    }
                }
                if (topPiecesLeft == 0) break block14;
                ++j;
            }
            ++i;
        }
        int bottomPiecesLeft = numPieces;
        int i2 = rows - 1;
        block16: while (i2 >= 0) {
            int j = cols - 1;
            while (j >= 0) {
                switch (positions) {
                    case ALL_FROM_FIRST_ROW: {
                        this.pieces[i2][j] = new Piece(bottomPlayerType.manPiece());
                        --bottomPiecesLeft;
                        break;
                    }
                    case ALL_FROM_SECOND_ROW: {
                        if (i2 >= rows - 1) break;
                        this.pieces[i2][j] = new Piece(bottomPlayerType.manPiece());
                        --bottomPiecesLeft;
                        break;
                    }
                    case ALTERNATING_FROM_BOTTOM_LEFT: {
                        if ((i2 + j) % 2 != 1) break;
                        this.pieces[i2][j] = new Piece(bottomPlayerType.manPiece());
                        --bottomPiecesLeft;
                        break;
                    }
                    case ALTERNATING_FROM_BOTTOM_RIGHT: {
                        if ((i2 + j) % 2 != 0) break;
                        this.pieces[i2][j] = new Piece(bottomPlayerType.manPiece());
                        --bottomPiecesLeft;
                        break;
                    }
                    case DAMEO: {
                        if (j < rows - 1 - i2 || j > i2) break;
                        this.pieces[i2][j] = new Piece(bottomPlayerType.manPiece());
                        --bottomPiecesLeft;
                    }
                }
                if (bottomPiecesLeft == 0) break block16;
                --j;
            }
            --i2;
        }
    }

    public Board(BoardState boardState, BoardPattern pattern) {
        this(boardState.rows(), boardState.cols(), pattern);
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                Piece.PieceType pieceType = boardState.pieceTypes()[i][j];
                this.pieces[i][j] = pieceType == null ? null : new Piece(pieceType);
                ++j;
            }
            ++i;
        }
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public BoardPattern getPattern() {
        return this.pattern;
    }

    public Square getSquare(Position pos) {
        return this.squares[pos.getRow()][pos.getCol()];
    }

    public Square getSquare(int row, int col) {
        return this.squares[row][col];
    }

    public Piece getPiece(Position pos) {
        return this.pieces[pos.getRow()][pos.getCol()];
    }

    public Piece getPiece(int row, int col) {
        return this.pieces[row][col];
    }

    public boolean isOccupied(Position pos) {
        return this.pieces[pos.getRow()][pos.getCol()] != null;
    }

    public boolean isOccupied(int row, int col) {
        return this.pieces[row][col] != null;
    }

    public Position getPosition(Piece piece) {
        Position pos = null;
        int i = 0;
        block0: while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                if (this.pieces[i][j] == piece) {
                    pos = new Position(i, j);
                    break block0;
                }
                ++j;
            }
            ++i;
        }
        return pos;
    }

    public boolean isValidSpace(Position position) {
        return this.isValidSpace(position.getRow(), position.getCol());
    }

    public boolean isValidSpace(int row, int col) {
        return row >= 0 && row < this.rows && col >= 0 && col < this.cols;
    }

    public boolean isMovableSpace(Position position) {
        return this.isValidSpace(position) && this.getPiece(position) == null;
    }

    public boolean isMovableSpace(int row, int col) {
        return this.isValidSpace(row, col) && this.getPiece(row, col) == null;
    }

    public boolean isInKingsRow(Piece piece) {
        boolean inKingsRow = false;
        if (piece.getPlayerType() == topPlayerType && this.getPosition(piece).getRow() == this.rows - 1 || piece.getPlayerType() == bottomPlayerType && this.getPosition(piece).getRow() == 0) {
            inKingsRow = true;
        }
        return inKingsRow;
    }

    public AbsoluteDirection absoluteDirection(Piece piece, Position position) {
        AbsoluteDirection[] absoluteDirectionArray = AbsoluteDirection.values();
        int n = absoluteDirectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            int colInc;
            int rowInc;
            AbsoluteDirection absDir = absoluteDirectionArray[n2];
            int curRow = this.getPosition(piece).getRow();
            int curCol = this.getPosition(piece).getCol();
            switch (absDir) {
                case N: 
                case NW: 
                case NE: {
                    rowInc = -1;
                    break;
                }
                case S: 
                case SW: 
                case SE: {
                    rowInc = 1;
                    break;
                }
                default: {
                    rowInc = 0;
                }
            }
            switch (absDir) {
                case W: 
                case NW: 
                case SW: {
                    colInc = -1;
                    break;
                }
                case E: 
                case NE: 
                case SE: {
                    colInc = 1;
                    break;
                }
                default: {
                    colInc = 0;
                }
            }
            do {
                if (curRow != position.getRow() || curCol != position.getCol()) continue;
                return absDir;
            } while (this.isValidSpace(curRow += rowInc, curCol += colInc));
            ++n2;
        }
        return null;
    }

    public void move(Piece piece, Position toPos) {
        Position fromPos = this.getPosition(piece);
        this.move(fromPos, toPos);
    }

    public void move(Piece piece, int toRow, int toCol) {
        Position fromPos = this.getPosition(piece);
        this.move(fromPos.getRow(), fromPos.getCol(), toRow, toCol);
    }

    public void move(Position fromPos, Position toPos) {
        this.move(fromPos.getRow(), fromPos.getCol(), toPos.getRow(), toPos.getCol());
    }

    public void move(int fromRow, int fromCol, int toRow, int toCol) {
        Piece piece = this.getPiece(fromRow, fromCol);
        this.pieces[fromRow][fromCol] = null;
        this.pieces[toRow][toCol] = piece;
        piece.markMoved(true);
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                if (this.pieces[i][j] != null && this.pieces[i][j].getPlayerType() == piece.getPlayerType() && this.pieces[i][j] != piece) {
                    piece.markMoved(false);
                }
                ++j;
            }
            ++i;
        }
    }

    public void remove(Piece piece) {
        this.remove(this.getPosition(piece));
    }

    public void remove(Position pos) {
        this.remove(pos.getRow(), pos.getCol());
    }

    public void remove(int row, int col) {
        this.pieces[row][col] = null;
    }

    public void invert() {
        Board.setTopPlayerType(Board.getBottomPlayerType());
        Piece[][] newPieces = new Piece[this.rows][this.cols];
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                newPieces[i][j] = this.pieces[this.rows - (i + 1)][this.cols - (j + 1)];
                ++j;
            }
            ++i;
        }
        this.pieces = newPieces;
    }

    public static PlayerType getTopPlayerType() {
        return topPlayerType;
    }

    public static PlayerType getBottomPlayerType() {
        return bottomPlayerType;
    }

    public static void setTopPlayerType(PlayerType playerType) {
        topPlayerType = playerType;
        bottomPlayerType = topPlayerType == PlayerType.BLACK ? PlayerType.WHITE : PlayerType.BLACK;
    }

    public static void setBottomPlayerType(PlayerType playerType) {
        bottomPlayerType = playerType;
        topPlayerType = bottomPlayerType == PlayerType.BLACK ? PlayerType.WHITE : PlayerType.BLACK;
    }

    public Board clone() {
        Board copy = new Board(this.rows, this.cols, this.pattern);
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                copy.pieces[i][j] = this.pieces[i][j] == null ? null : this.pieces[i][j].clone();
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public String toString() {
        String str = "";
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                Piece piece = this.pieces[i][j];
                str = piece == null ? String.valueOf(str) + " " : (piece.getPlayerType() == PlayerType.BLACK ? String.valueOf(str) + "B" : String.valueOf(str) + "W");
                ++j;
            }
            str = String.valueOf(str) + "\n";
            ++i;
        }
        return str;
    }
}

