/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.checkers.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.util.Duration;
import tech.octopusdragon.checkers.control.BoardGraphic;
import tech.octopusdragon.checkers.control.GhostPieceGraphic;
import tech.octopusdragon.checkers.control.PieceGraphic;
import tech.octopusdragon.checkers.model.Board;
import tech.octopusdragon.checkers.model.Capture;
import tech.octopusdragon.checkers.model.Checkers;
import tech.octopusdragon.checkers.model.ComputerPlayer;
import tech.octopusdragon.checkers.model.Config;
import tech.octopusdragon.checkers.model.Move;
import tech.octopusdragon.checkers.model.Piece;
import tech.octopusdragon.checkers.model.Player;
import tech.octopusdragon.checkers.model.PlayerType;
import tech.octopusdragon.checkers.model.Position;
import tech.octopusdragon.checkers.model.rules.StartingPlayer;
import tech.octopusdragon.checkers.window.NewGameDialog;
import tech.octopusdragon.checkers.window.StartingPlayerDialog;
import tech.octopusdragon.checkers.window.VariantInfoWindow;

public class GameRootController {
    private static final double MOVE_DURATION = 900.0;
    private static final double CAPTURE_DELAY = 100.0;
    private static final double REMOVE_SCALE = 2.0;
    private static final double REMOVE_DURATION = 450.0;
    private static final double MESSAGE_GRAPHIC_SIZE = 3.0;
    private static final long CHANGING_MESSAGE_TIMEOUT = 1000L;
    private Checkers game;
    private boolean selected;
    private Position selectedPos;
    private boolean dragging;
    private PieceGraphic draggedPiece;
    private PieceGraphic dragPiece;
    private List<Animation> runningAnimations;
    private List<Thread> runningThreads;
    @FXML
    private BorderPane root;
    @FXML
    private StackPane outerContainer;
    @FXML
    private StackPane innerContainer;
    @FXML
    private StackPane boardContainer;
    @FXML
    private StackPane topPane;
    @FXML
    private StackPane bottomPane;
    @FXML
    private CheckMenuItem highlightMovesMenuItem;
    @FXML
    private CheckMenuItem blackComputerPlayerCheckMenuItem;
    @FXML
    private CheckMenuItem whiteComputerPlayerCheckMenuItem;
    @FXML
    private Slider blackDifficultySlider;
    @FXML
    private Slider whiteDifficultySlider;
    private Map<PlayerType, Button> endTurnButtons;
    @FXML
    private Button topPlayerEndTurnButton;
    @FXML
    private Button bottomPlayerEndTurnButton;
    private Map<PlayerType, Label> messageLabels;
    @FXML
    private Label topPlayerMessageLabel;
    @FXML
    private Label bottomPlayerMessageLabel;
    private BoardGraphic board;

    @FXML
    private void initialize() {
        this.runningAnimations = new ArrayList<Animation>();
        this.runningThreads = new ArrayList<Thread>();
        this.messageLabels = new HashMap<PlayerType, Label>();
        this.messageLabels.put(Board.getTopPlayerType(), this.topPlayerMessageLabel);
        this.messageLabels.put(Board.getBottomPlayerType(), this.bottomPlayerMessageLabel);
        this.endTurnButtons = new HashMap<PlayerType, Button>();
        this.endTurnButtons.put(Board.getTopPlayerType(), this.topPlayerEndTurnButton);
        this.endTurnButtons.put(Board.getBottomPlayerType(), this.bottomPlayerEndTurnButton);
        this.blackDifficultySlider.setValue(Config.getBlackDifficulty());
        this.whiteDifficultySlider.setValue(Config.getWhiteDifficulty());
        this.blackDifficultySlider.disableProperty().bind((ObservableValue)this.blackComputerPlayerCheckMenuItem.selectedProperty().not());
        this.whiteDifficultySlider.disableProperty().bind((ObservableValue)this.whiteComputerPlayerCheckMenuItem.selectedProperty().not());
        this.blackDifficultySlider.valueProperty().addListener((obs, oldVal, newVal) -> Config.setBlackDifficulty(newVal.doubleValue()));
        this.whiteDifficultySlider.valueProperty().addListener((obs, oldVal, newVal) -> Config.setWhiteDifficulty(newVal.doubleValue()));
        this.outerContainer.prefHeightProperty().bind((ObservableValue)((Pane)this.root.getCenter()).heightProperty().subtract((ObservableNumberValue)Bindings.max((ObservableNumberValue)this.topPlayerMessageLabel.heightProperty().multiply((ObservableNumberValue)this.topPlayerMessageLabel.scaleYProperty()).multiply(2), (ObservableNumberValue)this.topPlayerEndTurnButton.heightProperty().multiply((ObservableNumberValue)this.topPlayerEndTurnButton.scaleYProperty()).multiply(2))));
        this.innerContainer.scaleXProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)this.outerContainer.widthProperty().divide((ObservableNumberValue)this.innerContainer.widthProperty()), (ObservableNumberValue)this.outerContainer.prefHeightProperty().divide((ObservableNumberValue)this.innerContainer.heightProperty())));
        this.innerContainer.scaleYProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)this.outerContainer.widthProperty().divide((ObservableNumberValue)this.innerContainer.widthProperty()), (ObservableNumberValue)this.outerContainer.prefHeightProperty().divide((ObservableNumberValue)this.innerContainer.heightProperty())));
        for (Button endTurnButton : this.endTurnButtons.values()) {
            endTurnButton.scaleXProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)this.outerContainer.widthProperty().divide((ObservableNumberValue)this.innerContainer.widthProperty()), (ObservableNumberValue)this.outerContainer.heightProperty().divide((ObservableNumberValue)this.innerContainer.heightProperty())));
            endTurnButton.scaleYProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)this.outerContainer.widthProperty().divide((ObservableNumberValue)this.innerContainer.widthProperty()), (ObservableNumberValue)this.outerContainer.heightProperty().divide((ObservableNumberValue)this.innerContainer.heightProperty())));
        }
        this.topPlayerEndTurnButton.translateYProperty().bind((ObservableValue)this.topPlayerMessageLabel.heightProperty().multiply((ObservableNumberValue)Bindings.min((ObservableNumberValue)this.outerContainer.widthProperty().divide((ObservableNumberValue)this.innerContainer.widthProperty()), (ObservableNumberValue)this.outerContainer.heightProperty().divide((ObservableNumberValue)this.innerContainer.heightProperty()))).divide(2).subtract((ObservableNumberValue)this.topPlayerMessageLabel.heightProperty().divide(2)));
        this.bottomPlayerEndTurnButton.translateYProperty().bind((ObservableValue)this.bottomPlayerMessageLabel.heightProperty().multiply((ObservableNumberValue)Bindings.min((ObservableNumberValue)this.outerContainer.widthProperty().divide((ObservableNumberValue)this.innerContainer.widthProperty()), (ObservableNumberValue)this.outerContainer.heightProperty().divide((ObservableNumberValue)this.innerContainer.heightProperty()))).divide(2).subtract((ObservableNumberValue)this.bottomPlayerMessageLabel.heightProperty().divide(2)).negate());
        for (Label messageLabel : this.messageLabels.values()) {
            messageLabel.scaleXProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)this.outerContainer.widthProperty().divide((ObservableNumberValue)this.innerContainer.widthProperty()), (ObservableNumberValue)this.outerContainer.heightProperty().divide((ObservableNumberValue)this.innerContainer.heightProperty())));
            messageLabel.scaleYProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)this.outerContainer.widthProperty().divide((ObservableNumberValue)this.innerContainer.widthProperty()), (ObservableNumberValue)this.outerContainer.heightProperty().divide((ObservableNumberValue)this.innerContainer.heightProperty())));
        }
        this.topPlayerMessageLabel.translateXProperty().bind((ObservableValue)this.topPlayerMessageLabel.widthProperty().multiply((ObservableNumberValue)Bindings.min((ObservableNumberValue)this.outerContainer.widthProperty().divide((ObservableNumberValue)this.innerContainer.widthProperty()), (ObservableNumberValue)this.outerContainer.heightProperty().divide((ObservableNumberValue)this.innerContainer.heightProperty()))).divide(2).subtract((ObservableNumberValue)this.topPlayerMessageLabel.widthProperty().divide(2)));
        this.topPlayerMessageLabel.translateYProperty().bind((ObservableValue)this.topPlayerMessageLabel.heightProperty().multiply((ObservableNumberValue)Bindings.min((ObservableNumberValue)this.outerContainer.widthProperty().divide((ObservableNumberValue)this.innerContainer.widthProperty()), (ObservableNumberValue)this.outerContainer.heightProperty().divide((ObservableNumberValue)this.innerContainer.heightProperty()))).divide(2).subtract((ObservableNumberValue)this.topPlayerMessageLabel.heightProperty().divide(2)));
        this.bottomPlayerMessageLabel.translateXProperty().bind((ObservableValue)this.bottomPlayerMessageLabel.widthProperty().multiply((ObservableNumberValue)Bindings.min((ObservableNumberValue)this.outerContainer.widthProperty().divide((ObservableNumberValue)this.innerContainer.widthProperty()), (ObservableNumberValue)this.outerContainer.heightProperty().divide((ObservableNumberValue)this.innerContainer.heightProperty()))).divide(2).subtract((ObservableNumberValue)this.bottomPlayerMessageLabel.widthProperty().divide(2)).negate());
        this.bottomPlayerMessageLabel.translateYProperty().bind((ObservableValue)this.bottomPlayerMessageLabel.heightProperty().multiply((ObservableNumberValue)Bindings.min((ObservableNumberValue)this.outerContainer.widthProperty().divide((ObservableNumberValue)this.innerContainer.widthProperty()), (ObservableNumberValue)this.outerContainer.heightProperty().divide((ObservableNumberValue)this.innerContainer.heightProperty()))).divide(2).subtract((ObservableNumberValue)this.bottomPlayerMessageLabel.heightProperty().divide(2)).negate());
    }

    public void newGame(Checkers game) {
        ((Stage)this.root.getScene().getWindow()).setTitle(game.getVariant().getName());
        this.game = game;
        this.selected = false;
        this.selectedPos = new Position();
        this.boardContainer.getChildren().clear();
        this.board = new BoardGraphic(game);
        this.boardContainer.getChildren().add((Object)this.board);
        int i = 0;
        while (i < game.getVariant().getRows()) {
            int j = 0;
            while (j < game.getVariant().getCols()) {
                this.board.getSpace(i, j).setOnMouseClicked((EventHandler)new ClickSpaceHandler());
                this.board.getSpace(i, j).setOnDragDetected((EventHandler)new DragDetectedSpaceHandler());
                this.board.getSpace(i, j).setOnMouseDragEntered((EventHandler)new DragEnteredSpaceHandler());
                this.board.getSpace(i, j).setOnMouseDragExited((EventHandler)new DragExitedSpaceHandler());
                this.board.getSpace(i, j).setOnMouseDragReleased((EventHandler)new DragReleasedSpaceHandler());
                ++j;
            }
            ++i;
        }
        this.boardContainer.setOnMouseDragOver((EventHandler)new DragOverSpaceHandler());
        this.root.setOnMouseReleased((EventHandler)new DragReleasedHandler());
        this.messageLabels.put(Board.getTopPlayerType(), this.topPlayerMessageLabel);
        this.messageLabels.put(Board.getBottomPlayerType(), this.bottomPlayerMessageLabel);
        this.endTurnButtons.put(Board.getTopPlayerType(), this.topPlayerEndTurnButton);
        this.endTurnButtons.put(Board.getBottomPlayerType(), this.bottomPlayerEndTurnButton);
        this.highlightMovesMenuItem.setSelected(Config.isHighlightMoves());
        this.blackComputerPlayerCheckMenuItem.setSelected(Config.isBlackComputerPlayer());
        this.whiteComputerPlayerCheckMenuItem.setSelected(Config.isWhiteComputerPlayer());
        this.updatePlayer();
    }

    private void highlightMoves() {
        if (this.selected) {
            this.highlightMovableSpaces();
        } else {
            this.highlightMovablePieces();
        }
    }

    private void highlightMovablePieces() {
        if (!Config.isHighlightMoves() || this.game.getCurPlayer().getType() == PlayerType.WHITE && Config.isWhiteComputerPlayer() || this.game.getCurPlayer().getType() == PlayerType.BLACK && Config.isBlackComputerPlayer()) {
            return;
        }
        for (Piece piece : this.game.movablePieces()) {
            int row = this.game.getBoard().getPosition(piece).getRow();
            int col = this.game.getBoard().getPosition(piece).getCol();
            this.board.getPiece(row, col).highlight();
            this.board.activateSpace(row, col);
        }
    }

    private void highlightMovableSpaces() {
        if (!Config.isHighlightMoves()) {
            return;
        }
        Piece piece = this.game.getBoard().getPiece(this.selectedPos);
        for (Move move : this.game.validMoves(piece)) {
            int row = move.getToPos().getRow();
            int col = move.getToPos().getCol();
            this.board.setPiece(row, col, new GhostPieceGraphic(this.board.getSquareSize()));
            this.board.activateSpace(row, col);
        }
    }

    private void removeHighlight() {
        int i = 0;
        while (i < this.game.getVariant().getRows()) {
            int j = 0;
            while (j < this.game.getVariant().getCols()) {
                if (this.board.getPiece(i, j) != null && this.board.getPiece(i, j) instanceof GhostPieceGraphic) {
                    this.board.removePiece(i, j);
                    this.board.deactivateSpace(i, j);
                } else if (this.board.getPiece(i, j) != null && this.board.getPiece(i, j).isHighlighted()) {
                    this.board.getPiece(i, j).deactivate();
                    this.board.deactivateSpace(i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    private void toggleHighlightMoves() {
        Config.setHighlightMoves(!Config.isHighlightMoves());
        if (Config.isHighlightMoves()) {
            this.highlightMoves();
        }
        if (!Config.isHighlightMoves()) {
            this.removeHighlight();
        }
    }

    private void selectPiece(int row, int col) {
        this.selectedPos.setRow(row);
        this.selectedPos.setCol(col);
        this.selected = true;
        int i = 0;
        while (i < this.game.getVariant().getRows()) {
            int j = 0;
            while (j < this.game.getVariant().getCols()) {
                if (this.board.getPiece(i, j) != null && this.board.getPiece(i, j).isActive()) {
                    this.board.getPiece(i, j).deactivate();
                    this.board.deactivateSpace(i, j);
                }
                ++j;
            }
            ++i;
        }
        if (this.game.canMove(this.game.getBoard().getPiece(row, col))) {
            this.board.getPiece(row, col).select();
        } else if (this.board.getPiece(row, col) != null && this.board.getPiece(row, col).isActive()) {
            this.board.getPiece(row, col).deactivate();
            this.board.deactivateSpace(row, col);
        }
    }

    private void deselect() {
        this.selected = false;
        int i = 0;
        while (i < this.game.getVariant().getRows()) {
            int j = 0;
            while (j < this.game.getVariant().getCols()) {
                if (this.board.getPiece(i, j) != null && this.board.getPiece(i, j) instanceof GhostPieceGraphic) {
                    this.board.removePiece(i, j);
                    this.board.deactivateSpace(i, j);
                } else if (this.board.getPiece(i, j) != null && this.board.getPiece(i, j).isActive()) {
                    this.board.getPiece(i, j).deactivate();
                    this.board.deactivateSpace(i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    private void move(Move move) {
        this.move(move.getFromPos().getRow(), move.getFromPos().getCol(), move.getToPos().getRow(), move.getToPos().getCol());
    }

    private void move(int fromRow, int fromCol, int toRow, int toCol) {
        Piece piece = this.game.getBoard().getPiece(fromRow, fromCol);
        this.game.move(piece, toRow, toCol);
        if (piece.isKing()) {
            this.board.getPiece(toRow, toCol).crown();
        }
        if (this.game.isOver()) {
            this.displayMessage();
            for (Button endTurnButton : this.endTurnButtons.values()) {
                endTurnButton.setVisible(false);
            }
        } else if (this.game.canCapture(piece)) {
            if (this.game.getCurPlayer().getType() == PlayerType.WHITE && Config.isWhiteComputerPlayer() || this.game.getCurPlayer().getType() == PlayerType.BLACK && Config.isBlackComputerPlayer()) {
                this.computerMove();
            } else {
                this.selectPiece(toRow, toCol);
                this.highlightMovableSpaces();
            }
        } else {
            this.updatePlayer();
        }
        if (this.game.getVariant().isHuffing() && this.game.hasCaptured()) {
            this.endTurnButtons.get((Object)piece.getPlayerType()).setVisible(true);
        } else if (this.game.getVariant().isHuffing()) {
            this.endTurn();
        }
        this.game.serialize();
    }

    private void updatePlayer() {
        this.displayMessage();
        for (Button endTurnButton : this.endTurnButtons.values()) {
            endTurnButton.setVisible(false);
        }
        if (!this.game.isOver() && this.game.getCurPlayer().getType() == PlayerType.WHITE && Config.isWhiteComputerPlayer() || this.game.getCurPlayer().getType() == PlayerType.BLACK && Config.isBlackComputerPlayer()) {
            this.computerMove();
        }
        this.deselect();
        if (!this.game.isOver()) {
            this.highlightMovablePieces();
        }
    }

    private void computerMove() {
        final Thread messageThread = new Thread(){

            @Override
            public void run() {
                int periods = 0;
                boolean running = true;
                while (running) {
                    String suffix = "";
                    int i = 0;
                    while (i < periods) {
                        suffix = String.valueOf(suffix) + ".";
                        ++i;
                    }
                    if (++periods > 3) {
                        periods = 0;
                    }
                    String FINAL_SUFFIX = suffix;
                    Platform.runLater(() -> GameRootController.this.displayMessage("Computer player thinking" + FINAL_SUFFIX + "\t"));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        running = false;
                    }
                }
                GameRootController.this.runningThreads.remove(this);
            }
        };
        messageThread.setDaemon(true);
        this.runningThreads.add(messageThread);
        messageThread.start();
        Thread thread = new Thread(){

            @Override
            public void run() {
                Move computerMove;
                try {
                    computerMove = ComputerPlayer.getMove(GameRootController.this.game, GameRootController.this.computerDifficulty());
                }
                catch (InterruptedException e) {
                    GameRootController.this.runningThreads.remove(this);
                    return;
                }
                messageThread.interrupt();
                Platform.runLater(() -> {
                    Animation moveAnimation = GameRootController.this.moveAnimation(computerMove);
                    moveAnimation.setOnFinished(e -> GameRootController.this.move(computerMove));
                    GameRootController.this.displayMessage();
                    GameRootController.this.play(moveAnimation);
                });
                GameRootController.this.runningThreads.remove(this);
            }
        };
        thread.setDaemon(true);
        this.runningThreads.add(thread);
        thread.start();
    }

    private void displayMessage() {
        PlayerType[] playerTypeArray = PlayerType.values();
        int n = playerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlayerType playerType = playerTypeArray[n2];
            Label messageLabel = this.messageLabels.get((Object)playerType);
            Platform.runLater(() -> {
                if (!this.game.isOver()) {
                    messageLabel.setGraphic((Node)new PieceGraphic(new Piece(this.game.getCurPlayer().getType().manPiece()), messageLabel.getFont().getSize() * 3.0));
                } else {
                    messageLabel.setGraphic((Node)new PieceGraphic(new Piece(playerType.manPiece()), messageLabel.getFont().getSize() * 3.0));
                }
            });
            if (this.game.isOver()) {
                Player winner = this.game.winner();
                if (winner == null) {
                    messageLabel.setText("It is a draw.");
                } else if (playerType == winner.getType()) {
                    messageLabel.setText("You win!");
                } else {
                    messageLabel.setText("You lose.");
                }
            } else if (playerType == this.game.getCurPlayer().getType()) {
                messageLabel.setText("Your turn");
            } else {
                messageLabel.setText("Opponent's turn");
            }
            ++n2;
        }
    }

    private void displayMessage(String message) {
        PlayerType[] playerTypeArray = PlayerType.values();
        int n = playerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlayerType playerType = playerTypeArray[n2];
            Label messageLabel = this.messageLabels.get((Object)playerType);
            messageLabel.setText(message);
            ++n2;
        }
    }

    private void endTurn() {
        if (!this.game.getVariant().isHuffing() || !this.game.hasMoved()) {
            return;
        }
        if (this.game.missedCapture()) {
            Position piecePosition = this.game.getBoard().getPosition(this.game.missedCapturePiece());
            int pieceRow = piecePosition.getRow();
            int pieceCol = piecePosition.getCol();
            this.removeAnimation(pieceRow, pieceCol);
        } else {
            this.play(this.delayedCaptureAnimation());
        }
        this.game.endTurn();
        this.updatePlayer();
    }

    private Animation moveAnimation(Move move) {
        return this.moveAnimation(move.getFromPos().getRow(), move.getFromPos().getCol(), move.getToPos().getRow(), move.getToPos().getCol());
    }

    private Animation moveAnimation(int fromRow, int fromCol, int toRow, int toCol) {
        ObservableList children;
        ParallelTransition trans;
        Piece piece = this.game.getBoard().getPiece(fromRow, fromCol);
        if (this.game.getVariant().isRemovePiecesImmediately()) {
            ParallelTransition ptrans;
            trans = ptrans = new ParallelTransition();
            children = ptrans.getChildren();
        } else {
            SequentialTransition strans = new SequentialTransition();
            trans = strans;
            children = strans.getChildren();
        }
        PieceGraphic playerPiece = this.board.getPiece(fromRow, fromCol);
        PieceGraphic tempPlayerPiece = new PieceGraphic(piece, this.board.getSquareSize());
        StackPane.setAlignment((Node)tempPlayerPiece, (Pos)Pos.TOP_LEFT);
        TranslateTransition ttrans = new TranslateTransition(Duration.millis((double)900.0), (Node)tempPlayerPiece);
        ttrans.setFromX(this.getPieceX(fromRow, fromCol));
        ttrans.setFromY(this.getPieceY(fromRow, fromCol));
        ttrans.setToX(this.getDestinationX(fromRow, fromCol, toRow, toCol));
        ttrans.setToY(this.getDestinationY(fromRow, fromCol, toRow, toCol));
        children.add((Object)ttrans);
        ttrans.setOnFinished(e -> {
            this.board.setPiece(toRow, toCol, playerPiece);
            this.boardContainer.getChildren().remove((Object)tempPlayerPiece);
        });
        if (this.game.isValidCapture(piece, toRow, toCol) && this.game.getVariant().isRemovePiecesImmediately()) {
            children.add((Object)this.immediateCaptureAnimation(fromRow, fromCol, toRow, toCol));
        } else if (this.game.isValidCapture(piece, toRow, toCol) && !this.game.canMultiCapture(piece) && !this.game.getVariant().isHuffing()) {
            Piece capturedPiece = null;
            for (Capture capture : this.game.validCaptures(piece)) {
                if (capture.getToPos().getRow() != toRow || capture.getToPos().getCol() != toCol) continue;
                Position curCapturedPos = capture.getCapturePos();
                capturedPiece = this.game.getBoard().getPiece(curCapturedPos);
                break;
            }
            children.add((Object)this.delayedCaptureAnimation(capturedPiece));
        }
        this.boardContainer.getChildren().add((Object)tempPlayerPiece);
        this.board.removePiece(fromRow, fromCol);
        return trans;
    }

    private Animation delayedCaptureAnimation() {
        return this.delayedCaptureAnimation(null);
    }

    private Animation delayedCaptureAnimation(Piece curCapturedPiece) {
        ParallelTransition ptrans = new ParallelTransition();
        ArrayList<Piece> capturedPieces = new ArrayList<Piece>(this.game.getCapturedPieces());
        if (curCapturedPiece != null) {
            capturedPieces.add(curCapturedPiece);
        }
        int i = 0;
        while (i < capturedPieces.size()) {
            Position capturedPos = this.game.getBoard().getPosition((Piece)capturedPieces.get(i));
            int capturedRow = capturedPos.getRow();
            int capturedCol = capturedPos.getCol();
            PieceGraphic tempOpponentPiece = new PieceGraphic(this.game.getBoard().getPiece(capturedRow, capturedCol), this.board.getSquareSize());
            StackPane.setAlignment((Node)tempOpponentPiece, (Pos)Pos.TOP_LEFT);
            tempOpponentPiece.setTranslateX(this.getPieceX(capturedRow, capturedCol));
            tempOpponentPiece.setTranslateY(this.getPieceY(capturedRow, capturedCol));
            FadeTransition ftrans = new FadeTransition(Duration.millis((double)450.0), (Node)tempOpponentPiece);
            ftrans.setDelay(Duration.millis((double)(100.0 * (double)i)));
            ftrans.setToValue(0.0);
            ptrans.getChildren().add((Object)ftrans);
            ScaleTransition strans = new ScaleTransition(Duration.millis((double)450.0), (Node)tempOpponentPiece);
            strans.setDelay(Duration.millis((double)(100.0 * (double)i)));
            strans.setByX(2.0);
            strans.setByY(2.0);
            ptrans.getChildren().add((Object)strans);
            ftrans.setOnFinished(e -> this.boardContainer.getChildren().remove((Object)tempOpponentPiece));
            this.boardContainer.getChildren().add((Object)tempOpponentPiece);
            this.board.removePiece(capturedRow, capturedCol);
            ++i;
        }
        return ptrans;
    }

    private Animation immediateCaptureAnimation(int fromRow, int fromCol, int toRow, int toCol) {
        Piece piece = this.game.getBoard().getPiece(fromRow, fromCol);
        Piece capturedPiece = null;
        for (Capture capture : this.game.validCaptures(piece)) {
            if (capture.getToPos().getRow() != toRow || capture.getToPos().getCol() != toCol) continue;
            Position curCapturedPos = capture.getCapturePos();
            capturedPiece = this.game.getBoard().getPiece(curCapturedPos);
            break;
        }
        ParallelTransition ptrans = new ParallelTransition();
        Position capturedPos = this.game.getBoard().getPosition(capturedPiece);
        int capturedRow = capturedPos.getRow();
        int capturedCol = capturedPos.getCol();
        PieceGraphic tempOpponentPiece = new PieceGraphic(this.game.getBoard().getPiece(capturedRow, capturedCol), this.board.getSquareSize());
        StackPane.setAlignment((Node)tempOpponentPiece, (Pos)Pos.TOP_LEFT);
        tempOpponentPiece.setTranslateX(this.getPieceX(capturedRow, capturedCol));
        tempOpponentPiece.setTranslateY(this.getPieceY(capturedRow, capturedCol));
        double duration = 900.0;
        if (this.game.getVariant().isRemovePiecesImmediately()) {
            double moveDistanceX = Math.abs(this.getDestinationX(fromRow, fromCol, toRow, toCol) - this.getPieceX(fromRow, fromCol));
            double moveDistanceY = Math.abs(this.getDestinationY(fromRow, fromCol, toRow, toCol) - this.getPieceY(fromRow, fromCol));
            double moveDistance = Math.sqrt(Math.pow(moveDistanceX, 2.0) + Math.pow(moveDistanceY, 2.0));
            double captureDistanceX = Math.abs(this.getPieceX(capturedRow, capturedCol) - this.getPieceX(fromRow, fromCol));
            double captureDistanceY = Math.abs(this.getPieceY(capturedRow, capturedCol) - this.getPieceY(fromRow, fromCol));
            double captureDistance = Math.sqrt(Math.pow(captureDistanceX, 2.0) + Math.pow(captureDistanceY, 2.0));
            double captureDistanceProportion = captureDistance / moveDistance;
            duration *= captureDistanceProportion;
        }
        FadeTransition ftrans = new FadeTransition(Duration.millis((double)450.0), (Node)tempOpponentPiece);
        ftrans.setDelay(Duration.millis((double)duration));
        ftrans.setToValue(0.0);
        ptrans.getChildren().add((Object)ftrans);
        ScaleTransition strans = new ScaleTransition(Duration.millis((double)450.0), (Node)tempOpponentPiece);
        strans.setDelay(Duration.millis((double)duration));
        strans.setByX(2.0);
        strans.setByY(2.0);
        ptrans.getChildren().add((Object)strans);
        ftrans.setOnFinished(e -> this.boardContainer.getChildren().remove((Object)tempOpponentPiece));
        this.boardContainer.getChildren().add((Object)tempOpponentPiece);
        this.board.removePiece(capturedRow, capturedCol);
        return ptrans;
    }

    private void removeAnimation(int row, int col) {
        ParallelTransition ptrans = new ParallelTransition();
        PieceGraphic tempPiece = new PieceGraphic(this.game.getBoard().getPiece(row, col), this.board.getSquareSize());
        StackPane.setAlignment((Node)tempPiece, (Pos)Pos.TOP_LEFT);
        tempPiece.setTranslateX(this.getPieceX(row, col));
        tempPiece.setTranslateY(this.getPieceY(row, col));
        FadeTransition ftrans = new FadeTransition(Duration.millis((double)450.0), (Node)tempPiece);
        ftrans.setToValue(0.0);
        ptrans.getChildren().add((Object)ftrans);
        ScaleTransition strans = new ScaleTransition(Duration.millis((double)450.0), (Node)tempPiece);
        strans.setByX(2.0);
        strans.setByY(2.0);
        ptrans.getChildren().add((Object)strans);
        ftrans.setOnFinished(e -> this.boardContainer.getChildren().remove((Object)tempPiece));
        this.boardContainer.getChildren().add((Object)tempPiece);
        this.board.removePiece(row, col);
        this.play((Animation)ptrans);
    }

    private void play(Animation animation) {
        ParallelTransition wrapper = new ParallelTransition(new Animation[]{animation});
        this.runningAnimations.add(animation);
        wrapper.setOnFinished(event -> this.runningAnimations.remove(animation));
        wrapper.play();
    }

    private boolean isAnimationRunning() {
        return !this.runningAnimations.isEmpty();
    }

    private void refresh() {
        int i = 0;
        while (i < this.game.getBoard().getRows()) {
            int j = 0;
            while (j < this.game.getBoard().getCols()) {
                Piece piece = this.game.getBoard().getPiece(i, j);
                if (piece == null) {
                    this.board.removePiece(i, j);
                } else {
                    this.board.setPiece(i, j, new PieceGraphic(piece, this.board.getSquareSize()));
                }
                ++j;
            }
            ++i;
        }
    }

    private double getSpaceX(int row, int col) {
        return this.board.getLayoutX() + this.board.getSpace(row, col).getLayoutX();
    }

    private double getSpaceY(int row, int col) {
        return this.board.getLayoutY() + this.board.getSpace(row, col).getLayoutY();
    }

    private double getPieceX(int row, int col) {
        return this.board.getLayoutX() + this.board.getSpace(row, col).getLayoutX() + this.board.getPiece(row, col).getLayoutX();
    }

    private double getPieceY(int row, int col) {
        return this.board.getLayoutY() + this.board.getSpace(row, col).getLayoutY() + this.board.getPiece(row, col).getLayoutY();
    }

    private double getDestinationX(int fromRow, int fromCol, int toRow, int toCol) {
        return this.board.getLayoutX() + this.board.getSpace(toRow, toCol).getLayoutX() + this.board.getPiece(fromRow, fromCol).getLayoutX();
    }

    private double getDestinationY(int fromRow, int fromCol, int toRow, int toCol) {
        return this.board.getLayoutY() + this.board.getSpace(toRow, toCol).getLayoutY() + this.board.getPiece(fromRow, fromCol).getLayoutY();
    }

    @FXML
    private void newGame(ActionEvent event) {
        this.newGame();
    }

    @FXML
    private void restartGame(ActionEvent event) {
        this.restartGame();
    }

    @FXML
    private void showInfo(ActionEvent event) {
        this.showInfo();
    }

    @FXML
    private void exit(ActionEvent event) {
        Platform.exit();
    }

    @FXML
    private void undoMove(ActionEvent event) {
        this.undoMove();
    }

    @FXML
    private void undoAllMoves(ActionEvent event) {
        this.undoAllMoves();
    }

    @FXML
    private void redoMove(ActionEvent event) {
        this.redoMove();
    }

    @FXML
    private void redoAllMoves(ActionEvent event) {
        this.redoAllMoves();
    }

    @FXML
    private void invertBoard(ActionEvent event) {
        this.invertBoard();
    }

    @FXML
    private void toggleHighlightMoves(ActionEvent event) {
        this.toggleHighlightMoves();
    }

    @FXML
    private void toggleBlackComputerPlayer(ActionEvent event) {
        Config.setBlackComputerPlayer(!Config.isBlackComputerPlayer());
        if (this.game.getCurPlayer().getType() == PlayerType.BLACK && !this.isAnimationRunning()) {
            this.removeHighlight();
            this.computerMove();
        }
    }

    @FXML
    private void toggleWhiteComputerPlayer(ActionEvent event) {
        Config.setWhiteComputerPlayer(!Config.isWhiteComputerPlayer());
        if (this.game.getCurPlayer().getType() == PlayerType.WHITE && !this.isAnimationRunning()) {
            this.removeHighlight();
            this.computerMove();
        }
    }

    @FXML
    private void endTurn(ActionEvent event) {
        this.endTurn();
    }

    private void newGame() {
        Optional result = new NewGameDialog().showAndWait();
        if (result.isPresent()) {
            for (Thread thread : this.runningThreads) {
                thread.interrupt();
            }
            this.newGame((Checkers)result.get());
        }
    }

    private void restartGame() {
        Checkers newGame = new Checkers(this.game.getVariant());
        if (this.game.getVariant().getStartingPlayer() == StartingPlayer.EITHER) {
            Optional startingPlayerResult = new StartingPlayerDialog().showAndWait();
            if (startingPlayerResult.isPresent()) {
                PlayerType startingPlayer = (PlayerType)((Object)startingPlayerResult.get());
                this.game.setStartingPlayer(startingPlayer);
            } else {
                return;
            }
        }
        this.newGame(newGame);
    }

    private void showInfo() {
        new VariantInfoWindow(this.game.getVariant()).showAndWait();
    }

    private void undoMove() {
        if (this.isAnimationRunning()) {
            return;
        }
        this.deselect();
        this.game.undoTurn();
        if (this.game.getCurPlayer().getType() == PlayerType.BLACK && Config.isBlackComputerPlayer() || this.game.getCurPlayer().getType() == PlayerType.WHITE && Config.isWhiteComputerPlayer()) {
            this.game.undoTurn();
        }
        this.refresh();
        this.updatePlayer();
    }

    private void undoAllMoves() {
        if (this.isAnimationRunning()) {
            return;
        }
        this.deselect();
        this.game.undoAllTurns();
        this.refresh();
        this.updatePlayer();
    }

    private void redoMove() {
        if (this.isAnimationRunning()) {
            return;
        }
        this.deselect();
        this.game.redoTurn();
        this.refresh();
        this.updatePlayer();
    }

    private void redoAllMoves() {
        if (this.isAnimationRunning()) {
            return;
        }
        this.deselect();
        this.game.redoAllTurns();
        this.refresh();
        this.updatePlayer();
    }

    private double computerDifficulty() {
        if (this.game.getCurPlayer().getType() == PlayerType.WHITE && Config.isWhiteComputerPlayer()) {
            return Config.getWhiteDifficulty();
        }
        if (this.game.getCurPlayer().getType() == PlayerType.BLACK && Config.isBlackComputerPlayer()) {
            return Config.getBlackDifficulty();
        }
        return 0.0;
    }

    public void invertBoard() {
        if (this.isAnimationRunning()) {
            return;
        }
        this.deselect();
        this.game.getBoard().invert();
        this.board.invert();
        this.refresh();
        this.highlightMovablePieces();
        this.messageLabels.put(Board.getTopPlayerType(), this.topPlayerMessageLabel);
        this.messageLabels.put(Board.getBottomPlayerType(), this.bottomPlayerMessageLabel);
        this.endTurnButtons.put(Board.getTopPlayerType(), this.topPlayerEndTurnButton);
        this.endTurnButtons.put(Board.getBottomPlayerType(), this.bottomPlayerEndTurnButton);
        this.displayMessage();
        boolean topEndTurnButtonVisible = this.topPlayerEndTurnButton.isVisible();
        boolean bottomEndTurnButtonVisible = this.bottomPlayerEndTurnButton.isVisible();
        this.topPlayerEndTurnButton.setVisible(bottomEndTurnButtonVisible);
        this.bottomPlayerEndTurnButton.setVisible(topEndTurnButtonVisible);
    }

    private class ClickSpaceHandler
    implements EventHandler<MouseEvent> {
        private ClickSpaceHandler() {
        }

        public void handle(MouseEvent event) {
            if (GameRootController.this.game.isOver() || !event.isStillSincePress()) {
                return;
            }
            Piece selectedPiece = null;
            if (GameRootController.this.selected) {
                selectedPiece = GameRootController.this.game.getBoard().getPiece(GameRootController.this.selectedPos.getRow(), GameRootController.this.selectedPos.getCol());
            }
            int row = GridPane.getRowIndex((Node)((Node)event.getSource()));
            int col = GridPane.getColumnIndex((Node)((Node)event.getSource()));
            Piece piece = GameRootController.this.game.getBoard().getPiece(row, col);
            if (GameRootController.this.selected && !GameRootController.this.game.isValidMove(selectedPiece, row, col)) {
                GameRootController.this.deselect();
                GameRootController.this.highlightMovablePieces();
            } else if (!GameRootController.this.selected && piece != null && GameRootController.this.game.canMove(piece)) {
                GameRootController.this.selectPiece(row, col);
                GameRootController.this.highlightMovableSpaces();
            } else if (GameRootController.this.selected) {
                GameRootController.this.deselect();
                Animation moveAnimation = GameRootController.this.moveAnimation(GameRootController.this.selectedPos.getRow(), GameRootController.this.selectedPos.getCol(), row, col);
                moveAnimation.setOnFinished(e -> GameRootController.this.move(GameRootController.this.selectedPos.getRow(), GameRootController.this.selectedPos.getCol(), row, col));
                GameRootController.this.play(moveAnimation);
            }
        }
    }

    private class DragDetectedSpaceHandler
    implements EventHandler<MouseEvent> {
        private DragDetectedSpaceHandler() {
        }

        public void handle(MouseEvent event) {
            if (GameRootController.this.game.isOver()) {
                return;
            }
            int row = GridPane.getRowIndex((Node)((Node)event.getSource()));
            int col = GridPane.getColumnIndex((Node)((Node)event.getSource()));
            Piece piece = GameRootController.this.game.getBoard().getPiece(row, col);
            if (piece == null || piece.getPlayerType() != GameRootController.this.game.getCurPlayer().getType() || !GameRootController.this.game.canMove(piece)) {
                return;
            }
            GameRootController.this.deselect();
            GameRootController.this.selectedPos = new Position(row, col);
            GameRootController.this.highlightMovableSpaces();
            GameRootController.this.dragPiece = new PieceGraphic(piece, GameRootController.this.board.getSquareSize());
            StackPane.setAlignment((Node)GameRootController.this.dragPiece, (Pos)Pos.TOP_LEFT);
            GameRootController.this.dragPiece.setTranslateX(GameRootController.this.getSpaceX(row, col) + event.getX() - GameRootController.this.dragPiece.getRadius());
            GameRootController.this.dragPiece.setTranslateY(GameRootController.this.getSpaceY(row, col) + event.getY() - GameRootController.this.dragPiece.getRadius());
            GameRootController.this.boardContainer.getChildren().add((Object)GameRootController.this.dragPiece);
            GameRootController.this.draggedPiece = GameRootController.this.board.getPiece(row, col);
            GameRootController.this.board.removePiece(row, col);
            GameRootController.this.dragPiece.startFullDrag();
            GameRootController.this.dragPiece.setMouseTransparent(true);
            GameRootController.this.dragging = true;
        }
    }

    private class DragEnteredSpaceHandler
    implements EventHandler<MouseDragEvent> {
        private DragEnteredSpaceHandler() {
        }

        public void handle(MouseDragEvent event) {
            int row = GridPane.getRowIndex((Node)((Node)event.getSource()));
            int col = GridPane.getColumnIndex((Node)((Node)event.getSource()));
            GameRootController.this.board.getSquare(row, col).getStyleClass().add((Object)"hovered");
        }
    }

    private class DragExitedSpaceHandler
    implements EventHandler<MouseDragEvent> {
        private DragExitedSpaceHandler() {
        }

        public void handle(MouseDragEvent event) {
            int row = GridPane.getRowIndex((Node)((Node)event.getSource()));
            int col = GridPane.getColumnIndex((Node)((Node)event.getSource()));
            GameRootController.this.board.getSquare(row, col).getStyleClass().remove((Object)"hovered");
        }
    }

    private class DragOverSpaceHandler
    implements EventHandler<MouseDragEvent> {
        private DragOverSpaceHandler() {
        }

        public void handle(MouseDragEvent event) {
            GameRootController.this.dragPiece.setTranslateX(event.getX() - GameRootController.this.dragPiece.getRadius());
            GameRootController.this.dragPiece.setTranslateY(event.getY() - GameRootController.this.dragPiece.getRadius());
        }
    }

    private class DragReleasedHandler
    implements EventHandler<MouseEvent> {
        private DragReleasedHandler() {
        }

        public void handle(MouseEvent event) {
            if (!GameRootController.this.dragging) {
                return;
            }
            GameRootController.this.boardContainer.getChildren().remove((Object)GameRootController.this.dragPiece);
            GameRootController.this.board.setPiece(GameRootController.this.selectedPos.getRow(), GameRootController.this.selectedPos.getCol(), GameRootController.this.draggedPiece);
            GameRootController.this.dragging = false;
            GameRootController.this.deselect();
            GameRootController.this.highlightMovablePieces();
        }
    }

    private class DragReleasedSpaceHandler
    implements EventHandler<MouseDragEvent> {
        private DragReleasedSpaceHandler() {
        }

        public void handle(MouseDragEvent event) {
            int row = GridPane.getRowIndex((Node)((Node)event.getSource()));
            int col = GridPane.getColumnIndex((Node)((Node)event.getSource()));
            if (!GameRootController.this.game.isValidMove(GameRootController.this.dragPiece.getPiece(), row, col)) {
                GameRootController.this.board.setPiece(GameRootController.this.selectedPos.getRow(), GameRootController.this.selectedPos.getCol(), GameRootController.this.draggedPiece);
            } else {
                if (GameRootController.this.game.isValidCapture(GameRootController.this.draggedPiece.getPiece(), row, col) && GameRootController.this.game.getVariant().isRemovePiecesImmediately()) {
                    for (Capture capture : GameRootController.this.game.validCaptures(GameRootController.this.draggedPiece.getPiece())) {
                        if (capture.getToPos().getRow() != row || capture.getToPos().getCol() != col) continue;
                        Position capturedPos = capture.getCapturePos();
                        GameRootController.this.removeAnimation(capturedPos.getRow(), capturedPos.getCol());
                        break;
                    }
                } else if (GameRootController.this.game.isValidCapture(GameRootController.this.draggedPiece.getPiece(), row, col) && !GameRootController.this.game.canMultiCapture(GameRootController.this.draggedPiece.getPiece()) && !GameRootController.this.game.getVariant().isHuffing()) {
                    for (Capture capture : GameRootController.this.game.validCaptures(GameRootController.this.draggedPiece.getPiece())) {
                        if (capture.getToPos().getRow() != row || capture.getToPos().getCol() != col) continue;
                        Position capturedPos = capture.getCapturePos();
                        GameRootController.this.play(GameRootController.this.delayedCaptureAnimation(GameRootController.this.game.getBoard().getPiece(capturedPos)));
                        break;
                    }
                }
                GameRootController.this.deselect();
                GameRootController.this.board.setPiece(row, col, GameRootController.this.draggedPiece);
                GameRootController.this.boardContainer.getChildren().remove((Object)GameRootController.this.dragPiece);
                GameRootController.this.move(GameRootController.this.selectedPos.getRow(), GameRootController.this.selectedPos.getCol(), row, col);
            }
            GameRootController.this.boardContainer.getChildren().remove((Object)GameRootController.this.dragPiece);
            GameRootController.this.dragging = false;
            GameRootController.this.deselect();
            if (!GameRootController.this.game.isOver()) {
                GameRootController.this.highlightMovablePieces();
            }
        }
    }
}

