/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.checkers.control;

import java.io.IOException;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.util.Duration;
import tech.octopusdragon.checkers.model.Board;
import tech.octopusdragon.checkers.model.Piece;

public class PieceGraphic
extends Group {
    private static final double PIECE_RATIO = 0.82;
    private static final double EDGE_WIDTH = 1.0;
    private static final double CONCAVITY_WIDTH = 0.75;
    protected static final double FADE_DURATION = 1500.0;
    private static final String CROWN_IMAGE = "images/crown.png";
    private Piece piece;
    protected boolean highlighted;
    protected boolean selected;
    private double radius;
    @FXML
    private Circle outerCircle;
    @FXML
    private Circle innerCircle;
    @FXML
    private Circle concavity;
    private InnerShadow concavityShadow;
    private ImageView decal;
    @FXML
    private Circle decalMask;
    private DropShadow highlight;
    private DropShadow select;
    private static final StyleablePropertyFactory<PieceGraphic> FACTORY = new StyleablePropertyFactory(Group.getClassCssMetaData());
    private StyleableProperty<Color> colorProperty = new SimpleStyleableObjectProperty(COLOR, (Object)Color.GRAY);
    private static final CssMetaData<PieceGraphic, Color> COLOR = FACTORY.createColorCssMetaData("-color", s -> s.colorProperty);
    protected StyleableProperty<Color> highlightColorProperty = new SimpleStyleableObjectProperty(HIGHLIGHT_COLOR, (Object)Color.GRAY);
    private static final CssMetaData<PieceGraphic, Color> HIGHLIGHT_COLOR = FACTORY.createColorCssMetaData("-highlight-color", s -> s.highlightColorProperty);
    private StyleableProperty<Color> selectColorProperty = new SimpleStyleableObjectProperty(SELECT_COLOR, (Object)Color.GRAY);
    private static final CssMetaData<PieceGraphic, Color> SELECT_COLOR = FACTORY.createColorCssMetaData("-select-color", s -> s.selectColorProperty);

    protected PieceGraphic() {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/view/Piece.fxml"));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PieceGraphic(Piece piece, double size) {
        this();
        this.buildPiece(piece);
        this.resizePiece(size, size);
        Platform.runLater(() -> this.autosizePiece());
    }

    public PieceGraphic(Piece piece) {
        this();
        this.buildPiece(piece);
        Platform.runLater(() -> this.autosizePiece());
    }

    private void buildPiece(Piece piece) {
        if (piece.isBlack()) {
            this.getStyleClass().add((Object)"black");
        }
        if (piece.isWhite()) {
            this.getStyleClass().add((Object)"white");
        }
        if (piece.isMan()) {
            this.getStyleClass().add((Object)"man");
        }
        if (piece.isKing()) {
            this.getStyleClass().add((Object)"king");
        }
        this.piece = piece;
        this.highlighted = false;
        this.selected = false;
        this.decal = new ImageView(new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(CROWN_IMAGE)));
        this.decal.setPreserveRatio(true);
        if (piece.getPlayerType() == Board.getTopPlayerType()) {
            this.decal.setRotate(180.0);
        }
        this.decalMask.setClip((Node)this.decal);
        if (!piece.isKing()) {
            this.decalMask.setVisible(false);
        }
        this.concavityShadow = new InnerShadow();
        this.concavity.setEffect((Effect)this.concavityShadow);
        this.highlight = new DropShadow();
        this.highlight.setBlurType(BlurType.THREE_PASS_BOX);
        this.highlight.setColor((Color)this.highlightColorProperty.getValue());
        this.highlight.setSpread(0.8);
        this.select = new DropShadow();
        this.select.setBlurType(BlurType.THREE_PASS_BOX);
        this.select.setSpread(0.9);
        this.colorProperty().addListener((obs, oldVal, newVal) -> {
            double hue = newVal.getHue();
            double saturation = newVal.getSaturation();
            double brightness = newVal.getBrightness();
            Color color = newVal;
            Color edgeColor = Color.hsb((double)hue, (double)saturation, (double)(brightness * 0.5));
            Color innerShadowColor = Color.hsb((double)hue, (double)saturation, (double)(brightness > 0.1 ? brightness - 0.1 : 0.0));
            Color decalColor = Color.hsb((double)hue, (double)saturation, (double)(brightness >= 0.5 ? brightness - 0.25 : brightness + 0.25));
            this.outerCircle.setFill((Paint)edgeColor);
            this.innerCircle.setFill((Paint)color);
            this.concavity.setFill((Paint)color);
            this.concavityShadow.setColor(innerShadowColor);
            this.decalMask.setFill((Paint)decalColor);
        });
        this.highlightColorProperty().addListener((obs, oldVal, newVal) -> {
            this.highlight.setColor((Color)this.highlightColorProperty.getValue());
            if (this.highlighted) {
                this.deactivate();
                this.highlight();
            }
        });
        this.selectColorProperty().addListener((obs, oldVal, newVal) -> {
            this.select.setColor((Color)this.selectColorProperty.getValue());
            if (this.selected) {
                this.deactivate();
                this.select();
            }
        });
    }

    public Piece getPiece() {
        return this.piece;
    }

    public double getRadius() {
        return this.radius;
    }

    public boolean isActive() {
        return this.selected || this.highlighted;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void highlight() {
        if (this.highlighted) {
            return;
        }
        this.selected = false;
        this.getStyleClass().remove((Object)"selected");
        this.highlighted = true;
        this.getStyleClass().add((Object)"highlighted");
        this.setEffect((Effect)this.highlight);
        this.highlight.setColor((Color)this.highlightColorProperty().getValue());
        Timeline timeline = new Timeline();
        timeline.setCycleCount(-1);
        timeline.setAutoReverse(true);
        KeyValue kv = new KeyValue((WritableValue)this.highlight.colorProperty(), (Object)Color.web((String)this.highlight.getColor().toString(), (double)0.0));
        KeyFrame kf = new KeyFrame(Duration.millis((double)1500.0), new KeyValue[]{kv});
        timeline.getKeyFrames().add((Object)kf);
        timeline.play();
    }

    public void select() {
        if (this.selected) {
            return;
        }
        this.highlighted = false;
        this.getStyleClass().remove((Object)"highlighted");
        this.selected = true;
        this.getStyleClass().add((Object)"selected");
        this.setEffect((Effect)this.select);
    }

    public void deactivate() {
        this.selected = false;
        this.getStyleClass().remove((Object)"selected");
        this.highlighted = false;
        this.getStyleClass().remove((Object)"highlighted");
        this.setEffect(null);
    }

    public void crown() {
        this.decalMask.setVisible(true);
    }

    private void autosizePiece() {
        if (this.getParent() == null) {
            return;
        }
        Bounds bounds = this.getParent().getLayoutBounds();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        this.resize(width, height);
    }

    private void resizePiece(double width, double height) {
        double squareSize = Math.min(width, height);
        double pieceSize = squareSize * 0.82;
        this.radius = pieceSize / 2.0 - 0.5;
        this.outerCircle.setCenterX(this.radius);
        this.outerCircle.setCenterY(this.radius);
        this.outerCircle.setRadius(this.radius);
        this.innerCircle.setCenterX(this.radius);
        this.innerCircle.setCenterY(this.radius);
        this.innerCircle.setRadius(this.radius - 1.0);
        this.concavity.setCenterX(this.radius);
        this.concavity.setCenterY(this.radius);
        this.concavity.setRadius(this.radius * 0.75);
        this.concavityShadow.setRadius(this.radius);
        this.decal.setFitWidth(Math.sqrt(2.0) * this.radius);
        this.decal.setX(this.radius + this.radius * Math.sin(-0.7853981633974483));
        this.decal.setY(this.radius + this.radius * Math.cos(-2.356194490192345));
        this.decalMask.setCenterX(this.radius);
        this.decalMask.setCenterY(this.radius);
        this.decalMask.setRadius(this.radius);
        this.highlight.setRadius((squareSize - pieceSize) / 2.0);
        this.select.setRadius((squareSize - pieceSize) / 2.0);
    }

    public ObservableValue<Color> colorProperty() {
        return (ObservableValue)this.colorProperty;
    }

    public ObservableValue<Color> highlightColorProperty() {
        return (ObservableValue)this.highlightColorProperty;
    }

    public ObservableValue<Color> selectColorProperty() {
        return (ObservableValue)this.selectColorProperty;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FACTORY.getCssMetaData();
    }
}

