/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.checkers.control;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.WritableValue;
import javafx.geometry.Bounds;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.util.Duration;
import tech.octopusdragon.checkers.control.PieceGraphic;

public class GhostPieceGraphic
extends PieceGraphic {
    private static final double PIECE_RATIO = 0.55;
    private Circle piece;
    private BoxBlur blur;

    public GhostPieceGraphic(double size) {
        this.buildPiece();
        this.resizePiece(size, size);
        this.parentProperty().addListener((obs, oldVal, newVal) -> this.autosizePiece());
    }

    public GhostPieceGraphic() {
        this.buildPiece();
        this.parentProperty().addListener((obs, oldVal, newVal) -> this.autosizePiece());
        Platform.runLater(() -> this.autosizePiece());
    }

    private void buildPiece() {
        this.getStyleClass().add((Object)"ghost-piece");
        this.highlighted = false;
        this.selected = false;
        this.piece = new Circle();
        this.piece.setOpacity(0.8);
        this.getChildren().add((Object)this.piece);
        this.blur = new BoxBlur();
        this.blur.setIterations(2);
        this.setEffect((Effect)this.blur);
        Timeline timeline = new Timeline();
        timeline.setCycleCount(-1);
        timeline.setAutoReverse(true);
        KeyValue kv = new KeyValue((WritableValue)this.opacityProperty(), (Object)0.0);
        KeyFrame kf = new KeyFrame(Duration.millis((double)1500.0), new KeyValue[]{kv});
        timeline.getKeyFrames().add((Object)kf);
        timeline.play();
        this.highlightColorProperty().addListener((obs, oldVal, newVal) -> this.piece.setFill((Paint)this.highlightColorProperty.getValue()));
    }

    private void autosizePiece() {
        if (this.getParent() == null) {
            return;
        }
        Bounds bounds = this.getParent().getLayoutBounds();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        this.resize(width, height);
    }

    private void resizePiece(double width, double height) {
        double squareSize = Math.min(width, height);
        double pieceSize = squareSize * 0.55;
        double radius = pieceSize / 2.0;
        this.piece.setCenterX(radius);
        this.piece.setCenterY(radius);
        this.piece.setRadius(radius);
        this.blur.setWidth((squareSize / 2.0 - radius) / 3.0);
        this.blur.setHeight((squareSize / 2.0 - radius) / 3.0);
    }
}

