/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.checkers.control;

import java.io.IOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import tech.octopusdragon.checkers.control.PieceGraphic;
import tech.octopusdragon.checkers.control.SquareGraphic;
import tech.octopusdragon.checkers.model.Checkers;
import tech.octopusdragon.checkers.model.Piece;
import tech.octopusdragon.checkers.model.Variant;

public class BoardGraphic
extends GridPane {
    private static final double DEFAULT_BOARD_HEIGHT = 400.0;
    private double squareSize;
    private int rows;
    private int cols;
    private StackPane[][] grid;
    private SquareGraphic[][] squares;
    private PieceGraphic[][] pieces;

    public BoardGraphic() {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/view/Board.fxml"));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BoardGraphic(Checkers game) {
        this();
        int j;
        Variant variant = game.getVariant();
        this.rows = variant.getRows();
        this.cols = variant.getCols();
        this.squareSize = Math.round(400.0 / (double)this.rows);
        StringBuilder styleClass = new StringBuilder(variant.getBoardPattern().name());
        styleClass.replace(0, styleClass.length(), styleClass.toString().toLowerCase());
        int i = 0;
        while (i < styleClass.length()) {
            if (styleClass.charAt(i) == '_') {
                styleClass.replace(i, i + 1, "-");
            }
            ++i;
        }
        this.getStyleClass().add((Object)styleClass.toString());
        this.grid = new StackPane[this.rows][this.cols];
        i = 0;
        while (i < this.rows) {
            j = 0;
            while (j < this.cols) {
                this.grid[i][j] = new StackPane();
                this.grid[i][j].getStyleClass().add((Object)"space");
                this.add((Node)this.grid[i][j], j, i);
                ++j;
            }
            ++i;
        }
        this.squares = new SquareGraphic[this.rows][this.cols];
        i = 0;
        while (i < this.rows) {
            j = 0;
            while (j < this.cols) {
                this.squares[i][j] = new SquareGraphic(game.getBoard().getSquare(i, j), this.squareSize);
                this.grid[i][j].getChildren().add((Object)this.squares[i][j]);
                if (i == 0) {
                    this.squares[i][j].getStyleClass().add((Object)"top");
                } else if (i == this.rows - 1) {
                    this.squares[i][j].getStyleClass().add((Object)"bottom");
                }
                if (j == 0) {
                    this.squares[i][j].getStyleClass().add((Object)"left");
                } else if (j == this.cols - 1) {
                    this.squares[i][j].getStyleClass().add((Object)"right");
                }
                if ((i + j) % 2 == 0) {
                    this.squares[i][j].getStyleClass().add((Object)"odd");
                } else {
                    this.squares[i][j].getStyleClass().add((Object)"even");
                }
                ++j;
            }
            ++i;
        }
        this.pieces = new PieceGraphic[this.rows][this.cols];
        i = 0;
        while (i < this.rows) {
            j = 0;
            while (j < this.cols) {
                Piece piece = game.getBoard().getPiece(i, j);
                if (piece != null) {
                    this.pieces[i][j] = new PieceGraphic(piece, this.squareSize);
                    this.grid[i][j].getChildren().add((Object)this.pieces[i][j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public double getSquareSize() {
        return this.squareSize;
    }

    public StackPane getSpace(int row, int col) {
        return this.grid[row][col];
    }

    public void activateSpace(int row, int col) {
        if (this.grid[row][col].getStyleClass().contains((Object)"active")) {
            return;
        }
        this.grid[row][col].getStyleClass().add((Object)"active");
    }

    public void deactivateSpace(int row, int col) {
        if (!this.grid[row][col].getStyleClass().contains((Object)"active")) {
            return;
        }
        this.grid[row][col].getStyleClass().remove((Object)"active");
    }

    public SquareGraphic getSquare(int row, int col) {
        return this.squares[row][col];
    }

    public PieceGraphic getPiece(int row, int col) {
        return this.pieces[row][col];
    }

    public void setPiece(int row, int col, PieceGraphic piece) {
        if (piece == null) {
            return;
        }
        this.removePiece(row, col);
        this.pieces[row][col] = piece;
        this.grid[row][col].getChildren().add((Object)piece);
    }

    public void removePiece(int row, int col) {
        if (this.pieces[row][col] == null) {
            return;
        }
        this.grid[row][col].getChildren().remove((Object)this.pieces[row][col]);
        this.pieces[row][col] = null;
    }

    public void invert() {
        int j;
        PieceGraphic[][] newPieces = new PieceGraphic[this.rows][this.cols];
        int i = 0;
        while (i < this.rows) {
            j = 0;
            while (j < this.cols) {
                newPieces[i][j] = this.pieces[this.rows - 1 - i][this.cols - 1 - j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.rows) {
            j = 0;
            while (j < this.cols) {
                this.removePiece(i, j);
                this.pieces[i][j] = newPieces[i][j];
                if (newPieces[i][j] != null) {
                    this.grid[i][j].getChildren().add((Object)this.pieces[i][j]);
                }
                ++j;
            }
            ++i;
        }
    }
}

