/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.checkers;

import java.io.IOException;
import java.util.Optional;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import tech.octopusdragon.checkers.controller.GameRootController;
import tech.octopusdragon.checkers.model.Checkers;
import tech.octopusdragon.checkers.window.NewGameDialog;

public class CheckersApplication
extends Application {
    public static final String USERDATA = "userdata/checkers.ser";
    public static final String CHECK_IMAGE_PATH = "images/icon.png";
    public static final String CSS_PATH = "styles/main.css";

    public void start(Stage primaryStage) {
        Checkers game;
        try {
            game = Checkers.deserialize(USERDATA);
        }
        catch (Exception e) {
            Optional result = new NewGameDialog().showAndWait();
            if (!result.isPresent()) {
                System.exit(0);
            }
            game = (Checkers)result.get();
        }
        FXMLLoader loader = this.setFXMLRoot("/view/GameRoot.fxml", primaryStage);
        GameRootController controller = (GameRootController)loader.getController();
        primaryStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(CHECK_IMAGE_PATH)));
        controller.newGame(game);
        Platform.runLater(() -> primaryStage.show());
    }

    public static void main(String[] args) {
        CheckersApplication.launch((String[])args);
    }

    private FXMLLoader setFXMLRoot(String fxmlPath, Stage stage) {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource(fxmlPath));
        try {
            Scene scene = new Scene((Parent)loader.load());
            scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getClassLoader().getResource(CSS_PATH).toExternalForm());
            stage.setScene(scene);
        }
        catch (IOException e) {
            System.out.println("Error loading FXML file");
            e.printStackTrace();
        }
        return loader;
    }
}

