/*
 * Decompiled with CFR 0.152.
 */
package com.octopusdragon.projects.battleship;

import com.octopusdragon.projects.battleship.Fleet;
import com.octopusdragon.projects.battleship.Ship;
import com.octopusdragon.projects.battleship.Square;

public class Board {
    private Fleet fleet = new Fleet();
    private Square[][] squares;

    public Board(int rows, int cols) {
        this.squares = new Square[rows][cols];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                this.squares[i][j] = new Square();
                ++j;
            }
            ++i;
        }
    }

    public Ship getShip(int row, int col) {
        return this.squares[row][col].getShip();
    }

    public boolean getOccupied(int row, int col) {
        return this.squares[row][col].getShip() != null;
    }

    public boolean getShot(int row, int column) {
        return this.squares[row][column].isShot();
    }

    public void setShip(Ship ship, int row, int column) {
        this.squares[row][column].setShip(ship);
    }

    public Fleet fleet() {
        return this.fleet;
    }

    public void shoot(int row, int column) {
        this.squares[row][column].shoot();
        Ship curShip = this.squares[row][column].getShip();
        if (curShip == null) {
            return;
        }
        boolean sunk = true;
        int i = 0;
        while (i < curShip.length()) {
            row = curShip.getLocation()[i].getRow();
            if (!this.squares[row][column = curShip.getLocation()[i].getColumn()].isShot()) {
                sunk = false;
                break;
            }
            ++i;
        }
        if (sunk) {
            curShip.sink();
        }
    }
}

